/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.commands.DelegatingCommandSource;
import io.papermc.paper.event.player.PlayerSignCommandPreprocessEvent;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.FormattedString;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_18_R1.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_18_R1.util.LazyPlayerSet;
import org.bukkit.entity.Player;
import org.spigotmc.SpigotConfig;

public class TileEntitySign
extends TileEntity
implements ICommandListener {
    private static final boolean CONVERT_LEGACY_SIGNS = Boolean.getBoolean("convertLegacySigns");
    public static final int a = 4;
    private static final String[] b = new String[]{"Text1", "Text2", "Text3", "Text4"};
    private static final String[] c = new String[]{"FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4"};
    public final IChatBaseComponent[] d = new IChatBaseComponent[]{ChatComponentText.d, ChatComponentText.d, ChatComponentText.d, ChatComponentText.d};
    private final IChatBaseComponent[] e = new IChatBaseComponent[]{ChatComponentText.d, ChatComponentText.d, ChatComponentText.d, ChatComponentText.d};
    public boolean f = true;
    @Nullable
    private UUID g;
    @Nullable
    private FormattedString[] h;
    private boolean i;
    private EnumColor j = EnumColor.p;
    private boolean k;
    private static final Logger LOGGER = LogManager.getLogger();

    public TileEntitySign(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.h, pos, state);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent ichatbasecomponent = this.d[i2];
            String s2 = IChatBaseComponent.ChatSerializer.a(ichatbasecomponent);
            nbt.a(b[i2], s2);
            IChatBaseComponent ichatbasecomponent1 = this.e[i2];
            if (ichatbasecomponent1.equals(ichatbasecomponent)) continue;
            nbt.a(c[i2], IChatBaseComponent.ChatSerializer.a(ichatbasecomponent1));
        }
        if (CONVERT_LEGACY_SIGNS) {
            nbt.a("Bukkit.isConverted", true);
        }
        nbt.a("Color", this.j.b());
        nbt.a("GlowingText", this.k);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.f = false;
        super.a(nbt);
        this.j = EnumColor.a(nbt.l("Color"), EnumColor.p);
        boolean oldSign = Boolean.getBoolean("convertLegacySigns") && !nbt.q("Bukkit.isConverted");
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent ichatbasecomponent;
            String s2 = nbt.l(b[i2]);
            if (s2 != null && s2.length() > 2048) {
                s2 = "\"\"";
            }
            if (oldSign && !this.isLoadingStructure) {
                this.d[i2] = CraftChatMessage.fromString(s2)[0];
                continue;
            }
            this.d[i2] = ichatbasecomponent = this.a(s2);
            String s1 = c[i2];
            this.e[i2] = nbt.b(s1, 8) ? this.a(nbt.l(s1)) : ichatbasecomponent;
        }
        this.h = null;
        this.k = nbt.q("GlowingText");
    }

    private IChatBaseComponent a(String json) {
        IChatBaseComponent ichatbasecomponent = this.b(json);
        if (this.n instanceof WorldServer) {
            try {
                return ChatComponentUtils.a(this.b((EntityPlayer)null), ichatbasecomponent, (Entity)null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return ichatbasecomponent;
    }

    private IChatBaseComponent b(String json) {
        try {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.ChatSerializer.a(json);
            if (ichatmutablecomponent != null) {
                return ichatmutablecomponent;
            }
        }
        catch (JsonParseException jsonparseexception) {
            return new ChatComponentText(json);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ChatComponentText.d;
    }

    public IChatBaseComponent a(int row, boolean filtered) {
        return this.c(filtered)[row];
    }

    public void a(int row, IChatBaseComponent text) {
        this.a(row, text, text);
    }

    public void a(int row, IChatBaseComponent text, IChatBaseComponent filteredText) {
        this.d[row] = text;
        this.e[row] = filteredText;
        this.h = null;
    }

    public FormattedString[] a(boolean filterText, Function<IChatBaseComponent, FormattedString> textOrderingFunction) {
        if (this.h == null || this.i != filterText) {
            this.i = filterText;
            this.h = new FormattedString[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                this.h[i2] = textOrderingFunction.apply(this.a(i2, filterText));
            }
        }
        return this.h;
    }

    private IChatBaseComponent[] c(boolean filtered) {
        return filtered ? this.e : this.d;
    }

    public PacketPlayOutTileEntityData c() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound Z_() {
        return this.o();
    }

    @Override
    public boolean t() {
        return true;
    }

    public boolean d() {
        return this.f;
    }

    public void a(boolean editable) {
        this.f = editable;
        if (!editable) {
            this.g = null;
        }
    }

    public void a(UUID editor) {
        this.g = editor;
    }

    @Nullable
    public UUID f() {
        return this.g;
    }

    public boolean a(EntityPlayer player) {
        for (IChatBaseComponent ichatbasecomponent : this.c(player.U())) {
            PlayerSignCommandPreprocessEvent event;
            Object command;
            ChatModifier chatmodifier = ichatbasecomponent.c();
            ChatClickable chatclickable = chatmodifier.h();
            if (chatclickable == null || chatclickable.a() != ChatClickable.EnumClickAction.c) continue;
            Object object = command = chatclickable.b().startsWith("/") ? chatclickable.b() : "/" + chatclickable.b();
            if (SpigotConfig.logCommands) {
                LOGGER.info("{} issued server command: {}", (Object)player.co(), command);
            }
            if (!(event = new PlayerSignCommandPreprocessEvent((Player)player.getBukkitEntity(), (String)command, (Set)new LazyPlayerSet(player.cB()), (Sign)MCUtil.toBukkitBlock(this.n, this.o).getState())).callEvent()) {
                return false;
            }
            player.cB().aA().a(this.b(((CraftPlayer)event.getPlayer()).getHandle()), event.getMessage());
        }
        return true;
    }

    @Override
    public void a(IChatBaseComponent message, UUID sender) {
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return wrapper.f() != null ? wrapper.f().getBukkitSender(wrapper) : new CraftBlockCommandSender(wrapper, this);
    }

    @Override
    public boolean i_() {
        return false;
    }

    @Override
    public boolean j_() {
        return false;
    }

    @Override
    public boolean F_() {
        return false;
    }

    public CommandListenerWrapper b(final @Nullable EntityPlayer player) {
        String s2 = player == null ? "Sign" : player.X().getString();
        IChatBaseComponent object = player == null ? new ChatComponentText("Sign") : player.C_();
        ICommandListener commandSource = this.n.paperConfig.showSignClickCommandFailureMessagesToPlayer ? new DelegatingCommandSource(this){

            @Override
            public void a(IChatBaseComponent message, UUID sender) {
                player.a(message, sender);
            }

            @Override
            public boolean j_() {
                return true;
            }
        } : this;
        return new CommandListenerWrapper(commandSource, Vec3D.a(this.o), Vec2F.a, (WorldServer)this.n, 2, s2, object, this.n.n(), player);
    }

    public EnumColor g() {
        return this.j;
    }

    public boolean a(EnumColor value) {
        if (value != this.g()) {
            this.j = value;
            this.j();
            return true;
        }
        return false;
    }

    public boolean i() {
        return this.k;
    }

    public boolean b(boolean glowingText) {
        if (this.k != glowingText) {
            this.k = glowingText;
            this.j();
            return true;
        }
        return false;
    }

    private void j() {
        this.e();
        if (this.n != null) {
            this.n.a(this.p(), this.q(), this.q(), 3);
        }
    }
}

