/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.event.entity.EntityTeleportEndGatewayEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.EndGateway;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TileEntityEndGateway
extends TileEntityEnderPortal {
    private static final Logger a = LogManager.getLogger();
    private static final int b = 200;
    private static final int c = 40;
    private static final int d = 2400;
    private static final int e = 1;
    private static final int f = 10;
    public long g;
    private int h;
    @Nullable
    public BlockPosition i;
    public boolean j;

    public TileEntityEndGateway(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.u, pos, state);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Age", this.g);
        if (this.i != null) {
            nbt.a("ExitPortal", GameProfileSerializer.a(this.i));
        }
        if (this.j) {
            nbt.a("ExactTeleport", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        BlockPosition blockposition;
        super.a(nbt);
        this.g = nbt.i("Age");
        if (nbt.b("ExitPortal", 10) && World.k(blockposition = GameProfileSerializer.b(nbt.p("ExitPortal")))) {
            this.i = blockposition;
        }
        this.j = nbt.q("ExactTeleport");
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityEndGateway blockEntity) {
        ++blockEntity.g;
        if (blockEntity.d()) {
            --blockEntity.h;
        }
    }

    public static void b(World world, BlockPosition pos, IBlockData state, TileEntityEndGateway blockEntity) {
        boolean flag = blockEntity.c();
        boolean flag1 = blockEntity.d();
        ++blockEntity.g;
        if (flag1) {
            --blockEntity.h;
        } else {
            List<net.minecraft.world.entity.Entity> list = world.a(net.minecraft.world.entity.Entity.class, new AxisAlignedBB(pos), TileEntityEndGateway::a);
            if (!list.isEmpty()) {
                for (net.minecraft.world.entity.Entity entity : list) {
                    if (!entity.ci()) continue;
                    TileEntityEndGateway.a(world, pos, state, entity, blockEntity);
                    break;
                }
            }
            if (blockEntity.g % 2400L == 0L) {
                TileEntityEndGateway.c(world, pos, state, blockEntity);
            }
        }
        if (flag != blockEntity.c() || flag1 != blockEntity.d()) {
            TileEntityEndGateway.a(world, pos, state);
        }
    }

    public static boolean a(net.minecraft.world.entity.Entity entity) {
        return IEntitySelector.f.test(entity) && !entity.cL().aq();
    }

    public boolean c() {
        return this.g < 200L;
    }

    public boolean d() {
        return this.h > 0;
    }

    public float a(float tickDelta) {
        return MathHelper.a(((float)this.g + tickDelta) / 200.0f, 0.0f, 1.0f);
    }

    public float b(float tickDelta) {
        return 1.0f - MathHelper.a(((float)this.h - tickDelta) / 40.0f, 0.0f, 1.0f);
    }

    public PacketPlayOutTileEntityData f() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound Z_() {
        return this.o();
    }

    private static void c(World world, BlockPosition pos, IBlockData state, TileEntityEndGateway blockEntity) {
        if (!world.y) {
            blockEntity.h = 40;
            world.a(pos, state.b(), 1, 0);
            TileEntityEndGateway.a(world, pos, state);
        }
    }

    @Override
    public boolean a_(int type, int data) {
        if (type == 1) {
            this.h = 40;
            return true;
        }
        return super.a_(type, data);
    }

    public static void a(World world, BlockPosition pos, IBlockData state, net.minecraft.world.entity.Entity entity, TileEntityEndGateway blockEntity) {
        if (world instanceof WorldServer && !blockEntity.d()) {
            BlockPosition blockposition1;
            WorldServer worldserver = (WorldServer)world;
            blockEntity.h = 100;
            if (blockEntity.i == null && world.getTypeKey() == WorldDimension.d) {
                blockposition1 = TileEntityEndGateway.a(worldserver, pos);
                blockposition1 = blockposition1.b(10);
                a.debug("Creating portal at {}", (Object)blockposition1);
                TileEntityEndGateway.a(worldserver, blockposition1, WorldGenEndGatewayConfiguration.a(pos, false));
                blockEntity.i = blockposition1;
            }
            if (blockEntity.i != null) {
                net.minecraft.world.entity.Entity entity1;
                BlockPosition blockPosition = blockposition1 = blockEntity.j ? blockEntity.i : TileEntityEndGateway.a(world, blockEntity.i);
                if (entity instanceof EntityEnderPearl) {
                    net.minecraft.world.entity.Entity entity2 = ((EntityEnderPearl)entity).x();
                    if (entity2 instanceof EntityPlayer) {
                        CriterionTriggers.d.a((EntityPlayer)entity2, state);
                    }
                    if (entity2 != null) {
                        entity1 = entity2;
                        entity.ah();
                    } else {
                        entity1 = entity;
                    }
                } else {
                    entity1 = entity.cL();
                }
                if (entity1 instanceof EntityPlayer) {
                    CraftPlayer player = (CraftPlayer)entity1.getBukkitEntity();
                    Location location = new Location((org.bukkit.World)world.getWorld(), (double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.5, (double)blockposition1.w() + 0.5);
                    location.setPitch(player.getLocation().getPitch());
                    location.setYaw(player.getLocation().getYaw());
                    PlayerTeleportEndGatewayEvent teleEvent = new PlayerTeleportEndGatewayEvent((Player)player, player.getLocation(), location, (EndGateway)new CraftEndGateway((org.bukkit.World)worldserver.getWorld(), blockEntity));
                    Bukkit.getPluginManager().callEvent((Event)teleEvent);
                    if (teleEvent.isCancelled()) {
                        return;
                    }
                    entity1.ap();
                    ((EntityPlayer)entity1).b.teleport(teleEvent.getTo());
                    TileEntityEndGateway.c(world, pos, state, blockEntity);
                    return;
                }
                CraftEntity bukkitEntity = entity.getBukkitEntity();
                Location location = new Location((org.bukkit.World)world.getWorld(), (double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.5, (double)blockposition1.w() + 0.5);
                location.setPitch(bukkitEntity.getLocation().getPitch());
                location.setYaw(bukkitEntity.getLocation().getYaw());
                EntityTeleportEndGatewayEvent event = new EntityTeleportEndGatewayEvent((Entity)bukkitEntity, bukkitEntity.getLocation(), location, (EndGateway)new CraftEndGateway((org.bukkit.World)world.getWorld(), blockEntity));
                if (!event.callEvent()) {
                    return;
                }
                entity1.ap();
                entity1.m(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
            }
            TileEntityEndGateway.c(world, pos, state, blockEntity);
        }
    }

    private static BlockPosition a(World world, BlockPosition pos) {
        BlockPosition blockposition1 = TileEntityEndGateway.a((IBlockAccess)world, pos.b(0, 2, 0), 5, false);
        a.debug("Best exit position for portal at {} is {}", (Object)pos, (Object)blockposition1);
        return blockposition1.b();
    }

    private static BlockPosition a(WorldServer world, BlockPosition pos) {
        Vec3D vec3d = TileEntityEndGateway.b(world, pos);
        Chunk chunk = TileEntityEndGateway.a((World)world, vec3d);
        BlockPosition blockposition1 = TileEntityEndGateway.a(chunk);
        if (blockposition1 == null) {
            blockposition1 = new BlockPosition(vec3d.b + 0.5, 75.0, vec3d.d + 0.5);
            a.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockposition1);
            EndFeatures.e.a(world, world.k().g(), new Random(blockposition1.a()), blockposition1);
        } else {
            a.debug("Found suitable block to teleport to: {}", (Object)blockposition1);
        }
        blockposition1 = TileEntityEndGateway.a((IBlockAccess)world, blockposition1, 16, true);
        return blockposition1;
    }

    private static Vec3D b(WorldServer world, BlockPosition pos) {
        Vec3D vec3d = new Vec3D(pos.u(), 0.0, pos.w()).d();
        boolean flag = true;
        Vec3D vec3d1 = vec3d.a(1024.0);
        int i2 = 16;
        while (!TileEntityEndGateway.a(world, vec3d1) && i2-- > 0) {
            a.debug("Skipping backwards past nonempty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.a(-16.0));
        }
        i2 = 16;
        while (TileEntityEndGateway.a(world, vec3d1) && i2-- > 0) {
            a.debug("Skipping forward past empty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.a(16.0));
        }
        a.debug("Found chunk at {}", (Object)vec3d1);
        return vec3d1;
    }

    private static boolean a(WorldServer world, Vec3D pos) {
        return TileEntityEndGateway.a((World)world, pos).b() <= world.u_();
    }

    private static BlockPosition a(IBlockAccess world, BlockPosition pos, int searchRadius, boolean force) {
        BaseBlockPosition blockposition1 = null;
        for (int j2 = -searchRadius; j2 <= searchRadius; ++j2) {
            block1: for (int k2 = -searchRadius; k2 <= searchRadius; ++k2) {
                if (j2 == 0 && k2 == 0 && !force) continue;
                for (int l2 = world.ag() - 1; l2 > (blockposition1 == null ? world.u_() : blockposition1.v()); --l2) {
                    BlockPosition blockposition2 = new BlockPosition(pos.u() + j2, l2, pos.w() + k2);
                    IBlockData iblockdata = world.a_(blockposition2);
                    if (!iblockdata.r(world, blockposition2) || !force && iblockdata.a(Blocks.z)) continue;
                    blockposition1 = blockposition2;
                    continue block1;
                }
            }
        }
        return blockposition1 == null ? pos : blockposition1;
    }

    private static Chunk a(World world, Vec3D pos) {
        return world.d(MathHelper.b(pos.b / 16.0), MathHelper.b(pos.d / 16.0));
    }

    @Nullable
    private static BlockPosition a(Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        BlockPosition blockposition = new BlockPosition(chunkcoordintpair.d(), 30, chunkcoordintpair.e());
        int i2 = chunk.b() + 16 - 1;
        BlockPosition blockposition1 = new BlockPosition(chunkcoordintpair.f(), i2, chunkcoordintpair.g());
        BlockPosition blockposition2 = null;
        double d0 = 0.0;
        for (BlockPosition blockposition3 : BlockPosition.a(blockposition, blockposition1)) {
            IBlockData iblockdata = chunk.a_(blockposition3);
            BlockPosition blockposition4 = blockposition3.b();
            BlockPosition blockposition5 = blockposition3.b(2);
            if (!iblockdata.a(Blocks.eq) || chunk.a_(blockposition4).r(chunk, blockposition4) || chunk.a_(blockposition5).r(chunk, blockposition5)) continue;
            double d1 = blockposition3.a(0.0, 0.0, 0.0, true);
            if (blockposition2 != null && !(d1 < d0)) continue;
            blockposition2 = blockposition3;
            d0 = d1;
        }
        return blockposition2;
    }

    private static void a(WorldServer world, BlockPosition pos, WorldGenEndGatewayConfiguration config) {
        WorldGenerator.N.a(config).a(world, world.k().g(), new Random(), pos);
    }

    @Override
    public boolean a(EnumDirection direction) {
        return Block.a(this.q(), this.n, this.p(), direction, this.p().a(direction));
    }

    public int g() {
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.values()) {
            i2 += this.a(enumdirection) ? 1 : 0;
        }
        return i2;
    }

    public void a(BlockPosition pos, boolean exactTeleport) {
        this.j = exactTeleport;
        this.i = pos;
    }
}

