/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.papermc.paper.event.block.BeaconActivatedEvent;
import io.papermc.paper.event.block.BeaconDeactivatedEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.ChestLock;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBeaconBeam;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R1.potion.CraftPotionUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffect;

public class TileEntityBeacon
extends TileEntity
implements ITileInventory {
    private static final int f = 4;
    public static final MobEffectList[][] a = new MobEffectList[][]{{MobEffects.a, MobEffects.c}, {MobEffects.k, MobEffects.h}, {MobEffects.e}, {MobEffects.j}};
    private static final Set<MobEffectList> g = Arrays.stream(a).flatMap(Arrays::stream).collect(Collectors.toSet());
    public static final int b = 0;
    public static final int c = 1;
    public static final int d = 2;
    public static final int e = 3;
    private static final int h = 10;
    List<BeaconColorTracker> i = Lists.newArrayList();
    private List<BeaconColorTracker> j = Lists.newArrayList();
    public int k;
    private int l;
    @Nullable
    public MobEffectList m;
    @Nullable
    public MobEffectList q;
    @Nullable
    public IChatBaseComponent r;
    public ChestLock s = ChestLock.a;
    private final IContainerProperties t = new IContainerProperties(){

        @Override
        public int a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityBeacon.this.k;
                }
                case 1: {
                    return MobEffectList.a(TileEntityBeacon.this.m);
                }
                case 2: {
                    return MobEffectList.a(TileEntityBeacon.this.q);
                }
            }
            return 0;
        }

        @Override
        public void a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityBeacon.this.k = value;
                    break;
                }
                case 1: {
                    if (!TileEntityBeacon.this.n.y && !TileEntityBeacon.this.i.isEmpty()) {
                        TileEntityBeacon.a(TileEntityBeacon.this.n, TileEntityBeacon.this.o, SoundEffects.bb);
                    }
                    TileEntityBeacon.this.m = TileEntityBeacon.a(value);
                    break;
                }
                case 2: {
                    TileEntityBeacon.this.q = TileEntityBeacon.a(value);
                }
            }
        }

        @Override
        public int a() {
            return 3;
        }
    };
    private final String PAPER_RANGE_TAG = "Paper.Range";
    private double effectRange = -1.0;

    public PotionEffect getPrimaryEffect() {
        return this.m != null ? CraftPotionUtil.toBukkit(new MobEffect(this.m, TileEntityBeacon.getLevel(this.k), TileEntityBeacon.getAmplification(this.k, this.m, this.q), true, true)) : null;
    }

    public PotionEffect getSecondaryEffect() {
        return TileEntityBeacon.hasSecondaryEffect(this.k, this.m, this.q) ? CraftPotionUtil.toBukkit(new MobEffect(this.q, TileEntityBeacon.getLevel(this.k), TileEntityBeacon.getAmplification(this.k, this.m, this.q), true, true)) : null;
    }

    public double getEffectRange() {
        if (this.effectRange < 0.0) {
            return this.k * 10 + 10;
        }
        return this.effectRange;
    }

    public void setEffectRange(double range) {
        this.effectRange = range;
    }

    public void resetEffectRange() {
        this.effectRange = -1.0;
    }

    public TileEntityBeacon(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.n, pos, state);
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityBeacon blockEntity) {
        int i1;
        BlockPosition blockposition1;
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        if (blockEntity.l < j2) {
            blockposition1 = pos;
            blockEntity.j = Lists.newArrayList();
            blockEntity.l = pos.v() - 1;
        } else {
            blockposition1 = new BlockPosition(i2, blockEntity.l + 1, k2);
        }
        BeaconColorTracker tileentitybeacon_beaconcolortracker = blockEntity.j.isEmpty() ? null : blockEntity.j.get(blockEntity.j.size() - 1);
        int l2 = world.a(HeightMap.Type.b, i2, k2);
        for (i1 = 0; i1 < 10 && blockposition1.v() <= l2; ++i1) {
            IBlockData iblockdata1 = world.a_(blockposition1);
            Block block = iblockdata1.b();
            if (block instanceof IBeaconBeam) {
                float[] afloat = ((IBeaconBeam)((Object)block)).a().d();
                if (blockEntity.j.size() <= 1) {
                    tileentitybeacon_beaconcolortracker = new BeaconColorTracker(afloat);
                    blockEntity.j.add(tileentitybeacon_beaconcolortracker);
                } else if (tileentitybeacon_beaconcolortracker != null) {
                    if (Arrays.equals(afloat, tileentitybeacon_beaconcolortracker.a)) {
                        tileentitybeacon_beaconcolortracker.a();
                    } else {
                        tileentitybeacon_beaconcolortracker = new BeaconColorTracker(new float[]{(tileentitybeacon_beaconcolortracker.a[0] + afloat[0]) / 2.0f, (tileentitybeacon_beaconcolortracker.a[1] + afloat[1]) / 2.0f, (tileentitybeacon_beaconcolortracker.a[2] + afloat[2]) / 2.0f});
                        blockEntity.j.add(tileentitybeacon_beaconcolortracker);
                    }
                }
            } else {
                if (tileentitybeacon_beaconcolortracker == null || iblockdata1.b((IBlockAccess)world, blockposition1) >= 15 && !iblockdata1.a(Blocks.z)) {
                    blockEntity.j.clear();
                    blockEntity.l = l2;
                    break;
                }
                tileentitybeacon_beaconcolortracker.a();
            }
            blockposition1 = blockposition1.b();
            ++blockEntity.l;
        }
        i1 = blockEntity.k;
        if (world.V() % 80L == 0L) {
            if (!blockEntity.i.isEmpty()) {
                blockEntity.k = TileEntityBeacon.a(world, i2, j2, k2);
            }
            if (blockEntity.k > 0 && !blockEntity.i.isEmpty()) {
                TileEntityBeacon.applyEffects(world, pos, blockEntity.k, blockEntity.m, blockEntity.q, blockEntity);
                TileEntityBeacon.a(world, pos, SoundEffects.aZ);
            }
        }
        if (i1 <= 0 && blockEntity.k > 0) {
            block = CraftBlock.at(world, pos);
            new BeaconActivatedEvent((org.bukkit.block.Block)block).callEvent();
        } else if (i1 > 0 && blockEntity.k <= 0) {
            block = CraftBlock.at(world, pos);
            new BeaconDeactivatedEvent((org.bukkit.block.Block)block).callEvent();
        }
        if (blockEntity.l >= l2) {
            blockEntity.l = world.u_() - 1;
            boolean flag = i1 > 0;
            blockEntity.i = blockEntity.j;
            if (!world.y) {
                boolean flag1;
                boolean bl = flag1 = blockEntity.k > 0;
                if (!flag && flag1) {
                    TileEntityBeacon.a(world, pos, SoundEffects.aY);
                    for (EntityPlayer entityplayer : world.a(EntityPlayer.class, new AxisAlignedBB(i2, j2, k2, i2, j2 - 4, k2).c(10.0, 5.0, 10.0))) {
                        CriterionTriggers.l.a(entityplayer, blockEntity.k);
                    }
                } else if (flag && !flag1) {
                    TileEntityBeacon.a(world, pos, SoundEffects.ba);
                }
            }
        }
    }

    private static int a(World world, int x2, int y2, int z2) {
        int j1;
        int l2 = 0;
        int i1 = 1;
        while (i1 <= 4 && (j1 = y2 - i1) >= world.u_()) {
            boolean flag = true;
            block1: for (int k1 = x2 - i1; k1 <= x2 + i1 && flag; ++k1) {
                for (int l1 = z2 - i1; l1 <= z2 + i1; ++l1) {
                    if (world.a_(new BlockPosition(k1, j1, l1)).a(TagsBlock.aA)) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            l2 = i1++;
        }
        return l2;
    }

    @Override
    public void aa_() {
        CraftBlock block = CraftBlock.at(this.n, this.o);
        new BeaconDeactivatedEvent((org.bukkit.block.Block)block).callEvent();
        TileEntityBeacon.a(this.n, this.o, SoundEffects.ba);
        super.aa_();
    }

    private static byte getAmplification(int i2, @Nullable MobEffectList mobeffectlist, @Nullable MobEffectList mobeffectlist1) {
        byte b0 = 0;
        if (i2 >= 4 && mobeffectlist == mobeffectlist1) {
            b0 = 1;
        }
        return b0;
    }

    private static int getLevel(int i2) {
        int j2 = (9 + i2 * 2) * 20;
        return j2;
    }

    public static List getHumansInRange(World world, BlockPosition blockposition, int i2) {
        return TileEntityBeacon.getHumansInRange(world, blockposition, i2, null);
    }

    public static List getHumansInRange(World world, BlockPosition blockposition, int i2, @Nullable TileEntityBeacon blockEntity) {
        double d0 = blockEntity != null ? blockEntity.getEffectRange() : (double)(i2 * 10 + 10);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockposition).g(d0).b(0.0, world.v_(), 0.0);
        List<EntityHuman> list = world.a(EntityHuman.class, axisalignedbb);
        return list;
    }

    private static void applyEffect(List list, MobEffectList effects, int i2, int b0, boolean isPrimary, BlockPosition worldPosition) {
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            org.bukkit.block.Block block = ((EntityHuman)list.get((int)0)).t.getWorld().getBlockAt(worldPosition.u(), worldPosition.v(), worldPosition.w());
            PotionEffect effect = CraftPotionUtil.toBukkit(new MobEffect(effects, i2, b0, true, true));
            while (iterator.hasNext()) {
                EntityPlayer entityhuman = (EntityPlayer)iterator.next();
                BeaconEffectEvent event = new BeaconEffectEvent(block, effect, (Player)((EntityHuman)entityhuman).getBukkitEntity(), isPrimary);
                if (CraftEventFactory.callEvent(event).isCancelled()) continue;
                entityhuman.addEffect(new MobEffect(CraftPotionUtil.fromBukkit(event.getEffect())), EntityPotionEffectEvent.Cause.BEACON);
            }
        }
    }

    private static boolean hasSecondaryEffect(int i2, @Nullable MobEffectList mobeffectlist, @Nullable MobEffectList mobeffectlist1) {
        return i2 >= 4 && mobeffectlist != mobeffectlist1 && mobeffectlist1 != null;
    }

    private static void a(World world, BlockPosition pos, int beaconLevel, @Nullable MobEffectList primaryEffect, @Nullable MobEffectList secondaryEffect) {
        TileEntityBeacon.applyEffects(world, pos, beaconLevel, primaryEffect, secondaryEffect, null);
    }

    private static void applyEffects(World world, BlockPosition pos, int beaconLevel, @Nullable MobEffectList primaryEffect, @Nullable MobEffectList secondaryEffect, @Nullable TileEntityBeacon blockEntity) {
        if (!world.y && primaryEffect != null) {
            double d0 = beaconLevel * 10 + 10;
            byte b0 = TileEntityBeacon.getAmplification(beaconLevel, primaryEffect, secondaryEffect);
            int j2 = TileEntityBeacon.getLevel(beaconLevel);
            List list = TileEntityBeacon.getHumansInRange(world, pos, beaconLevel, blockEntity);
            TileEntityBeacon.applyEffect(list, primaryEffect, j2, b0, true, pos);
            if (TileEntityBeacon.hasSecondaryEffect(beaconLevel, primaryEffect, secondaryEffect)) {
                TileEntityBeacon.applyEffect(list, secondaryEffect, j2, 0, false, pos);
            }
        }
    }

    public static void a(World world, BlockPosition pos, SoundEffect sound) {
        world.a((EntityHuman)null, pos, sound, SoundCategory.e, 1.0f, 1.0f);
    }

    public List<BeaconColorTracker> c() {
        return this.k == 0 ? ImmutableList.of() : this.i;
    }

    public PacketPlayOutTileEntityData f() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound Z_() {
        return this.o();
    }

    @Nullable
    static MobEffectList a(int id) {
        MobEffectList mobeffectlist = MobEffectList.a(id);
        return g.contains(mobeffectlist) ? mobeffectlist : null;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.m = MobEffectList.a(nbt.h("Primary"));
        this.q = MobEffectList.a(nbt.h("Secondary"));
        this.k = nbt.h("Levels");
        if (nbt.b("CustomName", 8)) {
            this.r = MCUtil.getBaseComponentFromNbt("CustomName", nbt);
        }
        this.s = ChestLock.b(nbt);
        this.effectRange = nbt.b("Paper.Range", 6) ? nbt.k("Paper.Range") : -1.0;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Primary", MobEffectList.a(this.m));
        nbt.a("Secondary", MobEffectList.a(this.q));
        nbt.a("Levels", this.k);
        if (this.r != null) {
            nbt.a("CustomName", IChatBaseComponent.ChatSerializer.a(this.r));
        }
        this.s.a(nbt);
        nbt.a("Paper.Range", this.effectRange);
    }

    public void a(@Nullable IChatBaseComponent customName) {
        this.r = customName;
    }

    @Override
    @Nullable
    public Container createMenu(int syncId, PlayerInventory inv, EntityHuman player) {
        return TileEntityContainer.a(player, this.s, this.C_()) ? new ContainerBeacon(syncId, inv, this.t, ContainerAccess.a(this.n, this.p())) : null;
    }

    @Override
    public IChatBaseComponent C_() {
        return this.r != null ? this.r : new ChatMessage("container.beacon");
    }

    @Override
    public void a(World world) {
        super.a(world);
        this.l = world.u_() - 1;
    }

    public static class BeaconColorTracker {
        final float[] a;
        private int b;

        public BeaconColorTracker(float[] color) {
            this.a = color;
            this.b = 1;
        }

        protected void a() {
            ++this.b;
        }

        public float[] b() {
            return this.a;
        }

        public int c() {
            return this.b;
        }
    }
}

