/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class BlockRespawnAnchor
extends Block {
    public static final int a = 0;
    public static final int b = 4;
    public static final BlockStateInteger c = BlockProperties.aU;
    private static final ImmutableList<BaseBlockPosition> d = ImmutableList.of((Object)new BaseBlockPosition(0, 0, -1), (Object)new BaseBlockPosition(-1, 0, 0), (Object)new BaseBlockPosition(0, 0, 1), (Object)new BaseBlockPosition(1, 0, 0), (Object)new BaseBlockPosition(-1, 0, -1), (Object)new BaseBlockPosition(1, 0, -1), (Object)new BaseBlockPosition(-1, 0, 1), (Object)new BaseBlockPosition(1, 0, 1));
    private static final ImmutableList<BaseBlockPosition> e = new ImmutableList.Builder().addAll(d).addAll(d.stream().map(BaseBlockPosition::n).iterator()).addAll(d.stream().map(BaseBlockPosition::o).iterator()).add((Object)new BaseBlockPosition(0, 1, 0)).build();

    public BlockRespawnAnchor(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(c, 0));
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        EntityPlayer serverPlayer;
        ItemStack itemStack = player.b(hand);
        if (hand == EnumHand.a && !BlockRespawnAnchor.a(itemStack) && BlockRespawnAnchor.a(player.b(EnumHand.b))) {
            return EnumInteractionResult.d;
        }
        if (BlockRespawnAnchor.a(itemStack) && BlockRespawnAnchor.h(state)) {
            BlockRespawnAnchor.a(world, pos, state);
            if (!player.fr().d) {
                itemStack.g(1);
            }
            return EnumInteractionResult.a(world.y);
        }
        if (state.c(c) == 0) {
            return EnumInteractionResult.d;
        }
        if (!BlockRespawnAnchor.a(world)) {
            if (!world.y) {
                this.d(state, world, pos);
            }
            return EnumInteractionResult.a(world.y);
        }
        if (!(world.y || (serverPlayer = (EntityPlayer)player).P() == world.aa() && pos.equals(serverPlayer.N()))) {
            serverPlayer.setRespawnPosition(world.aa(), pos, 0.0f, false, true, PlayerSetSpawnEvent.Cause.RESPAWN_ANCHOR);
            world.a((EntityHuman)null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.pT, SoundCategory.e, 1.0f, 1.0f);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.b;
    }

    private static boolean a(ItemStack stack) {
        return stack.a(Items.ep);
    }

    private static boolean h(IBlockData state) {
        return state.c(c) < 4;
    }

    private static boolean a(BlockPosition pos, World world) {
        Fluid fluidState = world.b_(pos);
        if (!fluidState.a(TagsFluid.b)) {
            return false;
        }
        if (fluidState.b()) {
            return true;
        }
        float f2 = fluidState.e();
        if (f2 < 2.0f) {
            return false;
        }
        Fluid fluidState2 = world.b_(pos.c());
        return !fluidState2.a(TagsFluid.b);
    }

    private void d(IBlockData state, World world, final BlockPosition explodedPos) {
        world.a(explodedPos, false);
        boolean bl = EnumDirection.EnumDirectionLimit.a.a().map(explodedPos::a).anyMatch(pos -> BlockRespawnAnchor.a(pos, world));
        final boolean bl2 = bl || world.b_(explodedPos.b()).a(TagsFluid.b);
        ExplosionDamageCalculator explosionDamageCalculator = new ExplosionDamageCalculator(){

            @Override
            public Optional<Float> a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState) {
                return pos.equals(explodedPos) && bl2 ? Optional.of(Float.valueOf(Blocks.A.f())) : super.a(explosion, world, pos, blockState, fluidState);
            }
        };
        world.a(null, DamageSource.a(), explosionDamageCalculator, (double)explodedPos.u() + 0.5, (double)explodedPos.v() + 0.5, (double)explodedPos.w() + 0.5, 5.0f, true, Explosion.Effect.c);
    }

    public static boolean a(World world) {
        return world.q_().i();
    }

    public static void a(World world, BlockPosition pos, IBlockData state) {
        world.a(pos, (IBlockData)state.a(c, state.c(c) + 1), 3);
        world.a((EntityHuman)null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.pR, SoundCategory.e, 1.0f, 1.0f);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Random random) {
        if (state.c(c) != 0) {
            if (random.nextInt(100) == 0) {
                world.a((EntityHuman)null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.pQ, SoundCategory.e, 1.0f, 1.0f);
            }
            double d2 = (double)pos.u() + 0.5 + (0.5 - random.nextDouble());
            double e2 = (double)pos.v() + 1.0;
            double f2 = (double)pos.w() + 0.5 + (0.5 - random.nextDouble());
            double g2 = (double)random.nextFloat() * 0.04;
            world.a(Particles.aw, d2, e2, f2, 0.0, g2, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    public static int a(IBlockData state, int maxLevel) {
        return MathHelper.d((float)(state.c(c) - 0) / 4.0f * (float)maxLevel);
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        return BlockRespawnAnchor.a(state, 15);
    }

    public static Optional<Vec3D> a(EntityTypes<?> entity, ICollisionAccess world, BlockPosition pos) {
        Optional<Vec3D> optional = BlockRespawnAnchor.a(entity, world, pos, true);
        return optional.isPresent() ? optional : BlockRespawnAnchor.a(entity, world, pos, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> entity, ICollisionAccess world, BlockPosition pos, boolean ignoreInvalidPos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (BaseBlockPosition vec3i : e) {
            mutableBlockPos.g(pos).h(vec3i);
            Vec3D vec3 = DismountUtil.a(entity, world, mutableBlockPos, ignoreInvalidPos);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }
}

