/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class BlockPressurePlateBinary
extends BlockPressurePlateAbstract {
    public static final BlockStateBoolean d = BlockProperties.w;
    private final EnumMobType e;

    protected BlockPressurePlateBinary(EnumMobType type, BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(d, false));
        this.e = type;
    }

    @Override
    protected int g(IBlockData state) {
        return state.c(d) != false ? 15 : 0;
    }

    @Override
    protected IBlockData a(IBlockData state, int rsOut) {
        return (IBlockData)state.a(d, rsOut > 0);
    }

    @Override
    protected void a(GeneratorAccess world, BlockPosition pos) {
        if (this.aG != Material.z && this.aG != Material.A) {
            world.a((EntityHuman)null, pos, SoundEffects.sL, SoundCategory.e, 0.3f, 0.6f);
        } else {
            world.a((EntityHuman)null, pos, SoundEffects.vx, SoundCategory.e, 0.3f, 0.8f);
        }
    }

    @Override
    protected void b(GeneratorAccess world, BlockPosition pos) {
        if (this.aG != Material.z && this.aG != Material.A) {
            world.a((EntityHuman)null, pos, SoundEffects.sK, SoundCategory.e, 0.3f, 0.5f);
        } else {
            world.a((EntityHuman)null, pos, SoundEffects.vw, SoundCategory.e, 0.3f, 0.7f);
        }
    }

    @Override
    protected int b(World world, BlockPosition pos) {
        List<net.minecraft.world.entity.Entity> list;
        AxisAlignedBB axisalignedbb = BlockPressurePlateAbstract.c.a(pos);
        switch (this.e) {
            case a: {
                list = world.a_(null, axisalignedbb);
                break;
            }
            case b: {
                list = world.a(EntityLiving.class, axisalignedbb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (entity.ck()) continue;
                if (this.g(world.a_(pos)) == 0) {
                    PlayerInteractEvent cancellable;
                    CraftWorld bworld = world.getWorld();
                    PluginManager manager = world.getCraftServer().getPluginManager();
                    if (entity instanceof EntityHuman) {
                        cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
                    } else {
                        cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), bworld.getBlockAt(pos.u(), pos.v(), pos.w()));
                        manager.callEvent((Event)((EntityInteractEvent)cancellable));
                    }
                    if (cancellable.isCancelled()) continue;
                }
                if (entity.ck()) continue;
                return 15;
            }
        }
        return 0;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
    }

    public static enum EnumMobType {
        a,
        b;

    }
}

