/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.data.worldgen.biome.BiomeRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.blending.Blender;

public class WorldChunkManagerMultiNoise
extends WorldChunkManager {
    public static final MapCodec<WorldChunkManagerMultiNoise> b = RecordCodecBuilder.mapCodec(instance2 -> instance2.group((App)ExtraCodecs.a(RecordCodecBuilder.create(instance -> instance.group((App)Climate.d.a.fieldOf("parameters").forGetter(Pair::getFirst), (App)BiomeBase.d.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf()).xmap(Climate.c::new, Climate.c::a).fieldOf("biomes").forGetter(multiNoiseBiomeSource -> multiNoiseBiomeSource.d)).apply((Applicative)instance2, WorldChunkManagerMultiNoise::new));
    public static final Codec<WorldChunkManagerMultiNoise> c = Codec.mapEither(net.minecraft.world.level.biome.WorldChunkManagerMultiNoise$b.a, b).xmap(either -> either.map(b::a, Function.identity()), multiNoiseBiomeSource -> multiNoiseBiomeSource.d().map(Either::left).orElseGet(() -> Either.right(multiNoiseBiomeSource))).codec();
    private final Climate.c<Supplier<BiomeBase>> d;
    private final Optional<b> e;

    private WorldChunkManagerMultiNoise(Climate.c<Supplier<BiomeBase>> entries) {
        this(entries, Optional.empty());
    }

    WorldChunkManagerMultiNoise(Climate.c<Supplier<BiomeBase>> biomeEntries, Optional<b> instance) {
        super(biomeEntries.a().stream().map(Pair::getSecond));
        this.e = instance;
        this.d = biomeEntries;
    }

    @Override
    @Override
    protected Codec<? extends WorldChunkManager> a() {
        return c;
    }

    @Override
    @Override
    public WorldChunkManager a(long seed) {
        return this;
    }

    private Optional<b> d() {
        return this.e;
    }

    public boolean a(a instance) {
        return this.e.isPresent() && Objects.equals(this.e.get().b(), instance);
    }

    @Override
    @Override
    public BiomeBase getNoiseBiome(int x2, int y2, int z2, Climate.Sampler noise) {
        return this.a(noise.sample(x2, y2, z2));
    }

    @VisibleForDebug
    public BiomeBase a(Climate.h point) {
        return this.d.a(point, () -> BiomeRegistry.a).get();
    }

    @Override
    @Override
    public void a(List<String> info, BlockPosition pos, Climate.Sampler noiseSampler) {
        int i2 = QuartPos.a(pos.u());
        int j2 = QuartPos.a(pos.v());
        int k2 = QuartPos.a(pos.w());
        Climate.h targetPoint = noiseSampler.sample(i2, j2, k2);
        float f2 = Climate.a(targetPoint.d());
        float g2 = Climate.a(targetPoint.e());
        float h2 = Climate.a(targetPoint.b());
        float l2 = Climate.a(targetPoint.c());
        float m2 = Climate.a(targetPoint.g());
        double d2 = TerrainShaper.a(m2);
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        info.add("Multinoise C: " + decimalFormat.format(f2) + " E: " + decimalFormat.format(g2) + " T: " + decimalFormat.format(h2) + " H: " + decimalFormat.format(l2) + " W: " + decimalFormat.format(m2));
        OverworldBiomeBuilder overworldBiomeBuilder = new OverworldBiomeBuilder();
        info.add("Biome builder PV: " + OverworldBiomeBuilder.a(d2) + " C: " + overworldBiomeBuilder.b(f2) + " E: " + overworldBiomeBuilder.c(g2) + " T: " + overworldBiomeBuilder.d(h2) + " H: " + overworldBiomeBuilder.e(l2));
        if (!(noiseSampler instanceof NoiseSampler)) {
            return;
        }
        NoiseSampler noiseSampler2 = (NoiseSampler)noiseSampler;
        TerrainInfo terrainInfo = noiseSampler2.a(pos.u(), pos.w(), f2, m2, g2, Blender.a());
        info.add("Terrain PV: " + decimalFormat.format(d2) + " O: " + decimalFormat.format(terrainInfo.a()) + " F: " + decimalFormat.format(terrainInfo.b()) + " JA: " + decimalFormat.format(terrainInfo.c()));
    }

    record b(a b, IRegistry<BiomeBase> c) {
        public static final MapCodec<b> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinecraftKey.a.flatXmap(id -> Optional.ofNullable(net.minecraft.world.level.biome.WorldChunkManagerMultiNoise$a.c.get(id)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + id))), preset -> DataResult.success((Object)preset.d)).fieldOf("preset").stable().forGetter(b::b), (App)RegistryLookupCodec.a(IRegistry.aR).forGetter(b::c)).apply((Applicative)instance, instance.stable(b::new)));

        public WorldChunkManagerMultiNoise a() {
            return this.b.a(this, true);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "preset;biomes", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "preset;biomes", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "preset;biomes", "b", "c"}, this, object);
        }
    }

    public static class a {
        static final Map<MinecraftKey, a> c = Maps.newHashMap();
        public static final a a = new a(new MinecraftKey("nether"), registry -> new Climate.c(ImmutableList.of((Object)Pair.of((Object)Climate.a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> registry.d(Biomes.Z)), (Object)Pair.of((Object)Climate.a(0.0f, -0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> registry.d(Biomes.ac)), (Object)Pair.of((Object)Climate.a(0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> registry.d(Biomes.ab)), (Object)Pair.of((Object)Climate.a(0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.375f), () -> registry.d(Biomes.aa)), (Object)Pair.of((Object)Climate.a(-0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.175f), () -> registry.d(Biomes.ad)))));
        public static final a b = new a(new MinecraftKey("overworld"), registry -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            new OverworldBiomeBuilder().a((Pair<Climate.d, ResourceKey<BiomeBase>> pair) -> builder.add((Object)pair.mapSecond(resourceKey -> () -> (BiomeBase)registry.d(resourceKey))));
            return new Climate.c(builder.build());
        });
        final MinecraftKey d;
        private final Function<IRegistry<BiomeBase>, Climate.c<Supplier<BiomeBase>>> e;

        public a(MinecraftKey id, Function<IRegistry<BiomeBase>, Climate.c<Supplier<BiomeBase>>> biomeSourceFunction) {
            this.d = id;
            this.e = biomeSourceFunction;
            c.put(id, this);
        }

        WorldChunkManagerMultiNoise a(b instance, boolean useInstance) {
            Climate.c<Supplier<BiomeBase>> parameterList = this.e.apply(instance.c());
            return new WorldChunkManagerMultiNoise(parameterList, useInstance ? Optional.of(instance) : Optional.empty());
        }

        public WorldChunkManagerMultiNoise a(IRegistry<BiomeBase> biomeRegistry, boolean useInstance) {
            return this.a(new b(this, biomeRegistry), useInstance);
        }

        public WorldChunkManagerMultiNoise a(IRegistry<BiomeBase> biomeRegistry) {
            return this.a(biomeRegistry, true);
        }
    }
}

