/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeSettingsGeneration {
    public static final Logger a = LogManager.getLogger();
    public static final BiomeSettingsGeneration b = new BiomeSettingsGeneration((Map<WorldGenStage.Features, List<Supplier<WorldGenCarverWrapper<?>>>>)ImmutableMap.of(), (List<List<Supplier<PlacedFeature>>>)ImmutableList.of());
    public static final MapCodec<BiomeSettingsGeneration> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.simpleMap(WorldGenStage.Features.c, (Codec)WorldGenCarverWrapper.c.promotePartial(SystemUtils.a("Carver: ", arg_0 -> ((Logger)a).error(arg_0))).flatXmap(ExtraCodecs.b(), ExtraCodecs.b()), (Keyable)INamable.a(WorldGenStage.Features.values())).fieldOf("carvers").forGetter(biomeGenerationSettings -> biomeGenerationSettings.d), (App)PlacedFeature.c.promotePartial(SystemUtils.a("Feature: ", arg_0 -> ((Logger)a).error(arg_0))).flatXmap(ExtraCodecs.b(), ExtraCodecs.b()).listOf().fieldOf("features").forGetter(biomeGenerationSettings -> biomeGenerationSettings.e)).apply((Applicative)instance, BiomeSettingsGeneration::new));
    private final Map<WorldGenStage.Features, List<Supplier<WorldGenCarverWrapper<?>>>> d;
    private final List<List<Supplier<PlacedFeature>>> e;
    private final List<WorldGenFeatureConfigured<?, ?>> f;
    private final Set<PlacedFeature> g;

    BiomeSettingsGeneration(Map<WorldGenStage.Features, List<Supplier<WorldGenCarverWrapper<?>>>> carvers, List<List<Supplier<PlacedFeature>>> features) {
        this.d = carvers;
        this.e = features;
        this.f = (List)features.stream().flatMap(Collection::stream).map(Supplier::get).flatMap(PlacedFeature::a).filter(configuredFeature -> configuredFeature.e == WorldGenerator.h).collect(ImmutableList.toImmutableList());
        this.g = features.stream().flatMap(Collection::stream).map(Supplier::get).collect(Collectors.toSet());
    }

    public List<Supplier<WorldGenCarverWrapper<?>>> a(WorldGenStage.Features carverStep) {
        return (List)this.d.getOrDefault(carverStep, (List<Supplier<WorldGenCarverWrapper<?>>>)ImmutableList.of());
    }

    public List<WorldGenFeatureConfigured<?, ?>> a() {
        return this.f;
    }

    public List<List<Supplier<PlacedFeature>>> b() {
        return this.e;
    }

    public boolean a(PlacedFeature feature) {
        return this.g.contains(feature);
    }

    public static class a {
        private final Map<WorldGenStage.Features, List<Supplier<WorldGenCarverWrapper<?>>>> a = Maps.newLinkedHashMap();
        private final List<List<Supplier<PlacedFeature>>> b = Lists.newArrayList();

        public a a(WorldGenStage.Decoration featureStep, PlacedFeature feature) {
            return this.a(featureStep.ordinal(), () -> feature);
        }

        public a a(int stepIndex, Supplier<PlacedFeature> featureSupplier) {
            this.a(stepIndex);
            this.b.get(stepIndex).add(featureSupplier);
            return this;
        }

        public <C extends WorldGenCarverConfiguration> a a(WorldGenStage.Features carverStep, WorldGenCarverWrapper<C> carver) {
            this.a.computeIfAbsent(carverStep, carving -> Lists.newArrayList()).add(() -> carver);
            return this;
        }

        private void a(int stepIndex) {
            while (this.b.size() <= stepIndex) {
                this.b.add(Lists.newArrayList());
            }
        }

        public BiomeSettingsGeneration a() {
            return new BiomeSettingsGeneration((Map)this.a.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableList.copyOf((Collection)((Collection)entry.getValue())))), (List)this.b.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList()));
        }
    }
}

