/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeParticles;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.CaveSound;
import net.minecraft.world.level.biome.CaveSoundSettings;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BiomeBase {
    public static final Logger a = LogManager.getLogger();
    public static final Codec<BiomeBase> b = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.level.biome.BiomeBase$c.a.forGetter(biome -> biome.j), (App)Geography.t.fieldOf("category").forGetter(biome -> biome.m), (App)BiomeFog.a.fieldOf("effects").forGetter(biome -> biome.n), (App)BiomeSettingsGeneration.c.forGetter(biome -> biome.k), (App)BiomeSettingsMobs.d.forGetter(biome -> biome.l)).apply((Applicative)instance, BiomeBase::new));
    public static final Codec<BiomeBase> c = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.level.biome.BiomeBase$c.a.forGetter(biome -> biome.j), (App)Geography.t.fieldOf("category").forGetter(biome -> biome.m), (App)BiomeFog.a.fieldOf("effects").forGetter(biome -> biome.n)).apply((Applicative)instance, (climateSettings, biomeCategory, biomeSpecialEffects) -> new BiomeBase((c)climateSettings, (Geography)biomeCategory, (BiomeFog)biomeSpecialEffects, BiomeSettingsGeneration.b, BiomeSettingsMobs.c)));
    public static final Codec<Supplier<BiomeBase>> d = RegistryFileCodec.a(IRegistry.aR, b);
    public static final Codec<List<Supplier<BiomeBase>>> e = RegistryFileCodec.b(IRegistry.aR, b);
    private static final NoiseGenerator3 g = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(1234L)), (List<Integer>)ImmutableList.of((Object)0));
    static final NoiseGenerator3 h = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(3456L)), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    @Deprecated(forRemoval=true)
    public static final NoiseGenerator3 f = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(2345L)), (List<Integer>)ImmutableList.of((Object)0));
    private static final int i = 1024;
    private final c j;
    private final BiomeSettingsGeneration k;
    private final BiomeSettingsMobs l;
    private final Geography m;
    private final BiomeFog n;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> o = ThreadLocal.withInitial(() -> SystemUtils.a(() -> {
        Long2FloatLinkedOpenHashMap long2FloatLinkedOpenHashMap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int i2) {
            }
        };
        long2FloatLinkedOpenHashMap.defaultReturnValue(Float.NaN);
        return long2FloatLinkedOpenHashMap;
    }));

    BiomeBase(c weather, Geography category, BiomeFog effects, BiomeSettingsGeneration generationSettings, BiomeSettingsMobs spawnSettings) {
        this.j = weather;
        this.k = generationSettings;
        this.l = spawnSettings;
        this.m = category;
        this.n = effects;
    }

    public int a() {
        return this.n.d();
    }

    public BiomeSettingsMobs b() {
        return this.l;
    }

    public Precipitation c() {
        return this.j.b;
    }

    public boolean d() {
        return this.h() > 0.85f;
    }

    private float e(BlockPosition pos) {
        float f2 = this.j.d.a(pos, this.i());
        if (pos.v() > 80) {
            float g2 = (float)(g.a((float)pos.u() / 8.0f, (float)pos.w() / 8.0f, false) * 8.0);
            return f2 - (g2 + (float)pos.v() - 80.0f) * 0.05f / 40.0f;
        }
        return f2;
    }

    @Deprecated
    public float f(BlockPosition blockPos) {
        long l2 = blockPos.a();
        Long2FloatLinkedOpenHashMap long2FloatLinkedOpenHashMap = this.o.get();
        float f2 = long2FloatLinkedOpenHashMap.get(l2);
        if (!Float.isNaN(f2)) {
            return f2;
        }
        float g2 = this.e(blockPos);
        if (long2FloatLinkedOpenHashMap.size() == 1024) {
            long2FloatLinkedOpenHashMap.removeFirstFloat();
        }
        long2FloatLinkedOpenHashMap.put(l2, g2);
        return g2;
    }

    public boolean a(IWorldReader world, BlockPosition blockPos) {
        return this.a(world, blockPos, true);
    }

    public boolean a(IWorldReader world, BlockPosition pos, boolean doWaterCheck) {
        if (this.b(pos)) {
            return false;
        }
        if (pos.v() >= world.u_() && pos.v() < world.ag() && world.a(EnumSkyBlock.b, pos) < 10) {
            IBlockData blockState = world.a_(pos);
            Fluid fluidState = world.b_(pos);
            if (fluidState.a() == FluidTypes.c && blockState.b() instanceof BlockFluids) {
                boolean bl;
                if (!doWaterCheck) {
                    return true;
                }
                boolean bl2 = bl = world.A(pos.f()) && world.A(pos.g()) && world.A(pos.d()) && world.A(pos.e());
                if (!bl) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean a(BlockPosition pos) {
        return !this.b(pos);
    }

    public boolean b(BlockPosition pos) {
        return this.f(pos) >= 0.15f;
    }

    public boolean c(BlockPosition pos) {
        return this.f(pos) > 0.1f;
    }

    public boolean d(BlockPosition pos) {
        return this.f(pos) > 1.0f;
    }

    public boolean b(IWorldReader world, BlockPosition pos) {
        IBlockData blockState;
        if (this.b(pos)) {
            return false;
        }
        return pos.v() >= world.u_() && pos.v() < world.ag() && world.a(EnumSkyBlock.b, pos) < 10 && (blockState = world.a_(pos)).g() && Blocks.cK.n().a(world, pos);
    }

    public BiomeSettingsGeneration e() {
        return this.k;
    }

    public int f() {
        return this.n.a();
    }

    public int a(double x2, double z2) {
        int i2 = this.n.f().orElseGet(this::s);
        return this.n.g().a(x2, z2, i2);
    }

    private int s() {
        double d2 = MathHelper.a(this.j.c, 0.0f, 1.0f);
        double e2 = MathHelper.a(this.j.e, 0.0f, 1.0f);
        return GrassColor.a(d2, e2);
    }

    public int g() {
        return this.n.e().orElseGet(this::t);
    }

    private int t() {
        double d2 = MathHelper.a(this.j.c, 0.0f, 1.0f);
        double e2 = MathHelper.a(this.j.e, 0.0f, 1.0f);
        return FoliageColor.a(d2, e2);
    }

    public final float h() {
        return this.j.e;
    }

    public final float i() {
        return this.j.c;
    }

    public BiomeFog j() {
        return this.n;
    }

    public final int k() {
        return this.n.b();
    }

    public final int l() {
        return this.n.c();
    }

    public Optional<BiomeParticles> m() {
        return this.n.h();
    }

    public Optional<SoundEffect> n() {
        return this.n.i();
    }

    public Optional<CaveSoundSettings> o() {
        return this.n.j();
    }

    public Optional<CaveSound> p() {
        return this.n.k();
    }

    public Optional<Music> q() {
        return this.n.l();
    }

    public final Geography r() {
        return this.m;
    }

    public String toString() {
        MinecraftKey resourceLocation = RegistryGeneration.i.b(this);
        return resourceLocation == null ? super.toString() : resourceLocation.toString();
    }

    static class c {
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Precipitation.d.fieldOf("precipitation").forGetter(climateSettings -> climateSettings.b), (App)Codec.FLOAT.fieldOf("temperature").forGetter(climateSettings -> Float.valueOf(climateSettings.c)), (App)TemperatureModifier.c.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.a).forGetter(climateSettings -> climateSettings.d), (App)Codec.FLOAT.fieldOf("downfall").forGetter(climateSettings -> Float.valueOf(climateSettings.e))).apply((Applicative)instance, c::new));
        final Precipitation b;
        final float c;
        final TemperatureModifier d;
        final float e;

        c(Precipitation precipitation, float temperature, TemperatureModifier temperatureModifier, float downfall) {
            this.b = precipitation;
            this.c = temperature;
            this.d = temperatureModifier;
            this.e = downfall;
        }
    }

    public static final class Geography
    extends Enum<Geography>
    implements INamable {
        public static final /* enum */ Geography a = new Geography("none");
        public static final /* enum */ Geography b = new Geography("taiga");
        public static final /* enum */ Geography c = new Geography("extreme_hills");
        public static final /* enum */ Geography d = new Geography("jungle");
        public static final /* enum */ Geography e = new Geography("mesa");
        public static final /* enum */ Geography f = new Geography("plains");
        public static final /* enum */ Geography g = new Geography("savanna");
        public static final /* enum */ Geography h = new Geography("icy");
        public static final /* enum */ Geography i = new Geography("the_end");
        public static final /* enum */ Geography j = new Geography("beach");
        public static final /* enum */ Geography k = new Geography("forest");
        public static final /* enum */ Geography l = new Geography("ocean");
        public static final /* enum */ Geography m = new Geography("desert");
        public static final /* enum */ Geography n = new Geography("river");
        public static final /* enum */ Geography o = new Geography("swamp");
        public static final /* enum */ Geography p = new Geography("mushroom");
        public static final /* enum */ Geography q = new Geography("nether");
        public static final /* enum */ Geography r = new Geography("underground");
        public static final /* enum */ Geography s = new Geography("mountain");
        public static final Codec<Geography> t;
        private static final Map<String, Geography> u;
        private final String v;
        private static final /* synthetic */ Geography[] w;

        public static Geography[] values() {
            return (Geography[])w.clone();
        }

        public static Geography valueOf(String name) {
            return Enum.valueOf(Geography.class, name);
        }

        private Geography(String name) {
            this.v = name;
        }

        public String a() {
            return this.v;
        }

        public static Geography a(String name) {
            return u.get(name);
        }

        @Override
        public String c() {
            return this.v;
        }

        private static /* synthetic */ Geography[] b() {
            return new Geography[]{a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s};
        }

        static {
            w = Geography.b();
            t = INamable.a(Geography::values, Geography::a);
            u = Arrays.stream(Geography.values()).collect(Collectors.toMap(Geography::a, category -> category));
        }
    }

    public static final class Precipitation
    extends Enum<Precipitation>
    implements INamable {
        public static final /* enum */ Precipitation a = new Precipitation("none");
        public static final /* enum */ Precipitation b = new Precipitation("rain");
        public static final /* enum */ Precipitation c = new Precipitation("snow");
        public static final Codec<Precipitation> d;
        private static final Map<String, Precipitation> e;
        private final String f;
        private static final /* synthetic */ Precipitation[] g;

        public static Precipitation[] values() {
            return (Precipitation[])g.clone();
        }

        public static Precipitation valueOf(String name) {
            return Enum.valueOf(Precipitation.class, name);
        }

        private Precipitation(String name) {
            this.f = name;
        }

        public String a() {
            return this.f;
        }

        public static Precipitation a(String name) {
            return e.get(name);
        }

        @Override
        public String c() {
            return this.f;
        }

        private static /* synthetic */ Precipitation[] b() {
            return new Precipitation[]{a, b, c};
        }

        static {
            g = Precipitation.b();
            d = INamable.a(Precipitation::values, Precipitation::a);
            e = Arrays.stream(Precipitation.values()).collect(Collectors.toMap(Precipitation::a, precipitation -> precipitation));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TemperatureModifier
    extends Enum<TemperatureModifier>
    implements INamable {
        public static final /* enum */ TemperatureModifier a = new TemperatureModifier("none"){

            @Override
            public float a(BlockPosition pos, float temperature) {
                return temperature;
            }
        };
        public static final /* enum */ TemperatureModifier b = new TemperatureModifier("frozen"){

            @Override
            public float a(BlockPosition pos, float temperature) {
                double g2;
                double e2;
                double d2 = h.a((double)pos.u() * 0.05, (double)pos.w() * 0.05, false) * 7.0;
                double f2 = d2 + (e2 = BiomeBase.f.a((double)pos.u() * 0.2, (double)pos.w() * 0.2, false));
                if (f2 < 0.3 && (g2 = BiomeBase.f.a((double)pos.u() * 0.09, (double)pos.w() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return temperature;
            }
        };
        private final String d;
        public static final Codec<TemperatureModifier> c;
        private static final Map<String, TemperatureModifier> e;
        private static final /* synthetic */ TemperatureModifier[] f;

        public static TemperatureModifier[] values() {
            return (TemperatureModifier[])f.clone();
        }

        public static TemperatureModifier valueOf(String name) {
            return Enum.valueOf(TemperatureModifier.class, name);
        }

        public abstract float a(BlockPosition var1, float var2);

        private TemperatureModifier(String name) {
            this.d = name;
        }

        public String a() {
            return this.d;
        }

        @Override
        public String c() {
            return this.d;
        }

        public static TemperatureModifier a(String name) {
            return e.get(name);
        }

        private static /* synthetic */ TemperatureModifier[] b() {
            return new TemperatureModifier[]{a, b};
        }

        static {
            f = TemperatureModifier.b();
            c = INamable.a(TemperatureModifier::values, TemperatureModifier::a);
            e = Arrays.stream(TemperatureModifier.values()).collect(Collectors.toMap(TemperatureModifier::a, temperatureModifier -> temperatureModifier));
        }
    }

    public static class a {
        @Nullable
        private Precipitation a;
        @Nullable
        private Geography b;
        @Nullable
        private Float c;
        private TemperatureModifier d = TemperatureModifier.a;
        @Nullable
        private Float e;
        @Nullable
        private BiomeFog f;
        @Nullable
        private BiomeSettingsMobs g;
        @Nullable
        private BiomeSettingsGeneration h;

        public a a(Precipitation precipitation) {
            this.a = precipitation;
            return this;
        }

        public a a(Geography category) {
            this.b = category;
            return this;
        }

        public a a(float temperature) {
            this.c = Float.valueOf(temperature);
            return this;
        }

        public a b(float downfall) {
            this.e = Float.valueOf(downfall);
            return this;
        }

        public a a(BiomeFog effects) {
            this.f = effects;
            return this;
        }

        public a a(BiomeSettingsMobs spawnSettings) {
            this.g = spawnSettings;
            return this;
        }

        public a a(BiomeSettingsGeneration generationSettings) {
            this.h = generationSettings;
            return this;
        }

        public a a(TemperatureModifier temperatureModifier) {
            this.d = temperatureModifier;
            return this;
        }

        public BiomeBase a() {
            if (this.a != null && this.b != null && this.c != null && this.e != null && this.f != null && this.g != null && this.h != null) {
                return new BiomeBase(new c(this.a, this.c.floatValue(), this.d, this.e.floatValue()), this.b, this.f, this.h, this.g);
            }
            throw new IllegalStateException("You are missing parameters to build a proper biome\n" + this);
        }

        public String toString() {
            return "BiomeBuilder{\nprecipitation=" + this.a + ",\nbiomeCategory=" + this.b + ",\ntemperature=" + this.c + ",\ntemperatureModifier=" + this.d + ",\ndownfall=" + this.e + ",\nspecialEffects=" + this.f + ",\nmobSpawnSettings=" + this.g + ",\ngenerationSettings=" + this.h + ",\n}";
        }
    }
}

