/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreatureProbabilities;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenNether;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;

public final class SpawnerCreature {
    private static final Logger c = LogManager.getLogger();
    private static final int d = 24;
    public static final int a = 8;
    public static final int b = 128;
    static final int e = (int)Math.pow(17.0, 2.0);
    public static final EnumCreatureType[] f = (EnumCreatureType[])Stream.of(EnumCreatureType.values()).filter(enumcreaturetype -> enumcreaturetype != EnumCreatureType.h).toArray(EnumCreatureType[]::new);

    private SpawnerCreature() {
    }

    public static d a(int spawningChunkCount, Iterable<Entity> entities, b chunkSource, LocalMobCapCalculator localmobcapcalculator) {
        return SpawnerCreature.createState(spawningChunkCount, entities, chunkSource, localmobcapcalculator, false);
    }

    public static d createState(int spawningChunkCount, Iterable<Entity> entities, b chunkSource, LocalMobCapCalculator localmobcapcalculator, boolean countMobs) {
        SpawnerCreatureProbabilities spawnercreatureprobabilities = new SpawnerCreatureProbabilities();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        for (Entity entity : entities) {
            EnumCreatureType enumcreaturetype;
            EntityInsentient entityinsentient;
            if (entity instanceof EntityInsentient && (entityinsentient = (EntityInsentient)entity).h(0.0) && entityinsentient.fi() || (enumcreaturetype = entity.ad().f()) == EnumCreatureType.h || !entity.t.paperConfig.countAllMobsForSpawning && entity.spawnReason != CreatureSpawnEvent.SpawnReason.NATURAL && entity.spawnReason != CreatureSpawnEvent.SpawnReason.CHUNK_GEN) continue;
            BlockPosition blockposition = entity.cW();
            chunkSource.query(ChunkCoordIntPair.a(blockposition), chunk -> {
                BiomeSettingsMobs.b biomesettingsmobs_b = SpawnerCreature.a(blockposition, (IChunkAccess)chunk).b().a(entity.ad());
                if (biomesettingsmobs_b != null) {
                    spawnercreatureprobabilities.a(entity.cW(), biomesettingsmobs_b.b());
                }
                if (localmobcapcalculator != null && entity instanceof EntityInsentient) {
                    localmobcapcalculator.a(chunk.f(), enumcreaturetype);
                }
                object2intopenhashmap.addTo((Object)enumcreaturetype, 1);
                if (countMobs) {
                    chunk.q.k().a.updatePlayerMobTypeMap(entity);
                }
            });
        }
        return new d(spawningChunkCount, (Object2IntOpenHashMap<EnumCreatureType>)object2intopenhashmap, spawnercreatureprobabilities, localmobcapcalculator);
    }

    static BiomeBase a(BlockPosition pos, IChunkAccess chunk) {
        return chunk.getNoiseBiome(QuartPos.a(pos.u()), QuartPos.a(pos.v()), QuartPos.a(pos.w()));
    }

    public static void a(WorldServer world, Chunk chunk, d info, boolean spawnAnimals, boolean spawnMonsters, boolean rareSpawn) {
        world.ab().a("spawner");
        world.timings.mobSpawn.startTiming();
        EnumCreatureType[] aenumcreaturetype = f;
        int i2 = aenumcreaturetype.length;
        WorldData worlddata = world.n_();
        boolean spawnAnimalThisTick = world.ticksPerAnimalSpawns != 0L && worlddata.e() % world.ticksPerAnimalSpawns == 0L;
        boolean spawnMonsterThisTick = world.ticksPerMonsterSpawns != 0L && worlddata.e() % world.ticksPerMonsterSpawns == 0L;
        boolean spawnWaterThisTick = world.ticksPerWaterSpawns != 0L && worlddata.e() % world.ticksPerWaterSpawns == 0L;
        boolean spawnAmbientThisTick = world.ticksPerAmbientSpawns != 0L && worlddata.e() % world.ticksPerAmbientSpawns == 0L;
        boolean spawnWaterAmbientThisTick = world.ticksPerWaterAmbientSpawns != 0L && worlddata.e() % world.ticksPerWaterAmbientSpawns == 0L;
        boolean spawnWaterUndergroundCreatureThisTick = world.ticksPerWaterUndergroundCreatureSpawns != 0L && worlddata.e() % world.ticksPerWaterUndergroundCreatureSpawns == 0L;
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumCreatureType enumcreaturetype = aenumcreaturetype[j2];
            boolean spawnThisTick = true;
            int limit = SpawnerCreature.limitForCategory(world, enumcreaturetype);
            switch (enumcreaturetype) {
                case a: {
                    spawnThisTick = spawnMonsterThisTick;
                    break;
                }
                case b: {
                    spawnThisTick = spawnAnimalThisTick;
                    break;
                }
                case f: {
                    spawnThisTick = spawnWaterThisTick;
                    break;
                }
                case e: {
                    spawnThisTick = spawnWaterUndergroundCreatureThisTick;
                    break;
                }
                case c: {
                    spawnThisTick = spawnAmbientThisTick;
                    break;
                }
                case g: {
                    spawnThisTick = spawnWaterAmbientThisTick;
                }
            }
            if (!spawnThisTick || limit == 0) continue;
            int currEntityCount = info.b.getInt((Object)enumcreaturetype);
            int k1 = limit * info.a() / e;
            int difference = k1 - currEntityCount;
            if (world.paperConfig.perPlayerMobSpawns) {
                int minDiff = Integer.MAX_VALUE;
                PooledLinkedHashSets.PooledObjectLinkedOpenHashSet inRange = world.k().a.playerMobDistanceMap.getObjectsInRange(chunk.f());
                if (inRange != null) {
                    E[] backingSet = inRange.getBackingSet();
                    for (int k2 = 0; k2 < backingSet.length; ++k2) {
                        Object e2 = backingSet[k2];
                        if (!(e2 instanceof EntityPlayer)) continue;
                        EntityPlayer player = (EntityPlayer)e2;
                        minDiff = Math.min(limit - world.k().a.getMobCountNear(player, enumcreaturetype), minDiff);
                    }
                }
                int n2 = difference = minDiff == Integer.MAX_VALUE ? 0 : minDiff;
            }
            if (!spawnAnimals && enumcreaturetype.d() || !spawnMonsters && !enumcreaturetype.d() || !rareSpawn && enumcreaturetype.e() || difference <= 0) continue;
            Objects.requireNonNull(info);
            c spawnercreature_c = info::a;
            Objects.requireNonNull(info);
            int spawnCount = SpawnerCreature.spawnCategoryForChunk(enumcreaturetype, world, chunk, spawnercreature_c, info::a, difference, world.paperConfig.perPlayerMobSpawns ? world.k().a::updatePlayerMobTypeMap : null);
            info.b.mergeInt((Object)enumcreaturetype, spawnCount, Integer::sum);
        }
        world.timings.mobSpawn.stopTiming();
        world.ab().c();
    }

    public static int limitForCategory(WorldServer world, EnumCreatureType enumcreaturetype) {
        return switch (enumcreaturetype) {
            case EnumCreatureType.a -> world.getWorld().getMonsterSpawnLimit();
            case EnumCreatureType.b -> world.getWorld().getAnimalSpawnLimit();
            case EnumCreatureType.f -> world.getWorld().getWaterAnimalSpawnLimit();
            case EnumCreatureType.e -> world.getWorld().getWaterUndergroundCreatureSpawnLimit();
            case EnumCreatureType.c -> world.getWorld().getAmbientSpawnLimit();
            case EnumCreatureType.g -> world.getWorld().getWaterAmbientSpawnLimit();
            default -> enumcreaturetype.b();
        };
    }

    public static int globalLimitForCategory(WorldServer level, EnumCreatureType category, int spawnableChunkCount) {
        int categoryLimit = SpawnerCreature.limitForCategory(level, category);
        if (categoryLimit < 1) {
            return categoryLimit;
        }
        return categoryLimit * spawnableChunkCount / e;
    }

    public static void a(EnumCreatureType group, WorldServer world, Chunk chunk, c checker, a runner) {
        SpawnerCreature.a(group, world, chunk, checker, runner);
    }

    public static int spawnCategoryForChunk(EnumCreatureType group, WorldServer world, Chunk chunk, c checker, a runner, int maxSpawns, Consumer<Entity> trackEntity) {
        BlockPosition blockposition = SpawnerCreature.a((World)world, chunk);
        if (blockposition.v() >= world.u_() + 1) {
            return SpawnerCreature.spawnCategoryForPosition(group, world, chunk, blockposition, checker, runner, maxSpawns, trackEntity);
        }
        return 0;
    }

    @VisibleForDebug
    public static void a(EnumCreatureType group, WorldServer world, BlockPosition pos) {
        SpawnerCreature.a(group, world, world.z(pos), pos, (EntityTypes<?> entitytypes, BlockPosition blockposition1, IChunkAccess ichunkaccess) -> true, (EntityInsentient entityinsentient, IChunkAccess ichunkaccess) -> {});
    }

    public static void a(EnumCreatureType group, WorldServer world, IChunkAccess chunk, BlockPosition pos, c checker, a runner) {
        SpawnerCreature.a(group, world, chunk, pos, checker, runner);
    }

    public static int spawnCategoryForPosition(EnumCreatureType group, WorldServer world, IChunkAccess chunk, BlockPosition pos, c checker, a runner, int maxSpawns, Consumer<Entity> trackEntity) {
        StructureManager structuremanager = world.a();
        ChunkGenerator chunkgenerator = world.k().g();
        int i2 = pos.v();
        IBlockData iblockdata = world.getBlockStateIfLoadedAndInBounds(pos);
        int j2 = 0;
        if (iblockdata != null && !iblockdata.g(chunk, pos)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            block0: for (int k2 = 0; k2 < 3; ++k2) {
                int l2 = pos.u();
                int i1 = pos.w();
                boolean flag = true;
                BiomeSettingsMobs.c biomesettingsmobs_c = null;
                GroupDataEntity groupdataentity = null;
                int j1 = MathHelper.f(world.w.nextFloat() * 4.0f);
                int k1 = 0;
                for (int l1 = 0; l1 < j1; ++l1) {
                    Boolean doSpawning;
                    EntityHuman entityhuman;
                    blockposition_mutableblockposition.d(l2 += world.w.nextInt(6) - world.w.nextInt(6), i2, i1 += world.w.nextInt(6) - world.w.nextInt(6));
                    double d0 = (double)l2 + 0.5;
                    double d1 = (double)i1 + 0.5;
                    EntityHuman entityHuman = entityhuman = chunk instanceof Chunk ? ((Chunk)chunk).findNearestPlayer(d0, i2, d1, 576.0, IEntitySelector.f) : world.a(d0, (double)i2, d1, -1.0, false);
                    if (entityhuman == null) continue;
                    double d2 = entityhuman.h(d0, i2, d1);
                    if (!world.isLoadedAndInBounds(blockposition_mutableblockposition) || !SpawnerCreature.a(world, chunk, blockposition_mutableblockposition, d2)) continue;
                    if (biomesettingsmobs_c == null) {
                        Optional<BiomeSettingsMobs.c> optional = SpawnerCreature.a(world, structuremanager, chunkgenerator, group, world.w, (BlockPosition)blockposition_mutableblockposition);
                        if (optional.isEmpty()) continue block0;
                        biomesettingsmobs_c = optional.get();
                        j1 = biomesettingsmobs_c.c + world.w.nextInt(1 + biomesettingsmobs_c.d - biomesettingsmobs_c.c);
                    }
                    if ((doSpawning = SpawnerCreature.isValidSpawnPostitionForType(world, group, structuremanager, chunkgenerator, biomesettingsmobs_c, blockposition_mutableblockposition, d2)) == null) {
                        return j2;
                    }
                    if (!doSpawning.booleanValue() || !checker.test(biomesettingsmobs_c.b, blockposition_mutableblockposition, chunk)) continue;
                    EntityInsentient entityinsentient = SpawnerCreature.a(world, biomesettingsmobs_c.b);
                    if (entityinsentient == null) {
                        return j2;
                    }
                    entityinsentient.b(d0, i2, d1, world.w.nextFloat() * 360.0f, 0.0f);
                    if (!SpawnerCreature.a(world, entityinsentient, d2)) continue;
                    groupdataentity = entityinsentient.a(world, world.d_(entityinsentient.cW()), EnumMobSpawn.a, groupdataentity, null);
                    world.addFreshEntityWithPassengers(entityinsentient, CreatureSpawnEvent.SpawnReason.NATURAL);
                    if (!entityinsentient.do()) {
                        ++j2;
                        ++k1;
                        runner.run(entityinsentient, chunk);
                        if (trackEntity != null) {
                            trackEntity.accept(entityinsentient);
                        }
                    }
                    if (j2 >= entityinsentient.fe() || j2 >= maxSpawns) {
                        return j2;
                    }
                    if (entityinsentient.c(k1)) continue block0;
                }
            }
        }
        return j2;
    }

    private static boolean a(WorldServer world, IChunkAccess chunk, BlockPosition.MutableBlockPosition pos, double squaredDistance) {
        return squaredDistance <= 576.0 ? false : (world.w().a((IPosition)new Vec3D((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5), 24.0) ? false : Objects.equals(new ChunkCoordIntPair(pos), chunk.f()) || world.e(pos));
    }

    private static Boolean isValidSpawnPostitionForType(WorldServer world, EnumCreatureType group, StructureManager structureAccessor, ChunkGenerator chunkGenerator, BiomeSettingsMobs.c spawnEntry, BlockPosition.MutableBlockPosition pos, double squaredDistance) {
        PreCreatureSpawnEvent event;
        EntityTypes<?> entitytypes = spawnEntry.b;
        EntityType type = EntityType.fromName((String)EntityTypes.a(entitytypes).a());
        if (type != null && !(event = new PreCreatureSpawnEvent(MCUtil.toLocation(world, pos), type, CreatureSpawnEvent.SpawnReason.NATURAL)).callEvent()) {
            if (event.shouldAbortSpawn()) {
                return null;
            }
            return false;
        }
        if (entitytypes.f() == EnumCreatureType.h) {
            return false;
        }
        if (!entitytypes.e() && squaredDistance > (double)(entitytypes.f().f() * entitytypes.f().f())) {
            return false;
        }
        if (entitytypes.c() && SpawnerCreature.a(world, structureAccessor, chunkGenerator, group, spawnEntry, (BlockPosition)pos)) {
            EntityPositionTypes.Surface entitypositiontypes_surface = EntityPositionTypes.a(entitytypes);
            return !SpawnerCreature.a(entitypositiontypes_surface, (IWorldReader)world, (BlockPosition)pos, entitytypes) ? false : (!EntityPositionTypes.a(entitytypes, world, EnumMobSpawn.a, pos, world.w) ? false : world.b(entitytypes.a((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5)));
        }
        return false;
    }

    @Nullable
    private static EntityInsentient a(WorldServer world, EntityTypes<?> type) {
        try {
            Object entity = type.a(world);
            if (!(entity instanceof EntityInsentient)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + IRegistry.Z.b(type));
            }
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient;
        }
        catch (Exception exception) {
            c.warn("Failed to create mob", (Throwable)exception);
            ServerInternalException.reportInternalException((Throwable)exception);
            return null;
        }
    }

    private static boolean a(WorldServer world, EntityInsentient entity, double squaredDistance) {
        return squaredDistance > (double)(entity.ad().f().f() * entity.ad().f().f()) && entity.h(squaredDistance) ? false : entity.a((GeneratorAccess)world, EnumMobSpawn.a) && entity.a((IWorldReader)world);
    }

    private static Optional<BiomeSettingsMobs.c> a(WorldServer world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, EnumCreatureType spawnGroup, Random random, BlockPosition pos) {
        BiomeBase biomebase = world.v(pos);
        return spawnGroup == EnumCreatureType.g && biomebase.r() == BiomeBase.Geography.n && random.nextFloat() < 0.98f ? Optional.empty() : SpawnerCreature.a(world, structureAccessor, chunkGenerator, spawnGroup, pos, biomebase).b(random);
    }

    private static boolean a(WorldServer world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, EnumCreatureType spawnGroup, BiomeSettingsMobs.c spawnEntry, BlockPosition pos) {
        return SpawnerCreature.a(world, structureAccessor, chunkGenerator, spawnGroup, pos, (BiomeBase)null).e().contains(spawnEntry);
    }

    private static WeightedRandomList<BiomeSettingsMobs.c> a(WorldServer world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, EnumCreatureType spawnGroup, BlockPosition pos, @Nullable BiomeBase biome) {
        return SpawnerCreature.a(pos, world, spawnGroup, structureAccessor) ? WorldGenNether.a : chunkGenerator.a(biome != null ? biome : world.v(pos), structureAccessor, spawnGroup, pos);
    }

    public static boolean a(BlockPosition pos, WorldServer world, EnumCreatureType spawnGroup, StructureManager structureAccessor) {
        return spawnGroup == EnumCreatureType.a && world.a_(pos.c()).a(Blocks.ee) && structureAccessor.a(pos, StructureGenerator.o).b();
    }

    private static BlockPosition a(World world, Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int i2 = chunkcoordintpair.d() + world.w.nextInt(16);
        int j2 = chunkcoordintpair.e() + world.w.nextInt(16);
        int k2 = chunk.a(HeightMap.Type.b, i2, j2) + 1;
        int l2 = MathHelper.b(world.w, world.u_(), k2);
        return new BlockPosition(i2, l2, j2);
    }

    public static boolean a(IBlockAccess blockView, BlockPosition pos, IBlockData state, Fluid fluidState, EntityTypes<?> entityType) {
        return state.r(blockView, pos) ? false : (state.i() ? false : (!fluidState.c() ? false : (state.a(TagsBlock.aK) ? false : !entityType.a(state))));
    }

    public static boolean a(EntityPositionTypes.Surface location, IWorldReader world, BlockPosition pos, @Nullable EntityTypes<?> entityType) {
        if (location == EntityPositionTypes.Surface.c) {
            return true;
        }
        if (entityType != null && world.p_().a(pos)) {
            IBlockData iblockdata = world.a_(pos);
            Fluid fluid = world.b_(pos);
            BlockPosition blockposition1 = pos.b();
            BlockPosition blockposition2 = pos.c();
            switch (location) {
                case b: {
                    return fluid.a(TagsFluid.b) && !world.a_(blockposition1).g(world, blockposition1);
                }
                case d: {
                    return fluid.a(TagsFluid.c);
                }
            }
            IBlockData iblockdata1 = world.a_(blockposition2);
            return !iblockdata1.a((IBlockAccess)world, blockposition2, entityType) ? false : SpawnerCreature.a(world, pos, iblockdata, fluid, entityType) && SpawnerCreature.a(world, blockposition1, world.a_(blockposition1), world.b_(blockposition1), entityType);
        }
        return false;
    }

    public static void a(WorldAccess world, BiomeBase biome, ChunkCoordIntPair chunkPos, Random random) {
        BiomeSettingsMobs biomesettingsmobs = biome.b();
        WeightedRandomList<BiomeSettingsMobs.c> weightedrandomlist = biomesettingsmobs.a(EnumCreatureType.b);
        if (!weightedrandomlist.d()) {
            int i2 = chunkPos.d();
            int j2 = chunkPos.e();
            while (random.nextFloat() < biomesettingsmobs.a()) {
                Optional<BiomeSettingsMobs.c> optional = weightedrandomlist.b(random);
                if (!optional.isPresent()) continue;
                BiomeSettingsMobs.c biomesettingsmobs_c = optional.get();
                int k2 = biomesettingsmobs_c.c + random.nextInt(1 + biomesettingsmobs_c.d - biomesettingsmobs_c.c);
                GroupDataEntity groupdataentity = null;
                int l2 = i2 + random.nextInt(16);
                int i1 = j2 + random.nextInt(16);
                int j1 = l2;
                int k1 = i1;
                for (int l1 = 0; l1 < k2; ++l1) {
                    boolean flag = false;
                    for (int i22 = 0; !flag && i22 < 4; ++i22) {
                        BlockPosition blockposition = SpawnerCreature.a((IWorldReader)world, biomesettingsmobs_c.b, l2, i1);
                        if (biomesettingsmobs_c.b.c() && SpawnerCreature.a(EntityPositionTypes.a(biomesettingsmobs_c.b), world, blockposition, biomesettingsmobs_c.b)) {
                            EntityInsentient entityinsentient;
                            Object entity;
                            float f2 = biomesettingsmobs_c.b.k();
                            double d0 = MathHelper.a((double)l2, (double)i2 + (double)f2, (double)i2 + 16.0 - (double)f2);
                            double d1 = MathHelper.a((double)i1, (double)j2 + (double)f2, (double)j2 + 16.0 - (double)f2);
                            if (!world.b(biomesettingsmobs_c.b.a(d0, blockposition.v(), d1)) || !EntityPositionTypes.a(biomesettingsmobs_c.b, world, EnumMobSpawn.b, new BlockPosition(d0, (double)blockposition.v(), d1), world.r_())) continue;
                            try {
                                entity = biomesettingsmobs_c.b.a(world.G());
                            }
                            catch (Exception exception) {
                                c.warn("Failed to create mob", (Throwable)exception);
                                ServerInternalException.reportInternalException((Throwable)exception);
                                continue;
                            }
                            ((Entity)entity).b(d0, blockposition.v(), d1, random.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof EntityInsentient && (entityinsentient = (EntityInsentient)entity).a(world, EnumMobSpawn.b) && entityinsentient.a(world)) {
                                groupdataentity = entityinsentient.a(world, world.d_(entityinsentient.cW()), EnumMobSpawn.b, groupdataentity, null);
                                world.addFreshEntityWithPassengers(entityinsentient, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
                                flag = true;
                            }
                        }
                        l2 += random.nextInt(5) - random.nextInt(5);
                        i1 += random.nextInt(5) - random.nextInt(5);
                        while (l2 < i2 || l2 >= i2 + 16 || i1 < j2 || i1 >= j2 + 16) {
                            l2 = j1 + random.nextInt(5) - random.nextInt(5);
                            i1 = k1 + random.nextInt(5) - random.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPosition a(IWorldReader world, EntityTypes<?> entityType, int x2, int z2) {
        BlockPosition blockposition;
        int k2 = world.a(EntityPositionTypes.b(entityType), x2, z2);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(x2, k2, z2);
        if (world.q_().c()) {
            do {
                blockposition_mutableblockposition.c(EnumDirection.a);
            } while (!world.a_(blockposition_mutableblockposition).g());
            do {
                blockposition_mutableblockposition.c(EnumDirection.a);
            } while (world.a_(blockposition_mutableblockposition).g() && blockposition_mutableblockposition.v() > world.u_());
        }
        if (EntityPositionTypes.a(entityType) == EntityPositionTypes.Surface.a && world.a_(blockposition = blockposition_mutableblockposition.c()).a((IBlockAccess)world, blockposition, PathMode.a)) {
            return blockposition;
        }
        return blockposition_mutableblockposition.h();
    }

    @FunctionalInterface
    public static interface b {
        public void query(long var1, Consumer<Chunk> var3);
    }

    public static class d {
        private final int a;
        private final Object2IntOpenHashMap<EnumCreatureType> b;
        private final SpawnerCreatureProbabilities c;
        private final Object2IntMap<EnumCreatureType> d;
        private final LocalMobCapCalculator e;
        @Nullable
        private BlockPosition f;
        @Nullable
        private EntityTypes<?> g;
        private double h;

        d(int spawningChunkCount, Object2IntOpenHashMap<EnumCreatureType> groupToCount, SpawnerCreatureProbabilities densityField, LocalMobCapCalculator densityCapper) {
            this.a = spawningChunkCount;
            this.b = groupToCount;
            this.c = densityField;
            this.e = densityCapper;
            this.d = Object2IntMaps.unmodifiable(groupToCount);
        }

        private boolean a(EntityTypes<?> type, BlockPosition pos, IChunkAccess chunk) {
            double d0;
            this.f = pos;
            this.g = type;
            BiomeSettingsMobs.b biomesettingsmobs_b = SpawnerCreature.a(pos, chunk).b().a(type);
            if (biomesettingsmobs_b == null) {
                this.h = 0.0;
                return true;
            }
            this.h = d0 = biomesettingsmobs_b.b();
            double d1 = this.c.b(pos, d0);
            return d1 <= biomesettingsmobs_b.a();
        }

        private void a(EntityInsentient entity, IChunkAccess chunk) {
            BiomeSettingsMobs.b biomesettingsmobs_b;
            EntityTypes<?> entitytypes = entity.ad();
            BlockPosition blockposition = entity.cW();
            double d0 = blockposition.equals(this.f) && entitytypes == this.g ? this.h : ((biomesettingsmobs_b = SpawnerCreature.a(blockposition, chunk).b().a(entitytypes)) != null ? biomesettingsmobs_b.b() : 0.0);
            this.c.a(blockposition, d0);
            EnumCreatureType enumcreaturetype = entitytypes.f();
            this.b.addTo((Object)enumcreaturetype, 1);
            if (this.e != null) {
                this.e.a(new ChunkCoordIntPair(blockposition), enumcreaturetype);
            }
        }

        public int a() {
            return this.a;
        }

        public Object2IntMap<EnumCreatureType> b() {
            return this.d;
        }

        boolean canSpawnForCategory(EnumCreatureType enumcreaturetype, ChunkCoordIntPair chunkcoordintpair, int limit) {
            int i2 = limit * this.a / e;
            if (this.e == null) {
                return this.b.getInt((Object)enumcreaturetype) < i2;
            }
            return this.b.getInt((Object)enumcreaturetype) >= i2 ? false : this.e.a(enumcreaturetype, chunkcoordintpair);
        }
    }

    @FunctionalInterface
    public static interface c {
        public boolean test(EntityTypes<?> var1, BlockPosition var2, IChunkAccess var3);
    }

    @FunctionalInterface
    public static interface a {
        public void run(EntityInsentient var1, IChunkAccess var2);
    }
}

