/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;

public abstract class MobSpawnerAbstract {
    private static final Logger a = LogManager.getLogger();
    private static final int b = 1;
    public int c = 20;
    public SimpleWeightedRandomList<MobSpawnerData> d = SimpleWeightedRandomList.b();
    public MobSpawnerData e = new MobSpawnerData();
    private double f;
    private double g;
    public int h = 200;
    public int i = 800;
    public int j = 4;
    @Nullable
    private Entity k;
    public int l = 6;
    public int m = 16;
    public int n = 4;
    private final Random o = new Random();
    private int tickDelay = 0;

    public void a(EntityTypes<?> type) {
        this.e.a().a("id", IRegistry.Z.b(type).toString());
        this.d = SimpleWeightedRandomList.b();
    }

    public boolean b(World world, BlockPosition pos) {
        return world.isAffectsSpawningPlayerNearby((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, this.m);
    }

    public void a(World world, BlockPosition pos) {
        if (!this.b(world, pos)) {
            this.g = this.f;
        } else {
            double d0 = (double)pos.u() + world.w.nextDouble();
            double d1 = (double)pos.v() + world.w.nextDouble();
            double d2 = (double)pos.w() + world.w.nextDouble();
            world.a(Particles.U, d0, d1, d2, 0.0, 0.0, 0.0);
            world.a(Particles.B, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.c > 0) {
                --this.c;
            }
            this.g = this.f;
            this.f = (this.f + (double)(1000.0f / ((float)this.c + 200.0f))) % 360.0;
        }
    }

    public void a(WorldServer world, BlockPosition pos) {
        if (this.c > 0 && --this.tickDelay > 0) {
            return;
        }
        this.tickDelay = world.paperConfig.mobSpawnerTickRate;
        if (this.tickDelay == -1) {
            return;
        }
        if (this.b(world, pos)) {
            if (this.c < -this.tickDelay) {
                this.c(world, pos);
            }
            if (this.c > 0) {
                this.c -= this.tickDelay;
            } else {
                boolean flag = false;
                for (int i2 = 0; i2 < this.j; ++i2) {
                    PreSpawnerSpawnEvent event;
                    MobSpawnerData.a mobspawnerdata_a;
                    double d2;
                    NBTTagCompound nbttagcompound = this.e.a();
                    Optional<EntityTypes<?>> optional = EntityTypes.a(nbttagcompound);
                    if (optional.isEmpty()) {
                        this.c(world, pos);
                        return;
                    }
                    NBTTagList nbttaglist = nbttagcompound.c("Pos", 6);
                    int j2 = nbttaglist.size();
                    double d0 = j2 >= 1 ? nbttaglist.h(0) : (double)pos.u() + (world.w.nextDouble() - world.w.nextDouble()) * (double)this.n + 0.5;
                    double d1 = j2 >= 2 ? nbttaglist.h(1) : (double)(pos.v() + world.w.nextInt(3) - 1);
                    double d3 = d2 = j2 >= 3 ? nbttaglist.h(2) : (double)pos.w() + (world.w.nextDouble() - world.w.nextDouble()) * (double)this.n + 0.5;
                    if (!world.b(optional.get().a(d0, d1, d2))) continue;
                    BlockPosition blockposition1 = new BlockPosition(d0, d1, d2);
                    if (!this.e.b().isPresent() ? !EntityPositionTypes.a(optional.get(), world, EnumMobSpawn.c, blockposition1, world.r_()) : !optional.get().f().d() && world.af() == EnumDifficulty.a || !(mobspawnerdata_a = this.e.b().get()).a().a(world.a(EnumSkyBlock.b, blockposition1)) || !mobspawnerdata_a.b().a(world.a(EnumSkyBlock.a, blockposition1))) continue;
                    EntityTypes<?> entityType = optional.get();
                    String key = EntityTypes.a(entityType).a();
                    EntityType type = EntityType.fromName((String)key);
                    if (type != null && !(event = new PreSpawnerSpawnEvent(MCUtil.toLocation(world, d0, d1, d2), type, MCUtil.toLocation(world, pos))).callEvent()) {
                        flag = true;
                        if (!event.shouldAbortSpawn()) continue;
                        break;
                    }
                    Entity entity = EntityTypes.a(nbttagcompound, world, entity1 -> {
                        entity1.b(d0, d1, d2, entity1.dm(), entity1.dn());
                        return entity1;
                    });
                    if (entity == null) {
                        this.c(world, pos);
                        return;
                    }
                    int k2 = world.a(entity.getClass(), new AxisAlignedBB(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1).g(this.n)).size();
                    if (k2 >= this.l) {
                        this.c(world, pos);
                        return;
                    }
                    entity.preserveMotion = true;
                    entity.b(entity.dc(), entity.de(), entity.di(), world.w.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof EntityInsentient) {
                        EntityInsentient entityinsentient = (EntityInsentient)entity;
                        if (this.e.b().isEmpty() && !entityinsentient.a((GeneratorAccess)world, EnumMobSpawn.c) || !entityinsentient.a((IWorldReader)world)) continue;
                        if (this.e.a().e() == 1 && this.e.a().b("id", 8)) {
                            ((EntityInsentient)entity).a(world, world.d_(entity.cW()), EnumMobSpawn.c, (GroupDataEntity)null, null);
                        }
                        if (entityinsentient.t.spigotConfig.nerfSpawnerMobs) {
                            entityinsentient.aware = false;
                        }
                    }
                    entity.spawnedViaMobSpawner = true;
                    entity.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                    flag = true;
                    if (CraftEventFactory.callSpawnerSpawnEvent(entity, pos).isCancelled()) {
                        Entity vehicle = entity.cN();
                        if (vehicle != null) {
                            vehicle.ah();
                        }
                        for (Entity passenger : entity.cJ()) {
                            passenger.ah();
                        }
                        continue;
                    }
                    if (!world.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                        this.c(world, pos);
                        return;
                    }
                    world.c(2004, pos, 0);
                    if (!(entity instanceof EntityInsentient)) continue;
                    ((EntityInsentient)entity).L();
                }
                if (flag) {
                    this.c(world, pos);
                }
            }
        }
    }

    public void c(World world, BlockPosition pos) {
        this.c = this.i <= this.h ? this.h : this.h + this.o.nextInt(this.i - this.h);
        this.d.b(this.o).ifPresent(weightedentry_b -> this.a(world, pos, (MobSpawnerData)weightedentry_b.b()));
        this.a(world, pos, 1);
    }

    public void a(@Nullable World world, BlockPosition pos, NBTTagCompound nbt) {
        this.c = nbt.e("Paper.Delay") ? nbt.h("Paper.Delay") : (int)nbt.g("Delay");
        boolean flag = nbt.b("SpawnPotentials", 9);
        boolean flag1 = nbt.b("SpawnData", 10);
        if (!flag) {
            MobSpawnerData mobspawnerdata = flag1 ? MobSpawnerData.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.p("SpawnData")).resultOrPartial(s2 -> a.warn("Invalid SpawnData: {}", s2)).orElseGet(MobSpawnerData::new) : new MobSpawnerData();
            this.d = SimpleWeightedRandomList.a(mobspawnerdata);
            this.a(world, pos, mobspawnerdata);
        } else {
            NBTTagList nbttaglist = nbt.c("SpawnPotentials", 10);
            this.d = MobSpawnerData.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttaglist).resultOrPartial(s2 -> a.warn("Invalid SpawnPotentials list: {}", s2)).orElseGet(SimpleWeightedRandomList::b);
            if (flag1) {
                MobSpawnerData mobspawnerdata1 = MobSpawnerData.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.p("SpawnData")).resultOrPartial(s2 -> a.warn("Invalid SpawnData: {}", s2)).orElseGet(MobSpawnerData::new);
                this.a(world, pos, mobspawnerdata1);
            } else {
                this.d.b(this.o).ifPresent(weightedentry_b -> this.a(world, pos, (MobSpawnerData)weightedentry_b.b()));
            }
        }
        if (nbt.b("Paper.MinSpawnDelay", 99)) {
            this.h = nbt.h("Paper.MinSpawnDelay");
            this.i = nbt.h("Paper.MaxSpawnDelay");
            this.j = nbt.g("SpawnCount");
        } else if (nbt.b("MinSpawnDelay", 99)) {
            this.h = nbt.h("MinSpawnDelay");
            this.i = nbt.h("MaxSpawnDelay");
            this.j = nbt.g("SpawnCount");
        }
        if (nbt.b("MaxNearbyEntities", 99)) {
            this.l = nbt.g("MaxNearbyEntities");
            this.m = nbt.g("RequiredPlayerRange");
        }
        if (nbt.b("SpawnRange", 99)) {
            this.n = nbt.g("SpawnRange");
        }
        this.k = null;
    }

    public NBTTagCompound a(NBTTagCompound nbt) {
        if (this.c > Short.MAX_VALUE) {
            nbt.a("Paper.Delay", this.c);
        }
        nbt.a("Delay", (short)Math.min(Short.MAX_VALUE, this.c));
        if (this.h > Short.MAX_VALUE || this.i > Short.MAX_VALUE) {
            nbt.a("Paper.MinSpawnDelay", this.h);
            nbt.a("Paper.MaxSpawnDelay", this.i);
        }
        nbt.a("MinSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.h));
        nbt.a("MaxSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.i));
        nbt.a("SpawnCount", (short)this.j);
        nbt.a("MaxNearbyEntities", (short)this.l);
        nbt.a("RequiredPlayerRange", (short)this.m);
        nbt.a("SpawnRange", (short)this.n);
        nbt.a("SpawnData", (NBTBase)MobSpawnerData.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.e).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        nbt.a("SpawnPotentials", (NBTBase)MobSpawnerData.b.encodeStart((DynamicOps)DynamicOpsNBT.a, this.d).result().orElseThrow());
        return nbt;
    }

    @Nullable
    public Entity a(World world) {
        if (this.k == null) {
            this.k = EntityTypes.a(this.e.a(), world, Function.identity());
            if (this.e.a().e() != 1 || !this.e.a().b("id", 8) || this.k instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.k;
    }

    public boolean a(World world, int i2) {
        if (i2 == 1) {
            if (world.y) {
                this.c = this.h;
            }
            return true;
        }
        return false;
    }

    public void a(@Nullable World world, BlockPosition pos, MobSpawnerData spawnEntry) {
        this.e = spawnEntry;
    }

    public abstract void a(World var1, BlockPosition var2, int var3);

    public double a() {
        return this.f;
    }

    public double b() {
        return this.g;
    }
}

