/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkCache
implements IBlockAccess,
ICollisionAccess {
    protected final int a;
    protected final int b;
    protected final IChunkAccess[][] c;
    protected boolean d;
    protected final World e;

    public ChunkCache(World world, BlockPosition minPos, BlockPosition maxPos) {
        this.e = world;
        this.a = SectionPosition.a(minPos.u());
        this.b = SectionPosition.a(minPos.w());
        int i2 = SectionPosition.a(maxPos.u());
        int j2 = SectionPosition.a(maxPos.w());
        this.c = new IChunkAccess[i2 - this.a + 1][j2 - this.b + 1];
        IChunkProvider chunkSource = world.L();
        this.d = true;
        for (int k2 = this.a; k2 <= i2; ++k2) {
            for (int l2 = this.b; l2 <= j2; ++l2) {
                this.c[k2 - this.a][l2 - this.b] = chunkSource.a(k2, l2);
            }
        }
        for (int m2 = SectionPosition.a(minPos.u()); m2 <= SectionPosition.a(maxPos.u()); ++m2) {
            for (int n2 = SectionPosition.a(minPos.w()); n2 <= SectionPosition.a(maxPos.w()); ++n2) {
                IChunkAccess chunkAccess = this.c[m2 - this.a][n2 - this.b];
                if (chunkAccess == null || chunkAccess.a(minPos.v(), maxPos.v())) continue;
                this.d = false;
                return;
            }
        }
    }

    private IChunkAccess d(BlockPosition pos) {
        return this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    private IChunkAccess a(int chunkX, int chunkZ) {
        int i2 = chunkX - this.a;
        int j2 = chunkZ - this.b;
        if (i2 >= 0 && i2 < this.c.length && j2 >= 0 && j2 < this.c[i2].length) {
            IChunkAccess chunkAccess = this.c[i2][j2];
            return chunkAccess != null ? chunkAccess : new ChunkEmpty(this.e, new ChunkCoordIntPair(chunkX, chunkZ));
        }
        return new ChunkEmpty(this.e, new ChunkCoordIntPair(chunkX, chunkZ));
    }

    @Nullable
    private IChunkAccess getChunkIfLoaded(int x2, int z2) {
        int xx = x2 - this.a;
        int zz = z2 - this.b;
        if (xx >= 0 && xx < this.c.length && zz >= 0 && zz < this.c[xx].length) {
            return this.c[xx][zz];
        }
        return null;
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoaded(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.b_(blockposition);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoaded(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.a_(blockposition);
    }

    @Override
    public WorldBorder p_() {
        return this.e.p_();
    }

    @Override
    public IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ);
    }

    @Override
    public List<VoxelShape> b(@Nullable Entity entity, AxisAlignedBB box) {
        return List.of();
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        IChunkAccess chunkAccess = this.d(pos);
        return chunkAccess.c_(pos);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        if (this.u(pos)) {
            return Blocks.a.n();
        }
        IChunkAccess chunkAccess = this.d(pos);
        return chunkAccess.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        if (this.u(pos)) {
            return FluidTypes.a.h();
        }
        IChunkAccess chunkAccess = this.d(pos);
        return chunkAccess.b_(pos);
    }

    @Override
    public int u_() {
        return this.e.u_();
    }

    @Override
    public int v_() {
        return this.e.v_();
    }

    public GameProfilerFiller a() {
        return this.e.ab();
    }
}

