/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import com.destroystokyo.paper.loottable.PaperMinecartLootableInventory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityMinecartContainer
extends EntityMinecartAbstract
implements IInventory,
ITileInventory {
    private NonNullList<ItemStack> c;
    @Nullable
    public MinecraftKey d;
    public long e;
    public List<HumanEntity> transaction;
    private int maxStack;

    @Override
    public List<ItemStack> getContents() {
        return this.c;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        CraftEntity cart = this.getBukkitEntity();
        if (cart instanceof InventoryHolder) {
            return (InventoryHolder)cart;
        }
        return null;
    }

    @Override
    public int M_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.getBukkitEntity().getLocation();
    }

    protected EntityMinecartContainer(EntityTypes<?> type, World world) {
        super(type, world);
        this.lootableData = new PaperLootableInventoryData(new PaperMinecartLootableInventory(this));
        this.transaction = new ArrayList<HumanEntity>();
        this.maxStack = 64;
        this.c = NonNullList.a(this.b(), ItemStack.b);
    }

    protected EntityMinecartContainer(EntityTypes<?> type, double x2, double y2, double z2, World world) {
        super(type, world, x2, y2, z2);
        this.lootableData = new PaperLootableInventoryData(new PaperMinecartLootableInventory(this));
        this.transaction = new ArrayList<HumanEntity>();
        this.maxStack = 64;
        this.c = NonNullList.a(this.b(), ItemStack.b);
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        if (this.t.X().b(GameRules.h)) {
            Entity entity;
            InventoryUtils.a(this.t, this, (IInventory)this);
            if (!this.t.y && (entity = damageSource.k()) != null && entity.ad() == EntityTypes.bi) {
                PiglinAI.a((EntityHuman)entity, true);
            }
        }
    }

    @Override
    public boolean c() {
        ItemStack itemstack;
        Iterator iterator = this.c.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).b());
        return false;
    }

    @Override
    public ItemStack a(int slot) {
        this.d((EntityHuman)null);
        return this.c.get(slot);
    }

    @Override
    public ItemStack a(int slot, int amount) {
        this.d((EntityHuman)null);
        return ContainerUtil.a(this.c, slot, amount);
    }

    @Override
    public ItemStack b(int slot) {
        this.d((EntityHuman)null);
        ItemStack itemstack = this.c.get(slot);
        if (itemstack.b()) {
            return ItemStack.b;
        }
        this.c.set(slot, ItemStack.b);
        return itemstack;
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.d((EntityHuman)null);
        this.c.set(slot, stack);
        if (!stack.b() && stack.I() > this.M_()) {
            stack.e(this.M_());
        }
    }

    @Override
    public SlotAccess k(final int mappedIndex) {
        return mappedIndex >= 0 && mappedIndex < this.b() ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityMinecartContainer.this.a(mappedIndex);
            }

            @Override
            public boolean a(ItemStack stack) {
                EntityMinecartContainer.this.a(mappedIndex, stack);
                return true;
            }
        } : super.k(mappedIndex);
    }

    @Override
    public void e() {
    }

    @Override
    public boolean a(EntityHuman player) {
        return this.do() ? false : player.f(this) <= 64.0;
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        if (!this.t.y && reason.a()) {
            InventoryUtils.a(this.t, this, (IInventory)this);
        }
        super.a(reason);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.lootableData.saveNbt(nbt);
        if (this.d != null) {
            nbt.a("LootTable", this.d.toString());
            if (this.e != 0L) {
                nbt.a("LootTableSeed", this.e);
            }
        }
        ContainerUtil.a(nbt, this.c);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.lootableData.loadNbt(nbt);
        this.c = NonNullList.a(this.b(), ItemStack.b);
        if (nbt.b("LootTable", 8)) {
            this.d = new MinecraftKey(nbt.l("LootTable"));
            this.e = nbt.i("LootTableSeed");
        }
        ContainerUtil.b(nbt, this.c);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        player.a(this);
        if (!player.t.y) {
            this.a(GameEvent.m, (Entity)player);
            PiglinAI.a(player, true);
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void j() {
        float f2 = 0.98f;
        if (this.d == null) {
            int i2 = 15 - Container.b(this);
            f2 += (float)i2 * 0.001f;
        }
        if (this.aQ()) {
            f2 *= 0.95f;
        }
        this.g(this.da().d(f2, 0.0, f2));
    }

    public void d(@Nullable EntityHuman player) {
        if (this.lootableData.shouldReplenish(player) && this.t.n() != null) {
            LootTable loottable = this.t.n().aG().a(this.d);
            if (player instanceof EntityPlayer) {
                CriterionTriggers.N.a((EntityPlayer)player, this.d);
            }
            this.lootableData.processRefill(player);
            LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.t).a(LootContextParameters.f, this.cV()).a(this.e);
            if (player != null) {
                loottableinfo_builder.a(player.fL()).a(LootContextParameters.a, player);
            }
            loottable.a((IInventory)this, loottableinfo_builder.a(LootContextParameterSets.b));
        }
    }

    @Override
    public void a() {
        this.d((EntityHuman)null);
        this.c.clear();
    }

    public void a(MinecraftKey id, long lootSeed) {
        this.d = id;
        this.e = lootSeed;
    }

    @Override
    @Nullable
    public Container createMenu(int syncId, PlayerInventory inv, EntityHuman player) {
        if (this.d != null && player.B_()) {
            return null;
        }
        this.d(inv.l);
        return this.a(syncId, inv);
    }

    protected abstract Container a(int var1, PlayerInventory var2);
}

