/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public class EntityBoat
extends Entity {
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> ap = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> aq = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.c);
    private static final DataWatcherObject<Integer> ar = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> as = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> at = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Integer> au = DataWatcher.a(EntityBoat.class, DataWatcherRegistry.b);
    public static final int b = 0;
    public static final int c = 1;
    private static final int av = 60;
    private static final double aw = (double)0.3926991f;
    public static final double d = 0.7853981852531433;
    public static final int e = 60;
    private final float[] ax = new float[2];
    private float ay;
    private float az;
    private float aA;
    private int aB;
    private double aC;
    private double aD;
    private double aE;
    private double aF;
    private double aG;
    private boolean aH;
    private boolean aI;
    private boolean aJ;
    private boolean aK;
    private double aL;
    private float aM;
    private EnumStatus aN;
    private EnumStatus aO;
    private double aP;
    private boolean aQ;
    private boolean aR;
    private float aS;
    private float aT;
    private float aU;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public EntityBoat(EntityTypes<? extends EntityBoat> type, World world) {
        super(type, world);
        this.r = true;
    }

    public EntityBoat(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityBoat>)EntityTypes.i, world);
        this.e(x2, y2, z2);
        this.u = x2;
        this.v = y2;
        this.w = z2;
    }

    @Override
    protected float a(EntityPose pose, EntitySize dimensions) {
        return dimensions.b;
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.Z.a(f, 0);
        this.Z.a(ap, 1);
        this.Z.a(aq, Float.valueOf(0.0f));
        this.Z.a(ar, EnumBoatType.a.ordinal());
        this.Z.a(as, false);
        this.Z.a(at, false);
        this.Z.a(au, 0);
    }

    @Override
    public boolean h(Entity other) {
        return EntityBoat.a(this, other);
    }

    public static boolean a(Entity entity, Entity other) {
        return (other.bn() || other.bi()) && !entity.v(other);
    }

    @Override
    public boolean bn() {
        return true;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    @Override
    public double bq() {
        return -0.1;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.t.y && !this.do()) {
            boolean flag;
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            CraftEntity attacker = source.l() == null ? null : source.l().getBukkitEntity();
            VehicleDamageEvent event = new VehicleDamageEvent(vehicle, (org.bukkit.entity.Entity)attacker, (double)amount);
            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            this.c(-this.q());
            this.b(10);
            this.a(this.n() + amount * 10.0f);
            this.bf();
            this.a(GameEvent.r, source.l());
            boolean bl = flag = source.l() instanceof EntityHuman && ((EntityHuman)source.l()).fr().d;
            if (flag || this.n() > 40.0f) {
                VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)attacker);
                this.t.getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                if (destroyEvent.isCancelled()) {
                    this.a(40.0f);
                    return true;
                }
                if (!flag && this.t.X().b(GameRules.h)) {
                    this.a(this.h());
                }
                this.ah();
            }
            return true;
        }
        return true;
    }

    @Override
    public void k(boolean drag) {
        if (!this.t.y) {
            this.aQ = true;
            this.aR = drag;
            if (this.A() == 0) {
                this.d(60);
            }
        }
        this.t.a(Particles.ab, this.dc() + (double)this.R.nextFloat(), this.de() + 0.7, this.di() + (double)this.R.nextFloat(), 0.0, 0.0, 0.0);
        if (this.R.nextInt(20) == 0) {
            this.t.a(this.dc(), this.de(), this.di(), this.aG(), this.cO(), 1.0f, 0.8f + 0.4f * this.R.nextFloat(), false);
        }
        this.a(GameEvent.P, this.cE());
    }

    @Override
    public void g(Entity entity) {
        if (!this.t.paperConfig.allowVehicleCollisions && this.t.paperConfig.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
            return;
        }
        if (entity instanceof EntityBoat) {
            if (entity.cw().b < this.cw().e) {
                if (!this.v(entity)) {
                    VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                    this.t.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                super.g(entity);
            }
        } else if (entity.cw().b <= this.cw().b) {
            if (!this.v(entity)) {
                VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.t.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            super.g(entity);
        }
    }

    public Item h() {
        switch (this.r()) {
            default: {
                return Items.lU;
            }
            case b: {
                return Items.lV;
            }
            case c: {
                return Items.lW;
            }
            case d: {
                return Items.lX;
            }
            case e: {
                return Items.lY;
            }
            case f: 
        }
        return Items.lZ;
    }

    @Override
    public void bA() {
        this.c(-this.q());
        this.b(10);
        this.a(this.n() * 11.0f);
    }

    @Override
    public boolean bh() {
        return !this.do();
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.aC = x2;
        this.aD = y2;
        this.aE = z2;
        this.aF = yaw;
        this.aG = pitch;
        this.aB = 10;
    }

    @Override
    public EnumDirection cu() {
        return this.ct().g();
    }

    @Override
    public void k() {
        this.aO = this.aN;
        this.aN = this.u();
        this.az = this.aN != EnumStatus.b && this.aN != EnumStatus.c ? 0.0f : (this.az += 1.0f);
        if (!this.t.y && this.az >= 60.0f) {
            this.bs();
        }
        if (this.o() > 0) {
            this.b(this.o() - 1);
        }
        if (this.n() > 0.0f) {
            this.a(this.n() - 1.0f);
        }
        super.k();
        this.t();
        if (this.cM()) {
            if (!(this.cG() instanceof EntityHuman)) {
                this.a(false, false);
            }
            this.y();
            if (this.t.y) {
                this.z();
                this.t.a(new PacketPlayInBoatMove(this.a(0), this.a(1)));
            }
            this.a(EnumMoveType.a, this.da());
        } else {
            this.g(Vec3D.a);
        }
        CraftServer server = this.t.getCraftServer();
        CraftWorld bworld = this.t.getWorld();
        Location to = new Location((org.bukkit.World)bworld, this.dc(), this.de(), this.di(), this.dm(), this.dn());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        server.getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            server.getPluginManager().callEvent((Event)event);
        }
        this.lastLocation = vehicle.getLocation();
        this.s();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.a(i2)) {
                SoundEffect soundeffect;
                if (!this.aL() && (double)(this.ax[i2] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.ax[i2] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundeffect = this.i()) != null) {
                    Vec3D vec3d = this.e(1.0f);
                    double d0 = i2 == 1 ? -vec3d.d : vec3d.d;
                    double d1 = i2 == 1 ? vec3d.b : -vec3d.b;
                    this.t.a((EntityHuman)null, this.dc() + d0, this.de(), this.di() + d1, soundeffect, this.cO(), 1.0f, 0.8f + 0.4f * this.R.nextFloat());
                    this.t.a(this.cE(), GameEvent.P, new BlockPosition(this.dc() + d0, this.de(), this.di() + d1));
                }
                this.ax[i2] = (float)((double)this.ax[i2] + (double)0.3926991f);
                continue;
            }
            this.ax[i2] = 0.0f;
        }
        this.aI();
        List<Entity> list = this.t.a((Entity)this, this.cw().c(0.2f, -0.01f, 0.2f), IEntitySelector.a(this));
        if (!list.isEmpty()) {
            boolean flag = !this.t.y && !(this.cE() instanceof EntityHuman);
            for (int j2 = 0; j2 < list.size(); ++j2) {
                Entity entity = list.get(j2);
                if (entity.u(this)) continue;
                if (flag && this.cF().size() < 2 && !entity.bF() && entity.cT() < this.cT() && entity instanceof EntityLiving && !(entity instanceof EntityWaterAnimal) && !(entity instanceof EntityHuman)) {
                    entity.k(this);
                    continue;
                }
                this.g(entity);
            }
        }
    }

    private void s() {
        if (this.t.y) {
            int i2 = this.A();
            this.aS = i2 > 0 ? (this.aS += 0.05f) : (this.aS -= 0.1f);
            this.aS = MathHelper.a(this.aS, 0.0f, 1.0f);
            this.aU = this.aT;
            this.aT = 10.0f * (float)Math.sin(0.5f * (float)this.t.V()) * this.aS;
        } else {
            int i3;
            if (!this.aQ) {
                this.d(0);
            }
            if ((i3 = this.A()) > 0) {
                this.d(--i3);
                int j2 = 60 - i3 - 1;
                if (j2 > 0 && i3 == 0) {
                    this.d(0);
                    Vec3D vec3d = this.da();
                    if (this.aR) {
                        this.g(vec3d.b(0.0, -0.7, 0.0));
                        this.bs();
                    } else {
                        this.n(vec3d.b, this.a((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, vec3d.d);
                    }
                }
                this.aQ = false;
            }
        }
    }

    @Nullable
    protected SoundEffect i() {
        switch (this.u()) {
            case a: 
            case b: 
            case c: {
                return SoundEffects.bA;
            }
            case d: {
                return SoundEffects.bz;
            }
        }
        return null;
    }

    private void t() {
        if (this.cM()) {
            this.aB = 0;
            this.d(this.dc(), this.de(), this.di());
        }
        if (this.aB > 0) {
            double d0 = this.dc() + (this.aC - this.dc()) / (double)this.aB;
            double d1 = this.de() + (this.aD - this.de()) / (double)this.aB;
            double d2 = this.di() + (this.aE - this.di()) / (double)this.aB;
            double d3 = MathHelper.f(this.aF - (double)this.dm());
            this.o(this.dm() + (float)d3 / (float)this.aB);
            this.p(this.dn() + (float)(this.aG - (double)this.dn()) / (float)this.aB);
            --this.aB;
            this.e(d0, d1, d2);
            this.a(this.dm(), this.dn());
        }
    }

    public void a(boolean leftMoving, boolean rightMoving) {
        this.Z.b(as, leftMoving);
        this.Z.b(at, rightMoving);
    }

    public float a(int paddle, float tickDelta) {
        return this.a(paddle) ? (float)MathHelper.b((double)this.ax[paddle] - (double)0.3926991f, (double)this.ax[paddle], (double)tickDelta) : 0.0f;
    }

    private EnumStatus u() {
        EnumStatus entityboat_enumstatus = this.x();
        if (entityboat_enumstatus != null) {
            this.aL = this.cw().e;
            return entityboat_enumstatus;
        }
        if (this.w()) {
            return EnumStatus.a;
        }
        float f2 = this.l();
        if (f2 > 0.0f) {
            this.aM = f2;
            return EnumStatus.d;
        }
        return EnumStatus.e;
    }

    public float j() {
        AxisAlignedBB axisalignedbb = this.cw();
        int i2 = MathHelper.b(axisalignedbb.a);
        int j2 = MathHelper.e(axisalignedbb.d);
        int k2 = MathHelper.b(axisalignedbb.e);
        int l2 = MathHelper.e(axisalignedbb.e - this.aP);
        int i1 = MathHelper.b(axisalignedbb.c);
        int j1 = MathHelper.e(axisalignedbb.f);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (int k1 = k2; k1 < l2; ++k1) {
            float f2 = 0.0f;
            block1: for (int l1 = i2; l1 < j2; ++l1) {
                int i22 = i1;
                while (true) {
                    if (i22 >= j1) {
                        continue block1;
                    }
                    blockposition_mutableblockposition.d(l1, k1, i22);
                    Fluid fluid = this.t.b_(blockposition_mutableblockposition);
                    if (fluid.a(TagsFluid.b)) {
                        f2 = Math.max(f2, fluid.a((IBlockAccess)this.t, (BlockPosition)blockposition_mutableblockposition));
                    }
                    if (f2 >= 1.0f) continue block0;
                    ++i22;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)blockposition_mutableblockposition.v() + f2;
        }
        return l2 + 1;
    }

    public float l() {
        AxisAlignedBB axisalignedbb = this.cw();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 0.001, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
        int i2 = MathHelper.b(axisalignedbb1.a) - 1;
        int j2 = MathHelper.e(axisalignedbb1.d) + 1;
        int k2 = MathHelper.b(axisalignedbb1.b) - 1;
        int l2 = MathHelper.e(axisalignedbb1.e) + 1;
        int i1 = MathHelper.b(axisalignedbb1.c) - 1;
        int j1 = MathHelper.e(axisalignedbb1.f) + 1;
        VoxelShape voxelshape = VoxelShapes.a(axisalignedbb1);
        float f2 = 0.0f;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = i1; i22 < j1; ++i22) {
                int j22 = (l1 != i2 && l1 != j2 - 1 ? 0 : 1) + (i22 != i1 && i22 != j1 - 1 ? 0 : 1);
                if (j22 == 2) continue;
                for (int k22 = k2; k22 < l2; ++k22) {
                    if (j22 > 0 && (k22 == k2 || k22 == l2 - 1)) continue;
                    blockposition_mutableblockposition.d(l1, k22, i22);
                    IBlockData iblockdata = this.t.a_(blockposition_mutableblockposition);
                    if (iblockdata.b() instanceof BlockWaterLily || !VoxelShapes.c(iblockdata.k(this.t, blockposition_mutableblockposition).a((double)l1, (double)k22, (double)i22), voxelshape, OperatorBoolean.i)) continue;
                    f2 += iblockdata.b().i();
                    ++k1;
                }
            }
        }
        return f2 / (float)k1;
    }

    private boolean w() {
        AxisAlignedBB axisalignedbb = this.cw();
        int i2 = MathHelper.b(axisalignedbb.a);
        int j2 = MathHelper.e(axisalignedbb.d);
        int k2 = MathHelper.b(axisalignedbb.b);
        int l2 = MathHelper.e(axisalignedbb.b + 0.001);
        int i1 = MathHelper.b(axisalignedbb.c);
        int j1 = MathHelper.e(axisalignedbb.f);
        boolean flag = false;
        this.aL = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.t.b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.b)) continue;
                    float f2 = (float)l1 + fluid.a((IBlockAccess)this.t, (BlockPosition)blockposition_mutableblockposition);
                    this.aL = Math.max((double)f2, this.aL);
                    flag |= axisalignedbb.b < (double)f2;
                }
            }
        }
        return flag;
    }

    @Nullable
    private EnumStatus x() {
        AxisAlignedBB axisalignedbb = this.cw();
        double d0 = axisalignedbb.e + 0.001;
        int i2 = MathHelper.b(axisalignedbb.a);
        int j2 = MathHelper.e(axisalignedbb.d);
        int k2 = MathHelper.b(axisalignedbb.e);
        int l2 = MathHelper.e(d0);
        int i1 = MathHelper.b(axisalignedbb.c);
        int j1 = MathHelper.e(axisalignedbb.f);
        boolean flag = false;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.t.b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.b) || !(d0 < (double)((float)blockposition_mutableblockposition.v() + fluid.a((IBlockAccess)this.t, (BlockPosition)blockposition_mutableblockposition)))) continue;
                    if (!fluid.b()) {
                        return EnumStatus.c;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.b : null;
    }

    private void y() {
        double d0 = -0.04f;
        double d1 = this.aM() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.ay = 0.05f;
        if (this.aO == EnumStatus.e && this.aN != EnumStatus.e && this.aN != EnumStatus.d) {
            this.aL = this.e(1.0);
            this.a(EnumMoveType.a, new Vec3D(0.0, (double)(this.j() - this.cU()) + 0.101 - this.de(), 0.0));
            this.g(this.da().d(1.0, 0.0, 1.0));
            this.aP = 0.0;
            this.aN = EnumStatus.a;
        } else {
            if (this.aN == EnumStatus.a) {
                d2 = (this.aL - this.de()) / (double)this.cU();
                this.ay = 0.9f;
            } else if (this.aN == EnumStatus.c) {
                d1 = -7.0E-4;
                this.ay = 0.9f;
            } else if (this.aN == EnumStatus.b) {
                d2 = 0.01f;
                this.ay = 0.45f;
            } else if (this.aN == EnumStatus.e) {
                this.ay = 0.9f;
            } else if (this.aN == EnumStatus.d) {
                this.ay = this.aM;
                if (this.cE() instanceof EntityHuman) {
                    this.aM /= 2.0f;
                }
            }
            Vec3D vec3d = this.da();
            this.n(vec3d.b * (double)this.ay, vec3d.c + d1, vec3d.d * (double)this.ay);
            this.aA *= this.ay;
            if (d2 > 0.0) {
                Vec3D vec3d1 = this.da();
                this.n(vec3d1.b, (vec3d1.c + d2 * 0.06153846016296973) * 0.75, vec3d1.d);
            }
        }
    }

    private void z() {
        if (this.bG()) {
            float f2 = 0.0f;
            if (this.aH) {
                this.aA -= 1.0f;
            }
            if (this.aI) {
                this.aA += 1.0f;
            }
            if (this.aI != this.aH && !this.aJ && !this.aK) {
                f2 += 0.005f;
            }
            this.o(this.dm() + this.aA);
            if (this.aJ) {
                f2 += 0.04f;
            }
            if (this.aK) {
                f2 -= 0.005f;
            }
            this.g(this.da().b(MathHelper.a(-this.dm() * ((float)Math.PI / 180)) * f2, 0.0, MathHelper.b(this.dm() * ((float)Math.PI / 180)) * f2));
            this.a(this.aI && !this.aH || this.aJ, this.aH && !this.aI || this.aJ);
        }
    }

    @Override
    public void i(Entity passenger) {
        if (this.u(passenger)) {
            float f2 = 0.0f;
            float f1 = (float)((this.do() ? (double)0.01f : this.bq()) + passenger.bp());
            if (this.cF().size() > 1) {
                int i2 = this.cF().indexOf(passenger);
                f2 = i2 == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f2 = (float)((double)f2 + 0.2);
                }
            }
            Vec3D vec3d = new Vec3D(f2, 0.0, 0.0).b(-this.dm() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.e(this.dc() + vec3d.b, this.de() + (double)f1, this.di() + vec3d.d);
            passenger.o(passenger.dm() + this.aA);
            passenger.l(passenger.ce() + this.aA);
            this.a(passenger);
            if (passenger instanceof EntityAnimal && this.cF().size() > 1) {
                int j2 = passenger.ae() % 2 == 0 ? 90 : 270;
                passenger.m(((EntityAnimal)passenger).aY + (float)j2);
                passenger.l(passenger.ce() + (float)j2);
            }
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        double d1;
        Vec3D vec3d = EntityBoat.a(this.cT() * MathHelper.g, (double)passenger.cT(), passenger.dm());
        double d0 = this.dc() + vec3d.b;
        BlockPosition blockposition = new BlockPosition(d0, this.cw().e, d1 = this.di() + vec3d.d);
        BlockPosition blockposition1 = blockposition.c();
        if (!this.t.A(blockposition1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.t.h(blockposition);
            if (DismountUtil.a(d2)) {
                list.add(new Vec3D(d0, (double)blockposition.v() + d2, d1));
            }
            if (DismountUtil.a(d3 = this.t.h(blockposition1))) {
                list.add(new Vec3D(d0, (double)blockposition1.v() + d3, d1));
            }
            for (EntityPose entitypose : passenger.eY()) {
                for (Vec3D vec3d1 : list) {
                    if (!DismountUtil.a(this.t, vec3d1, passenger, entitypose)) continue;
                    passenger.b(entitypose);
                    return vec3d1;
                }
            }
        }
        return super.b(passenger);
    }

    protected void a(Entity entity) {
        entity.m(this.dm());
        float f2 = MathHelper.g(entity.dm() - this.dm());
        float f1 = MathHelper.a(f2, -105.0f, 105.0f);
        entity.x += f1 - f2;
        entity.o(entity.dm() + f1 - f2);
        entity.l(entity.dm());
    }

    @Override
    public void j(Entity passenger) {
        this.a(passenger);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("Type", this.r().a());
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("Type", 8)) {
            this.a(EnumBoatType.a(nbt.l("Type")));
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        return player.ff() ? EnumInteractionResult.d : (this.az < 60.0f ? (!this.t.y ? (player.k(this) ? EnumInteractionResult.b : EnumInteractionResult.d) : EnumInteractionResult.a) : EnumInteractionResult.d);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData landedState, BlockPosition landedPosition) {
        this.aP = this.da().c;
        if (!this.bF()) {
            if (onGround) {
                if (this.L > 3.0f) {
                    if (this.aN != EnumStatus.d) {
                        this.m();
                        return;
                    }
                    this.a(this.L, 1.0f, DamageSource.k);
                    if (!this.t.y && !this.do()) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, null);
                        this.t.getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                        if (!destroyEvent.isCancelled()) {
                            this.ag();
                            if (this.t.X().b(GameRules.h)) {
                                int i2;
                                for (i2 = 0; i2 < 3; ++i2) {
                                    this.a(this.r().b());
                                }
                                for (i2 = 0; i2 < 2; ++i2) {
                                    this.a(Items.nb);
                                }
                            }
                        }
                    }
                }
                this.m();
            } else if (!this.t.b_(this.cW().c()).a(TagsFluid.b) && heightDifference < 0.0) {
                this.L = (float)((double)this.L - heightDifference);
            }
        }
    }

    public boolean a(int paddle) {
        return this.Z.a(paddle == 0 ? as : at) != false && this.cE() != null;
    }

    public void a(float wobbleStrength) {
        this.Z.b(aq, Float.valueOf(wobbleStrength));
    }

    public float n() {
        return this.Z.a(aq).floatValue();
    }

    public void b(int wobbleTicks) {
        this.Z.b(f, wobbleTicks);
    }

    public int o() {
        return this.Z.a(f);
    }

    private void d(int wobbleTicks) {
        this.Z.b(au, wobbleTicks);
    }

    private int A() {
        return this.Z.a(au);
    }

    public float b(float tickDelta) {
        return MathHelper.i(tickDelta, this.aU, this.aT);
    }

    public void c(int side) {
        this.Z.b(ap, side);
    }

    public int q() {
        return this.Z.a(ap);
    }

    public void a(EnumBoatType type) {
        this.Z.b(ar, type.ordinal());
    }

    public EnumBoatType r() {
        return EnumBoatType.a(this.Z.a(ar));
    }

    @Override
    protected boolean o(Entity passenger) {
        return this.cF().size() < 2 && !this.a(TagsFluid.b);
    }

    @Override
    @Nullable
    public Entity cE() {
        return this.cG();
    }

    public void a(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        this.aH = pressingLeft;
        this.aI = pressingRight;
        this.aJ = pressingForward;
        this.aK = pressingBack;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    @Override
    public boolean aU() {
        return this.aN == EnumStatus.b || this.aN == EnumStatus.c;
    }

    @Override
    public ItemStack dk() {
        return new ItemStack(this.h());
    }

    public static enum EnumBoatType {
        a(Blocks.n, "oak"),
        b(Blocks.o, "spruce"),
        c(Blocks.p, "birch"),
        d(Blocks.q, "jungle"),
        e(Blocks.r, "acacia"),
        f(Blocks.s, "dark_oak");

        private final String g;
        private final Block h;

        private EnumBoatType(Block block, String s2) {
            this.g = s2;
            this.h = block;
        }

        public String a() {
            return this.g;
        }

        public Block b() {
            return this.h;
        }

        public String toString() {
            return this.g;
        }

        public static EnumBoatType a(int type) {
            EnumBoatType[] aentityboat_enumboattype = EnumBoatType.values();
            if (type < 0 || type >= aentityboat_enumboattype.length) {
                type = 0;
            }
            return aentityboat_enumboattype[type];
        }

        public static EnumBoatType a(String name) {
            EnumBoatType[] aentityboat_enumboattype = EnumBoatType.values();
            for (int i2 = 0; i2 < aentityboat_enumboattype.length; ++i2) {
                if (!aentityboat_enumboattype[i2].a().equals(name)) continue;
                return aentityboat_enumboattype[i2];
            }
            return aentityboat_enumboattype[0];
        }
    }

    public static enum EnumStatus {
        a,
        b,
        c,
        d,
        e;

    }
}

