/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class DismountUtil {
    public static int[][] a(EnumDirection movementDirection) {
        EnumDirection direction = movementDirection.g();
        EnumDirection direction2 = direction.f();
        EnumDirection direction3 = movementDirection.f();
        return new int[][]{{direction.i(), direction.k()}, {direction2.i(), direction2.k()}, {direction3.i() + direction.i(), direction3.k() + direction.k()}, {direction3.i() + direction2.i(), direction3.k() + direction2.k()}, {movementDirection.i() + direction.i(), movementDirection.k() + direction.k()}, {movementDirection.i() + direction2.i(), movementDirection.k() + direction2.k()}, {direction3.i(), direction3.k()}, {movementDirection.i(), movementDirection.k()}};
    }

    public static boolean a(double height) {
        return !Double.isInfinite(height) && height < 1.0;
    }

    public static boolean a(ICollisionAccess world, EntityLiving entity, AxisAlignedBB targetBox) {
        Iterable<VoxelShape> iterable = world.d(entity, targetBox);
        for (VoxelShape voxelShape : iterable) {
            if (voxelShape.b()) continue;
            return false;
        }
        return world.p_().a(targetBox);
    }

    public static boolean a(ICollisionAccess world, Vec3D offset, EntityLiving entity, EntityPose pose) {
        return DismountUtil.a(world, entity, entity.f(pose).c(offset));
    }

    public static VoxelShape a(IBlockAccess world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        if (blockState.a(TagsBlock.aD) || blockState.b() instanceof BlockTrapdoor && blockState.c(BlockTrapdoor.a).booleanValue()) {
            return VoxelShapes.a();
        }
        return blockState.k(world, pos);
    }

    public static double a(BlockPosition pos, int maxDistance, Function<BlockPosition, VoxelShape> collisionShapeGetter) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.i();
        for (int i2 = 0; i2 < maxDistance; ++i2) {
            VoxelShape voxelShape = collisionShapeGetter.apply(mutableBlockPos);
            if (!voxelShape.b()) {
                return (double)(pos.v() + i2) + voxelShape.b(EnumDirection.EnumAxis.b);
            }
            mutableBlockPos.c(EnumDirection.b);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Nullable
    public static Vec3D a(EntityTypes<?> entityType, ICollisionAccess world, BlockPosition pos, boolean ignoreInvalidPos) {
        if (ignoreInvalidPos && entityType.a(world.a_(pos))) {
            return null;
        }
        double d2 = world.a(DismountUtil.a((IBlockAccess)world, pos), () -> DismountUtil.a((IBlockAccess)world, pos.c()));
        if (!DismountUtil.a(d2)) {
            return null;
        }
        if (ignoreInvalidPos && d2 <= 0.0 && entityType.a(world.a_(pos.c()))) {
            return null;
        }
        Vec3D vec3 = Vec3D.a(pos, d2);
        AxisAlignedBB aABB = entityType.m().a(vec3);
        Iterable<VoxelShape> iterable = world.d(null, aABB);
        for (VoxelShape voxelShape : iterable) {
            if (voxelShape.b()) continue;
            return null;
        }
        if (!world.p_().a(aABB)) {
            return null;
        }
        return vec3;
    }
}

