/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class EntityPotion
extends EntityProjectileThrowable
implements ItemSupplier {
    public static final double b = 4.0;
    private static final double d = 16.0;
    public static final Predicate<EntityLiving> c = EntityLiving::eD;
    private static final Predicate<EntityLiving> APPLY_WATER_GET_ENTITIES_PREDICATE = c.or(Axolotl.class::isInstance);

    public EntityPotion(EntityTypes<? extends EntityPotion> type, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)type, world);
    }

    public EntityPotion(World world, EntityLiving owner) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.aP, owner, world);
    }

    public EntityPotion(World world, double x2, double y2, double z2) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.aP, x2, y2, z2, world);
    }

    @Override
    protected Item i() {
        return Items.sr;
    }

    @Override
    protected float l() {
        return 0.05f;
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        if (!this.t.y) {
            ItemStack itemstack = this.h();
            PotionRegistry potionregistry = PotionUtil.d(itemstack);
            List<MobEffect> list = PotionUtil.a(itemstack);
            boolean flag = potionregistry == Potions.b && list.isEmpty();
            EnumDirection enumdirection = blockHitResult.b();
            BlockPosition blockposition = blockHitResult.a();
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            if (flag) {
                this.a(blockposition1);
                this.a(blockposition1.a(enumdirection.f()));
                for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
                    this.a(blockposition1.a(enumdirection1));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        if (!this.t.y) {
            boolean flag;
            ItemStack itemstack = this.h();
            PotionRegistry potionregistry = PotionUtil.d(itemstack);
            List<MobEffect> list = PotionUtil.a(itemstack);
            boolean bl = flag = potionregistry == Potions.b && list.isEmpty();
            if (flag) {
                this.n();
            } else if (this.o()) {
                this.a(itemstack, potionregistry);
            } else {
                this.a(list, hitResult.c() == MovingObjectPosition.EnumMovingObjectType.c ? ((MovingObjectPositionEntity)hitResult).a() : null);
            }
            int i2 = potionregistry.b() ? 2007 : 2002;
            this.t.c(i2, this.cW(), PotionUtil.c(itemstack));
            this.ah();
        }
    }

    private void n() {
        PotionSplashEvent event;
        AxisAlignedBB axisalignedbb = this.cw().c(4.0, 2.0, 4.0);
        List<EntityLiving> list = this.t.a(EntityLiving.class, axisalignedbb, APPLY_WATER_GET_ENTITIES_PREDICATE);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        if (!list.isEmpty()) {
            for (EntityLiving entityliving : list) {
                if (entityliving instanceof Axolotl) {
                    Axolotl axolotl = (Axolotl)entityliving;
                    affected.put(axolotl.getBukkitLivingEntity(), 1.0);
                    continue;
                }
                double d0 = this.f(entityliving);
                if (!(d0 < 16.0) || !entityliving.eD()) continue;
                double intensity = 1.0 - Math.sqrt(d0) / 4.0;
                affected.put(entityliving.getBukkitLivingEntity(), intensity);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, affected)).isCancelled()) {
            for (LivingEntity affectedEntity : event.getAffectedEntities()) {
                EntityLiving entityliving = ((CraftLivingEntity)affectedEntity).getHandle();
                if (entityliving instanceof Axolotl) {
                    Axolotl axolotl = (Axolotl)entityliving;
                    if (event.getIntensity(affectedEntity) > 0.0) {
                        axolotl.fy();
                        continue;
                    }
                }
                entityliving.a(DamageSource.c(this, this.x()), 1.0f);
            }
        }
    }

    private void a(List<MobEffect> statusEffects, @Nullable Entity entity) {
        PotionSplashEvent event;
        double d1;
        AxisAlignedBB axisalignedbb = this.cw().c(4.0, 2.0, 4.0);
        List<EntityLiving> list1 = this.t.a(EntityLiving.class, axisalignedbb);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        if (!list1.isEmpty()) {
            Entity entity1 = this.y();
            for (EntityLiving entityliving : list1) {
                double d0;
                if (!entityliving.eW() || !((d0 = this.f(entityliving)) < 16.0)) continue;
                d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (entityliving == entity) {
                    d1 = 1.0;
                }
                affected.put((LivingEntity)entityliving.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, affected)).isCancelled() && statusEffects != null && !statusEffects.isEmpty()) {
            Entity entity1 = this.y();
            for (LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                EntityLiving entityliving = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffect mobeffect : statusEffects) {
                    int i2;
                    MobEffectList mobeffectlist = mobeffect.a();
                    if (!this.t.pvpMode && this.x() instanceof EntityPlayer && entityliving instanceof EntityPlayer && entityliving != this.x() && ((i2 = MobEffectList.a(mobeffectlist)) == 2 || i2 == 4 || i2 == 7 || i2 == 15 || i2 == 17 || i2 == 18 || i2 == 19)) continue;
                    if (mobeffectlist.a()) {
                        mobeffectlist.a(this, this.x(), entityliving, mobeffect.c(), d1);
                        continue;
                    }
                    i2 = (int)(d1 * (double)mobeffect.b() + 0.5);
                    if (i2 <= 20) continue;
                    entityliving.addEffect(new MobEffect(mobeffectlist, i2, mobeffect.c(), mobeffect.d(), mobeffect.e()), entity1, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
    }

    private void a(ItemStack stack, PotionRegistry potion) {
        LingeringPotionSplashEvent event;
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.t, this.dc(), this.de(), this.di());
        Entity entity = this.x();
        if (entity instanceof EntityLiving) {
            entityareaeffectcloud.a((EntityLiving)entity);
        }
        entityareaeffectcloud.a(3.0f);
        entityareaeffectcloud.b(-0.5f);
        entityareaeffectcloud.d(10);
        entityareaeffectcloud.c(-entityareaeffectcloud.h() / (float)entityareaeffectcloud.n());
        entityareaeffectcloud.a(potion);
        for (MobEffect mobeffect : PotionUtil.b(stack)) {
            entityareaeffectcloud.a(new MobEffect(mobeffect));
        }
        NBTTagCompound nbttagcompound = stack.s();
        if (nbttagcompound != null && nbttagcompound.b("CustomPotionColor", 99)) {
            entityareaeffectcloud.a(nbttagcompound.h("CustomPotionColor"));
        }
        if (!(event = CraftEventFactory.callLingeringPotionSplashEvent(this, entityareaeffectcloud)).isCancelled() && !entityareaeffectcloud.do()) {
            this.t.b(entityareaeffectcloud);
        } else {
            entityareaeffectcloud.ah();
        }
    }

    public boolean o() {
        return this.h().a(Items.su);
    }

    private void a(BlockPosition pos) {
        IBlockData iblockdata = this.t.a_(pos);
        if (iblockdata.a(TagsBlock.ax)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(this, pos, Blocks.a.n()).isCancelled()) {
                this.t.a(pos, false);
            }
        } else if (AbstractCandleBlock.b(iblockdata)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)iblockdata.a(AbstractCandleBlock.b, false)).isCancelled()) {
                AbstractCandleBlock.a((EntityHuman)null, iblockdata, (GeneratorAccess)this.t, pos);
            }
        } else if (BlockCampfire.g(iblockdata) && !CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)iblockdata.a(BlockCampfire.b, false)).isCancelled()) {
            this.t.a((EntityHuman)null, 1009, pos, 0);
            BlockCampfire.a(this.x(), (GeneratorAccess)this.t, pos, iblockdata);
            this.t.b(pos, (IBlockData)iblockdata.a(BlockCampfire.b, false));
        }
    }
}

