/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final DataWatcherObject<VillagerData> cc = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.q);
    public static final int bY = 12;
    public static final Map<Item, Integer> bZ = ImmutableMap.of((Object)Items.nj, (Object)4, (Object)Items.rm, (Object)1, (Object)Items.rl, (Object)1, (Object)Items.sn, (Object)1);
    private static final int cd = 2;
    private static final Set<Item> ce = ImmutableSet.of((Object)Items.nj, (Object)Items.rm, (Object)Items.rl, (Object)Items.ni, (Object)Items.nh, (Object)Items.sn, (Object[])new Item[]{Items.so});
    private static final int cf = 10;
    private static final int cg = 1200;
    private static final int ch = 24000;
    private static final int ci = 25;
    private static final int cj = 10;
    private static final int ck = 5;
    private static final long cl = 24000L;
    @VisibleForTesting
    public static final float ca = 0.5f;
    private int cm;
    private boolean cn;
    @Nullable
    private EntityHuman co;
    private boolean cp;
    private byte cq;
    private final Reputation cr = new Reputation();
    private long cs;
    private long ct;
    private int cu;
    private long cv;
    public int cw;
    private long cx;
    private boolean cy;
    private static final ImmutableList<MemoryModuleType<?>> cz = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.K, MemoryModuleType.m, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.t, MemoryModuleType.v, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.A, MemoryModuleType.f, MemoryModuleType.C, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.G, MemoryModuleType.H, MemoryModuleType.I, MemoryModuleType.F});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> cA = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, VillagePlaceType>> cb = ImmutableMap.of(MemoryModuleType.b, (entityvillager, villageplacetype) -> villageplacetype == VillagePlaceType.r, MemoryModuleType.c, (entityvillager, villageplacetype) -> entityvillager.fJ().b().b() == villageplacetype, MemoryModuleType.d, (entityvillager, villageplacetype) -> VillagePlaceType.a.test((VillagePlaceType)villageplacetype), MemoryModuleType.e, (entityvillager, villageplacetype) -> villageplacetype == VillagePlaceType.s);

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world) {
        this(entityType, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world, VillagerType type) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entityType, world);
        ((Navigation)this.D()).a(true);
        this.D().d(true);
        this.r(true);
        this.a(this.fJ().a(type).a(VillagerProfession.a));
    }

    public BehaviorController<EntityVillager> dt() {
        return super.dt();
    }

    protected BehaviorController.b<EntityVillager> du() {
        return BehaviorController.a(cz, cA);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.du().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void c(WorldServer world) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dt();
        behaviorcontroller.b(world, this);
        this.bE = behaviorcontroller.h();
        this.a(this.dt());
    }

    private void a(BehaviorController<EntityVillager> brain) {
        VillagerProfession villagerprofession = this.fJ().b();
        if (this.y_()) {
            brain.a(Schedule.e);
            brain.a(Activity.d, Behaviors.a(0.5f));
        } else {
            brain.a(Schedule.f);
            brain.a(Activity.c, (ImmutableList<Pair<Integer, Behavior<EntityVillager>>>)Behaviors.b(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        brain.a(Activity.a, Behaviors.a(villagerprofession, 0.5f));
        brain.a(Activity.f, (ImmutableList<Pair<Integer, Behavior<EntityVillager>>>)Behaviors.d(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        brain.a(Activity.e, Behaviors.c(villagerprofession, 0.5f));
        brain.a(Activity.b, Behaviors.e(villagerprofession, 0.5f));
        brain.a(Activity.g, Behaviors.f(villagerprofession, 0.5f));
        brain.a(Activity.i, Behaviors.g(villagerprofession, 0.5f));
        brain.a(Activity.h, Behaviors.h(villagerprofession, 0.5f));
        brain.a(Activity.j, Behaviors.i(villagerprofession, 0.5f));
        brain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        brain.b(Activity.b);
        brain.a(Activity.b);
        brain.a(this.t.W(), this.t.V());
    }

    @Override
    protected void n() {
        super.n();
        if (this.t instanceof WorldServer) {
            this.c((WorldServer)this.t);
        }
    }

    public static AttributeProvider.Builder fK() {
        return EntityInsentient.w().a(GenericAttributes.d, 0.5).a(GenericAttributes.b, 48.0);
    }

    public boolean fL() {
        return this.cy;
    }

    @Override
    public void inactiveTick() {
        if (this.q() > 0) {
            this.s(this.q() - 1);
        }
        if (this.eH()) {
            if (this.t.spigotConfig.tickInactiveVillagers) {
                this.R();
            } else {
                this.mobTick(true);
            }
        }
        this.gi();
        super.inactiveTick();
    }

    @Override
    protected void R() {
        this.mobTick(false);
    }

    protected void mobTick(boolean inactive) {
        Raid raid;
        this.t.ab().a("villagerBrain");
        if (!inactive) {
            this.dt().a((WorldServer)this.t, this);
        }
        this.t.ab().c();
        if (this.cy) {
            this.cy = false;
        }
        if (!this.fz() && this.cm > 0) {
            --this.cm;
            if (this.cm <= 0) {
                if (this.cn) {
                    this.gg();
                    this.cn = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.co != null && this.t instanceof WorldServer) {
            ((WorldServer)this.t).a(ReputationEvent.e, (Entity)this.co, this);
            this.t.a((Entity)this, (byte)14);
            this.co = null;
        }
        if (!inactive && !this.fr() && this.R.nextInt(100) == 0 && (raid = ((WorldServer)this.t).c(this.cW())) != null && raid.v() && !raid.a()) {
            this.t.a((Entity)this, (byte)42);
        }
        if (this.fJ().b() == VillagerProfession.a && this.fz()) {
            this.fE();
        }
        if (inactive) {
            return;
        }
        super.R();
    }

    @Override
    public void k() {
        super.k();
        if (this.q() > 0) {
            this.s(this.q() - 1);
        }
        this.gi();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.qT) && this.bl() && !this.fz() && !this.fb()) {
            if (this.y_()) {
                this.fW();
                return EnumInteractionResult.a(this.t.y);
            }
            boolean flag = this.fA().isEmpty();
            if (hand == EnumHand.a) {
                if (flag && !this.t.y) {
                    this.fW();
                }
                player.a(StatisticList.S);
            }
            if (flag) {
                return EnumInteractionResult.a(this.t.y);
            }
            if (!this.t.y && !this.bX.isEmpty()) {
                this.h(player);
            }
            return EnumInteractionResult.a(this.t.y);
        }
        return super.b(player, hand);
    }

    public void fW() {
        this.s(40);
        if (!this.t.k_()) {
            this.a(SoundEffects.tV, this.eu(), this.ev());
        }
    }

    private void h(EntityHuman customer) {
        this.i(customer);
        this.f(customer);
        this.a(customer, this.C_(), this.fJ().c());
    }

    @Override
    public void f(@Nullable EntityHuman customer) {
        boolean flag = this.fy() != null && customer == null;
        super.f(customer);
        if (flag) {
            this.fE();
        }
    }

    @Override
    protected void fE() {
        super.fE();
        this.fX();
    }

    private void fX() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fA()) {
            merchantrecipe.l();
        }
    }

    @Override
    public boolean fM() {
        return true;
    }

    @Override
    public boolean fH() {
        return this.W().y;
    }

    public void fN() {
        this.gb();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fA()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.h();
        }
        this.cv = this.t.V();
        ++this.cw;
    }

    private boolean fY() {
        net.minecraft.world.item.trading.MerchantRecipe merchantrecipe;
        Iterator iterator = this.fA().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(merchantrecipe = (net.minecraft.world.item.trading.MerchantRecipe)iterator.next()).r());
        return true;
    }

    private boolean fZ() {
        return this.cw == 0 || this.cw < 2 && this.t.V() > this.cv + 2400L;
    }

    public boolean fO() {
        long i2 = this.cv + 12000L;
        long j2 = this.t.V();
        boolean flag = j2 > i2;
        long k2 = this.t.W();
        if (this.cx > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.cx / 24000L;
            flag |= i1 > l2;
        }
        this.cx = k2;
        if (flag) {
            this.cv = j2;
            this.gj();
        }
        return this.fZ() && this.fY();
    }

    private void ga() {
        int i2 = 2 - this.cw;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fA()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.h();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.gb();
        }
    }

    private void gb() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fA()) {
            merchantrecipe.e();
        }
    }

    private void i(EntityHuman player) {
        int i2 = this.g(player);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.fA()) {
                if (merchantrecipe.ignoreDiscounts) continue;
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.n()));
            }
        }
        if (player.a(MobEffects.F)) {
            MobEffect mobeffect = player.b(MobEffects.F);
            int j2 = mobeffect.c();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.fA()) {
                if (merchantrecipe1.ignoreDiscounts) continue;
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().I());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(cc, new VillagerData(VillagerType.c, VillagerProfession.a, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.fJ());
        Logger logger = Entity.g;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        nbt.a("FoodLevel", this.cq);
        nbt.a("Gossips", this.cr.a(DynamicOpsNBT.a).getValue());
        nbt.a("Xp", this.cu);
        nbt.a("LastRestock", this.cv);
        nbt.a("LastGossipDecay", this.ct);
        nbt.a("RestocksToday", this.cw);
        if (this.cy) {
            nbt.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = Entity.g;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbt.b("Offers", 10)) {
            this.bX = new MerchantRecipeList(nbt.p("Offers"));
        }
        if (nbt.b("FoodLevel", 1)) {
            this.cq = nbt.f("FoodLevel");
        }
        NBTTagList nbttaglist = nbt.c("Gossips", 10);
        this.cr.a(new Dynamic<NBTTagList>(DynamicOpsNBT.a, nbttaglist));
        if (nbt.b("Xp", 3)) {
            this.cu = nbt.h("Xp");
        }
        this.cv = nbt.i("LastRestock");
        this.ct = nbt.i("LastGossipDecay");
        this.r(true);
        if (this.t instanceof WorldServer) {
            this.c((WorldServer)this.t);
        }
        this.cw = nbt.h("RestocksToday");
        if (nbt.e("AssignProfessionWhenSpawned")) {
            this.cy = nbt.q("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect r() {
        return this.fb() ? null : (this.fz() ? SoundEffects.tW : SoundEffects.tR);
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.tU;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.tT;
    }

    public void fP() {
        SoundEffect soundeffect = this.fJ().b().e();
        if (soundeffect != null) {
            this.a(soundeffect, this.eu(), this.ev());
        }
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.fJ();
        if (villagerdata1.b() != villagerData.b()) {
            this.bX = null;
        }
        this.Z.b(cc, villagerData);
    }

    @Override
    public VillagerData fJ() {
        return this.Z.a(cc);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe offer) {
        int i2 = 3 + this.R.nextInt(4);
        this.cu += offer.o();
        this.co = this.fy();
        if (this.gf()) {
            this.cm = 40;
            this.cn = true;
            i2 += 5;
        }
        if (offer.s()) {
            this.t.b(new EntityExperienceOrb(this.t, this.dc(), this.de() + 0.5, this.di(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.fy(), this));
        }
    }

    public void w(boolean flag) {
        this.cp = flag;
    }

    public boolean fQ() {
        return this.cp;
    }

    @Override
    public void a(@Nullable EntityLiving attacker) {
        if (attacker != null && this.t instanceof WorldServer) {
            ((WorldServer)this.t).a(ReputationEvent.c, (Entity)attacker, this);
            if (this.bl() && attacker instanceof EntityHuman) {
                this.t.a((Entity)this, (byte)13);
            }
        }
        super.a(attacker);
    }

    @Override
    public void a(DamageSource source) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            Entity.g.info("Villager {} died, message: '{}'", (Object)this, (Object)source.a(this).getString());
        }
        if ((entity = source.l()) != null) {
            this.a(entity);
        }
        this.gc();
        super.a(source);
    }

    public void gc() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void a(Entity killer) {
        World world = this.t;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.bE.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, killer, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    public void a(MemoryModuleType<GlobalPos> memorymoduletype) {
        if (this.t instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.t).n();
            this.bE.c(memorymoduletype).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.A();
                    Optional<VillagePlaceType> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, VillagePlaceType> bipredicate = cb.get(memorymoduletype);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        PacketDebug.c(worldserver, globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean g() {
        return this.cq + this.gh() >= 12 && this.j() == 0;
    }

    private boolean gd() {
        return this.cq < 12;
    }

    private void ge() {
        if (this.gd() && this.gh() != 0) {
            for (int i2 = 0; i2 < this.fF().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.fF().a(i2);
                if (itemstack.b() || (integer = bZ.get(itemstack.c())) == null) continue;
                for (int k2 = j2 = itemstack.I(); k2 > 0; --k2) {
                    this.cq = (byte)(this.cq + integer);
                    this.fF().a(i2, 1);
                    if (this.gd()) continue;
                    return;
                }
            }
        }
    }

    public int g(EntityHuman player) {
        return this.cr.a(player.cm(), (ReputationType reputationtype) -> true);
    }

    private void v(int amount) {
        this.cq = (byte)(this.cq - amount);
    }

    public void fR() {
        this.ge();
        this.v(12);
    }

    public void b(MerchantRecipeList offers) {
        this.bX = offers;
    }

    private boolean gf() {
        int i2 = this.fJ().c();
        return VillagerData.d(i2) && this.cu >= VillagerData.c(i2);
    }

    public void gg() {
        this.a(this.fJ().a(this.fJ().c() + 1));
        this.fG();
    }

    @Override
    protected IChatBaseComponent cd() {
        String s2 = this.ad().g();
        return new ChatMessage(s2 + "." + IRegistry.aq.b(this.fJ().b()).a());
    }

    @Override
    public void a(byte status) {
        if (status == 12) {
            this.a(Particles.H);
        } else if (status == 13) {
            this.a(Particles.b);
        } else if (status == 14) {
            this.a(Particles.F);
        } else if (status == 42) {
            this.a(Particles.ab);
        } else {
            super.a(status);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (spawnReason == EnumMobSpawn.e) {
            this.a(this.fJ().a(VillagerProfession.a));
        }
        if (spawnReason == EnumMobSpawn.n || spawnReason == EnumMobSpawn.m || spawnReason == EnumMobSpawn.c || spawnReason == EnumMobSpawn.o) {
            this.a(this.fJ().a(VillagerType.a(world.i(this.cW()))));
        }
        if (spawnReason == EnumMobSpawn.d) {
            this.cy = true;
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public EntityVillager b(WorldServer world, EntityAgeable entity) {
        double d0 = this.R.nextDouble();
        VillagerType villagertype = d0 < 0.5 ? VillagerType.a(world.i(this.cW())) : (d0 < 0.75 ? this.fJ().a() : ((EntityVillager)entity).fJ().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.aV, world, villagertype);
        entityvillager.a(world, world.d_(entityvillager.cW()), EnumMobSpawn.e, (GroupDataEntity)null, null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        if (world.af() != EnumDifficulty.a) {
            EntityWitch entitywitch = EntityTypes.aY.a(world);
            if (CraftEventFactory.callEntityZapEvent(this, lightning, entitywitch).isCancelled()) {
                return;
            }
            if (SpigotConfig.logVillagerDeaths) {
                Entity.g.info("Villager {} was struck by lightning {}.", (Object)this, (Object)lightning);
            }
            entitywitch.b(this.dc(), this.de(), this.di(), this.dm(), this.dn());
            entitywitch.a(world, world.d_(entitywitch.cW()), EnumMobSpawn.i, (GroupDataEntity)null, null);
            entitywitch.s(this.fr());
            if (this.Y()) {
                entitywitch.a(this.Z());
                entitywitch.n(this.cr());
            }
            entitywitch.fg();
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, entitywitch, EntityTransformEvent.TransformReason.LIGHTNING).isCancelled()) {
                return;
            }
            world.addFreshEntityWithPassengers(entitywitch, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.gc();
            this.ah();
        } else {
            super.a(world, lightning);
        }
    }

    @Override
    protected void b(EntityItem item) {
        ItemStack itemstack = item.h();
        if (this.l(itemstack)) {
            InventorySubcontainer inventorysubcontainer = this.fF();
            boolean flag = inventorysubcontainer.b(itemstack);
            if (!flag) {
                return;
            }
            ItemStack remaining = new InventorySubcontainer(inventorysubcontainer).a(itemstack);
            if (CraftEventFactory.callEntityPickupItemEvent(this, item, remaining.I(), false).isCancelled()) {
                return;
            }
            this.a(item);
            this.a((Entity)item, itemstack.I());
            ItemStack itemstack1 = inventorysubcontainer.a(itemstack);
            if (itemstack1.b()) {
                item.ah();
            } else {
                itemstack.e(itemstack1.I());
            }
        }
    }

    @Override
    public boolean l(ItemStack stack) {
        Item item = stack.c();
        return (ce.contains(item) || this.fJ().b().c().contains((Object)item)) && this.fF().b(stack);
    }

    public boolean fS() {
        return this.gh() >= 24;
    }

    public boolean fT() {
        return this.gh() < 12;
    }

    private int gh() {
        InventorySubcontainer inventorysubcontainer = this.fF();
        return bZ.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean fU() {
        return this.fF().a((Set<Item>)ImmutableSet.of((Object)Items.nh, (Object)Items.rm, (Object)Items.rl, (Object)Items.so));
    }

    @Override
    protected void fG() {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        VillagerData villagerdata = this.fJ();
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap = VillagerTrades.a.get(villagerdata.b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.fA();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, 2);
        }
    }

    public void a(WorldServer world, EntityVillager villager, long time) {
        if (!(time >= this.cs && time < this.cs + 1200L || time >= villager.cs && time < villager.cs + 1200L)) {
            this.cr.a(villager.cr, this.R, 10);
            this.cs = time;
            villager.cs = time;
            this.a(world, time, 5);
        }
    }

    private void gi() {
        long i2 = this.t.V();
        if (this.ct == 0L) {
            this.ct = i2;
        } else if (i2 >= this.ct + 24000L) {
            this.cr.b();
            this.ct = i2;
        }
    }

    public void a(WorldServer world, long time, int requiredCount) {
        EntityIronGolem entityirongolem;
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List list1;
        if (this.a(time) && (list1 = (list = world.a(EntityVillager.class, axisalignedbb = this.cw().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(time)).limit(5L).collect(Collectors.toList())).size() >= requiredCount && (entityirongolem = this.d(world)) != null) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long time) {
        return !this.b(this.t.V()) ? false : !this.bE.a(MemoryModuleType.F);
    }

    @Nullable
    private EntityIronGolem d(WorldServer world) {
        BlockPosition blockposition = this.cW();
        for (int i2 = 0; i2 < 10; ++i2) {
            double d1;
            double d0 = world.w.nextInt(16) - 8;
            BlockPosition blockposition1 = this.a(blockposition, d0, d1 = (double)(world.w.nextInt(16) - 8));
            if (blockposition1 == null) continue;
            PreCreatureSpawnEvent event = new PreCreatureSpawnEvent(MCUtil.toLocation(this.t, blockposition1), EntityType.IRON_GOLEM, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE);
            if (!event.callEvent()) {
                if (!event.shouldAbortSpawn()) break;
                SensorGolemLastSeen.b(this);
                return null;
            }
            EntityIronGolem entityirongolem = EntityTypes.P.b(world, null, null, null, blockposition1, EnumMobSpawn.f, false, false);
            if (entityirongolem == null) continue;
            if (entityirongolem.a((GeneratorAccess)world, EnumMobSpawn.f) && entityirongolem.a((IWorldReader)world)) {
                world.addFreshEntityWithPassengers(entityirongolem, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE);
                return entityirongolem;
            }
            entityirongolem.ah();
        }
        return null;
    }

    @Nullable
    private BlockPosition a(BlockPosition pos, double x2, double z2) {
        boolean flag = true;
        BlockPosition blockposition1 = pos.a(x2, 6.0, z2);
        IBlockData iblockdata = this.t.a_(blockposition1);
        for (int i2 = 6; i2 >= -6; --i2) {
            BlockPosition blockposition2 = blockposition1;
            IBlockData iblockdata1 = iblockdata;
            blockposition1 = blockposition1.c();
            iblockdata = this.t.a_(blockposition1);
            if (!iblockdata1.g() && !iblockdata1.c().a() || !iblockdata.c().f()) continue;
            return blockposition2;
        }
        return null;
    }

    @Override
    public void a(ReputationEvent interaction, Entity entity) {
        if (interaction == ReputationEvent.a) {
            Reputation.a playerReputation;
            if (this.t.paperConfig.fixCuringZombieVillagerDiscountExploit && (playerReputation = this.fV().getReputations().get(entity.cm())) != null) {
                playerReputation.b(ReputationType.d);
                playerReputation.b(ReputationType.c);
            }
            this.cr.a(entity.cm(), ReputationType.d, 20);
            this.cr.a(entity.cm(), ReputationType.c, 25);
        } else if (interaction == ReputationEvent.e) {
            this.cr.a(entity.cm(), ReputationType.e, 2);
        } else if (interaction == ReputationEvent.c) {
            this.cr.a(entity.cm(), ReputationType.b, 25);
        } else if (interaction == ReputationEvent.d) {
            this.cr.a(entity.cm(), ReputationType.a, 25);
        }
    }

    @Override
    public int t() {
        return this.cu;
    }

    public void u(int amount) {
        this.cu = amount;
    }

    private void gj() {
        this.ga();
        this.cw = 0;
    }

    public Reputation fV() {
        return this.cr;
    }

    public void a(NBTBase nbt) {
        this.cr.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt));
    }

    @Override
    protected void Q() {
        super.Q();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition pos) {
        super.b(pos);
        this.bE.a(MemoryModuleType.G, Long.valueOf(this.t.V()));
        this.bE.b(MemoryModuleType.m);
        this.bE.b(MemoryModuleType.E);
    }

    @Override
    public void fc() {
        super.fc();
        this.bE.a(MemoryModuleType.H, Long.valueOf(this.t.V()));
    }

    private boolean b(long worldTime) {
        Optional<Long> optional = this.bE.c(MemoryModuleType.G);
        return optional.isPresent() ? worldTime - optional.get() < 24000L : false;
    }
}

