/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.logging.log4j.Logger;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    public static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<VillagerData> c = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.q);
    private static final int d = 3600;
    private static final int bZ = 6000;
    private static final int ca = 14;
    private static final int cb = 4;
    public int cc;
    @Nullable
    public UUID cd;
    @Nullable
    private NBTBase ce;
    @Nullable
    private NBTTagCompound cf;
    private int cg;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> type, World world) {
        super((EntityTypes<? extends EntityZombie>)type, world);
        this.a(this.fJ().a(IRegistry.aq.a(this.R)));
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(b, false);
        this.Z.a(c, new VillagerData(VillagerType.c, VillagerProfession.a, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.fJ());
        Logger logger = Entity.g;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        if (this.cf != null) {
            nbt.a("Offers", this.cf);
        }
        if (this.ce != null) {
            nbt.a("Gossips", this.ce);
        }
        nbt.a("ConversionTime", this.fI() ? this.cc : -1);
        if (this.cd != null) {
            nbt.a("ConversionPlayer", this.cd);
        }
        nbt.a("Xp", this.cg);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = Entity.g;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbt.b("Offers", 10)) {
            this.cf = nbt.p("Offers");
        }
        if (nbt.b("Gossips", 10)) {
            this.ce = nbt.c("Gossips", 10);
        }
        if (nbt.b("ConversionTime", 99) && nbt.h("ConversionTime") > -1) {
            this.a(nbt.b("ConversionPlayer") ? nbt.a("ConversionPlayer") : null, nbt.h("ConversionTime"));
        }
        if (nbt.b("Xp", 3)) {
            this.cg = nbt.h("Xp");
        }
    }

    @Override
    public void k() {
        if (!this.t.y && this.bl() && this.fI()) {
            int i2 = this.fL();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.cc -= (i2 *= elapsedTicks);
            if (this.cc <= 0) {
                this.c((WorldServer)this.t);
            }
        }
        super.k();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.nM)) {
            if (this.a(MobEffects.r)) {
                if (!player.fr().d) {
                    itemstack.g(1);
                }
                if (!this.t.y) {
                    this.a(player.cm(), this.R.nextInt(2401) + 3600);
                }
                this.a(GameEvent.C, this.cY());
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.b;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean fz() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.fI() && this.cg == 0;
    }

    public boolean fI() {
        return this.ai().a(b);
    }

    public void a(@Nullable UUID uuid, int delay) {
        this.cd = uuid;
        this.cc = delay;
        this.ai().b(b, true);
        this.setPersistenceRequired(true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, delay, Math.min(this.t.af().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        this.t.a((Entity)this, (byte)16);
    }

    @Override
    public void a(byte status) {
        if (status == 16) {
            if (!this.aL()) {
                this.t.a(this.dc(), this.dg(), this.di(), SoundEffects.wd, this.cO(), 1.0f + this.R.nextFloat(), this.R.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.a(status);
        }
    }

    private void c(WorldServer world) {
        EntityHuman entityhuman;
        EntityVillager entityvillager = this.convertTo(EntityTypes.aV, false, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (entityvillager == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
            return;
        }
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack = this.b(enumitemslot);
            if (itemstack.b()) continue;
            if (EnchantmentManager.d(itemstack)) {
                entityvillager.k(enumitemslot.b() + 300).a(itemstack);
                continue;
            }
            double d0 = this.e(enumitemslot);
            if (!(d0 > 1.0)) continue;
            this.forceDrops = true;
            this.b(itemstack);
            this.forceDrops = false;
        }
        entityvillager.a(this.fJ());
        if (this.ce != null) {
            entityvillager.a(this.ce);
        }
        if (this.cf != null) {
            entityvillager.b(new MerchantRecipeList(this.cf));
        }
        entityvillager.u(this.cg);
        entityvillager.a(world, world.d_(entityvillager.cW()), EnumMobSpawn.i, (GroupDataEntity)null, null);
        if (this.cd != null && (entityhuman = world.b(this.cd)) instanceof EntityPlayer) {
            CriterionTriggers.r.a((EntityPlayer)entityhuman, this, entityvillager);
            world.a(ReputationEvent.a, (Entity)entityhuman, entityvillager);
        }
        entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
        if (!this.aL()) {
            world.a((EntityHuman)null, 1027, this.cW(), 0);
        }
    }

    private int fL() {
        int i2 = 1;
        if (this.R.nextFloat() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k2 = (int)this.dc() - 4; k2 < (int)this.dc() + 4 && j2 < 14; ++k2) {
                for (int l2 = (int)this.de() - 4; l2 < (int)this.de() + 4 && j2 < 14; ++l2) {
                    for (int i1 = (int)this.di() - 4; i1 < (int)this.di() + 4 && j2 < 14; ++i1) {
                        IBlockData iblockdata = this.t.a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (!iblockdata.a(Blocks.dP) && !(iblockdata.b() instanceof BlockBed)) continue;
                        if (this.R.nextFloat() < 0.3f) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float ev() {
        return this.y_() ? (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 2.0f : (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect r() {
        return SoundEffects.wb;
    }

    @Override
    public SoundEffect c(DamageSource source) {
        return SoundEffects.wf;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.we;
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.wg;
    }

    @Override
    protected ItemStack fy() {
        return ItemStack.b;
    }

    public void c(NBTTagCompound offerTag) {
        this.cf = offerTag;
    }

    public void a(NBTBase gossipTag) {
        this.ce = gossipTag;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.a(this.fJ().a(VillagerType.a(world.i(this.cW()))));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.fJ();
        if (villagerdata1.b() != villagerData.b()) {
            this.cf = null;
        }
        this.Z.b(c, villagerData);
    }

    @Override
    public VillagerData fJ() {
        return this.Z.a(c);
    }

    public int fK() {
        return this.cg;
    }

    @Override
    public void a(int xp) {
        this.cg = xp;
    }
}

