/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCrossbowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public class EntityPillager
extends EntityIllagerAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityPillager.class, DataWatcherRegistry.i);
    private static final int e = 5;
    private static final int bW = 300;
    private static final float bX = 1.6f;
    public final InventorySubcontainer bY = new InventorySubcontainer(5);

    public EntityPillager(EntityTypes<? extends EntityPillager> type, World world) {
        super((EntityTypes<? extends EntityIllagerAbstract>)type, world);
    }

    @Override
    @Override
    protected void u() {
        super.u();
        this.bR.a(0, new PathfinderGoalFloat(this));
        this.bR.a(2, new EntityRaider.a(this, this, 10.0f));
        this.bR.a(3, new PathfinderGoalCrossbowAttack<EntityPillager>(this, 1.0, 8.0f));
        this.bR.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bR.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 15.0f, 1.0f));
        this.bR.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 15.0f));
        this.bS.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bS.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bS.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.bS.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.fD().a(GenericAttributes.d, 0.35f).a(GenericAttributes.a, 24.0).a(GenericAttributes.f, 5.0).a(GenericAttributes.b, 32.0);
    }

    @Override
    @Override
    protected void a_() {
        super.a_();
        this.Z.a(b, false);
    }

    @Override
    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.sT;
    }

    public boolean fy() {
        return this.Z.a(b);
    }

    @Override
    @Override
    public void b(boolean charging) {
        this.Z.b(b, charging);
    }

    @Override
    @Override
    public void a() {
        this.bg = 0;
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        NBTTagList listTag = new NBTTagList();
        for (int i2 = 0; i2 < this.bY.b(); ++i2) {
            ItemStack itemStack = this.bY.a(i2);
            if (itemStack.b()) continue;
            listTag.add(itemStack.b(new NBTTagCompound()));
        }
        nbt.a("Inventory", listTag);
    }

    @Override
    @Override
    public EntityIllagerAbstract.a n() {
        if (this.fy()) {
            return EntityIllagerAbstract.a.f;
        }
        if (this.a(Items.sT)) {
            return EntityIllagerAbstract.a.e;
        }
        if (this.ft()) {
            return EntityIllagerAbstract.a.b;
        }
        return EntityIllagerAbstract.a.h;
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        NBTTagList listTag = nbt.c("Inventory", 10);
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            ItemStack itemStack = ItemStack.a(listTag.a(i2));
            if (itemStack.b()) continue;
            this.bY.a(itemStack);
        }
        this.r(true);
    }

    @Override
    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    @Override
    public int fe() {
        return 1;
    }

    @Override
    @Nullable
    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.a(difficulty);
        this.b(difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    @Override
    protected void a(DifficultyDamageScaler difficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.sT));
    }

    @Override
    @Override
    protected void x(float power) {
        ItemStack itemStack;
        super.x(power);
        if (this.R.nextInt(300) == 0 && (itemStack = this.er()).a(Items.sT)) {
            Map<Enchantment, Integer> map = EnchantmentManager.a(itemStack);
            map.putIfAbsent(Enchantments.J, 1);
            EnchantmentManager.a(map, itemStack);
            this.a(EnumItemSlot.a, itemStack);
        }
    }

    @Override
    @Override
    public boolean p(Entity other) {
        if (super.p(other)) {
            return true;
        }
        if (other instanceof EntityLiving && ((EntityLiving)other).eq() == EnumMonsterType.d) {
            return this.bW() == null && other.bW() == null;
        }
        return false;
    }

    @Override
    @Override
    protected SoundEffect r() {
        return SoundEffects.oq;
    }

    @Override
    @Override
    public SoundEffect x_() {
        return SoundEffects.os;
    }

    @Override
    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.ot;
    }

    @Override
    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.b(this, 1.6f);
    }

    @Override
    @Override
    public void a(EntityLiving target, ItemStack crossbow, IProjectile projectile, float multiShotSpray) {
        this.a(this, target, projectile, multiShotSpray, 1.6f);
    }

    @Override
    @Override
    public IInventory fI() {
        return this.bY;
    }

    @Override
    @Override
    protected void b(EntityItem item) {
        ItemStack itemStack = item.h();
        if (itemStack.c() instanceof ItemBanner) {
            super.b(item);
        } else if (this.m(itemStack)) {
            this.a(item);
            ItemStack itemStack2 = this.bY.a(itemStack);
            if (itemStack2.b()) {
                item.ah();
            } else {
                itemStack.e(itemStack2.I());
            }
        }
    }

    private boolean m(ItemStack stack) {
        return this.fN() && stack.a(Items.rU);
    }

    @Override
    @Override
    public SlotAccess k(int mappedIndex) {
        int i2 = mappedIndex - 300;
        if (i2 >= 0 && i2 < this.bY.b()) {
            return SlotAccess.a(this.bY, i2);
        }
        return super.k(mappedIndex);
    }

    @Override
    @Override
    public void a(int wave, boolean unused) {
        boolean bl;
        Raid raid = this.fM();
        boolean bl2 = bl = this.R.nextFloat() <= raid.w();
        if (bl) {
            ItemStack itemStack = new ItemStack(Items.sT);
            HashMap map = Maps.newHashMap();
            if (wave > raid.a(EnumDifficulty.c)) {
                map.put(Enchantments.I, 2);
            } else if (wave > raid.a(EnumDifficulty.b)) {
                map.put(Enchantments.I, 1);
            }
            map.put(Enchantments.H, 1);
            EnchantmentManager.a(map, itemStack);
            this.a(EnumItemSlot.a, itemStack);
        }
    }

    @Override
    @Override
    public SoundEffect t() {
        return SoundEffects.or;
    }
}

