/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;

public class EntityFallingBlock
extends Entity {
    private static final int f = 50;
    private IBlockData ap = Blocks.C.n();
    public int b;
    public boolean c = true;
    private boolean aq;
    public boolean ar;
    private int as = 40;
    private float at;
    private long au;
    @Nullable
    public NBTTagCompound d;
    protected static final DataWatcherObject<BlockPosition> e = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.l);

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> type, World world) {
        super(type, world);
    }

    public EntityFallingBlock(World world, double x2, double y2, double z2, IBlockData block) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.C, world);
        this.ap = block;
        this.r = true;
        this.e(x2, y2 + (double)((1.0f - this.cU()) / 2.0f), z2);
        this.g(Vec3D.a);
        this.u = x2;
        this.v = y2;
        this.w = z2;
        this.a(this.cW());
    }

    @Override
    public boolean cf() {
        return false;
    }

    public void a(BlockPosition pos) {
        this.Z.b(e, pos);
    }

    public BlockPosition h() {
        return this.Z.a(e);
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.Z.a(e, BlockPosition.b);
    }

    @Override
    public boolean bh() {
        return !this.do();
    }

    @Override
    public void k() {
        if (this.do()) {
            return;
        }
        if (this.ap.g()) {
            this.ah();
        } else if (this.t.y && this.au > 0L) {
            if (System.currentTimeMillis() >= this.au) {
                super.b(Entity.RemovalReason.b);
            }
        } else {
            BlockPosition blockposition;
            Block block = this.ap.b();
            if (this.b++ == 0) {
                blockposition = this.cW();
                if (this.t.a_(blockposition).a(block)) {
                    if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.a.n()).isCancelled()) {
                        if (this.t.a_(blockposition).a(block)) {
                            ((WorldServer)this.t).k().a(blockposition);
                        }
                        this.ah();
                        return;
                    }
                    this.t.a(blockposition, false);
                } else if (!this.t.y) {
                    this.ah();
                    return;
                }
            }
            if (!this.aM()) {
                this.g(this.da().b(0.0, -0.04, 0.0));
            }
            this.a(EnumMoveType.a, this.da());
            if (this.do()) {
                return;
            }
            if (this.t.paperConfig.fallingBlockHeightNerf != 0 && this.de() > (double)this.t.paperConfig.fallingBlockHeightNerf) {
                if (this.c && this.t.X().b(GameRules.h)) {
                    this.a(block);
                }
                this.ah();
                return;
            }
            if (!this.t.y) {
                MovingObjectPositionBlock movingobjectpositionblock;
                blockposition = this.cW();
                boolean flag = this.ap.b() instanceof BlockConcretePowder;
                boolean flag1 = flag && this.t.b_(blockposition).a(TagsFluid.b);
                double d0 = this.da().g();
                if (flag && d0 > 1.0 && (movingobjectpositionblock = this.t.a(new RayTrace(new Vec3D(this.u, this.v, this.w), this.cV(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).c() != MovingObjectPosition.EnumMovingObjectType.a && this.t.b_(movingobjectpositionblock.a()).a(TagsFluid.b)) {
                    blockposition = movingobjectpositionblock.a();
                    flag1 = true;
                }
                if (!this.z && !flag1) {
                    if (!(this.t.y || (this.b <= 100 || blockposition.v() > this.t.u_() && blockposition.v() <= this.t.ag()) && this.b <= 600)) {
                        if (this.c && this.t.X().b(GameRules.h)) {
                            this.a(block);
                        }
                        this.ah();
                    }
                } else {
                    IBlockData iblockdata = this.t.a_(blockposition);
                    this.g(this.da().d(0.7, -0.5, 0.7));
                    if (!iblockdata.a(Blocks.bu)) {
                        if (!this.aq) {
                            boolean flag4;
                            boolean flag2 = iblockdata.a(new BlockActionContextDirectional(this.t, blockposition, EnumDirection.a, ItemStack.b, EnumDirection.b));
                            boolean flag3 = BlockFalling.h(this.t.a_(blockposition.c())) && (!flag || !flag1);
                            boolean bl = flag4 = this.ap.a((IWorldReader)this.t, blockposition) && !flag3;
                            if (flag2 && flag4) {
                                if (this.ap.b(BlockProperties.C) && this.t.b_(blockposition).a() == FluidTypes.c) {
                                    this.ap = (IBlockData)this.ap.a(BlockProperties.C, true);
                                }
                                if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.ap).isCancelled()) {
                                    this.ah();
                                    return;
                                }
                                if (this.t.a(blockposition, this.ap, 3)) {
                                    TileEntity tileentity;
                                    ((WorldServer)this.t).k().a.a(this, new PacketPlayOutBlockChange(blockposition, this.t.a_(blockposition)));
                                    this.ah();
                                    if (block instanceof Fallable) {
                                        ((Fallable)((Object)block)).a(this.t, blockposition, this.ap, iblockdata, this);
                                    }
                                    if (this.d != null && this.ap.m() && (tileentity = this.t.c_(blockposition)) != null) {
                                        NBTTagCompound nbttagcompound = tileentity.o();
                                        for (String s2 : this.d.d()) {
                                            nbttagcompound.a(s2, this.d.c(s2).c());
                                        }
                                        try {
                                            tileentity.a(nbttagcompound);
                                        }
                                        catch (Exception exception) {
                                            Entity.g.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileentity.e();
                                    }
                                } else if (this.c && this.t.X().b(GameRules.h)) {
                                    this.ah();
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            } else {
                                this.ah();
                                if (this.c && this.t.X().b(GameRules.h)) {
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            }
                        } else {
                            this.ah();
                            this.a(block, blockposition);
                        }
                    }
                }
            }
            this.g(this.da().a(0.98));
        }
    }

    @Override
    public void b(Entity.RemovalReason reason) {
        if (this.t.a(reason)) {
            this.au = System.currentTimeMillis() + 50L;
        } else {
            super.b(reason);
        }
    }

    public void a(Block block, BlockPosition pos) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.t, pos, this);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        DamageSource damagesource1;
        Predicate<Entity> predicate;
        if (!this.ar) {
            return false;
        }
        int i2 = MathHelper.f(fallDistance - 1.0f);
        if (i2 < 0) {
            return false;
        }
        if (this.ap.b() instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)this.ap.b());
            predicate = fallable.U_();
            damagesource1 = fallable.b();
        } else {
            predicate = IEntitySelector.f;
            damagesource1 = DamageSource.r;
        }
        float f2 = Math.min(MathHelper.d((float)i2 * this.at), this.as);
        this.t.a((Entity)this, this.cw(), predicate).forEach(entity -> {
            CraftEventFactory.entityDamage = this;
            entity.a(damagesource1, f2);
            CraftEventFactory.entityDamage = null;
        });
        boolean flag = this.ap.a(TagsBlock.G);
        if (flag && f2 > 0.0f && this.R.nextFloat() < 0.05f + (float)i2 * 0.05f) {
            IBlockData iblockdata = BlockAnvil.e(this.ap);
            if (iblockdata == null) {
                this.aq = true;
            } else {
                this.ap = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("BlockState", GameProfileSerializer.a(this.ap));
        nbt.a("Time", this.b);
        nbt.a("DropItem", this.c);
        nbt.a("HurtEntities", this.ar);
        nbt.a("FallHurtAmount", this.at);
        nbt.a("FallHurtMax", this.as);
        if (this.d != null) {
            nbt.a("TileEntityData", this.d);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.ap = GameProfileSerializer.c(nbt.p("BlockState"));
        Block b2 = this.ap.b();
        if (this.t.paperConfig.filterNBTFromSpawnEgg && (b2 == Blocks.eE || b2 == Blocks.iU || b2 == Blocks.iV || b2 == Blocks.nn || b2 == Blocks.nm || b2 instanceof GameMasterBlock)) {
            this.ap = Blocks.b.n();
        }
        this.b = nbt.h("Time");
        if (nbt.b("HurtEntities", 99)) {
            this.ar = nbt.q("HurtEntities");
            this.at = nbt.j("FallHurtAmount");
            this.as = nbt.h("FallHurtMax");
        } else if (this.ap.a(TagsBlock.G)) {
            this.ar = true;
        }
        if (nbt.b("DropItem", 99)) {
            this.c = nbt.q("DropItem");
        }
        if (nbt.b("TileEntityData", 10)) {
            this.d = nbt.p("TileEntityData");
        }
        if (this.ap.g()) {
            this.ap = Blocks.C.n();
        }
        if (nbt.e("SourceLoc_x")) {
            int srcX = nbt.h("SourceLoc_x");
            int srcY = nbt.h("SourceLoc_y");
            int srcZ = nbt.h("SourceLoc_z");
            this.setOrigin(new Location((org.bukkit.World)this.t.getWorld(), (double)srcX, (double)srcY, (double)srcZ));
        }
    }

    public void b(float fallHurtAmount, int fallHurtMax) {
        this.ar = true;
        this.at = fallHurtAmount;
        this.as = fallHurtMax;
    }

    @Override
    public boolean cl() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails section) {
        super.a(section);
        section.a("Immitating BlockState", this.ap.toString());
    }

    public IBlockData i() {
        return this.ap;
    }

    @Override
    public boolean cD() {
        return true;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntity(this, Block.i(this.i()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.ap = Block.a(packet.m());
        this.r = true;
        double d0 = packet.d();
        double d1 = packet.e();
        double d2 = packet.f();
        this.e(d0, d1 + (double)((1.0f - this.cU()) / 2.0f), d2);
        this.a(this.cW());
    }
}

