/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap bW = new PathfinderGoalHorseTrap(this);
    private static final int cm = 18000;
    private boolean cn;
    public int co;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> type, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, world);
    }

    public static AttributeProvider.Builder t() {
        return EntityHorseSkeleton.fU().a(GenericAttributes.a, 15.0).a(GenericAttributes.d, 0.2f);
    }

    @Override
    protected void q() {
        this.a(GenericAttributes.m).a(this.gc());
    }

    @Override
    protected void fH() {
    }

    @Override
    protected SoundEffect r() {
        super.r();
        return ((Entity)this).a(TagsFluid.b) ? SoundEffects.re : SoundEffects.ra;
    }

    @Override
    public SoundEffect x_() {
        super.x_();
        return SoundEffects.rb;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        super.c(source);
        return SoundEffects.rc;
    }

    @Override
    protected SoundEffect aF() {
        if (this.z) {
            if (!this.bG()) {
                return SoundEffects.rh;
            }
            ++this.cl;
            if (this.cl > 5 && this.cl % 3 == 0) {
                return SoundEffects.rf;
            }
            if (this.cl <= 5) {
                return SoundEffects.rh;
            }
        }
        return SoundEffects.rd;
    }

    @Override
    protected void d(float volume) {
        if (this.z) {
            super.d(0.3f);
        } else {
            super.d(Math.min(0.1f, volume * 25.0f));
        }
    }

    @Override
    protected void fZ() {
        if (this.aQ()) {
            this.a(SoundEffects.rg, 0.4f, 1.0f);
        } else {
            super.fZ();
        }
    }

    @Override
    public EnumMonsterType eq() {
        return EnumMonsterType.b;
    }

    @Override
    public double bq() {
        return super.bq() - 0.1875;
    }

    @Override
    public void w_() {
        super.w_();
        if (this.fy() && this.co++ >= 18000) {
            this.ah();
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("SkeletonTrap", this.fy());
        nbt.a("SkeletonTrapTime", this.co);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.v(nbt.q("SkeletonTrap"));
        this.co = nbt.h("SkeletonTrapTime");
    }

    @Override
    public boolean bH() {
        return true;
    }

    @Override
    protected float eB() {
        return 0.96f;
    }

    public boolean fy() {
        return this.cn;
    }

    public void v(boolean trapped) {
        if (trapped != this.cn) {
            this.cn = trapped;
            if (trapped) {
                this.bR.a(1, this.bW);
            } else {
                this.bR.a(this.bW);
            }
        }
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aC.a(world);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!this.fI()) {
            return EnumInteractionResult.d;
        }
        if (this.y_()) {
            return super.b(player, hand);
        }
        if (player.ff()) {
            this.f(player);
            return EnumInteractionResult.a(this.t.y);
        }
        if (this.bG()) {
            return super.b(player, hand);
        }
        if (!itemstack.b()) {
            if (itemstack.a(Items.lL) && !this.d()) {
                this.f(player);
                return EnumInteractionResult.a(this.t.y);
            }
            EnumInteractionResult enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand);
            if (enuminteractionresult.a()) {
                return enuminteractionresult;
            }
        }
        this.h(player);
        return EnumInteractionResult.a(this.t.y);
    }
}

