/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize bW = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int cc = 2;
    private static final int cd = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> bX = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.n, SensorType.f, SensorType.q);
    protected static final ImmutableList<MemoryModuleType<?>> bZ = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.ap, MemoryModuleType.r, MemoryModuleType.Q, MemoryModuleType.R, MemoryModuleType.N, MemoryModuleType.J, MemoryModuleType.O, (Object[])new MemoryModuleType[]{MemoryModuleType.P, MemoryModuleType.T, MemoryModuleType.U});
    public static final int ca = 10;
    public static final double cb = 0.02;
    private static final DataWatcherObject<Boolean> ce = DataWatcher.a(Goat.class, DataWatcherRegistry.i);
    private boolean cf;
    private int cg;

    public Goat(EntityTypes<? extends Goat> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.D().d(true);
    }

    protected BehaviorController.b<Goat> du() {
        return BehaviorController.a(bZ, bX);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.du().a(dynamic));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.w().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.2f).a(GenericAttributes.f, 2.0);
    }

    @Override
    protected void n() {
        if (this.y_()) {
            this.a(GenericAttributes.f).a(1.0);
        } else {
            this.a(GenericAttributes.f).a(2.0);
        }
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return super.d(fallDistance, damageMultiplier) - 10;
    }

    @Override
    protected SoundEffect r() {
        return this.fy() ? SoundEffects.hA : SoundEffects.hs;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return this.fy() ? SoundEffects.hD : SoundEffects.hv;
    }

    @Override
    public SoundEffect x_() {
        return this.fy() ? SoundEffects.hB : SoundEffects.ht;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.hI, 0.15f, 1.0f);
    }

    protected SoundEffect t() {
        return this.fy() ? SoundEffects.hF : SoundEffects.hx;
    }

    public Goat b(WorldServer world, EntityAgeable entity) {
        Goat goat = EntityTypes.J.a(world);
        if (goat != null) {
            GoatAi.a(goat);
            boolean flag = entity instanceof Goat && ((Goat)entity).fy();
            goat.v(flag || world.r_().nextDouble() < 0.02);
        }
        return goat;
    }

    public BehaviorController<Goat> dt() {
        return super.dt();
    }

    @Override
    protected void R() {
        this.t.ab().a("goatBrain");
        this.dt().a((WorldServer)this.t, this);
        this.t.ab().c();
        this.t.ab().a("goatActivityUpdate");
        GoatAi.b(this);
        this.t.ab().c();
        super.R();
    }

    @Override
    public int U() {
        return 15;
    }

    @Override
    public void l(float headYaw) {
        int i2 = this.U();
        float f1 = MathHelper.c(this.aY, headYaw);
        float f2 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.l(this.aY + f2);
    }

    @Override
    public SoundEffect e(ItemStack stack) {
        return this.fy() ? SoundEffects.hC : SoundEffects.hu;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.nW) && !this.y_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)player.t, player, this.cW(), this.cW(), null, itemstack, Items.oc, hand);
            if (event.isCancelled()) {
                return EnumInteractionResult.d;
            }
            player.a(this.t(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemstack1);
            return EnumInteractionResult.a(this.t.y);
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && this.n(itemstack)) {
            this.t.a((EntityHuman)null, this, this.e(itemstack), SoundCategory.g, 1.0f, MathHelper.b(this.t.w, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        GoatAi.a(this);
        this.v(world.r_().nextDouble() < 0.02);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void Q() {
        super.Q();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return pose == EntityPose.g ? bW.a(this.dE()) : super.a(pose);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsScreamingGoat", this.fy());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.v(nbt.q("IsScreamingGoat"));
    }

    @Override
    public void a(byte status) {
        if (status == 58) {
            this.cf = true;
        } else if (status == 59) {
            this.cf = false;
        } else {
            super.a(status);
        }
    }

    @Override
    public void w_() {
        this.cg = this.cf ? ++this.cg : (this.cg -= 2);
        this.cg = MathHelper.a(this.cg, 0, 20);
        super.w_();
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(ce, false);
    }

    public boolean fy() {
        return this.Z.a(ce);
    }

    public void v(boolean screaming) {
        this.Z.b(ce, screaming);
    }

    public float fz() {
        return (float)this.cg / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new b(this, world);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.a_(pos.c()).a(TagsBlock.bu) && Goat.a(world, pos);
    }

    public void ram(EntityLiving entity) {
        BehaviorController<Goat> brain = this.dt();
        brain.a(MemoryModuleType.U, entity.cV());
        brain.b(MemoryModuleType.T);
        brain.b(MemoryModuleType.r);
        brain.b(MemoryModuleType.N);
        brain.a(Activity.r);
    }

    private static class b
    extends Navigation {
        b(Goat goat, World world) {
            super(goat, world);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new a();
            return new Pathfinder(this.o, range);
        }
    }

    private static class a
    extends PathfinderNormal {
        private final BlockPosition.MutableBlockPosition l = new BlockPosition.MutableBlockPosition();

        a() {
        }

        @Override
        public PathType a(IBlockAccess world, int x2, int y2, int z2) {
            this.l.d(x2, y2 - 1, z2);
            PathType pathtype = a.b(world, this.l);
            return pathtype == PathType.f ? PathType.a : a.a(world, this.l.c(EnumDirection.b));
        }
    }
}

