/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Integer> cb = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cc = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    public static final Predicate<EntityLiving> bZ = entityliving -> {
        EntityTypes<?> entitytypes = entityliving.ad();
        return entitytypes == EntityTypes.ax || entitytypes == EntityTypes.au || entitytypes == EntityTypes.E;
    };
    private static final float cd = 8.0f;
    private static final float ce = 20.0f;
    private float cf;
    private float cg;
    private boolean ch;
    private boolean ci;
    private float cj;
    private float ck;
    private static final UniformInt cl = TimeRange.a(20, 39);
    @Nullable
    private UUID cm;

    public EntityWolf(EntityTypes<? extends EntityWolf> type, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, world);
        this.w(false);
    }

    @Override
    protected void u() {
        this.bR.a(1, new PathfinderGoalFloat(this));
        this.bR.a(2, new PathfinderGoalSit(this));
        this.bR.a(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.bR.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bR.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bR.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f, false));
        this.bR.a(7, new PathfinderGoalBreed(this, 1.0));
        this.bR.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bR.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.bR.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bR.a(10, new PathfinderGoalRandomLookaround(this));
        this.bS.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.bS.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.bS.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bS.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bS.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, bZ));
        this.bS.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bX));
        this.bS.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.bS.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public static AttributeProvider.Builder fG() {
        return EntityInsentient.w().a(GenericAttributes.d, 0.3f).a(GenericAttributes.a, 8.0).a(GenericAttributes.f, 2.0);
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fire) {
        if (!super.setTarget(entityliving, reason, fire)) {
            return false;
        }
        entityliving = this.G();
        return true;
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(ca, false);
        this.Z.a(cb, EnumColor.o.a());
        this.Z.a(cc, 0);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.vk, 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("CollarColor", (byte)this.fJ().a());
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbt.h("CollarColor")));
        }
        this.a(this.t, nbt);
    }

    @Override
    protected SoundEffect r() {
        return this.H_() ? SoundEffects.vf : (this.R.nextInt(3) == 0 ? (this.q() && this.dZ() < 10.0f ? SoundEffects.vl : SoundEffects.vi) : SoundEffects.vd);
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.vh;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.ve;
    }

    @Override
    public float eu() {
        return 0.4f;
    }

    @Override
    public void w_() {
        super.w_();
        if (!this.t.y && this.ch && !this.ci && !this.fw() && this.z) {
            this.ci = true;
            this.cj = 0.0f;
            this.ck = 0.0f;
            this.t.a((Entity)this, (byte)8);
        }
        if (!this.t.y) {
            this.a((WorldServer)this.t, true);
        }
    }

    @Override
    public void k() {
        super.k();
        if (this.bl()) {
            this.cg = this.cf;
            this.cf = this.fK() ? (this.cf += (1.0f - this.cf) * 0.4f) : (this.cf += (0.0f - this.cf) * 0.4f);
            if (this.aS()) {
                this.ch = true;
                if (this.ci && !this.t.y) {
                    this.t.a((Entity)this, (byte)56);
                    this.fL();
                }
            } else if ((this.ch || this.ci) && this.ci) {
                if (this.cj == 0.0f) {
                    this.a(SoundEffects.vj, this.eu(), (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f);
                    this.a(GameEvent.S);
                }
                this.ck = this.cj;
                this.cj += 0.05f;
                if (this.ck >= 2.0f) {
                    this.ch = false;
                    this.ci = false;
                    this.ck = 0.0f;
                    this.cj = 0.0f;
                }
                if (this.cj > 0.4f) {
                    float f2 = (float)this.de();
                    int i2 = (int)(MathHelper.a((this.cj - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D vec3d = this.da();
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f1 = (this.R.nextFloat() * 2.0f - 1.0f) * this.cT() * 0.5f;
                        float f22 = (this.R.nextFloat() * 2.0f - 1.0f) * this.cT() * 0.5f;
                        this.t.a(Particles.ab, this.dc() + (double)f1, (double)(f2 + 0.8f), this.di() + (double)f22, vec3d.b, vec3d.c, vec3d.d);
                    }
                }
            }
        }
    }

    private void fL() {
        this.ci = false;
        this.cj = 0.0f;
        this.ck = 0.0f;
    }

    @Override
    public void a(DamageSource source) {
        this.ch = false;
        this.ci = false;
        this.ck = 0.0f;
        this.cj = 0.0f;
        super.a(source);
    }

    public boolean fH() {
        return this.ch;
    }

    public float z(float tickDelta) {
        return Math.min(0.5f + MathHelper.i(tickDelta, this.ck, this.cj) / 2.0f * 0.5f, 1.0f);
    }

    public float f(float tickDelta, float f1) {
        float f2 = (MathHelper.i(tickDelta, this.ck, this.cj) + f1) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.a(f2 * (float)Math.PI) * MathHelper.a(f2 * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float A(float tickDelta) {
        return MathHelper.i(tickDelta, this.cg, this.cf) * 0.15f * (float)Math.PI;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.8f;
    }

    @Override
    public int T() {
        return this.fy() ? 20 : super.T();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        Entity entity = source.l();
        if (entity != null && !(entity instanceof EntityHuman) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.a(source, amount);
    }

    @Override
    public boolean z(Entity target) {
        boolean flag = target.a(DamageSource.c(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, target);
        }
        return flag;
    }

    @Override
    public void w(boolean tamed) {
        super.w(tamed);
        if (tamed) {
            this.a(GenericAttributes.a).a(20.0);
            this.c(this.el());
        } else {
            this.a(GenericAttributes.a).a(8.0);
        }
        this.a(GenericAttributes.f).a(4.0);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        Item item = itemstack.c();
        if (this.t.y) {
            boolean flag = this.j(player) || this.q() || itemstack.a(Items.oV) && !this.q() && !this.H_();
            return flag ? EnumInteractionResult.b : EnumInteractionResult.d;
        }
        if (this.q()) {
            if (this.n(itemstack) && this.dZ() < this.el()) {
                if (!player.fr().d) {
                    itemstack.g(1);
                }
                this.heal(item.v().a(), EntityRegainHealthEvent.RegainReason.EATING);
                this.a(GameEvent.C, this.cY());
                return EnumInteractionResult.a;
            }
            if (!(item instanceof ItemDye)) {
                EnumInteractionResult enuminteractionresult = super.b(player, hand);
                if ((!enuminteractionresult.a() || this.y_()) && this.j(player)) {
                    this.y(!this.fA());
                    this.bo = false;
                    this.bQ.n();
                    this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                    return EnumInteractionResult.a;
                }
                return enuminteractionresult;
            }
            EnumColor enumcolor = ((ItemDye)item).d();
            if (enumcolor != this.fJ()) {
                this.a(enumcolor);
                if (!player.fr().d) {
                    itemstack.g(1);
                }
                return EnumInteractionResult.a;
            }
        } else if (itemstack.a(Items.oV) && !this.H_()) {
            if (!player.fr().d) {
                itemstack.g(1);
            }
            if (this.R.nextInt(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                this.f(player);
                this.bQ.n();
                this.h((EntityLiving)null);
                this.y(true);
                this.t.a((Entity)this, (byte)7);
            } else {
                this.t.a((Entity)this, (byte)6);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(byte status) {
        if (status == 8) {
            this.ci = true;
            this.cj = 0.0f;
            this.ck = 0.0f;
        } else if (status == 56) {
            this.fL();
        } else {
            super.a(status);
        }
    }

    public float fI() {
        return this.H_() ? 1.5393804f : (this.q() ? (0.55f - (this.el() - this.dZ()) * 0.02f) * (float)Math.PI : 0.62831855f);
    }

    @Override
    public boolean n(ItemStack stack) {
        Item item = stack.c();
        return item.u() && item.v().c();
    }

    @Override
    public int fe() {
        return 8;
    }

    @Override
    public int a() {
        return this.Z.a(cc);
    }

    @Override
    public void a(int ticks) {
        this.Z.b(cc, ticks);
    }

    @Override
    public void c() {
        this.a(cl.a(this.R));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cm;
    }

    @Override
    public void a(@Nullable UUID uuid) {
        this.cm = uuid;
    }

    public EnumColor fJ() {
        return EnumColor.a(this.Z.a(cb));
    }

    public void a(EnumColor color) {
        this.Z.b(cb, color.a());
    }

    public EntityWolf b(WorldServer world, EntityAgeable entity) {
        EntityWolf entitywolf = EntityTypes.bc.a(world);
        UUID uuid = this.d();
        if (uuid != null) {
            entitywolf.b(uuid);
            entitywolf.w(true);
        }
        return entitywolf;
    }

    public void z(boolean begging) {
        this.Z.b(ca, begging);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (other == this) {
            return false;
        }
        if (!this.q()) {
            return false;
        }
        if (!(other instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)other;
        return !entitywolf.q() ? false : (entitywolf.fy() ? false : this.fE() && entitywolf.fE());
    }

    public boolean fK() {
        return this.Z.a(ca);
    }

    @Override
    public boolean a(EntityLiving target, EntityLiving owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            if (target instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)target;
                return !entitywolf.q() || entitywolf.fz() != owner;
            }
            return target instanceof EntityHuman && owner instanceof EntityHuman && !((EntityHuman)owner).a((EntityHuman)target) ? false : (target instanceof EntityHorseAbstract && ((EntityHorseAbstract)target).fI() ? false : !(target instanceof EntityTameableAnimal) || !((EntityTameableAnimal)target).q());
        }
        return false;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.H_() && super.a(player);
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.6f * this.cy(), this.cT() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.a_(pos.c()).a(TagsBlock.bA) && EntityWolf.a(world, pos);
    }

    private class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf entitywolf, Class oclass, float f2, double d0, double d1) {
            super(entitywolf, oclass, f2, d0, d1);
            this.j = entitywolf;
        }

        @Override
        public boolean a() {
            return super.a() && this.b instanceof EntityLlama ? !this.j.q() && this.a((EntityLlama)this.b) : false;
        }

        private boolean a(EntityLlama llama) {
            return llama.gh() >= EntityWolf.this.R.nextInt(5);
        }

        @Override
        public void c() {
            EntityWolf.this.h((EntityLiving)null);
            super.c();
        }

        @Override
        public void e() {
            EntityWolf.this.h((EntityLiving)null);
            super.e();
        }
    }
}

