/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityPolarBear.class, DataWatcherRegistry.i);
    private static final float bX = 6.0f;
    private float bZ;
    private float ca;
    private int cb;
    private static final UniformInt cc = TimeRange.a(20, 39);
    private int cd;
    @Nullable
    private UUID ce;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.ar.a(world);
    }

    @Override
    @Override
    public boolean n(ItemStack stack) {
        return false;
    }

    @Override
    @Override
    protected void u() {
        super.u();
        this.bR.a(0, new PathfinderGoalFloat(this));
        this.bR.a(1, new c());
        this.bR.a(1, new d());
        this.bR.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bR.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.bR.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bR.a(7, new PathfinderGoalRandomLookaround(this));
        this.bS.a(1, new b());
        this.bS.a(2, new a());
        this.bS.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bS.a(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.bS.a(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.w().a(GenericAttributes.a, 30.0).a(GenericAttributes.b, 20.0).a(GenericAttributes.d, 0.25).a(GenericAttributes.f, 6.0);
    }

    public static boolean c(EntityTypes<EntityPolarBear> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        Optional<ResourceKey<BiomeBase>> optional = world.i(pos);
        if (Objects.equals(optional, Optional.of(Biomes.U)) || Objects.equals(optional, Optional.of(Biomes.V))) {
            return EntityPolarBear.a(world, pos) && world.a_(pos.c()).a(TagsBlock.bx);
        }
        return EntityPolarBear.b(type, world, spawnReason, pos, random);
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(this.t, nbt);
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.c(nbt);
    }

    @Override
    @Override
    public void c() {
        this.a(cc.a(this.R));
    }

    @Override
    @Override
    public void a(int ticks) {
        this.cd = ticks;
    }

    @Override
    @Override
    public int a() {
        return this.cd;
    }

    @Override
    @Override
    public void a(@Nullable UUID uuid) {
        this.ce = uuid;
    }

    @Override
    @Nullable
    @Override
    public UUID b() {
        return this.ce;
    }

    @Override
    @Override
    protected SoundEffect r() {
        if (this.y_()) {
            return SoundEffects.oR;
        }
        return SoundEffects.oQ;
    }

    @Override
    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.oT;
    }

    @Override
    @Override
    public SoundEffect x_() {
        return SoundEffects.oS;
    }

    @Override
    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.oU, 0.15f, 1.0f);
    }

    protected void t() {
        if (this.cb <= 0) {
            this.a(SoundEffects.oV, 1.0f, this.ev());
            this.cb = 40;
        }
    }

    @Override
    @Override
    protected void a_() {
        super.a_();
        this.Z.a(bW, false);
    }

    @Override
    @Override
    public void k() {
        super.k();
        if (this.t.y) {
            if (this.ca != this.bZ) {
                this.z_();
            }
            this.bZ = this.ca;
            this.ca = this.fy() ? MathHelper.a(this.ca + 1.0f, 0.0f, 6.0f) : MathHelper.a(this.ca - 1.0f, 0.0f, 6.0f);
        }
        if (this.cb > 0) {
            --this.cb;
        }
        if (!this.t.y) {
            this.a((WorldServer)this.t, true);
        }
    }

    @Override
    @Override
    public EntitySize a(EntityPose pose) {
        if (this.ca > 0.0f) {
            float f2 = this.ca / 6.0f;
            float g2 = 1.0f + f2;
            return super.a(pose).a(1.0f, g2);
        }
        return super.a(pose);
    }

    @Override
    @Override
    public boolean z(Entity target) {
        boolean bl = target.a(DamageSource.c(this), (float)((int)this.b(GenericAttributes.f)));
        if (bl) {
            this.a((EntityLiving)this, target);
        }
        return bl;
    }

    public boolean fy() {
        return this.Z.a(bW);
    }

    public void v(boolean warning) {
        this.Z.b(bW, warning);
    }

    public float z(float tickDelta) {
        return MathHelper.i(tickDelta, this.bZ, this.ca) / 6.0f;
    }

    @Override
    @Override
    protected float eB() {
        return 0.98f;
    }

    @Override
    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(1.0f);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        @Override
        protected void a(EntityLiving target, double squaredDistance) {
            double d2 = this.a(target);
            if (squaredDistance <= d2 && this.i()) {
                this.g();
                this.a.z(target);
                EntityPolarBear.this.v(false);
            } else if (squaredDistance <= d2 * 2.0) {
                if (this.i()) {
                    EntityPolarBear.this.v(false);
                    this.g();
                }
                if (this.k() <= 10) {
                    EntityPolarBear.this.v(true);
                    EntityPolarBear.this.t();
                }
            } else {
                this.g();
                EntityPolarBear.this.v(false);
            }
        }

        @Override
        @Override
        public void d() {
            EntityPolarBear.this.v(false);
            super.d();
        }

        @Override
        @Override
        protected double a(EntityLiving entity) {
            return 4.0f + entity.cT();
        }
    }

    class d
    extends PathfinderGoalPanic {
        public d() {
            super(EntityPolarBear.this, 2.0);
        }

        @Override
        @Override
        public boolean a() {
            if (!EntityPolarBear.this.y_() && !EntityPolarBear.this.bE()) {
                return false;
            }
            return super.a();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        @Override
        public void c() {
            super.c();
            if (EntityPolarBear.this.y_()) {
                this.g();
                this.d();
            }
        }

        @Override
        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPolarBear && !mob.y_()) {
                super.a(mob, target);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        @Override
        public boolean a() {
            if (EntityPolarBear.this.y_()) {
                return false;
            }
            if (super.a()) {
                List<EntityPolarBear> list = EntityPolarBear.this.t.a(EntityPolarBear.class, EntityPolarBear.this.cw().c(8.0, 4.0, 8.0));
                for (EntityPolarBear polarBear : list) {
                    if (!polarBear.y_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        @Override
        protected double l() {
            return super.l() * 0.5;
        }
    }
}

