/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class EntityFox
extends EntityAnimal {
    private static final DataWatcherObject<Integer> ca = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> cb = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int cc = 1;
    public static final int bW = 4;
    public static final int bX = 8;
    public static final int bZ = 16;
    private static final int cd = 32;
    private static final int ce = 64;
    private static final int cf = 128;
    public static final DataWatcherObject<Optional<UUID>> cg = DataWatcher.a(EntityFox.class, DataWatcherRegistry.o);
    public static final DataWatcherObject<Optional<UUID>> ch = DataWatcher.a(EntityFox.class, DataWatcherRegistry.o);
    static final Predicate<EntityItem> ci = entityitem -> !entityitem.r() && entityitem.bl();
    private static final Predicate<Entity> cj = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.dN() != null && entityliving.dO() < entityliving.S + 600;
    };
    static final Predicate<Entity> ck = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> cl = entity -> !entity.bL() && IEntitySelector.e.test((Entity)entity);
    private static final int cm = 600;
    private PathfinderGoal cn;
    private PathfinderGoal co;
    private PathfinderGoal cp;
    private float cq;
    private float cr;
    float cs;
    float ct;
    private int cu;

    public EntityFox(EntityTypes<? extends EntityFox> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bN = new k();
        this.bO = new m();
        this.a(PathType.q, 0.0f);
        this.a(PathType.r, 0.0f);
        this.r(true);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(cg, Optional.empty());
        this.Z.a(ch, Optional.empty());
        this.Z.a(ca, 0);
        this.Z.a(cb, (byte)0);
    }

    @Override
    protected void u() {
        this.cn = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, entityliving -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.co = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.bX);
        this.cp = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, entityliving -> entityliving instanceof EntityFishSchool);
        this.bR.a(0, new g());
        this.bR.a(1, new b());
        this.bR.a(2, new n(2.2));
        this.bR.a(3, new e(1.0));
        this.bR.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> cl.test((Entity)entityliving) && !this.c(entityliving.cm()) && !this.fL()));
        this.bR.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).q() && !this.fL()));
        this.bR.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.fL()));
        this.bR.a(5, new u());
        this.bR.a(6, new o());
        this.bR.a(6, new s(1.25));
        this.bR.a(7, new l((double)1.2f, true));
        this.bR.a(7, new t());
        this.bR.a(8, new h(this, 1.25));
        this.bR.a(9, new q(32, 200));
        this.bR.a(10, new f((double)1.2f, 12, 1));
        this.bR.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bR.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bR.a(11, new p());
        this.bR.a(12, new j(this, EntityHuman.class, 24.0f));
        this.bR.a(13, new r());
        this.bS.a(3, new a(EntityLiving.class, false, false, entityliving -> cj.test((Entity)entityliving) && !this.c(entityliving.cm())));
    }

    @Override
    public SoundEffect e(ItemStack stack) {
        return SoundEffects.gu;
    }

    @Override
    public void w_() {
        if (!this.t.y && this.bl() && this.eH()) {
            EntityLiving entityliving;
            ++this.cu;
            ItemStack itemstack = this.b(EnumItemSlot.a);
            if (this.m(itemstack)) {
                if (this.cu > 600) {
                    ItemStack itemstack1 = itemstack.a(this.t, this);
                    if (!itemstack1.b()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.cu = 0;
                } else if (this.cu > 560 && this.R.nextFloat() < 0.1f) {
                    this.a(this.e(itemstack), 1.0f, 1.0f);
                    this.t.a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.G()) == null || !entityliving.bl()) {
                this.x(false);
                this.y(false);
            }
        }
        if (this.fb() || this.ew()) {
            this.bo = false;
            this.bp = 0.0f;
            this.br = 0.0f;
        }
        super.w_();
        if (this.fL() && this.R.nextFloat() < 0.05f) {
            this.a(SoundEffects.gq, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean ew() {
        return this.ea();
    }

    private boolean m(ItemStack stack) {
        return stack.c().u() && this.G() == null && this.z && !this.fb();
    }

    @Override
    protected void a(DifficultyDamageScaler difficulty) {
        if (this.R.nextFloat() < 0.2f) {
            float f2 = this.R.nextFloat();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.ml) : (f2 < 0.2f ? new ItemStack(Items.oo) : (f2 < 0.4f ? (this.R.nextBoolean() ? new ItemStack(Items.rI) : new ItemStack(Items.rJ)) : (f2 < 0.6f ? new ItemStack(Items.ni) : (f2 < 0.8f ? new ItemStack(Items.ob) : new ItemStack(Items.nf)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void a(byte status) {
        if (status == 45) {
            ItemStack itemstack = this.b(EnumItemSlot.a);
            if (!itemstack.b()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.R.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dn() * ((float)Math.PI / 180)).b(-this.dm() * ((float)Math.PI / 180));
                    this.t.a(new ParticleParamItem(Particles.J, itemstack), this.dc() + this.bv().b / 2.0, this.de(), this.di() + this.bv().d / 2.0, vec3d.b, vec3d.c + 0.05, vec3d.d);
                }
            }
        } else {
            super.a(status);
        }
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.w().a(GenericAttributes.d, 0.3f).a(GenericAttributes.a, 10.0).a(GenericAttributes.b, 32.0).a(GenericAttributes.f, 2.0);
    }

    public EntityFox b(WorldServer world, EntityAgeable entity) {
        EntityFox entityfox = EntityTypes.E.a(world);
        entityfox.a(this.R.nextBoolean() ? this.t() : ((EntityFox)entity).t());
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.a_(pos.c()).a(TagsBlock.bz) && EntityFox.a(world, pos);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        BiomeBase biomebase = world.v(this.cW());
        Type entityfox_type = Type.a(biomebase);
        boolean flag = false;
        if (entityData instanceof i) {
            entityfox_type = ((i)entityData).a;
            if (((i)entityData).a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.b_(-24000);
        }
        if (world instanceof WorldServer) {
            this.fJ();
        }
        this.a(difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private void fJ() {
        if (this.t() == Type.a) {
            this.bS.a(4, this.cn);
            this.bS.a(4, this.co);
            this.bS.a(6, this.cp);
        } else {
            this.bS.a(4, this.cp);
            this.bS.a(6, this.cn);
            this.bS.a(6, this.co);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (this.n(stack)) {
            this.a(this.e(stack), 1.0f, 1.0f);
        }
        super.a(player, hand, stack);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.y_() ? dimensions.b * 0.85f : 0.4f;
    }

    public Type t() {
        return Type.a(this.Z.a(ca));
    }

    public void a(Type type) {
        this.Z.b(ca, type.b());
    }

    List<UUID> fK() {
        ArrayList list = Lists.newArrayList();
        list.add(this.Z.a(cg).orElse(null));
        list.add(this.Z.a(ch).orElse(null));
        return list;
    }

    void b(@Nullable UUID uuid) {
        if (this.Z.a(cg).isPresent()) {
            this.Z.b(ch, Optional.ofNullable(uuid));
        } else {
            this.Z.b(cg, Optional.ofNullable(uuid));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        List<UUID> list = this.fK();
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            nbttaglist.add(GameProfileSerializer.a(uuid));
        }
        nbt.a("Trusted", nbttaglist);
        nbt.a("Sleeping", this.fb());
        nbt.a("Type", this.t().a());
        nbt.a("Sitting", this.fy());
        nbt.a("Crouching", this.bN());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        NBTTagList nbttaglist = nbt.c("Trusted", 11);
        for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
            this.b(GameProfileSerializer.a(nbttaglist.k(i2)));
        }
        this.B(nbt.q("Sleeping"));
        this.a(Type.a(nbt.l("Type")));
        this.v(nbt.q("Sitting"));
        this.x(nbt.q("Crouching"));
        if (this.t instanceof WorldServer) {
            this.fJ();
        }
    }

    public boolean fy() {
        return this.t(1);
    }

    public void v(boolean sitting) {
        this.d(1, sitting);
    }

    public boolean fz() {
        return this.t(64);
    }

    public void z(boolean walking) {
        this.d(64, walking);
    }

    public boolean fL() {
        return this.t(128);
    }

    public void A(boolean aggressive) {
        this.d(128, aggressive);
    }

    @Override
    public boolean fb() {
        return this.t(32);
    }

    public void B(boolean sleeping) {
        this.d(32, sleeping);
    }

    private void d(int mask, boolean value) {
        if (value) {
            this.Z.b(cb, (byte)(this.Z.a(cb) | mask));
        } else {
            this.Z.b(cb, (byte)(this.Z.a(cb) & ~mask));
        }
    }

    private boolean t(int bitmask) {
        return (this.Z.a(cb) & bitmask) != 0;
    }

    @Override
    public boolean g(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.i(stack);
        return !this.b(enumitemslot).b() ? false : enumitemslot == EnumItemSlot.a && super.g(stack);
    }

    @Override
    public boolean k(ItemStack stack) {
        Item item = stack.c();
        ItemStack itemstack1 = this.b(EnumItemSlot.a);
        return itemstack1.b() || this.cu > 0 && item.u() && !itemstack1.c().u();
    }

    private void o(ItemStack stack) {
        if (!stack.b() && !this.t.y) {
            EntityItem entityitem = new EntityItem(this.t, this.dc() + this.bv().b, this.de() + 1.0, this.di() + this.bv().d, stack);
            entityitem.a(40);
            entityitem.c(this.cm());
            this.a(SoundEffects.gz, 1.0f, 1.0f);
            this.t.b(entityitem);
        }
    }

    private void p(ItemStack stack) {
        EntityItem entityitem = new EntityItem(this.t, this.dc(), this.de(), this.di(), stack);
        this.t.b(entityitem);
    }

    @Override
    protected void b(EntityItem item) {
        ItemStack itemstack = item.h();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, item, itemstack.I() - 1, !this.k(itemstack)).isCancelled()) {
            itemstack = item.h();
            int i2 = itemstack.I();
            if (i2 > 1) {
                this.p(itemstack.a(i2 - 1));
            }
            this.o(this.b(EnumItemSlot.a));
            this.a(item);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.bT[EnumItemSlot.a.b()] = 2.0f;
            this.a((Entity)item, itemstack.I());
            item.ah();
            this.cu = 0;
        }
    }

    @Override
    public void k() {
        super.k();
        if (this.eH()) {
            boolean flag = this.aQ();
            if (flag || this.G() != null || this.t.Y()) {
                this.fM();
            }
            if (flag || this.fb()) {
                this.v(false);
            }
            if (this.fz() && this.t.w.nextFloat() < 0.2f) {
                BlockPosition blockposition = this.cW();
                IBlockData iblockdata = this.t.a_(blockposition);
                this.t.c(2001, blockposition, Block.i(iblockdata));
            }
        }
        this.cr = this.cq;
        this.cq = this.fI() ? (this.cq += (1.0f - this.cq) * 0.4f) : (this.cq += (0.0f - this.cq) * 0.4f);
        this.ct = this.cs;
        if (this.bN()) {
            this.cs += 0.2f;
            if (this.cs > 3.0f) {
                this.cs = 3.0f;
            }
        } else {
            this.cs = 0.0f;
        }
    }

    @Override
    public boolean n(ItemStack stack) {
        return stack.a(TagsItem.R);
    }

    @Override
    protected void a(EntityHuman player, EntityInsentient child) {
        ((EntityFox)child).b(player.cm());
    }

    public boolean fA() {
        return this.t(16);
    }

    public void w(boolean chasing) {
        this.d(16, chasing);
    }

    public boolean fG() {
        return this.bo;
    }

    public boolean fH() {
        return this.cs == 3.0f;
    }

    public void x(boolean crouching) {
        this.d(4, crouching);
    }

    @Override
    public boolean bN() {
        return this.t(4);
    }

    public void y(boolean rollingHead) {
        this.d(8, rollingHead);
    }

    public boolean fI() {
        return this.t(8);
    }

    public float z(float tickDelta) {
        return MathHelper.i(tickDelta, this.cr, this.cq) * 0.11f * (float)Math.PI;
    }

    public float A(float tickDelta) {
        return MathHelper.i(tickDelta, this.ct, this.cs);
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (this.fL() && target == null) {
            this.A(false);
        }
        super.h(target);
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return MathHelper.f((fallDistance - 5.0f) * damageMultiplier);
    }

    void fM() {
        this.B(false);
    }

    void fN() {
        this.y(false);
        this.x(false);
        this.v(false);
        this.B(false);
        this.A(false);
        this.z(false);
    }

    boolean fO() {
        return !this.fb() && !this.fy() && !this.fz();
    }

    @Override
    public void K() {
        SoundEffect soundeffect = this.r();
        if (soundeffect == SoundEffects.gw) {
            this.a(soundeffect, 2.0f, this.ev());
        } else {
            super.K();
        }
    }

    @Override
    @Nullable
    protected SoundEffect r() {
        List<Entity> list;
        if (this.fb()) {
            return SoundEffects.gx;
        }
        if (!this.t.P() && this.R.nextFloat() < 0.1f && (list = this.t.a(EntityHuman.class, this.cw().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.gw;
        }
        return SoundEffects.gr;
    }

    @Override
    @Nullable
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.gv;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.gt;
    }

    boolean c(UUID uuid) {
        return this.fK().contains(uuid);
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(DamageSource source) {
        ItemStack itemstack = this.b(EnumItemSlot.a).m();
        EntityDeathEvent deathEvent = super.dropAllDeathLoot(source);
        if (deathEvent == null || deathEvent.isCancelled()) {
            return deathEvent;
        }
        if (!itemstack.b()) {
            this.b(itemstack);
            this.a(EnumItemSlot.a, ItemStack.b);
        }
        return deathEvent;
    }

    public static boolean a(EntityFox fox, EntityLiving chasedEntity) {
        double d0 = chasedEntity.di() - fox.di();
        double d1 = chasedEntity.dc() - fox.dc();
        double d2 = d0 / d1;
        boolean flag = true;
        for (int i2 = 0; i2 < 6; ++i2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)i2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)i2 / 6.0f) : d3 / d2;
            for (int j2 = 1; j2 < 4; ++j2) {
                if (fox.t.a_(new BlockPosition(fox.dc() + d4, fox.de() + (double)j2, fox.di() + d3)).c().e()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.55f * this.cy(), this.cT() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fb()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.fA() && !EntityFox.this.bN() && !EntityFox.this.fI() && !EntityFox.this.fz();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.fO()) {
                super.a();
            }
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void c() {
            super.c();
            EntityFox.this.fN();
        }

        @Override
        public boolean a() {
            return EntityFox.this.aQ() && EntityFox.this.b(TagsFluid.b) > 0.25 || EntityFox.this.bc();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return EntityFox.this.fz();
        }

        @Override
        public boolean b() {
            return this.a() && this.a > 0;
        }

        @Override
        public void c() {
            this.a = this.a(40);
        }

        @Override
        public void d() {
            EntityFox.this.z(false);
        }

        @Override
        public void e() {
            --this.a;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean a() {
            return !EntityFox.this.fL() && super.a();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public void c() {
            ((EntityFox)this.a).fN();
            ((EntityFox)this.c).fN();
            super.c();
        }

        @Override
        protected void g() {
            WorldServer worldserver = (WorldServer)this.b;
            EntityFox entityfox = (EntityFox)this.a.a(worldserver, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.fD();
                EntityPlayer entityplayer1 = this.c.fD();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.b(entityplayer.cm());
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.b(entityplayer1.cm());
                }
                entityfox.b_(-24000);
                entityfox.b(this.a.dc(), this.a.de(), this.a.di(), 0.0f, 0.0f);
                int experience = this.a.dK().nextInt(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.P);
                    CriterionTriggers.o.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.b_(6000);
                this.c.b_(6000);
                this.a.fF();
                this.c.fF();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (this.b.X().b(GameRules.f) && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dc(), this.a.de(), this.a.di(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityfox));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            if (EntityFox.this.fb()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.G();
            return entityliving != null && entityliving.bl() && ck.test(entityliving) && EntityFox.this.f((Entity)entityliving) > 36.0 && !EntityFox.this.bN() && !EntityFox.this.fI() && !EntityFox.this.bo;
        }

        @Override
        public void c() {
            EntityFox.this.v(false);
            EntityFox.this.z(false);
        }

        @Override
        public void d() {
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.y(true);
                EntityFox.this.x(true);
                EntityFox.this.D().n();
                EntityFox.this.z().a(entityliving, (float)EntityFox.this.U(), (float)EntityFox.this.T());
            } else {
                EntityFox.this.y(false);
                EntityFox.this.x(false);
            }
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null) {
                EntityFox.this.z().a(entityliving, (float)EntityFox.this.U(), (float)EntityFox.this.T());
                if (EntityFox.this.f((Entity)entityliving) <= 36.0) {
                    EntityFox.this.y(true);
                    EntityFox.this.x(true);
                    EntityFox.this.D().n();
                } else {
                    EntityFox.this.D().a((Entity)entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean a() {
            if (!EntityFox.this.fH()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null && entityliving.bl()) {
                if (entityliving.cu() != entityliving.ct()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.D().a((Entity)entityliving, 0);
                    EntityFox.this.x(false);
                    EntityFox.this.y(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null && entityliving.bl()) {
                double d0 = EntityFox.this.da().c;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.dn()) >= 15.0f || !EntityFox.this.z) && !EntityFox.this.fz();
            }
            return false;
        }

        @Override
        public boolean D_() {
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.q(true);
            EntityFox.this.w(true);
            EntityFox.this.y(false);
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null) {
                EntityFox.this.z().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dc() - EntityFox.this.dc(), entityliving.de() - EntityFox.this.de(), entityliving.di() - EntityFox.this.di()).d();
                EntityFox.this.g(EntityFox.this.da().b(vec3d.b * 0.8, 0.9, vec3d.d * 0.8));
            }
            EntityFox.this.D().n();
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.cs = 0.0f;
            EntityFox.this.ct = 0.0f;
            EntityFox.this.y(false);
            EntityFox.this.w(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null) {
                EntityFox.this.z().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.fz()) {
                Vec3D vec3d = EntityFox.this.da();
                if (vec3d.c * vec3d.c < (double)0.03f && EntityFox.this.dn() != 0.0f) {
                    EntityFox.this.p(MathHelper.l(EntityFox.this.dn(), 0.0f, 0.2f));
                } else {
                    double d0 = vec3d.h();
                    double d1 = Math.signum(-vec3d.c) * Math.acos(d0 / vec3d.f()) * 57.2957763671875;
                    EntityFox.this.p((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.e((Entity)entityliving) <= 2.0f) {
                EntityFox.this.z(entityliving);
            } else if (EntityFox.this.dn() > 0.0f && EntityFox.this.z && (float)EntityFox.this.da().c != 0.0f && EntityFox.this.t.a_(EntityFox.this.cW()).a(Blocks.cK)) {
                EntityFox.this.p(60.0f);
                EntityFox.this.h((EntityLiving)null);
                EntityFox.this.z(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.fb() && this.a.G() == null) {
                if (EntityFox.this.t.Y()) {
                    return true;
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.cW();
                return EntityFox.this.t.P() && EntityFox.this.t.f(blockposition) && !((WorldServer)EntityFox.this.t).b(blockposition) && this.g();
            }
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.fN();
            super.c();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving target, double squaredDistance) {
            double d1 = this.a(target);
            if (squaredDistance <= d1 && this.i()) {
                this.g();
                this.a.z(target);
                EntityFox.this.a(SoundEffects.gs, 1.0f, 1.0f);
            }
        }

        @Override
        public void c() {
            EntityFox.this.y(false);
            super.c();
        }

        @Override
        public boolean a() {
            return !EntityFox.this.fy() && !EntityFox.this.fb() && !EntityFox.this.bN() && !EntityFox.this.fz() && super.a();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.R.nextInt(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean a() {
            return EntityFox.this.bp == 0.0f && EntityFox.this.bq == 0.0f && EntityFox.this.br == 0.0f ? this.k() || EntityFox.this.fb() : false;
        }

        @Override
        public boolean b() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.t.P() && this.g() && !this.i() && !EntityFox.this.am;
        }

        @Override
        public void d() {
            this.d = EntityFox.this.R.nextInt(c);
            EntityFox.this.fN();
        }

        @Override
        public void c() {
            EntityFox.this.v(false);
            EntityFox.this.x(false);
            EntityFox.this.y(false);
            EntityFox.this.q(false);
            EntityFox.this.B(true);
            EntityFox.this.D().n();
            EntityFox.this.A().a(EntityFox.this.dc(), EntityFox.this.de(), EntityFox.this.di(), 0.0);
        }
    }

    private class h
    extends PathfinderGoalFollowParent {
        private final EntityFox e;

        public h(EntityFox entityfox, double d0) {
            super(entityfox, d0);
            this.e = entityfox;
        }

        @Override
        public boolean a() {
            return !this.e.fL() && super.a();
        }

        @Override
        public boolean b() {
            return !this.e.fL() && super.b();
        }

        @Override
        public void c() {
            this.e.fN();
            super.c();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void c() {
            EntityFox.this.fN();
            super.c();
        }

        @Override
        public boolean a() {
            return super.a() && this.g();
        }

        @Override
        public boolean b() {
            return super.b() && this.g();
        }

        private boolean g() {
            return !EntityFox.this.fb() && !EntityFox.this.fy() && !EntityFox.this.fL() && EntityFox.this.G() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            IBlockData iblockdata = world.a_(pos);
            return iblockdata.a(Blocks.mu) && iblockdata.c(BlockSweetBerryBush.b) >= 2 || CaveVines.a(iblockdata);
        }

        @Override
        public void e() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.R.nextFloat() < 0.05f) {
                EntityFox.this.a(SoundEffects.gy, 1.0f, 1.0f);
            }
            super.e();
        }

        protected void o() {
            if (EntityFox.this.t.X().b(GameRules.c)) {
                IBlockData iblockdata = EntityFox.this.t.a_(this.e);
                if (iblockdata.a(Blocks.mu)) {
                    this.b(iblockdata);
                } else if (CaveVines.a(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData state) {
            CaveVines.use(state, EntityFox.this.t, this.e, EntityFox.this);
        }

        private void b(IBlockData state) {
            int i2 = state.c(BlockSweetBerryBush.b);
            state.a(BlockSweetBerryBush.b, 1);
            if (CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)state.a(BlockSweetBerryBush.b, 1)).isCancelled()) {
                return;
            }
            int j2 = 1 + EntityFox.this.t.w.nextInt(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.b(EnumItemSlot.a);
            if (itemstack.b()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.to));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.t, this.e, new ItemStack(Items.to, j2));
            }
            EntityFox.this.a(SoundEffects.sT, 1.0f, 1.0f);
            EntityFox.this.t.a(this.e, (IBlockData)state.a(BlockSweetBerryBush.b, 1), 2);
        }

        @Override
        public boolean a() {
            return !EntityFox.this.fb() && super.a();
        }

        @Override
        public void c() {
            this.g = 0;
            EntityFox.this.v(false);
            super.c();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.b(EnumItemSlot.a).b()) {
                return false;
            }
            if (EntityFox.this.G() == null && EntityFox.this.dL() == null) {
                if (!EntityFox.this.fO()) {
                    return false;
                }
                if (EntityFox.this.dK().nextInt(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.t.a(EntityItem.class, EntityFox.this.cw().c(8.0, 8.0, 8.0), ci);
                return !list.isEmpty() && EntityFox.this.b(EnumItemSlot.a).b();
            }
            return false;
        }

        @Override
        public void e() {
            List<EntityItem> list = EntityFox.this.t.a(EntityItem.class, EntityFox.this.cw().c(8.0, 8.0, 8.0), ci);
            ItemStack itemstack = EntityFox.this.b(EnumItemSlot.a);
            if (itemstack.b() && !list.isEmpty()) {
                EntityFox.this.D().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void c() {
            List<EntityItem> list = EntityFox.this.t.a(EntityItem.class, EntityFox.this.cw().c(8.0, 8.0, 8.0), ci);
            if (!list.isEmpty()) {
                EntityFox.this.D().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient mob, Class targetType, float range) {
            super(mob, targetType, range);
        }

        @Override
        public boolean a() {
            return super.a() && !EntityFox.this.fz() && !EntityFox.this.fI();
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.fz() && !EntityFox.this.fI();
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return EntityFox.this.dL() == null && EntityFox.this.dK().nextFloat() < 0.02f && !EntityFox.this.fb() && EntityFox.this.G() == null && EntityFox.this.D().l() && !this.i() && !EntityFox.this.fA() && !EntityFox.this.bN();
        }

        @Override
        public boolean b() {
            return this.f > 0;
        }

        @Override
        public void c() {
            this.k();
            this.f = 2 + EntityFox.this.dK().nextInt(3);
            EntityFox.this.v(true);
            EntityFox.this.D().n();
        }

        @Override
        public void d() {
            EntityFox.this.v(false);
        }

        @Override
        public void e() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.z().a(EntityFox.this.dc() + this.c, EntityFox.this.dg(), EntityFox.this.di() + this.d, EntityFox.this.U(), EntityFox.this.T());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.dK().nextDouble();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.dK().nextInt(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, Predicate<EntityLiving> predicate) {
            super(EntityFox.this, oclass, 10, flag, flag1, predicate);
        }

        @Override
        public boolean a() {
            if (this.b > 0 && this.e.dK().nextInt(this.b) != 0) {
                return false;
            }
            for (UUID uuid : EntityFox.this.fK()) {
                EntityLiving entityliving;
                Entity entity;
                if (uuid == null || !(EntityFox.this.t instanceof WorldServer) || !((entity = ((WorldServer)EntityFox.this.t).a(uuid)) instanceof EntityLiving)) continue;
                this.k = entityliving = (EntityLiving)entity;
                this.j = entityliving.dL();
                int i2 = entityliving.dM();
                return i2 != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void c() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.dM();
            }
            EntityFox.this.a(SoundEffects.gq, 1.0f, 1.0f);
            EntityFox.this.A(true);
            EntityFox.this.fM();
            super.c();
        }
    }

    public static enum Type {
        a(0, "red"),
        b(1, "snow");

        private static final Type[] c;
        private static final Map<String, Type> d;
        private final int e;
        private final String f;

        private Type(int i2, String s2) {
            this.e = i2;
            this.f = s2;
        }

        public String a() {
            return this.f;
        }

        public int b() {
            return this.e;
        }

        public static Type a(String name) {
            return d.getOrDefault(name, a);
        }

        public static Type a(int id) {
            if (id < 0 || id > c.length) {
                id = 0;
            }
            return c[id];
        }

        public static Type a(BiomeBase biome) {
            return biome.c() == BiomeBase.Precipitation.c ? b : a;
        }

        static {
            c = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::b)).toArray(Type[]::new);
            d = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::a, entityfox_type -> entityfox_type));
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type type) {
            super(false);
            this.a = type;
        }
    }

    public class c
    implements Predicate<EntityLiving> {
        public boolean a(EntityLiving entityliving) {
            return entityliving instanceof EntityFox ? false : (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster) ? (entityliving instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entityliving).q() : (entityliving instanceof EntityHuman && (entityliving.B_() || ((EntityHuman)entityliving).f()) ? false : (EntityFox.this.c(entityliving.cm()) ? false : !entityliving.fb() && !entityliving.bL()))) : true);
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean g() {
            BlockPosition blockposition = new BlockPosition(EntityFox.this.dc(), EntityFox.this.cw().e, EntityFox.this.di());
            return !EntityFox.this.t.f(blockposition) && EntityFox.this.f(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !EntityFox.this.t.a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cw().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

