/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public class PrepareRamNearestTarget<E extends EntityCreature>
extends Behavior<E> {
    public static final int a = 160;
    private final ToIntFunction<E> c;
    private final int d;
    private final int e;
    private final float f;
    private final PathfinderTargetCondition g;
    private final int h;
    private final Function<E, SoundEffect> i;
    private Optional<Long> j = Optional.empty();
    private Optional<a> k = Optional.empty();

    public PrepareRamNearestTarget(ToIntFunction<E> cooldownFactory, int minDistance, int maxDistance, float speed, PathfinderTargetCondition targetPredicate, int prepareTime, Function<E, SoundEffect> soundFactory) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.n, (Object)((Object)MemoryStatus.c), MemoryModuleType.T, (Object)((Object)MemoryStatus.b), MemoryModuleType.h, (Object)((Object)MemoryStatus.a), MemoryModuleType.U, (Object)((Object)MemoryStatus.b)), 160);
        this.c = cooldownFactory;
        this.d = minDistance;
        this.e = maxDistance;
        this.f = speed;
        this.g = targetPredicate;
        this.h = prepareTime;
        this.i = soundFactory;
    }

    @Override
    @Override
    protected void a(WorldServer world, EntityCreature entity, long time) {
        BehaviorController<?> brain = entity.dt();
        brain.c(MemoryModuleType.h).flatMap(nearestVisibleLivingEntities -> nearestVisibleLivingEntities.a(mob -> this.g.a(entity, (EntityLiving)mob))).ifPresent(mob -> this.b(entity, (EntityLiving)mob));
    }

    @Override
    protected void b(WorldServer serverLevel, E pathfinderMob, long l2) {
        BehaviorController<Vec3D> brain = ((EntityLiving)pathfinderMob).dt();
        if (!brain.a(MemoryModuleType.U)) {
            serverLevel.a((Entity)pathfinderMob, (byte)59);
            brain.a(MemoryModuleType.T, Integer.valueOf(this.c.applyAsInt(pathfinderMob)));
        }
    }

    @Override
    protected boolean c(WorldServer serverLevel, EntityCreature pathfinderMob, long l2) {
        return this.k.isPresent() && this.k.get().c().bl();
    }

    @Override
    @Override
    protected void d(WorldServer world, E entity, long time) {
        boolean bl;
        if (!this.k.isPresent()) {
            return;
        }
        ((EntityLiving)entity).dt().a(MemoryModuleType.m, new MemoryTarget(this.k.get().a(), this.f, 0));
        ((EntityLiving)entity).dt().a(MemoryModuleType.n, new BehaviorPositionEntity(this.k.get().c(), true));
        boolean bl2 = bl = !this.k.get().c().cW().equals(this.k.get().b());
        if (bl) {
            world.a((Entity)entity, (byte)59);
            ((EntityInsentient)entity).D().n();
            this.b((EntityCreature)entity, this.k.get().c);
        } else {
            BlockPosition blockPos = ((Entity)entity).cW();
            if (blockPos.equals(this.k.get().a())) {
                world.a((Entity)entity, (byte)58);
                if (!this.j.isPresent()) {
                    this.j = Optional.of(time);
                }
                if (time - this.j.get() >= (long)this.h) {
                    ((EntityLiving)entity).dt().a(MemoryModuleType.U, this.a(blockPos, this.k.get().b()));
                    world.a(null, (Entity)entity, this.i.apply(entity), SoundCategory.f, 1.0f, ((EntityLiving)entity).ev());
                    this.k = Optional.empty();
                }
            }
        }
    }

    private Vec3D a(BlockPosition start, BlockPosition end) {
        double d2 = 0.5;
        double e2 = 0.5 * (double)MathHelper.k((double)(end.u() - start.u()));
        double f2 = 0.5 * (double)MathHelper.k((double)(end.w() - start.w()));
        return Vec3D.c(end).b(e2, 0.0, f2);
    }

    private Optional<BlockPosition> a(EntityCreature entity, EntityLiving target) {
        BlockPosition blockPos = target.cW();
        if (!this.a(entity, blockPos)) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList();
        BlockPosition.MutableBlockPosition mutableBlockPos = blockPos.i();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            mutableBlockPos.g(blockPos);
            for (int i2 = 0; i2 < this.e; ++i2) {
                if (this.a(entity, (BlockPosition)mutableBlockPos.c(direction))) continue;
                mutableBlockPos.c(direction.f());
                break;
            }
            if (mutableBlockPos.k(blockPos) < this.d) continue;
            list.add(mutableBlockPos.h());
        }
        NavigationAbstract pathNavigation = entity.D();
        return list.stream().sorted(Comparator.comparingDouble(entity.cW()::j)).filter(start -> {
            PathEntity path = pathNavigation.a((BlockPosition)start, 0);
            return path != null && path.j();
        }).findFirst();
    }

    private boolean a(EntityCreature entity, BlockPosition target) {
        return entity.D().a(target) && entity.a(PathfinderNormal.a((IBlockAccess)entity.t, target.i())) == 0.0f;
    }

    private void b(EntityCreature entity, EntityLiving target) {
        this.j = Optional.empty();
        this.k = this.a(entity, target).map(start -> new a((BlockPosition)start, target.cW(), target));
    }

    @Override
    protected /* synthetic */ boolean b(WorldServer world, EntityLiving entity, long time) {
        return this.c(world, (EntityCreature)entity, time);
    }

    @Override
    protected /* synthetic */ void c(WorldServer world, EntityLiving entity, long time) {
        this.b(world, (E)((EntityCreature)entity), time);
    }

    public static class a {
        private final BlockPosition a;
        private final BlockPosition b;
        final EntityLiving c;

        public a(BlockPosition start, BlockPosition end, EntityLiving entity) {
            this.a = start;
            this.b = end;
            this.c = entity;
        }

        public BlockPosition a() {
            return this.a;
        }

        public BlockPosition b() {
            return this.b;
        }

        public EntityLiving c() {
            return this.c;
        }
    }
}

