/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.Tag;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;

public abstract class EntityInsentient
extends EntityLiving {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int c = 1;
    private static final int d = 2;
    private static final int e = 4;
    public static final float f = 0.15f;
    public static final float bF = 0.55f;
    public static final float bG = 0.5f;
    public static final float bH = 0.25f;
    public static final String bI = "Leash";
    private static final int bV = 1;
    public static final float bJ = 0.085f;
    public static final int bK = 2;
    public int bL;
    protected int bM;
    protected ControllerLook bN;
    protected ControllerMove bO;
    protected ControllerJump bP;
    private final EntityAIBodyControl bW;
    protected NavigationAbstract bQ;
    public PathfinderGoalSelector bR;
    @Nullable
    public PathfinderGoalFloat goalFloat;
    public PathfinderGoalSelector bS;
    @Nullable
    private EntityLiving bX;
    private final EntitySenses bY;
    public final NonNullList<ItemStack> bZ = NonNullList.a(2, ItemStack.b);
    public final float[] bT = new float[2];
    public final NonNullList<ItemStack> ca = NonNullList.a(4, ItemStack.b);
    public final float[] bU = new float[4];
    private boolean cb;
    private boolean cc;
    private final Map<PathType, Float> cd = Maps.newEnumMap(PathType.class);
    @Nullable
    public MinecraftKey ce;
    public long cf;
    @Nullable
    public Entity cg;
    private int ch;
    @Nullable
    private NBTTagCompound ci;
    private BlockPosition cj = BlockPosition.b;
    private float ck = -1.0f;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        this.bR = new PathfinderGoalSelector(world.ac());
        this.bS = new PathfinderGoalSelector(world.ac());
        this.bN = new ControllerLook(this);
        this.bO = new ControllerMove(this);
        this.bP = new ControllerJump(this);
        this.bW = this.y();
        this.bQ = this.a(world);
        this.bY = new EntitySenses(this);
        Arrays.fill(this.bU, 0.085f);
        Arrays.fill(this.bT, 0.085f);
        if (world != null && !world.y) {
            this.u();
        }
        this.cc = !this.h(0.0);
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.cc = persistenceRequired;
    }

    protected void u() {
    }

    public static AttributeProvider.Builder w() {
        return EntityLiving.dv().a(GenericAttributes.b, 16.0).a(GenericAttributes.g);
    }

    protected NavigationAbstract a(World world) {
        return new Navigation(this, world);
    }

    protected boolean x() {
        return false;
    }

    public float a(PathType nodeType) {
        EntityInsentient entityinsentient = this.cN() instanceof EntityInsentient && ((EntityInsentient)this.cN()).x() ? (EntityInsentient)this.cN() : this;
        Float ofloat = entityinsentient.cd.get((Object)nodeType);
        return ofloat == null ? nodeType.a() : ofloat.floatValue();
    }

    public void a(PathType nodeType, float penalty) {
        this.cd.put(nodeType, Float.valueOf(penalty));
    }

    public boolean b(PathType type) {
        return type != PathType.m && type != PathType.o && type != PathType.q && type != PathType.d;
    }

    protected EntityAIBodyControl y() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook z() {
        return this.bN;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.bR.inactiveTick()) {
            this.bR.b();
        }
        if (this.bS.inactiveTick()) {
            this.bS.b();
        }
    }

    public ControllerMove A() {
        if (this.bF() && this.cN() instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)this.cN();
            return entityinsentient.A();
        }
        return this.bO;
    }

    public ControllerJump C() {
        return this.bP;
    }

    public NavigationAbstract D() {
        if (this.bF() && this.cN() instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)this.cN();
            return entityinsentient.D();
        }
        return this.bQ;
    }

    public EntitySenses E() {
        return this.bY;
    }

    @Nullable
    public EntityLiving G() {
        return this.bX;
    }

    public CraftMob getBukkitMob() {
        return (CraftMob)super.getBukkitEntity();
    }

    public void h(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.G() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.G() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.G().bl() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.t.getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.bX = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return type != EntityTypes.F;
    }

    public boolean a(ItemProjectileWeapon weapon) {
        return false;
    }

    public void I() {
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(b, (byte)0);
    }

    public int J() {
        return 80;
    }

    public void K() {
        SoundEffect soundeffect = this.r();
        if (soundeffect != null) {
            this.a(soundeffect, this.eu(), this.ev());
        }
    }

    @Override
    public void an() {
        super.an();
        this.t.ab().a("mobBaseTick");
        if (this.bl() && this.R.nextInt(1000) < this.bL++) {
            this.n();
            this.K();
        }
        this.t.ab().c();
    }

    @Override
    protected void d(DamageSource source) {
        this.n();
        super.d(source);
    }

    private void n() {
        this.bL = -this.J();
    }

    @Override
    protected int d(EntityHuman player) {
        if (this.bM > 0) {
            int j2;
            int i2 = this.bM;
            for (j2 = 0; j2 < this.ca.size(); ++j2) {
                if (this.ca.get(j2).b() || !(this.bU[j2] <= 1.0f)) continue;
                i2 += 1 + this.R.nextInt(3);
            }
            for (j2 = 0; j2 < this.bZ.size(); ++j2) {
                if (this.bZ.get(j2).b() || !(this.bT[j2] <= 1.0f)) continue;
                i2 += 1 + this.R.nextInt(3);
            }
            return i2;
        }
        return this.bM;
    }

    public void L() {
        if (this.t.y) {
            for (int i2 = 0; i2 < 20; ++i2) {
                double d0 = this.R.nextGaussian() * 0.02;
                double d1 = this.R.nextGaussian() * 0.02;
                double d2 = this.R.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.t.a(Particles.R, this.c(1.0) - d0 * 10.0, this.df() - d1 * 10.0, this.g(1.0) - d2 * 10.0, d0, d1, d2);
            }
        } else {
            this.t.a((Entity)this, (byte)20);
        }
    }

    @Override
    public void a(byte status) {
        if (status == 20) {
            this.L();
        } else {
            super.a(status);
        }
    }

    @Override
    public void k() {
        super.k();
        if (!this.t.y) {
            this.fo();
            if (this.S % 5 == 0) {
                this.M();
            }
        }
    }

    protected void M() {
        boolean flag = !(this.cE() instanceof EntityInsentient);
        boolean flag1 = !(this.cN() instanceof EntityBoat);
        this.bR.a(PathfinderGoal.Type.a, flag);
        this.bR.a(PathfinderGoal.Type.c, flag && flag1);
        this.bR.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected float e(float bodyRotation, float headRotation) {
        this.bW.a();
        return headRotation;
    }

    @Nullable
    protected SoundEffect r() {
        return null;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound2;
        super.b(nbt);
        nbt.a("CanPickUpLoot", this.fh());
        nbt.a("PersistenceRequired", this.cc);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.ca) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack.b()) {
                itemstack.b(nbttagcompound1);
            }
            nbttaglist.add(nbttagcompound1);
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ItemStack itemstack1 : this.bZ) {
            nbttagcompound2 = new NBTTagCompound();
            if (!itemstack1.b()) {
                itemstack1.b(nbttagcompound2);
            }
            nbttaglist1.add(nbttagcompound2);
        }
        nbt.a("HandItems", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (float f2 : this.bU) {
            nbttaglist2.add(NBTTagFloat.a(f2));
        }
        nbt.a("ArmorDropChances", nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (float f1 : this.bT) {
            nbttaglist3.add(NBTTagFloat.a(f1));
        }
        nbt.a("HandDropChances", nbttaglist3);
        if (this.cg != null) {
            nbttagcompound2 = new NBTTagCompound();
            if (this.cg instanceof EntityLiving) {
                UUID uuid = this.cg.cm();
                nbttagcompound2.a("UUID", uuid);
            } else if (this.cg instanceof EntityHanging) {
                BlockPosition blockposition = ((EntityHanging)this.cg).w();
                nbttagcompound2.a("X", blockposition.u());
                nbttagcompound2.a("Y", blockposition.v());
                nbttagcompound2.a("Z", blockposition.w());
            }
            nbt.a(bI, nbttagcompound2);
        } else if (this.ci != null) {
            nbt.a(bI, this.ci.g());
        }
        nbt.a("LeftHanded", this.fs());
        if (this.ce != null) {
            nbt.a("DeathLootTable", this.ce.toString());
            if (this.cf != 0L) {
                nbt.a("DeathLootTableSeed", this.cf);
            }
        }
        if (this.fr()) {
            nbt.a("NoAI", this.fr());
        }
        nbt.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2;
        NBTTagList nbttaglist;
        boolean data;
        super.a(nbt);
        if (nbt.b("CanPickUpLoot", 1)) {
            data = nbt.q("CanPickUpLoot");
            if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
                this.r(data);
            }
        }
        data = nbt.q("PersistenceRequired");
        if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
            this.cc = data;
        }
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.ca.size(); ++i2) {
                this.ca.set(i2, ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.bZ.size(); ++i2) {
                this.bZ.set(i2, ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("ArmorDropChances", 9)) {
            nbttaglist = nbt.c("ArmorDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bU[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b("HandDropChances", 9)) {
            nbttaglist = nbt.c("HandDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bT[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b(bI, 10)) {
            this.ci = nbt.p(bI);
        }
        this.t(nbt.q("LeftHanded"));
        if (nbt.b("DeathLootTable", 8)) {
            this.ce = new MinecraftKey(nbt.l("DeathLootTable"));
            this.cf = nbt.i("DeathLootTableSeed");
        }
        this.s(nbt.q("NoAI"));
        if (nbt.e("Bukkit.Aware")) {
            this.aware = nbt.q("Bukkit.Aware");
        }
    }

    @Override
    protected void a(DamageSource source, boolean causedByPlayer) {
        super.a(source, causedByPlayer);
        this.ce = null;
    }

    @Override
    protected LootTableInfo.Builder a(boolean causedByPlayer, DamageSource source) {
        return super.a(causedByPlayer, source).a(this.cf, this.R);
    }

    @Override
    public final MinecraftKey ee() {
        return this.ce == null ? this.N() : this.ce;
    }

    public MinecraftKey N() {
        return super.ee();
    }

    public void u(float forwardSpeed) {
        this.br = forwardSpeed;
    }

    public void v(float upwardSpeed) {
        this.bq = upwardSpeed;
    }

    public void w(float sidewaysMovement) {
        this.bp = sidewaysMovement;
    }

    @Override
    public void r(float movementSpeed) {
        super.r(movementSpeed);
        this.u(movementSpeed);
    }

    @Override
    public void w_() {
        super.w_();
        this.t.ab().a("looting");
        if (!this.t.y && this.fh() && this.bl() && !this.bf && this.t.X().b(GameRules.c)) {
            List<EntityItem> list = this.t.a(EntityItem.class, this.cw().c(1.0, 0.0, 1.0));
            for (EntityItem entityitem : list) {
                if (entityitem.do() || entityitem.h().b() || entityitem.r() || !this.l(entityitem.h()) || !entityitem.canMobPickup) continue;
                this.b(entityitem);
            }
        }
        this.t.ab().c();
    }

    protected void b(EntityItem item) {
        ItemStack itemstack = item.h();
        if (this.equipItemIfPossible(itemstack, item)) {
            this.a(item);
            this.a((Entity)item, itemstack.I());
            item.ah();
        }
    }

    public boolean j(ItemStack equipment) {
        return this.equipItemIfPossible(equipment, null);
    }

    public boolean equipItemIfPossible(ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = EntityInsentient.i(itemstack);
        ItemStack itemstack1 = this.b(enumitemslot);
        boolean flag = this.a(itemstack, itemstack1);
        boolean bl = canPickup = flag && this.k(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.e(enumitemslot);
            if (!itemstack1.b() && (double)Math.max(this.R.nextFloat() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.b(itemstack1);
                this.forceDrops = false;
            }
            this.b(enumitemslot, itemstack);
            this.c(itemstack);
            return true;
        }
        return false;
    }

    protected void b(EnumItemSlot slot, ItemStack stack) {
        this.a(slot, stack);
        this.d(slot);
        this.cc = true;
    }

    public void d(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                this.bT[slot.b()] = 2.0f;
                break;
            }
            case b: {
                this.bU[slot.b()] = 2.0f;
            }
        }
    }

    protected boolean a(ItemStack newStack, ItemStack oldStack) {
        if (oldStack.b()) {
            return true;
        }
        if (newStack.c() instanceof ItemSword) {
            if (!(oldStack.c() instanceof ItemSword)) {
                return true;
            }
            ItemSword itemsword = (ItemSword)newStack.c();
            ItemSword itemsword1 = (ItemSword)oldStack.c();
            return itemsword.i() != itemsword1.i() ? itemsword.i() > itemsword1.i() : this.b(newStack, oldStack);
        }
        if (newStack.c() instanceof ItemBow && oldStack.c() instanceof ItemBow) {
            return this.b(newStack, oldStack);
        }
        if (newStack.c() instanceof ItemCrossbow && oldStack.c() instanceof ItemCrossbow) {
            return this.b(newStack, oldStack);
        }
        if (newStack.c() instanceof ItemArmor) {
            if (EnchantmentManager.d(oldStack)) {
                return false;
            }
            if (!(oldStack.c() instanceof ItemArmor)) {
                return true;
            }
            ItemArmor itemarmor = (ItemArmor)newStack.c();
            ItemArmor itemarmor1 = (ItemArmor)oldStack.c();
            return itemarmor.e() != itemarmor1.e() ? itemarmor.e() > itemarmor1.e() : (itemarmor.f() != itemarmor1.f() ? itemarmor.f() > itemarmor1.f() : this.b(newStack, oldStack));
        }
        if (newStack.c() instanceof ItemTool) {
            if (oldStack.c() instanceof ItemBlock) {
                return true;
            }
            if (oldStack.c() instanceof ItemTool) {
                ItemTool itemtool = (ItemTool)newStack.c();
                ItemTool itemtool1 = (ItemTool)oldStack.c();
                if (itemtool.d() != itemtool1.d()) {
                    return itemtool.d() > itemtool1.d();
                }
                return this.b(newStack, oldStack);
            }
        }
        return false;
    }

    public boolean b(ItemStack newStack, ItemStack oldStack) {
        return newStack.h() >= oldStack.h() && (!newStack.r() || oldStack.r()) ? (newStack.r() && oldStack.r() ? newStack.s().d().stream().anyMatch(s2 -> !s2.equals("Damage")) && !oldStack.s().d().stream().anyMatch(s2 -> !s2.equals("Damage")) : false) : true;
    }

    public boolean k(ItemStack stack) {
        return true;
    }

    public boolean l(ItemStack stack) {
        return this.k(stack);
    }

    public boolean h(double distanceSquared) {
        return true;
    }

    public boolean O() {
        return this.bF();
    }

    protected boolean P() {
        return false;
    }

    @Override
    public void dj() {
        if (this.t.af() == EnumDifficulty.a && this.P()) {
            this.ah();
        } else if (!this.fi() && !this.O()) {
            EntityHuman entityhuman = this.t.findNearbyPlayer(this, this.t.paperConfig.hardDespawnDistances.getInt((Object)this.ad().f()) + 1, IEntitySelector.affectsSpawning);
            if (entityhuman == null) {
                EntityHuman entityHuman = entityhuman = ((WorldServer)this.t).playersAffectingSpawning.isEmpty() ? null : (EntityHuman)((WorldServer)this.t).playersAffectingSpawning.get(0);
            }
            if (entityhuman != null) {
                int i2;
                int j2;
                double d0 = entityhuman.f((Entity)this);
                if (d0 > (double)(j2 = (i2 = this.t.paperConfig.hardDespawnDistances.getInt((Object)this.ad().f())) * i2)) {
                    this.ah();
                }
                int k2 = this.t.paperConfig.softDespawnDistances.getInt((Object)this.ad().f());
                int l2 = k2 * k2;
                if (this.bg > 600 && this.R.nextInt(800) == 0 && d0 > (double)l2) {
                    this.ah();
                } else if (d0 < (double)l2) {
                    this.bg = 0;
                }
            }
        } else {
            this.bg = 0;
        }
    }

    @Override
    protected final void eE() {
        ++this.bg;
        if (!this.aware) {
            if (this.goalFloat != null) {
                if (this.goalFloat.a()) {
                    this.goalFloat.e();
                }
                this.C().b();
            }
            if (this.eD() && this.aS()) {
                this.a(DamageSource.h, 1.0f);
            }
            return;
        }
        this.t.ab().a("sensing");
        this.bY.a();
        this.t.ab().c();
        int i2 = this.t.n().ag() + this.ae();
        if (i2 % 2 != 0 && this.S > 1) {
            this.t.ab().a("targetSelector");
            this.bS.a(false);
            this.t.ab().c();
            this.t.ab().a("goalSelector");
            this.bR.a(false);
            this.t.ab().c();
        } else {
            this.t.ab().a("targetSelector");
            this.bS.b();
            this.t.ab().c();
            this.t.ab().a("goalSelector");
            this.bR.b();
            this.t.ab().c();
        }
        this.t.ab().a("navigation");
        this.bQ.c();
        this.t.ab().c();
        this.t.ab().a("mob tick");
        this.R();
        this.t.ab().c();
        this.t.ab().a("controls");
        this.t.ab().a("move");
        this.bO.a();
        this.t.ab().b("look");
        this.bN.a();
        this.t.ab().b("jump");
        this.bP.b();
        this.t.ab().c();
        this.t.ab().c();
        this.Q();
    }

    protected void Q() {
        PacketDebug.a(this.t, this, this.bR);
    }

    protected void R() {
    }

    public int T() {
        return 40;
    }

    public int U() {
        return 75;
    }

    public int V() {
        return 10;
    }

    public void a(Entity targetEntity, float maxYawChange, float maxPitchChange) {
        double d2;
        double d0 = targetEntity.dc() - this.dc();
        double d1 = targetEntity.di() - this.di();
        if (targetEntity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)targetEntity;
            d2 = entityliving.dg() - this.dg();
        } else {
            d2 = (targetEntity.cw().b + targetEntity.cw().e) / 2.0 - this.dg();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f2 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.p(this.a(this.dn(), f3, maxPitchChange));
        this.o(this.a(this.dm(), f2, maxYawChange));
    }

    private float a(float from, float to, float max) {
        float f3 = MathHelper.g(to - from);
        if (f3 > max) {
            f3 = max;
        }
        if (f3 < -max) {
            f3 = -max;
        }
        return from + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        BlockPosition blockposition1 = pos.c();
        return spawnReason == EnumMobSpawn.c || world.a_(blockposition1).a((IBlockAccess)world, blockposition1, type);
    }

    public boolean a(GeneratorAccess world, EnumMobSpawn spawnReason) {
        return true;
    }

    public boolean a(IWorldReader world) {
        return !world.d(this.cw()) && world.f(this);
    }

    public int fe() {
        return 4;
    }

    public boolean c(int count) {
        return false;
    }

    @Override
    public int cj() {
        if (this.G() == null) {
            return 3;
        }
        int i2 = (int)(this.dZ() - this.el() * 0.33f);
        if ((i2 -= (3 - this.t.af().a()) * 4) < 0) {
            i2 = 0;
        }
        return i2 + 3;
    }

    @Override
    public Iterable<ItemStack> bB() {
        return this.bZ;
    }

    @Override
    public Iterable<ItemStack> bC() {
        return this.ca;
    }

    @Override
    public ItemStack b(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.bZ.get(slot.b());
            }
            case b: {
                return this.ca.get(slot.b());
            }
        }
        return ItemStack.b;
    }

    @Override
    public void a(EnumItemSlot slot, ItemStack stack) {
        this.f(stack);
        switch (slot.a()) {
            case a: {
                this.bZ.set(slot.b(), stack);
                break;
            }
            case b: {
                this.ca.set(slot.b(), stack);
            }
        }
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            boolean flag1;
            ItemStack itemstack = this.b(enumitemslot);
            float f2 = this.e(enumitemslot);
            boolean bl = flag1 = f2 > 1.0f;
            if (itemstack.b() || EnchantmentManager.e(itemstack) || !allowDrops && !flag1 || !(Math.max(this.R.nextFloat() - (float)lootingMultiplier * 0.01f, 0.0f) < f2)) continue;
            if (!flag1 && itemstack.f()) {
                itemstack.b(itemstack.i() - this.R.nextInt(1 + this.R.nextInt(Math.max(itemstack.i() - 3, 1))));
            }
            this.b(itemstack);
            if (!this.clearEquipmentSlots) continue;
            this.a(enumitemslot, ItemStack.b);
        }
    }

    protected float e(EnumItemSlot slot) {
        return switch (slot.a()) {
            case EnumItemSlot.Function.a -> this.bT[slot.b()];
            case EnumItemSlot.Function.b -> this.bU[slot.b()];
            default -> 0.0f;
        };
    }

    protected void a(DifficultyDamageScaler difficulty) {
        if (this.R.nextFloat() < 0.15f * difficulty.d()) {
            float f2;
            int i2 = this.R.nextInt(2);
            float f3 = f2 = this.t.af() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (this.R.nextFloat() < 0.095f) {
                ++i2;
            }
            if (this.R.nextFloat() < 0.095f) {
                ++i2;
            }
            if (this.R.nextFloat() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                Item item;
                if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
                ItemStack itemstack = this.b(enumitemslot);
                if (!flag && this.R.nextFloat() < f2) break;
                flag = false;
                if (!itemstack.b() || (item = EntityInsentient.a(enumitemslot, i2)) == null) continue;
                this.a(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot equipmentSlot, int equipmentLevel) {
        switch (equipmentSlot) {
            case f: {
                if (equipmentLevel == 0) {
                    return Items.nk;
                }
                if (equipmentLevel == 1) {
                    return Items.nA;
                }
                if (equipmentLevel == 2) {
                    return Items.no;
                }
                if (equipmentLevel == 3) {
                    return Items.ns;
                }
                if (equipmentLevel == 4) {
                    return Items.nw;
                }
            }
            case e: {
                if (equipmentLevel == 0) {
                    return Items.nl;
                }
                if (equipmentLevel == 1) {
                    return Items.nB;
                }
                if (equipmentLevel == 2) {
                    return Items.np;
                }
                if (equipmentLevel == 3) {
                    return Items.nt;
                }
                if (equipmentLevel == 4) {
                    return Items.nx;
                }
            }
            case d: {
                if (equipmentLevel == 0) {
                    return Items.nm;
                }
                if (equipmentLevel == 1) {
                    return Items.nC;
                }
                if (equipmentLevel == 2) {
                    return Items.nq;
                }
                if (equipmentLevel == 3) {
                    return Items.nu;
                }
                if (equipmentLevel == 4) {
                    return Items.ny;
                }
            }
            case c: {
                if (equipmentLevel == 0) {
                    return Items.nn;
                }
                if (equipmentLevel == 1) {
                    return Items.nD;
                }
                if (equipmentLevel == 2) {
                    return Items.nr;
                }
                if (equipmentLevel == 3) {
                    return Items.nv;
                }
                if (equipmentLevel != 4) break;
                return Items.nz;
            }
        }
        return null;
    }

    protected void b(DifficultyDamageScaler difficulty) {
        float f2 = difficulty.d();
        this.x(f2);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            this.a(f2, enumitemslot);
        }
    }

    protected void x(float power) {
        if (!this.er().b() && this.R.nextFloat() < 0.25f * power) {
            this.a(EnumItemSlot.a, EnchantmentManager.a(this.R, this.er(), (int)(5.0f + power * (float)this.R.nextInt(18)), false));
        }
    }

    protected void a(float power, EnumItemSlot slot) {
        ItemStack itemstack = this.b(slot);
        if (!itemstack.b() && this.R.nextFloat() < 0.5f * power) {
            this.a(slot, EnchantmentManager.a(this.R, itemstack, (int)(5.0f + power * (float)this.R.nextInt(18)), false));
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.a(GenericAttributes.b).c(new AttributeModifier("Random spawn bonus", this.R.nextGaussian() * 0.05, AttributeModifier.Operation.b));
        if (this.R.nextFloat() < 0.05f) {
            this.t(true);
        } else {
            this.t(false);
        }
        return entityData;
    }

    public boolean ff() {
        return false;
    }

    public void fg() {
        this.cc = true;
    }

    public void a(EnumItemSlot slot, float chance) {
        switch (slot.a()) {
            case a: {
                this.bT[slot.b()] = chance;
                break;
            }
            case b: {
                this.bU[slot.b()] = chance;
            }
        }
    }

    public boolean fh() {
        return this.cb;
    }

    public void r(boolean pickUpLoot) {
        this.cb = pickUpLoot;
    }

    @Override
    public boolean g(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.i(stack);
        return this.b(enumitemslot).b() && this.fh();
    }

    public boolean fi() {
        return this.cc;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (!this.bl()) {
            return EnumInteractionResult.d;
        }
        if (this.fq() == player) {
            PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(this, player, !player.fr().d);
            if (event.isCancelled()) {
                ((EntityPlayer)player).b.a(new PacketPlayOutAttachEntity(this, this.fq()));
                return EnumInteractionResult.d;
            }
            this.a(true, event.isDropLeash());
            return EnumInteractionResult.a(this.t.y);
        }
        EnumInteractionResult enuminteractionresult = this.c(player, hand);
        if (enuminteractionresult.a()) {
            return enuminteractionresult;
        }
        enuminteractionresult = this.b(player, hand);
        return enuminteractionresult.a() ? enuminteractionresult : super.a(player, hand);
    }

    private EnumInteractionResult c(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.rP) && this.a(player)) {
            if (CraftEventFactory.callPlayerLeashEntityEvent(this, player, player).isCancelled()) {
                ((EntityPlayer)player).b.a(new PacketPlayOutAttachEntity(this, this.fq()));
                return EnumInteractionResult.d;
            }
            this.b((Entity)player, true);
            itemstack.g(1);
            return EnumInteractionResult.a(this.t.y);
        }
        if (itemstack.a(Items.rQ) && (enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand)).a()) {
            return enuminteractionresult;
        }
        if (itemstack.c() instanceof ItemMonsterEgg) {
            if (this.t instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.c();
                Optional<EntityInsentient> optional = itemmonsteregg.a(player, this, this.ad(), (WorldServer)this.t, this.cV(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(player, (EntityInsentient)entityinsentient));
                return optional.isPresent() ? EnumInteractionResult.a : EnumInteractionResult.d;
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.d;
    }

    protected void a(EntityHuman player, EntityInsentient child) {
    }

    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean fj() {
        return this.a(this.cW());
    }

    public boolean a(BlockPosition pos) {
        return this.ck == -1.0f ? true : this.cj.j(pos) < (double)(this.ck * this.ck);
    }

    public void a(BlockPosition target, int range) {
        this.cj = target;
        this.ck = range;
    }

    public BlockPosition fk() {
        return this.cj;
    }

    public float fl() {
        return this.ck;
    }

    public void fm() {
        this.ck = -1.0f;
    }

    public boolean fn() {
        return this.ck != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, boolean keepEquipment) {
        return this.convertTo(entityType, keepEquipment, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, boolean flag, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.do()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.t);
        t0.s(this);
        t0.a(this.y_());
        t0.s(this.fr());
        if (this.Y()) {
            t0.a(this.Z());
            t0.n(this.cr());
        }
        if (this.fi()) {
            t0.fg();
        }
        t0.m(this.cg());
        if (flag) {
            t0.r(this.fh());
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                ItemStack itemstack = this.b(enumitemslot);
                if (itemstack.b()) continue;
                t0.a(enumitemslot, itemstack.m());
                t0.a(enumitemslot, this.e(enumitemslot));
                itemstack.e(0);
            }
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        this.t.addFreshEntity(t0, spawnReason);
        if (this.bF()) {
            Entity entity = this.cN();
            this.p();
            t0.a(entity, true);
        }
        this.ah();
        return (T)t0;
    }

    protected void fo() {
        if (this.ci != null) {
            this.fw();
        }
        if (!(this.cg == null || this.bl() && this.cg.bl())) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), !this.bl() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, true);
            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
            this.a(true, event.isDropLeash());
        }
    }

    public void a(boolean sendPacket, boolean dropItem) {
        if (this.cg != null) {
            this.cg = null;
            this.ci = null;
            if (!this.t.y && dropItem) {
                this.forceDrops = true;
                this.a((IMaterial)Items.rP);
                this.forceDrops = false;
            }
            if (!this.t.y && sendPacket && this.t instanceof WorldServer) {
                ((WorldServer)this.t).k().b(this, new PacketPlayOutAttachEntity(this, null));
            }
        }
    }

    public boolean a(EntityHuman player) {
        return !this.fp() && !(this instanceof IMonster);
    }

    public boolean fp() {
        return this.cg != null;
    }

    @Nullable
    public Entity fq() {
        if (this.cg == null && this.ch != 0 && this.t.y) {
            this.cg = this.t.a(this.ch);
        }
        return this.cg;
    }

    public void b(Entity entity, boolean sendPacket) {
        this.cg = entity;
        this.ci = null;
        if (!this.t.y && sendPacket && this.t instanceof WorldServer) {
            ((WorldServer)this.t).k().b(this, new PacketPlayOutAttachEntity(this, this.cg));
        }
        if (this.bF()) {
            this.p();
        }
    }

    public void d(int id) {
        this.ch = id;
        this.a(false, false);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        boolean flag1 = super.a(entity, force);
        if (flag1 && this.fp()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, true);
            if (!event.callEvent()) {
                return flag1;
            }
            this.a(true, event.isDropLeash());
        }
        return flag1;
    }

    private void fw() {
        if (this.ci != null && this.t instanceof WorldServer) {
            if (this.ci.b("UUID")) {
                UUID uuid = this.ci.a("UUID");
                Entity entity = ((WorldServer)this.t).a(uuid);
                if (entity != null) {
                    this.b(entity, true);
                    return;
                }
            } else if (this.ci.b("X", 99) && this.ci.b("Y", 99) && this.ci.b("Z", 99)) {
                BlockPosition blockposition = GameProfileSerializer.b(this.ci);
                this.b(EntityLeash.b(this.t, blockposition), true);
                return;
            }
            if (this.S > 100) {
                this.forceDrops = true;
                this.a((IMaterial)Items.rP);
                this.forceDrops = false;
                this.ci = null;
            }
        }
    }

    @Override
    public boolean cM() {
        return this.ff() && super.cM();
    }

    @Override
    public boolean eH() {
        return super.eH() && !this.fr();
    }

    public void s(boolean aiDisabled) {
        byte b0 = this.Z.a(b);
        this.Z.b(b, aiDisabled ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void t(boolean leftHanded) {
        byte b0 = this.Z.a(b);
        this.Z.b(b, leftHanded ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void u(boolean attacking) {
        byte b0 = this.Z.a(b);
        this.Z.b(b, attacking ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean fr() {
        return (this.Z.a(b) & 1) != 0;
    }

    public boolean fs() {
        return (this.Z.a(b) & 2) != 0;
    }

    public boolean ft() {
        return (this.Z.a(b) & 4) != 0;
    }

    public void a(boolean baby) {
    }

    @Override
    public EnumMainHand eK() {
        return this.fs() ? EnumMainHand.a : EnumMainHand.b;
    }

    public double i(EntityLiving target) {
        return this.cT() * 2.0f * this.cT() * 2.0f + target.cT();
    }

    @Override
    public boolean z(Entity target) {
        boolean flag;
        int i2;
        float f2 = (float)this.b(GenericAttributes.f);
        float f1 = (float)this.b(GenericAttributes.g);
        if (target instanceof EntityLiving) {
            f2 += EnchantmentManager.a(this.er(), ((EntityLiving)target).eq());
            f1 += (float)EnchantmentManager.b(this);
        }
        if ((i2 = EnchantmentManager.c(this)) > 0) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), i2 * 4);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                target.setSecondsOnFire(combustEvent.getDuration(), false);
            }
        }
        if (flag = target.a(DamageSource.c(this), f2)) {
            if (f1 > 0.0f && target instanceof EntityLiving) {
                ((EntityLiving)target).knockback(f1 * 0.5f, MathHelper.a(this.dm() * ((float)Math.PI / 180)), -MathHelper.b(this.dm() * ((float)Math.PI / 180)), this);
                this.g(this.da().d(0.6, 1.0, 0.6));
            }
            if (target instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)target;
                this.a(entityhuman, this.er(), entityhuman.eL() ? entityhuman.eN() : ItemStack.b);
            }
            this.a((EntityLiving)this, target);
            this.x(target);
        }
        return flag;
    }

    private void a(EntityHuman player, ItemStack mobStack, ItemStack playerStack) {
        if (!mobStack.b() && !playerStack.b() && mobStack.c() instanceof ItemAxe && playerStack.a(Items.sv)) {
            float f2 = 0.25f + (float)EnchantmentManager.f(this) * 0.05f;
            if (this.R.nextFloat() < f2) {
                player.fK().a(Items.sv, 100);
                this.t.a((Entity)player, (byte)30);
            }
        }
    }

    public boolean fu() {
        if (this.t.P() && !this.t.y) {
            boolean flag;
            float f2 = this.bd();
            BlockPosition blockposition = new BlockPosition(this.dc(), this.dg(), this.di());
            boolean bl = flag = this.aS() || this.am || this.an;
            if (f2 > 0.5f && this.R.nextFloat() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.t.f(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(Tag<FluidType> fluid) {
        if (this.D().q()) {
            super.c(fluid);
        } else {
            this.g(this.da().b(0.0, 0.3, 0.0));
        }
    }

    public void fv() {
        this.bR.a();
        this.dt().g();
    }

    @Override
    protected void ch() {
        super.ch();
        EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
        this.t.getCraftServer().getPluginManager().callEvent((Event)event);
        this.a(true, event.isDropLeash());
        this.bD().forEach(itemstack -> {
            if (!itemstack.b()) {
                itemstack.e(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack dk() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.ad());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }
}

