/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class EntityExperienceOrb
extends Entity {
    private static final int b = 6000;
    private static final int c = 20;
    private static final int d = 8;
    private static final int e = 40;
    private static final double f = 0.5;
    private int ap;
    private int aq = 5;
    public int ar;
    private int as = 1;
    private EntityHuman at;
    public UUID sourceEntityId;
    public UUID triggerEntityId;
    public ExperienceOrb.SpawnReason spawnReason = ExperienceOrb.SpawnReason.UNKNOWN;

    private void loadPaperNBT(NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.b("Paper.ExpData", 10)) {
            return;
        }
        NBTTagCompound comp = nbttagcompound.p("Paper.ExpData");
        if (comp.b("source")) {
            this.sourceEntityId = comp.a("source");
        }
        if (comp.b("trigger")) {
            this.triggerEntityId = comp.a("trigger");
        }
        if (comp.e("reason")) {
            String reason = comp.l("reason");
            try {
                this.spawnReason = ExperienceOrb.SpawnReason.valueOf((String)reason);
            }
            catch (Exception e2) {
                this.t.getCraftServer().getLogger().warning("Invalid spawnReason set for experience orb: " + e2.getMessage() + " - " + reason);
            }
        }
    }

    private void savePaperNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound comp = new NBTTagCompound();
        if (this.sourceEntityId != null) {
            comp.a("source", this.sourceEntityId);
        }
        if (this.triggerEntityId != null) {
            comp.a("trigger", this.triggerEntityId);
        }
        if (this.spawnReason != null && this.spawnReason != ExperienceOrb.SpawnReason.UNKNOWN) {
            comp.a("reason", this.spawnReason.name());
        }
        nbttagcompound.a("Paper.ExpData", comp);
    }

    public EntityExperienceOrb(World world, double x2, double y2, double z2, int amount) {
        this(world, x2, y2, z2, amount, null, null);
    }

    public EntityExperienceOrb(World world, double d0, double d1, double d2, int i2, ExperienceOrb.SpawnReason reason, Entity triggerId) {
        this(world, d0, d1, d2, i2, reason, triggerId, null);
    }

    public EntityExperienceOrb(World world, double d0, double d1, double d2, int i2, ExperienceOrb.SpawnReason reason, Entity triggerId, Entity sourceId) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.A, world);
        this.sourceEntityId = sourceId != null ? sourceId.cm() : null;
        this.triggerEntityId = triggerId != null ? triggerId.cm() : null;
        this.spawnReason = reason != null ? reason : ExperienceOrb.SpawnReason.UNKNOWN;
        this.e(d0, d1, d2);
        this.o((float)(this.R.nextDouble() * 360.0));
        this.n((this.R.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.R.nextDouble() * 0.2 * 2.0, (this.R.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        this.ar = i2;
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> type, World world) {
        super(type, world);
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
    }

    @Override
    public void k() {
        Vec3D vec3d;
        double d0;
        super.k();
        EntityHuman prevTarget = this.at;
        this.u = this.dc();
        this.v = this.de();
        this.w = this.di();
        if (this.a(TagsFluid.b)) {
            this.l();
        } else if (!this.aM()) {
            this.g(this.da().b(0.0, -0.03, 0.0));
        }
        if (this.t.b_(this.cW()).a(TagsFluid.c)) {
            this.n((this.R.nextFloat() - this.R.nextFloat()) * 0.2f, 0.2f, (this.R.nextFloat() - this.R.nextFloat()) * 0.2f);
        }
        if (!this.t.b(this.cw())) {
            this.l(this.dc(), (this.cw().b + this.cw().e) / 2.0, this.di());
        }
        if (this.S % 20 == 1) {
            this.j();
        }
        if (this.at != null && (this.at.B_() || this.at.ea())) {
            this.at = null;
        }
        boolean cancelled = false;
        if (this.at != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.at, this.at != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            EntityLiving target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.at = prevTarget;
            } else {
                EntityHuman entityHuman = this.at = target instanceof EntityHuman ? (EntityHuman)target : null;
            }
        }
        if (this.at != null && !cancelled && (d0 = (vec3d = new Vec3D(this.at.dc() - this.dc(), this.at.de() + (double)this.at.cy() / 2.0 - this.de(), this.at.di() - this.di())).g()) < 64.0) {
            double d1 = 1.0 - Math.sqrt(d0) / 8.0;
            this.g(this.da().e(vec3d.d().a(d1 * d1 * 0.1)));
        }
        this.a(EnumMoveType.a, this.da());
        float f2 = 0.98f;
        if (this.z) {
            f2 = this.t.a_(new BlockPosition(this.dc(), this.de() - 1.0, this.di())).b().i() * 0.98f;
        }
        this.g(this.da().d(f2, 0.98, f2));
        if (this.z) {
            this.g(this.da().d(1.0, -0.9, 1.0));
        }
        ++this.ap;
        if (this.ap >= 6000) {
            this.ah();
        }
    }

    private void j() {
        if (this.at == null || this.at.f(this) > 64.0) {
            this.at = this.t.a((Entity)this, 8.0);
        }
        if (this.t instanceof WorldServer) {
            List<EntityExperienceOrb> list = this.t.a(EntityTypeTest.a(EntityExperienceOrb.class), this.cw().g(0.5), this::a);
            for (EntityExperienceOrb entityexperienceorb : list) {
                this.b(entityexperienceorb);
            }
        }
    }

    public static void a(WorldServer world, Vec3D pos, int amount) {
        EntityExperienceOrb.award(world, pos, amount, null, null, null);
    }

    public static void award(WorldServer world, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId) {
        EntityExperienceOrb.award(world, pos, amount, reason, triggerId, null);
    }

    public static void award(WorldServer world, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId, Entity sourceId) {
        while (amount > 0) {
            int j2 = EntityExperienceOrb.a(amount);
            amount -= j2;
            if (EntityExperienceOrb.b(world, pos, j2)) continue;
            world.b(new EntityExperienceOrb(world, pos.a(), pos.b(), pos.c(), j2, reason, triggerId, sourceId));
        }
    }

    private static boolean b(WorldServer world, Vec3D pos, int amount) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(pos, 1.0, 1.0, 1.0);
        int j2 = world.r_().nextInt(40);
        List<EntityExperienceOrb> list = world.a(EntityTypeTest.a(EntityExperienceOrb.class), axisalignedbb, (? super T entityexperienceorb) -> EntityExperienceOrb.a(entityexperienceorb, j2, amount));
        if (!list.isEmpty()) {
            EntityExperienceOrb entityexperienceorb2 = list.get(0);
            ++entityexperienceorb2.as;
            entityexperienceorb2.ap = 0;
            return true;
        }
        return false;
    }

    private boolean a(EntityExperienceOrb other) {
        return other != this && EntityExperienceOrb.a(other, this.ae(), this.ar);
    }

    private static boolean a(EntityExperienceOrb orb, int seed, int amount) {
        return !orb.do() && (orb.ae() - seed) % 40 == 0 && orb.ar == amount;
    }

    private void b(EntityExperienceOrb other) {
        this.as += other.as;
        this.ap = Math.min(this.ap, other.ap);
        other.ah();
    }

    private void l() {
        Vec3D vec3d = this.da();
        this.n(vec3d.b * (double)0.99f, Math.min(vec3d.c + (double)5.0E-4f, (double)0.06f), vec3d.d * (double)0.99f);
    }

    @Override
    protected void aY() {
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        this.bf();
        this.aq = (int)((float)this.aq - amount);
        if (this.aq <= 0) {
            this.ah();
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        nbt.a("Health", (short)this.aq);
        nbt.a("Age", (short)this.ap);
        nbt.a("Value", this.ar);
        nbt.a("Count", this.as);
        this.savePaperNBT(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.aq = nbt.g("Health");
        this.ap = nbt.g("Age");
        this.ar = nbt.h("Value");
        this.as = Math.max(nbt.h("Count"), 1);
        this.loadPaperNBT(nbt);
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.t.y && player.cb == 0 && new PlayerPickupExperienceEvent((Player)((EntityPlayer)player).getBukkitEntity(), (ExperienceOrb)this.getBukkitEntity()).callEvent()) {
            player.cb = 2;
            player.a((Entity)this, 1);
            int i2 = this.a(player, this.ar);
            if (i2 > 0) {
                player.d(CraftEventFactory.callPlayerExpChangeEvent(player, this).getAmount());
            }
            --this.as;
            if (this.as == 0) {
                this.ah();
            }
        }
    }

    private int a(EntityHuman player, int amount) {
        Map.Entry<EnumItemSlot, ItemStack> entry = EnchantmentManager.a(Enchantments.K, player, ItemStack::g);
        if (entry != null) {
            int k2;
            ItemStack itemstack = entry.getValue();
            int j2 = Math.min(this.c(this.ar), itemstack.h());
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(player, this, itemstack, j2);
            j2 = event.getRepairAmount();
            if (event.isCancelled()) {
                return amount;
            }
            itemstack.b(itemstack.h() - j2);
            this.ar = k2 = amount - this.b(j2);
            return k2 > 0 ? this.a(player, k2) : 0;
        }
        return amount;
    }

    public int b(int repairAmount) {
        return repairAmount / 2;
    }

    public int c(int experienceAmount) {
        return experienceAmount * 2;
    }

    public int h() {
        return this.ar;
    }

    public int i() {
        return this.ar >= 2477 ? 10 : (this.ar >= 1237 ? 9 : (this.ar >= 617 ? 8 : (this.ar >= 307 ? 7 : (this.ar >= 149 ? 6 : (this.ar >= 73 ? 5 : (this.ar >= 37 ? 4 : (this.ar >= 17 ? 3 : (this.ar >= 7 ? 2 : (this.ar >= 3 ? 1 : 0)))))))));
    }

    public static int a(int value) {
        if (value > 162670129) {
            return value - 100000;
        }
        if (value > 81335063) {
            return 81335063;
        }
        if (value > 40667527) {
            return 40667527;
        }
        if (value > 20333759) {
            return 20333759;
        }
        if (value > 10166857) {
            return 10166857;
        }
        if (value > 5083423) {
            return 5083423;
        }
        if (value > 2541701) {
            return 2541701;
        }
        if (value > 1270849) {
            return 1270849;
        }
        if (value > 635413) {
            return 635413;
        }
        if (value > 317701) {
            return 317701;
        }
        if (value > 158849) {
            return 158849;
        }
        if (value > 79423) {
            return 79423;
        }
        if (value > 39709) {
            return 39709;
        }
        if (value > 19853) {
            return 19853;
        }
        if (value > 9923) {
            return 9923;
        }
        if (value > 4957) {
            return 4957;
        }
        return value >= 2477 ? 2477 : (value >= 1237 ? 1237 : (value >= 617 ? 617 : (value >= 307 ? 307 : (value >= 149 ? 149 : (value >= 73 ? 73 : (value >= 37 ? 37 : (value >= 17 ? 17 : (value >= 7 ? 7 : (value >= 3 ? 3 : 1)))))))));
    }

    @Override
    public boolean cf() {
        return false;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntityExperienceOrb(this);
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.i;
    }
}

