/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobEffect
implements Comparable<MobEffect> {
    private static final Logger a = LogManager.getLogger();
    private final MobEffectList b;
    private int c;
    private int d;
    private boolean e;
    private boolean f;
    private boolean g;
    private boolean h;
    @Nullable
    private MobEffect i;

    public MobEffect(MobEffectList type) {
        this(type, 0, 0);
    }

    public MobEffect(MobEffectList type, int duration) {
        this(type, duration, 0);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier) {
        this(type, duration, amplifier, false, true);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier, boolean ambient, boolean visible) {
        this(type, duration, amplifier, ambient, visible, visible);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon) {
        this(type, duration, amplifier, ambient, showParticles, showIcon, null);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon, @Nullable MobEffect hiddenEffect) {
        this.b = type;
        this.c = duration;
        this.d = amplifier;
        this.e = ambient;
        this.g = showParticles;
        this.h = showIcon;
        this.i = hiddenEffect;
    }

    public MobEffect(MobEffect toCopy) {
        this.b = toCopy.b;
        this.a(toCopy);
    }

    void a(MobEffect that) {
        this.c = that.c;
        this.d = that.d;
        this.e = that.e;
        this.g = that.g;
        this.h = that.h;
    }

    public boolean b(MobEffect that) {
        if (this.b != that.b) {
            a.warn("This method should only be called for matching effects!");
        }
        boolean bl = false;
        if (that.d > this.d) {
            if (that.c < this.c) {
                MobEffect mobEffectInstance = this.i;
                this.i = new MobEffect(this);
                this.i.i = mobEffectInstance;
            }
            this.d = that.d;
            this.c = that.c;
            bl = true;
        } else if (that.c > this.c) {
            if (that.d == this.d) {
                this.c = that.c;
                bl = true;
            } else if (this.i == null) {
                this.i = new MobEffect(that);
            } else {
                this.i.b(that);
            }
        }
        if (!that.e && this.e || bl) {
            this.e = that.e;
            bl = true;
        }
        if (that.g != this.g) {
            this.g = that.g;
            bl = true;
        }
        if (that.h != this.h) {
            this.h = that.h;
            bl = true;
        }
        return bl;
    }

    public MobEffectList a() {
        return this.b;
    }

    public int b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public boolean d() {
        return this.e;
    }

    public boolean e() {
        return this.g;
    }

    public boolean f() {
        return this.h;
    }

    public boolean a(EntityLiving entity, Runnable overwriteCallback) {
        if (this.c > 0) {
            if (this.b.a(this.c, this.d)) {
                this.a(entity);
            }
            this.i();
            if (this.c == 0 && this.i != null) {
                this.a(this.i);
                this.i = this.i.i;
                overwriteCallback.run();
            }
        }
        return this.c > 0;
    }

    private int i() {
        if (this.i != null) {
            this.i.i();
        }
        return --this.c;
    }

    public void a(EntityLiving entity) {
        if (this.c > 0) {
            this.b.a(entity, this.d);
        }
    }

    public String g() {
        return this.b.c();
    }

    public String toString() {
        String string = this.d > 0 ? this.g() + " x " + (this.d + 1) + ", Duration: " + this.c : this.g() + ", Duration: " + this.c;
        if (!this.g) {
            string = string + ", Particles: false";
        }
        if (!this.h) {
            string = string + ", Show Icon: false";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MobEffect)) {
            return false;
        }
        MobEffect mobEffectInstance = (MobEffect)object;
        return this.c == mobEffectInstance.c && this.d == mobEffectInstance.d && this.e == mobEffectInstance.e && this.b.equals(mobEffectInstance.b);
    }

    public int hashCode() {
        int i2 = this.b.hashCode();
        i2 = 31 * i2 + this.c;
        i2 = 31 * i2 + this.d;
        return 31 * i2 + (this.e ? 1 : 0);
    }

    public NBTTagCompound a(NBTTagCompound nbt) {
        nbt.a("Id", (byte)MobEffectList.a(this.a()));
        this.c(nbt);
        return nbt;
    }

    private void c(NBTTagCompound nbt) {
        nbt.a("Amplifier", (byte)this.c());
        nbt.a("Duration", this.b());
        nbt.a("Ambient", this.d());
        nbt.a("ShowParticles", this.e());
        nbt.a("ShowIcon", this.f());
        if (this.i != null) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            this.i.a(compoundTag);
            nbt.a("HiddenEffect", compoundTag);
        }
    }

    @Nullable
    public static MobEffect b(NBTTagCompound nbt) {
        byte i2 = nbt.f("Id");
        MobEffectList mobEffect = MobEffectList.a(i2);
        return mobEffect == null ? null : MobEffect.a(mobEffect, nbt);
    }

    private static MobEffect a(MobEffectList type, NBTTagCompound nbt) {
        int i2 = Byte.toUnsignedInt(nbt.f("Amplifier"));
        int j2 = nbt.h("Duration");
        boolean bl = nbt.q("Ambient");
        boolean bl2 = true;
        if (nbt.b("ShowParticles", 1)) {
            bl2 = nbt.q("ShowParticles");
        }
        boolean bl3 = bl2;
        if (nbt.b("ShowIcon", 1)) {
            bl3 = nbt.q("ShowIcon");
        }
        MobEffect mobEffectInstance = null;
        if (nbt.b("HiddenEffect", 10)) {
            mobEffectInstance = MobEffect.a(type, nbt.p("HiddenEffect"));
        }
        return new MobEffect(type, j2, i2 < 0 ? 0 : i2, bl, bl2, bl3, mobEffectInstance);
    }

    public void a(boolean permanent) {
        this.f = permanent;
    }

    public boolean h() {
        return this.f;
    }

    public int c(MobEffect mobEffectInstance) {
        int i2 = 32147;
        return !(this.b() > 32147 && mobEffectInstance.b() > 32147 || this.d() && mobEffectInstance.d()) ? ComparisonChain.start().compare(Boolean.valueOf(this.d()), Boolean.valueOf(mobEffectInstance.d())).compare(this.b(), mobEffectInstance.b()).compare(this.a().f(), mobEffectInstance.a().f()).result() : ComparisonChain.start().compare(Boolean.valueOf(this.d()), Boolean.valueOf(mobEffectInstance.d())).compare(this.a().f(), mobEffectInstance.a().f()).result();
    }
}

