/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldUpgrader {
    private static final Logger a = LogManager.getLogger();
    private static final ThreadFactory b = new ThreadFactoryBuilder().setDaemon(true).build();
    private final GeneratorSettings c;
    private final boolean d;
    private final Convertable.ConversionSession e;
    private final Thread f;
    private final DataFixer g;
    private volatile boolean h = true;
    private volatile boolean i;
    private volatile float j;
    private volatile int k;
    private volatile int l;
    private volatile int m;
    private final Object2FloatMap<ResourceKey<WorldDimension>> n = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(SystemUtils.l()));
    private volatile IChatBaseComponent o = new ChatMessage("optimizeWorld.stage.counting");
    public static final Pattern p = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final WorldPersistentData q;

    public WorldUpgrader(Convertable.ConversionSession session, DataFixer dataFixer, GeneratorSettings generatorOptions, boolean eraseCache) {
        this.c = generatorOptions;
        this.d = eraseCache;
        this.g = dataFixer;
        this.e = session;
        this.q = new WorldPersistentData(this.e.a(World.f).resolve("data").toFile(), dataFixer);
        this.f = b.newThread(this::i);
        this.f.setUncaughtExceptionHandler((thread, throwable) -> {
            a.error("Error upgrading world", throwable);
            this.o = new ChatMessage("optimizeWorld.stage.failed");
            this.i = true;
        });
        this.f.start();
    }

    public void a() {
        this.h = false;
        try {
            this.f.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void i() {
        this.k = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableSet immutableset = ImmutableSet.of(this.e.dimensionType);
        for (ResourceKey resourcekey : immutableset) {
            List<ChunkCoordIntPair> list = this.b(resourcekey);
            builder.put((Object)resourcekey, list.listIterator());
            this.k += list.size();
        }
        if (this.k == 0) {
            this.i = true;
        } else {
            float f2 = this.k;
            ImmutableMap immutablemap = builder.build();
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            for (ResourceKey resourcekey1 : immutableset) {
                Path path = this.e.a((ResourceKey<World>)null);
                builder1.put((Object)resourcekey1, (Object)new IChunkLoader(path.resolve("region"), this.g, true));
            }
            ImmutableMap immutablemap1 = builder1.build();
            long i2 = SystemUtils.c();
            this.o = new ChatMessage("optimizeWorld.stage.upgrading");
            while (this.h) {
                boolean flag = false;
                float f1 = 0.0f;
                for (ResourceKey resourcekey2 : immutableset) {
                    ListIterator listiterator = (ListIterator)immutablemap.get((Object)resourcekey2);
                    IChunkLoader ichunkloader = (IChunkLoader)immutablemap1.get((Object)resourcekey2);
                    if (listiterator.hasNext()) {
                        ChunkCoordIntPair chunkcoordintpair = (ChunkCoordIntPair)listiterator.next();
                        boolean flag1 = false;
                        try {
                            NBTTagCompound nbttagcompound = ichunkloader.f(chunkcoordintpair);
                            if (nbttagcompound != null) {
                                boolean flag2;
                                int j2 = IChunkLoader.a(nbttagcompound);
                                ChunkGenerator chunkgenerator = this.c.d().a(resourcekey2).c();
                                NBTTagCompound nbttagcompound1 = ichunkloader.upgradeChunkTag(resourcekey2, () -> this.q, nbttagcompound, chunkgenerator.b(), chunkcoordintpair, null);
                                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(nbttagcompound1.h("xPos"), nbttagcompound1.h("zPos"));
                                if (!chunkcoordintpair1.equals(chunkcoordintpair)) {
                                    a.warn("Chunk {} has invalid position {}", (Object)chunkcoordintpair, (Object)chunkcoordintpair1);
                                }
                                boolean bl = flag2 = j2 < SharedConstants.b().getWorldVersion();
                                if (this.d) {
                                    flag2 = flag2 || nbttagcompound1.e("Heightmaps");
                                    nbttagcompound1.r("Heightmaps");
                                    flag2 = flag2 || nbttagcompound1.e("isLightOn");
                                    nbttagcompound1.r("isLightOn");
                                }
                                if (flag2) {
                                    ichunkloader.a(chunkcoordintpair, nbttagcompound1);
                                    flag1 = true;
                                }
                            }
                        }
                        catch (ReportedException reportedexception) {
                            Throwable throwable = reportedexception.getCause();
                            if (!(throwable instanceof IOException)) {
                                throw reportedexception;
                            }
                            a.error("Error upgrading chunk {}", (Object)chunkcoordintpair, (Object)throwable);
                        }
                        catch (IOException ioexception) {
                            a.error("Error upgrading chunk {}", (Object)chunkcoordintpair, (Object)ioexception);
                        }
                        if (flag1) {
                            ++this.l;
                        } else {
                            ++this.m;
                        }
                        flag = true;
                    }
                    float f22 = (float)listiterator.nextIndex() / f2;
                    this.n.put((Object)resourcekey2, f22);
                    f1 += f22;
                }
                this.j = f1;
                if (flag) continue;
                this.h = false;
            }
            this.o = new ChatMessage("optimizeWorld.stage.finished");
            for (IChunkLoader ichunkloader1 : immutablemap1.values()) {
                try {
                    ichunkloader1.close();
                }
                catch (IOException ioexception1) {
                    a.error("Error upgrading chunk", (Throwable)ioexception1);
                }
            }
            this.q.a();
            i2 = SystemUtils.c() - i2;
            a.info("World optimizaton finished after {} ms", (Object)i2);
            this.i = true;
        }
    }

    private List<ChunkCoordIntPair> b(ResourceKey<WorldDimension> world) {
        File file = this.e.a((ResourceKey<World>)null).toFile();
        File file1 = new File(file, "region");
        File[] afile = file1.listFiles((file2, s2) -> s2.endsWith(".mca"));
        if (afile == null) {
            return ImmutableList.of();
        }
        ArrayList list = Lists.newArrayList();
        File[] afile1 = afile;
        int i2 = afile.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            File file22 = afile1[j2];
            Matcher matcher = p.matcher(file22.getName());
            if (!matcher.matches()) continue;
            int k2 = Integer.parseInt(matcher.group(1)) << 5;
            int l2 = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionfile = new RegionFile(file22.toPath(), file1.toPath(), true);){
                for (int i1 = 0; i1 < 32; ++i1) {
                    for (int j1 = 0; j1 < 32; ++j1) {
                        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i1 + k2, j1 + l2);
                        if (!regionfile.b(chunkcoordintpair)) continue;
                        list.add(chunkcoordintpair);
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }

    public boolean b() {
        return this.i;
    }

    public ImmutableSet<ResourceKey<World>> c() {
        throw new AssertionError((Object)"Unsupported");
    }

    public float a(ResourceKey<World> world) {
        return this.n.getFloat(world);
    }

    public float d() {
        return this.j;
    }

    public int e() {
        return this.k;
    }

    public int f() {
        return this.l;
    }

    public int g() {
        return this.m;
    }

    public IChatBaseComponent h() {
        return this.o;
    }
}

