/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class UniformFloat
extends FloatProvider {
    public static final Codec<UniformFloat> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_inclusive").forGetter(provider -> Float.valueOf(provider.b)), (App)Codec.FLOAT.fieldOf("max_exclusive").forGetter(provider -> Float.valueOf(provider.d))).apply((Applicative)instance, UniformFloat::new)).comapFlatMap(provider -> {
        if (provider.d <= provider.b) {
            return DataResult.error((String)("Max must be larger than min, min_inclusive: " + provider.b + ", max_exclusive: " + provider.d));
        }
        return DataResult.success((Object)provider);
    }, Function.identity());
    private final float b;
    private final float d;

    private UniformFloat(float min, float max) {
        this.b = min;
        this.d = max;
    }

    public static UniformFloat b(float min, float max) {
        if (max <= min) {
            throw new IllegalArgumentException("Max must exceed min");
        }
        return new UniformFloat(min, max);
    }

    @Override
    @Override
    public float a(Random random) {
        return MathHelper.b(random, this.b, this.d);
    }

    @Override
    @Override
    public float a() {
        return this.b;
    }

    @Override
    @Override
    public float b() {
        return this.d;
    }

    @Override
    @Override
    public FloatProviderType<?> c() {
        return FloatProviderType.b;
    }

    @Override
    public String toString() {
        return "[" + this.b + "-" + this.d + "]";
    }
}

