/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.Mailbox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IAsyncTaskHandler<R extends Runnable>
implements ProfilerMeasured,
Mailbox<R>,
Executor {
    private final String b;
    private static final Logger c = LogManager.getLogger();
    private final Queue<R> d = Queues.newConcurrentLinkedQueue();
    private int e;

    protected IAsyncTaskHandler(String name) {
        this.b = name;
        MetricsRegistry.a.a(this);
    }

    protected abstract R e(Runnable var1);

    protected abstract boolean d(R var1);

    public boolean bl() {
        return Thread.currentThread() == this.at();
    }

    protected abstract Thread at();

    protected boolean as() {
        return !this.bl();
    }

    public int bm() {
        return this.d.size();
    }

    @Override
    public String bn() {
        return this.b;
    }

    public <V> CompletableFuture<V> a(Supplier<V> task) {
        return this.as() ? CompletableFuture.supplyAsync(task, this) : CompletableFuture.completedFuture(task.get());
    }

    private CompletableFuture<Void> a(Runnable runnable) {
        return CompletableFuture.supplyAsync(() -> {
            runnable.run();
            return null;
        }, this);
    }

    public CompletableFuture<Void> f(Runnable task) {
        if (this.as()) {
            return this.a(task);
        }
        task.run();
        return CompletableFuture.completedFuture(null);
    }

    public void g(Runnable runnable) {
        if (!this.bl()) {
            this.a(runnable).join();
        } else {
            runnable.run();
        }
    }

    public void scheduleOnMain(Runnable r0) {
        this.h(this.e(r0));
    }

    public void h(R runnable) {
        this.d.add(runnable);
        LockSupport.unpark(this.at());
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.as()) {
            this.h(this.e(runnable));
        } else {
            runnable.run();
        }
    }

    protected void bo() {
        this.d.clear();
    }

    public void bp() {
        while (this.y()) {
        }
    }

    public boolean y() {
        Runnable runnable = (Runnable)this.d.peek();
        if (runnable == null) {
            return false;
        }
        if (this.e == 0 && !this.d(runnable)) {
            return false;
        }
        this.c((Runnable)this.d.remove());
        return true;
    }

    public void c(BooleanSupplier stopCondition) {
        ++this.e;
        try {
            while (!stopCondition.getAsBoolean()) {
                if (this.y()) continue;
                this.bq();
            }
        }
        finally {
            --this.e;
        }
    }

    protected void bq() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void c(R task) {
        try {
            task.run();
        }
        catch (Exception var3) {
            if (var3.getCause() instanceof ThreadDeath) {
                throw var3;
            }
            c.fatal("Error executing task on {}", (Object)this.bn(), (Object)var3);
        }
    }

    @Override
    public List<MetricSampler> bk() {
        return ImmutableList.of((Object)MetricSampler.a(this.b + "-pending-tasks", MetricCategory.b, this::bm));
    }
}

