/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics.storage;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.storage.RecordedDeviation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetricsPersister {
    public static final Path a = Paths.get("debug/profiling", new String[0]);
    public static final String b = "metrics";
    public static final String c = "deviations";
    public static final String d = "profiling.txt";
    private static final Logger e = LogManager.getLogger();
    private final String f;

    public MetricsPersister(String type) {
        this.f = type;
    }

    public Path a(Set<MetricSampler> samplers, Map<MetricSampler, List<RecordedDeviation>> deviations, MethodProfilerResults result) {
        try {
            Files.createDirectories(a, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        try {
            Path path = Files.createTempDirectory("minecraft-profiling", new FileAttribute[0]);
            path.toFile().deleteOnExit();
            Files.createDirectories(a, new FileAttribute[0]);
            Path path2 = path.resolve(this.f);
            Path path3 = path2.resolve(b);
            this.a(samplers, path3);
            if (!deviations.isEmpty()) {
                this.a(deviations, path2.resolve(c));
            }
            this.a(result, path2);
            return path;
        }
        catch (IOException iOException2) {
            throw new UncheckedIOException(iOException2);
        }
    }

    private void a(Set<MetricSampler> samplers, Path directory) {
        if (samplers.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one sampler to persist");
        }
        Map<MetricCategory, List<MetricSampler>> map = samplers.stream().collect(Collectors.groupingBy(MetricSampler::e));
        map.forEach((type, sampler) -> this.a((MetricCategory)((Object)type), (List<MetricSampler>)sampler, directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(MetricCategory type, List<MetricSampler> samplers, Path directory) {
        Path path = directory.resolve(SystemUtils.a(type.a(), MinecraftKey::b) + ".csv");
        BufferedWriter writer = null;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            CSVWriter.a builder = CSVWriter.a();
            builder.a("@tick");
            for (MetricSampler metricSampler : samplers) {
                builder.a(metricSampler.d());
            }
            CSVWriter csvOutput = builder.a(writer);
            List list = samplers.stream().map(MetricSampler::f).collect(Collectors.toList());
            int i2 = list.stream().mapToInt(MetricSampler.b::a).summaryStatistics().getMin();
            int j2 = list.stream().mapToInt(MetricSampler.b::b).summaryStatistics().getMax();
            for (int k2 = i2; k2 <= j2; ++k2) {
                int l2 = k2;
                Stream<String> stream = list.stream().map(data -> String.valueOf(data.a(l2)));
                Object[] objects = Stream.concat(Stream.of(String.valueOf(k2)), stream).toArray(String[]::new);
                csvOutput.a(objects);
            }
            e.info("Flushed metrics to {}", (Object)path);
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (Exception exception) {
            e.error("Could not save profiler results to {}", (Object)path, (Object)exception);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    private void a(Map<MetricSampler, List<RecordedDeviation>> deviations, Path deviationsDirectory) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss.SSS", Locale.UK).withZone(ZoneId.systemDefault());
        deviations.forEach((sampler, sampleDeviations) -> sampleDeviations.forEach(deviation -> {
            String string = dateTimeFormatter.format(deviation.a);
            Path path2 = deviationsDirectory.resolve(SystemUtils.a(sampler.d(), MinecraftKey::b)).resolve(String.format(Locale.ROOT, "%d@%s.txt", deviation.b, string));
            deviation.c.a(path2);
        }));
    }

    private void a(MethodProfilerResults result, Path directory) {
        result.a(directory.resolve(d));
    }
}

