/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nullable;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.profiling.jfr.parse.JfrStatsParser;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.util.Supplier;

public class SummaryReporter {
    private static final Logger a = LogManager.getLogger();
    private final Runnable b;

    protected SummaryReporter(Runnable stopCallback) {
        this.b = stopCallback;
    }

    /*
     * WARNING - void declaration
     */
    public void a(@Nullable Path dumpPath) {
        if (dumpPath == null) {
            return;
        }
        this.b.run();
        SummaryReporter.a((Supplier<String>)((Supplier)() -> "Dumped flight recorder profiling to " + dumpPath));
        try {
            JfrStatsResult jfrStatsResult = JfrStatsParser.a(dumpPath);
        }
        catch (Throwable throwable) {
            SummaryReporter.a((Supplier<String>)((Supplier)() -> "Failed to parse JFR recording"), throwable);
            return;
        }
        try {
            void jfrStatsResult2;
            SummaryReporter.a((Supplier<String>)((Supplier)((JfrStatsResult)jfrStatsResult2)::b));
            Path path = dumpPath.resolveSibling("jfr-report-" + StringUtils.substringBefore((String)dumpPath.getFileName().toString(), (String)".jfr") + ".json");
            Files.writeString(path, (CharSequence)jfrStatsResult2.b(), StandardOpenOption.CREATE);
            SummaryReporter.a((Supplier<String>)((Supplier)() -> "Dumped recording summary to " + path));
        }
        catch (Throwable throwable2) {
            SummaryReporter.a((Supplier<String>)((Supplier)() -> "Failed to output JFR report"), throwable2);
        }
    }

    private static void a(Supplier<String> messageSupplier) {
        if (SummaryReporter.a()) {
            a.info(messageSupplier);
        } else {
            DispenserRegistry.a((String)messageSupplier.get());
        }
    }

    private static void a(Supplier<String> messageSupplier, Throwable throwable) {
        if (SummaryReporter.a()) {
            a.warn(messageSupplier, throwable);
        } else {
            DispenserRegistry.a((String)messageSupplier.get());
            throwable.printStackTrace(DispenserRegistry.a);
        }
    }

    private static boolean a() {
        LoggerContext loggerContext = LogManager.getContext();
        if (loggerContext instanceof LifeCycle) {
            LifeCycle lifeCycle = (LifeCycle)loggerContext;
            return !lifeCycle.isStopped();
        }
        return true;
    }
}

