/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class DataConverterObjectiveRenderType
extends DataFix {
    public DataConverterObjectiveRenderType(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    private static IScoreboardCriteria.EnumScoreboardHealthDisplay a(String oldName) {
        return oldName.equals("health") ? IScoreboardCriteria.EnumScoreboardHealthDisplay.b : IScoreboardCriteria.EnumScoreboardHealthDisplay.a;
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.v);
        return this.fixTypeEverywhereTyped("ObjectiveRenderTypeFix", type, typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Optional optional = dynamic.get("RenderType").asString().result();
            if (!optional.isPresent()) {
                String string = dynamic.get("CriteriaName").asString("");
                IScoreboardCriteria.EnumScoreboardHealthDisplay renderType = DataConverterObjectiveRenderType.a(string);
                return dynamic.set("RenderType", dynamic.createString(renderType.a()));
            }
            return dynamic;
        }));
    }
}

