/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.mutable.MutableInt;

public class ChunkProtoTickListFix
extends DataFix {
    private static final int a = 16;
    private static final ImmutableSet<String> b = ImmutableSet.of((Object)"minecraft:bubble_column", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant", (Object)"minecraft:seagrass", (Object)"minecraft:tall_seagrass");

    public ChunkProtoTickListFix(Schema schema) {
        super(schema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder2 = opticFinder.type().findField("Sections");
        OpticFinder opticFinder3 = ((List.ListType)opticFinder2.type()).getElement().finder();
        OpticFinder opticFinder4 = opticFinder3.type().findField("block_states");
        OpticFinder opticFinder5 = opticFinder3.type().findField("biomes");
        OpticFinder opticFinder6 = opticFinder4.type().findField("palette");
        OpticFinder opticFinder7 = opticFinder.type().findField("TileTicks");
        return this.fixTypeEverywhereTyped("ChunkProtoTickListFix", type, typed2 -> typed2.updateTyped(opticFinder, typed -> {
            typed = typed.update(DSL.remainderFinder(), dynamic -> (Dynamic)((Object)((Object)((Object)((Object)DataFixUtils.orElse(dynamic.get("LiquidTicks").result().map(dynamic2 -> dynamic.set("fluid_ticks", (Dynamic<?>)((Object)((Object)((Object)((Object)dynamic2))))).remove("LiquidTicks")), (Object)dynamic))))));
            Dynamic dynamic3 = (Dynamic)((Object)((Object)((Object)typed.get(DSL.remainderFinder()))));
            MutableInt mutableInt = new MutableInt();
            Int2ObjectArrayMap int2ObjectMap = new Int2ObjectArrayMap();
            typed.getOptionalTyped(opticFinder2).ifPresent(arg_0 -> ChunkProtoTickListFix.a(opticFinder3, opticFinder5, mutableInt, opticFinder4, (Int2ObjectMap)int2ObjectMap, opticFinder6, arg_0));
            byte b2 = mutableInt.getValue().byteValue();
            typed = typed.update(DSL.remainderFinder(), dynamic2 -> dynamic2.update("yPos", dynamic -> dynamic.createByte(b2)));
            if (typed.getOptionalTyped(opticFinder7).isPresent() || dynamic3.get("fluid_ticks").result().isPresent()) {
                return typed;
            }
            int i2 = dynamic3.get("xPos").asInt(0);
            int j2 = dynamic3.get("zPos").asInt(0);
            Dynamic<?> dynamic22 = this.a(dynamic3, (Int2ObjectMap<Supplier<a>>)int2ObjectMap, b2, i2, j2, "LiquidsToBeTicked", ChunkProtoTickListFix::b);
            Dynamic<?> dynamic32 = this.a(dynamic3, (Int2ObjectMap<Supplier<a>>)int2ObjectMap, b2, i2, j2, "ToBeTicked", ChunkProtoTickListFix::a);
            Optional optional = opticFinder7.type().readTyped(dynamic32).result();
            if (optional.isPresent()) {
                typed = typed.set(opticFinder7, (Typed)((Pair)optional.get()).getFirst());
            }
            return typed.update(DSL.remainderFinder(), dynamic2 -> dynamic2.remove("ToBeTicked").remove("LiquidsToBeTicked").set("fluid_ticks", dynamic22));
        }));
    }

    private Dynamic<?> a(Dynamic<?> dynamic2, Int2ObjectMap<Supplier<a>> int2ObjectMap, byte b2, int i3, int j2, String string, Function<Dynamic<?>, String> function) {
        Stream<Object> stream = Stream.empty();
        List list = dynamic2.get(string).asList(Function.identity());
        for (int k2 = 0; k2 < list.size(); ++k2) {
            int l2 = k2 + b2;
            Supplier supplier = (Supplier)int2ObjectMap.get(l2);
            Stream<Dynamic> stream2 = ((Dynamic)((Object)list.get(k2))).asStream().mapToInt(dynamic -> dynamic.asShort((short)-1)).filter(i2 -> i2 > 0).mapToObj(arg_0 -> this.a(dynamic2, (Supplier)supplier, i3, l2, j2, function, arg_0));
            stream = Stream.concat(stream, stream2);
        }
        return dynamic2.createList(stream);
    }

    private static String a(@Nullable Dynamic<?> dynamic) {
        return dynamic != null ? dynamic.get("Name").asString("minecraft:air") : "minecraft:air";
    }

    private static String b(@Nullable Dynamic<?> dynamic) {
        if (dynamic == null) {
            return "minecraft:empty";
        }
        String string = dynamic.get("Name").asString("");
        if ("minecraft:water".equals(string)) {
            return dynamic.get("Properties").get("level").asInt(0) == 0 ? "minecraft:water" : "minecraft:flowing_water";
        }
        if ("minecraft:lava".equals(string)) {
            return dynamic.get("Properties").get("level").asInt(0) == 0 ? "minecraft:lava" : "minecraft:flowing_lava";
        }
        if (b.contains((Object)string) || dynamic.get("Properties").get("waterlogged").asBoolean(false)) {
            return "minecraft:water";
        }
        return "minecraft:empty";
    }

    private Dynamic<?> a(Dynamic<?> dynamic, @Nullable Supplier<a> supplier, int i2, int j2, int k2, int l2, Function<Dynamic<?>, String> function) {
        int m2 = l2 & 0xF;
        int n2 = l2 >>> 4 & 0xF;
        int o2 = l2 >>> 8 & 0xF;
        String string = function.apply(supplier != null ? supplier.get().a(m2, n2, o2) : null);
        return dynamic.createMap((Map)ImmutableMap.builder().put((Object)dynamic.createString("i"), (Object)dynamic.createString(string)).put((Object)dynamic.createString("x"), (Object)dynamic.createInt(i2 * 16 + m2)).put((Object)dynamic.createString("y"), (Object)dynamic.createInt(j2 * 16 + n2)).put((Object)dynamic.createString("z"), (Object)dynamic.createInt(k2 * 16 + o2)).put((Object)dynamic.createString("t"), (Object)dynamic.createInt(0)).put((Object)dynamic.createString("p"), (Object)dynamic.createInt(0)).build());
    }

    private /* synthetic */ Dynamic a(Dynamic dynamic, Supplier supplier, int i2, int j2, int k2, Function function, int l2) {
        return this.a(dynamic, (Supplier<a>)supplier, i2, j2, k2, l2, function);
    }

    private static /* synthetic */ void a(OpticFinder opticFinder, OpticFinder opticFinder2, MutableInt mutableInt, OpticFinder opticFinder3, Int2ObjectMap int2ObjectMap, OpticFinder opticFinder4, Typed typed) {
        typed.getAllTyped(opticFinder).forEach(typed2 -> {
            Dynamic dynamic = (Dynamic)((Object)((Object)typed2.get(DSL.remainderFinder())));
            int i2 = dynamic.get("Y").asInt(Integer.MAX_VALUE);
            if (i2 == Integer.MAX_VALUE) {
                return;
            }
            if (typed2.getOptionalTyped(opticFinder2).isPresent()) {
                mutableInt.setValue(Math.min(i2, mutableInt.getValue()));
            }
            typed2.getOptionalTyped(opticFinder3).ifPresent(typed -> int2ObjectMap.put(i2, (Object)Suppliers.memoize(() -> {
                List list = typed.getOptionalTyped(opticFinder4).map(typed -> typed.write().result().map(dynamic -> dynamic.asList(Function.identity())).orElse(Collections.emptyList())).orElse(Collections.emptyList());
                long[] ls = ((Dynamic)((Object)((Object)((Object)((Object)typed.get(DSL.remainderFinder())))))).get("data").asLongStream().toArray();
                return new a(list, ls);
            })));
        });
    }

    public static final class a {
        private static final long a = 4L;
        private final List<? extends Dynamic<?>> b;
        private final long[] c;
        private final int d;
        private final long e;
        private final int f;

        public a(List<? extends Dynamic<?>> list, long[] ls) {
            this.b = list;
            this.c = ls;
            this.d = Math.max(4, ChunkHeightAndBiomeFix.a(list.size()));
            this.e = (1L << this.d) - 1L;
            this.f = (char)(64 / this.d);
        }

        @Nullable
        public Dynamic<?> a(int i2, int j2, int k2) {
            int l2 = this.b.size();
            if (l2 < 1) {
                return null;
            }
            if (l2 == 1) {
                return this.b.get(0);
            }
            int m2 = this.b(i2, j2, k2);
            int n2 = m2 / this.f;
            if (n2 < 0 || n2 >= this.c.length) {
                return null;
            }
            long o2 = this.c[n2];
            int p2 = (m2 - n2 * this.f) * this.d;
            int q2 = (int)(o2 >> p2 & this.e);
            if (q2 < 0 || q2 >= l2) {
                return null;
            }
            return this.b.get(q2);
        }

        private int b(int i2, int j2, int k2) {
            return (j2 << 4 | k2) << 4 | i2;
        }

        public List<? extends Dynamic<?>> a() {
            return this.b;
        }

        public long[] b() {
            return this.c;
        }
    }
}

