/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class ChunkHeightAndBiomeFix
extends DataFix {
    public static final String a = "__context";
    private static final String d = "ChunkHeightAndBiomeFix";
    private static final int e = 16;
    private static final int f = 24;
    private static final int g = -4;
    public static final int b = 4096;
    private static final int h = 64;
    private static final int i = 9;
    private static final long j = 511L;
    private static final int k = 64;
    private static final String[] l = new String[]{"WORLD_SURFACE_WG", "WORLD_SURFACE", "WORLD_SURFACE_IGNORE_SNOW", "OCEAN_FLOOR_WG", "OCEAN_FLOOR", "MOTION_BLOCKING", "MOTION_BLOCKING_NO_LEAVES"};
    private static final Set<String> m = Set.of("surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> n = Set.of("noise", "surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> o = Set.of("minecraft:air", "minecraft:basalt", "minecraft:bedrock", "minecraft:blackstone", "minecraft:calcite", "minecraft:cave_air", "minecraft:coarse_dirt", "minecraft:crimson_nylium", "minecraft:dirt", "minecraft:end_stone", "minecraft:grass_block", "minecraft:gravel", "minecraft:ice", "minecraft:lava", "minecraft:mycelium", "minecraft:nether_wart_block", "minecraft:netherrack", "minecraft:orange_terracotta", "minecraft:packed_ice", "minecraft:podzol", "minecraft:powder_snow", "minecraft:red_sand", "minecraft:red_sandstone", "minecraft:sand", "minecraft:sandstone", "minecraft:snow_block", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:stone", "minecraft:terracotta", "minecraft:warped_nylium", "minecraft:warped_wart_block", "minecraft:water", "minecraft:white_terracotta");
    private static final int p = 16;
    private static final int q = 64;
    private static final int r = 1008;
    public static final String c = "minecraft:plains";
    private static final Int2ObjectMap<String> s = new Int2ObjectOpenHashMap();

    public ChunkHeightAndBiomeFix(Schema schema) {
        super(schema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder2 = opticFinder.type().findField("Sections");
        Schema schema = this.getOutputSchema();
        Type type2 = schema.getType(DataConverterTypes.c);
        Type type3 = type2.findField("Level").type();
        Type type4 = type3.findField("Sections").type();
        return this.fixTypeEverywhereTyped(d, type, type2, typed -> typed.updateTyped(opticFinder, type3, typed22 -> {
            Dynamic dynamic2 = (Dynamic)((Object)((Object)((Object)typed22.get(DSL.remainderFinder()))));
            OptionalDynamic optionalDynamic = ((Dynamic)((Object)((Object)((Object)typed.get(DSL.remainderFinder()))))).get(a);
            String string = optionalDynamic.get("dimension").asString().result().orElse("");
            String string2 = optionalDynamic.get("generator").asString().result().orElse("");
            boolean bl = "minecraft:overworld".equals(string);
            MutableBoolean mutableBoolean = new MutableBoolean();
            int i2 = bl ? -4 : 0;
            Dynamic[] dynamics = ChunkHeightAndBiomeFix.a(dynamic2, bl, i2, mutableBoolean);
            Dynamic<?> dynamic22 = ChunkHeightAndBiomeFix.d(dynamic2.createList(Stream.of(dynamic2.createMap((Map)ImmutableMap.of((Object)((Object)dynamic2.createString("Name")), (Object)((Object)dynamic2.createString("minecraft:air")))))));
            HashSet set = Sets.newHashSet();
            MutableObject mutableObject = new MutableObject(() -> null);
            typed22 = typed22.updateTyped(opticFinder2, type4, typed -> {
                IntOpenHashSet intSet = new IntOpenHashSet();
                Dynamic dynamic3 = (Dynamic)((Object)((Object)((Object)((Object)typed.write().result().orElseThrow(() -> new IllegalStateException("Malformed Chunk.Level.Sections"))))));
                List list = dynamic3.asStream().map(arg_0 -> ChunkHeightAndBiomeFix.a(set, dynamic22, i2, dynamics, (IntSet)intSet, mutableObject, arg_0)).collect(Collectors.toCollection(ArrayList::new));
                for (int j2 = 0; j2 < dynamics.length; ++j2) {
                    int k2 = j2 + i2;
                    if (!intSet.add(k2)) continue;
                    Dynamic dynamic4 = dynamic2.createMap(Map.of(dynamic2.createString("Y"), dynamic2.createInt(k2)));
                    dynamic4 = dynamic4.set("block_states", dynamic22);
                    dynamic4 = dynamic4.set("biomes", dynamics[j2]);
                    list.add(dynamic4);
                }
                return (Typed)((Pair)type4.readTyped(dynamic2.createList(list.stream())).result().orElseThrow(() -> new IllegalStateException("ChunkHeightAndBiomeFix failed."))).getFirst();
            });
            return typed22.update(DSL.remainderFinder(), dynamic -> {
                if (bl) {
                    dynamic = this.a((Dynamic<?>)((Object)((Object)((Object)dynamic))), set);
                }
                return ChunkHeightAndBiomeFix.a(dynamic, bl, mutableBoolean.booleanValue(), "minecraft:noise".equals(string2), (Supplier)mutableObject.getValue());
            });
        }));
    }

    private Dynamic<?> a(Dynamic<?> dynamic2, Set<String> set) {
        return dynamic2.update("Status", dynamic -> {
            boolean bl2;
            String string = dynamic.asString("empty");
            if (m.contains(string)) {
                return dynamic;
            }
            set.remove("minecraft:air");
            boolean bl = !set.isEmpty();
            set.removeAll(o);
            boolean bl3 = bl2 = !set.isEmpty();
            if (bl2) {
                return dynamic.createString("liquid_carvers");
            }
            if ("noise".equals(string) || bl) {
                return dynamic.createString("noise");
            }
            if ("biomes".equals(string)) {
                return dynamic.createString("structure_references");
            }
            return dynamic;
        });
    }

    private static Dynamic<?>[] a(Dynamic<?> dynamic, boolean bl, int i3, MutableBoolean mutableBoolean) {
        Dynamic[] dynamics = new Dynamic[bl ? 24 : 16];
        int[] is = dynamic.get("Biomes").asIntStreamOpt().result().map(IntStream::toArray).orElse(null);
        if (is != null && is.length == 1536) {
            mutableBoolean.setValue(true);
            for (int j3 = 0; j3 < 24; ++j3) {
                int k2 = j3;
                dynamics[j3] = ChunkHeightAndBiomeFix.a(dynamic, j2 -> ChunkHeightAndBiomeFix.a(is, k2 * 64 + j2));
            }
        } else if (is != null && is.length == 1024) {
            int l2 = 0;
            while (l2 < 16) {
                int m2 = l2 - i3;
                int n2 = l2++;
                dynamics[m2] = ChunkHeightAndBiomeFix.a(dynamic, j2 -> ChunkHeightAndBiomeFix.a(is, n2 * 64 + j2));
            }
            if (bl) {
                Dynamic<?> dynamic2 = ChunkHeightAndBiomeFix.a(dynamic, i2 -> ChunkHeightAndBiomeFix.a(is, i2 % 16));
                Dynamic<?> dynamic3 = ChunkHeightAndBiomeFix.a(dynamic, i2 -> ChunkHeightAndBiomeFix.a(is, i2 % 16 + 1008));
                for (int o2 = 0; o2 < 4; ++o2) {
                    dynamics[o2] = dynamic2;
                }
                for (int p2 = 20; p2 < 24; ++p2) {
                    dynamics[p2] = dynamic3;
                }
            }
        } else {
            Arrays.fill((Object[])dynamics, ChunkHeightAndBiomeFix.d(dynamic.createList(Stream.of(dynamic.createString(c)))));
        }
        return dynamics;
    }

    private static int a(int[] is, int i2) {
        return is[i2] & 0xFF;
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, boolean bl, boolean bl2, boolean bl3, Supplier<ChunkProtoTickListFix.a> supplier) {
        Dynamic dynamic2;
        String string;
        dynamic = dynamic.remove("Biomes");
        if (!bl) {
            return ChunkHeightAndBiomeFix.a(dynamic, 16, 0);
        }
        if (bl2) {
            return ChunkHeightAndBiomeFix.a(dynamic, 24, 0);
        }
        dynamic = ChunkHeightAndBiomeFix.b(dynamic);
        dynamic = ChunkHeightAndBiomeFix.a(dynamic, "Lights");
        dynamic = ChunkHeightAndBiomeFix.a(dynamic, "LiquidsToBeTicked");
        dynamic = ChunkHeightAndBiomeFix.a(dynamic, "PostProcessing");
        dynamic = ChunkHeightAndBiomeFix.a(dynamic, "ToBeTicked");
        dynamic = ChunkHeightAndBiomeFix.a(dynamic, 24, 4);
        dynamic = dynamic.update("UpgradeData", ChunkHeightAndBiomeFix::a);
        if (!bl3) {
            return dynamic;
        }
        Optional optional = dynamic.get("Status").result();
        if (optional.isPresent() && !"empty".equals(string = (dynamic2 = (Dynamic)((Object)optional.get())).asString(""))) {
            dynamic = dynamic.set("blending_data", dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("old_noise")), (Object)((Object)dynamic.createBoolean(n.contains(string))))));
            ChunkProtoTickListFix.a poorMansPalettedContainer = supplier.get();
            if (poorMansPalettedContainer != null) {
                BitSet bitSet = new BitSet(256);
                boolean bl4 = string.equals("noise");
                for (int i2 = 0; i2 < 16; ++i2) {
                    for (int j2 = 0; j2 < 16; ++j2) {
                        boolean bl6;
                        Dynamic<?> dynamic3 = poorMansPalettedContainer.a(j2, 0, i2);
                        boolean bl5 = dynamic3 != null && "minecraft:bedrock".equals(dynamic3.get("Name").asString(""));
                        boolean bl7 = bl6 = dynamic3 != null && "minecraft:air".equals(dynamic3.get("Name").asString(""));
                        if (bl6) {
                            bitSet.set(i2 * 16 + j2);
                        }
                        bl4 |= bl5;
                    }
                }
                if (bl4 && bitSet.cardinality() != bitSet.size()) {
                    Dynamic dynamic4 = "full".equals(string) ? dynamic.createString("heightmaps") : dynamic2;
                    dynamic = dynamic.set("below_zero_retrogen", dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("target_status")), (Object)((Object)dynamic4), (Object)((Object)dynamic.createString("missing_bedrock")), (Object)((Object)dynamic.createLongList(LongStream.of(bitSet.toLongArray()))))));
                    dynamic = dynamic.set("Status", dynamic.createString("empty"));
                }
                dynamic = dynamic.set("isLightOn", dynamic.createBoolean(false));
            }
        }
        return dynamic;
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic2) {
        return dynamic2.update("Indices", dynamic -> {
            HashMap map = new HashMap();
            dynamic.getMapValues().result().ifPresent(map2 -> map2.forEach((dynamic, dynamic2) -> {
                try {
                    dynamic.asString().result().map(Integer::parseInt).ifPresent(integer -> {
                        int i2 = integer - -4;
                        map.put(dynamic.createString(Integer.toString(i2)), dynamic2);
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }));
            return dynamic.createMap(map);
        });
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, int i2, int j2) {
        Dynamic dynamic2 = dynamic.get("CarvingMasks").orElseEmptyMap();
        dynamic2 = dynamic2.updateMapValues(pair -> {
            long[] ls = BitSet.valueOf(((Dynamic)((Object)((Object)pair.getSecond()))).asByteBuffer().array()).toLongArray();
            long[] ms = new long[64 * i2];
            System.arraycopy(ls, 0, ms, 64 * j2, ls.length);
            return Pair.of((Object)((Object)((Dynamic)((Object)((Object)pair.getFirst())))), (Object)((Object)dynamic.createLongList(LongStream.of(ms))));
        });
        return dynamic.set("CarvingMasks", dynamic2);
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, String string) {
        List list = dynamic.get(string).orElseEmptyList().asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 24) {
            return dynamic;
        }
        Dynamic dynamic2 = dynamic.emptyList();
        for (int i2 = 0; i2 < 4; ++i2) {
            list.add(0, dynamic2);
            list.add(dynamic2);
        }
        return dynamic.set(string, dynamic.createList(list.stream()));
    }

    private static Dynamic<?> b(Dynamic<?> dynamic2) {
        return dynamic2.update("Heightmaps", dynamic -> {
            for (String string : l) {
                dynamic = dynamic.update(string, ChunkHeightAndBiomeFix::c);
            }
            return dynamic;
        });
    }

    private static Dynamic<?> c(Dynamic<?> dynamic) {
        return dynamic.createLongList(dynamic.asLongStream().map(l2 -> {
            long m2 = 0L;
            int i2 = 0;
            while (i2 + 9 <= 64) {
                long p2;
                long n2 = l2 >> i2 & 0x1FFL;
                if (n2 == 0L) {
                    long o2 = 0L;
                } else {
                    p2 = Math.min(n2 + 64L, 511L);
                }
                m2 |= p2 << i2;
                i2 += 9;
            }
            return m2;
        }));
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, Int2IntFunction int2IntFunction) {
        Int2IntLinkedOpenHashMap int2IntMap = new Int2IntLinkedOpenHashMap();
        for (int i2 = 0; i2 < 64; ++i2) {
            int j2 = int2IntFunction.applyAsInt(i2);
            if (int2IntMap.containsKey(j2)) continue;
            int2IntMap.put(j2, int2IntMap.size());
        }
        Dynamic dynamic2 = dynamic.createList(int2IntMap.keySet().stream().map(integer -> dynamic.createString((String)s.getOrDefault(integer.intValue(), (Object)c))));
        int k2 = ChunkHeightAndBiomeFix.a(int2IntMap.size());
        if (k2 == 0) {
            return ChunkHeightAndBiomeFix.d(dynamic2);
        }
        int l2 = 64 / k2;
        int m2 = (64 + l2 - 1) / l2;
        long[] ls = new long[m2];
        int n2 = 0;
        int o2 = 0;
        for (int p2 = 0; p2 < 64; ++p2) {
            int q2 = int2IntFunction.applyAsInt(p2);
            int n3 = n2++;
            ls[n3] = ls[n3] | (long)int2IntMap.get(q2) << o2;
            if ((o2 += k2) + k2 <= 64) continue;
            o2 = 0;
        }
        Dynamic dynamic3 = dynamic.createLongList(Arrays.stream(ls));
        return ChunkHeightAndBiomeFix.a(dynamic2, dynamic3);
    }

    private static Dynamic<?> d(Dynamic<?> dynamic) {
        return dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("palette")), dynamic));
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, Dynamic<?> dynamic2) {
        return dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("palette")), dynamic, (Object)((Object)dynamic.createString("data")), dynamic2));
    }

    private static Dynamic<?> b(Dynamic<?> dynamic, Dynamic<?> dynamic2) {
        List list = dynamic.asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 1) {
            return ChunkHeightAndBiomeFix.d(dynamic);
        }
        dynamic = ChunkHeightAndBiomeFix.a(dynamic, dynamic2, list);
        return ChunkHeightAndBiomeFix.a(dynamic, dynamic2);
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, Dynamic<?> dynamic2, List<Dynamic<?>> list) {
        int i2;
        int j2;
        long l2 = dynamic2.asLongStream().count() * 64L;
        long m2 = l2 / 4096L;
        if (m2 > (long)(j2 = ChunkHeightAndBiomeFix.a(i2 = list.size()))) {
            Dynamic dynamic3 = dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("Name")), (Object)((Object)dynamic.createString("minecraft:air"))));
            int k2 = (1 << (int)(m2 - 1L)) + 1;
            int n2 = k2 - i2;
            for (int o2 = 0; o2 < n2; ++o2) {
                list.add(dynamic3);
            }
            return dynamic.createList(list.stream());
        }
        return dynamic;
    }

    public static int a(int value) {
        if (value == 0) {
            return 0;
        }
        return (int)Math.ceil(Math.log(value) / Math.log(2.0));
    }

    private static /* synthetic */ Dynamic a(Set set, Dynamic dynamic, int i2, Dynamic[] dynamics, IntSet intSet, MutableObject mutableObject, Dynamic dynamic2) {
        int j2 = dynamic2.get("Y").asInt(0);
        Dynamic dynamic3 = (Dynamic)((Object)DataFixUtils.orElse(dynamic2.get("Palette").result().flatMap(dynamic22 -> {
            dynamic22.asStream().map(dynamic -> dynamic.get("Name").asString("minecraft:air")).forEach(set::add);
            return dynamic2.get("BlockStates").result().map(dynamic2 -> ChunkHeightAndBiomeFix.b(dynamic22, dynamic2));
        }), (Object)((Object)dynamic)));
        Dynamic dynamic4 = dynamic2;
        int k2 = j2 - i2;
        if (k2 >= 0 && k2 < dynamics.length) {
            dynamic4 = dynamic4.set("biomes", dynamics[k2]);
        }
        intSet.add(j2);
        if (dynamic2.get("Y").asInt(Integer.MAX_VALUE) == 0) {
            mutableObject.setValue(() -> {
                List list = dynamic3.get("palette").asList(Function.identity());
                long[] ls = dynamic3.get("data").asLongStream().toArray();
                return new ChunkProtoTickListFix.a(list, ls);
            });
        }
        return dynamic4.set("block_states", dynamic3).remove("Palette").remove("BlockStates");
    }

    static {
        s.put(0, (Object)"minecraft:ocean");
        s.put(1, (Object)c);
        s.put(2, (Object)"minecraft:desert");
        s.put(3, (Object)"minecraft:mountains");
        s.put(4, (Object)"minecraft:forest");
        s.put(5, (Object)"minecraft:taiga");
        s.put(6, (Object)"minecraft:swamp");
        s.put(7, (Object)"minecraft:river");
        s.put(8, (Object)"minecraft:nether_wastes");
        s.put(9, (Object)"minecraft:the_end");
        s.put(10, (Object)"minecraft:frozen_ocean");
        s.put(11, (Object)"minecraft:frozen_river");
        s.put(12, (Object)"minecraft:snowy_tundra");
        s.put(13, (Object)"minecraft:snowy_mountains");
        s.put(14, (Object)"minecraft:mushroom_fields");
        s.put(15, (Object)"minecraft:mushroom_field_shore");
        s.put(16, (Object)"minecraft:beach");
        s.put(17, (Object)"minecraft:desert_hills");
        s.put(18, (Object)"minecraft:wooded_hills");
        s.put(19, (Object)"minecraft:taiga_hills");
        s.put(20, (Object)"minecraft:mountain_edge");
        s.put(21, (Object)"minecraft:jungle");
        s.put(22, (Object)"minecraft:jungle_hills");
        s.put(23, (Object)"minecraft:jungle_edge");
        s.put(24, (Object)"minecraft:deep_ocean");
        s.put(25, (Object)"minecraft:stone_shore");
        s.put(26, (Object)"minecraft:snowy_beach");
        s.put(27, (Object)"minecraft:birch_forest");
        s.put(28, (Object)"minecraft:birch_forest_hills");
        s.put(29, (Object)"minecraft:dark_forest");
        s.put(30, (Object)"minecraft:snowy_taiga");
        s.put(31, (Object)"minecraft:snowy_taiga_hills");
        s.put(32, (Object)"minecraft:giant_tree_taiga");
        s.put(33, (Object)"minecraft:giant_tree_taiga_hills");
        s.put(34, (Object)"minecraft:wooded_mountains");
        s.put(35, (Object)"minecraft:savanna");
        s.put(36, (Object)"minecraft:savanna_plateau");
        s.put(37, (Object)"minecraft:badlands");
        s.put(38, (Object)"minecraft:wooded_badlands_plateau");
        s.put(39, (Object)"minecraft:badlands_plateau");
        s.put(40, (Object)"minecraft:small_end_islands");
        s.put(41, (Object)"minecraft:end_midlands");
        s.put(42, (Object)"minecraft:end_highlands");
        s.put(43, (Object)"minecraft:end_barrens");
        s.put(44, (Object)"minecraft:warm_ocean");
        s.put(45, (Object)"minecraft:lukewarm_ocean");
        s.put(46, (Object)"minecraft:cold_ocean");
        s.put(47, (Object)"minecraft:deep_warm_ocean");
        s.put(48, (Object)"minecraft:deep_lukewarm_ocean");
        s.put(49, (Object)"minecraft:deep_cold_ocean");
        s.put(50, (Object)"minecraft:deep_frozen_ocean");
        s.put(127, (Object)"minecraft:the_void");
        s.put(129, (Object)"minecraft:sunflower_plains");
        s.put(130, (Object)"minecraft:desert_lakes");
        s.put(131, (Object)"minecraft:gravelly_mountains");
        s.put(132, (Object)"minecraft:flower_forest");
        s.put(133, (Object)"minecraft:taiga_mountains");
        s.put(134, (Object)"minecraft:swamp_hills");
        s.put(140, (Object)"minecraft:ice_spikes");
        s.put(149, (Object)"minecraft:modified_jungle");
        s.put(151, (Object)"minecraft:modified_jungle_edge");
        s.put(155, (Object)"minecraft:tall_birch_forest");
        s.put(156, (Object)"minecraft:tall_birch_hills");
        s.put(157, (Object)"minecraft:dark_forest_hills");
        s.put(158, (Object)"minecraft:snowy_taiga_mountains");
        s.put(160, (Object)"minecraft:giant_spruce_taiga");
        s.put(161, (Object)"minecraft:giant_spruce_taiga_hills");
        s.put(162, (Object)"minecraft:modified_gravelly_mountains");
        s.put(163, (Object)"minecraft:shattered_savanna");
        s.put(164, (Object)"minecraft:shattered_savanna_plateau");
        s.put(165, (Object)"minecraft:eroded_badlands");
        s.put(166, (Object)"minecraft:modified_wooded_badlands_plateau");
        s.put(167, (Object)"minecraft:modified_badlands_plateau");
        s.put(168, (Object)"minecraft:bamboo_jungle");
        s.put(169, (Object)"minecraft:bamboo_jungle_hills");
        s.put(170, (Object)"minecraft:soul_sand_valley");
        s.put(171, (Object)"minecraft:crimson_forest");
        s.put(172, (Object)"minecraft:warped_forest");
        s.put(173, (Object)"minecraft:basalt_deltas");
        s.put(174, (Object)"minecraft:dripstone_caves");
        s.put(175, (Object)"minecraft:lush_caves");
        s.put(177, (Object)"minecraft:meadow");
        s.put(178, (Object)"minecraft:grove");
        s.put(179, (Object)"minecraft:snowy_slopes");
        s.put(180, (Object)"minecraft:snowcapped_peaks");
        s.put(181, (Object)"minecraft:lofty_peaks");
        s.put(182, (Object)"minecraft:stony_peaks");
    }
}

