/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Random;
import java.util.UUID;
import java.util.function.IntPredicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.math.NumberUtils;

public class MathHelper {
    private static final int h = 1024;
    private static final float i = 1024.0f;
    private static final long j = 61440L;
    private static final long k = 16384L;
    private static final long l = -4611686018427387904L;
    private static final long m = Long.MIN_VALUE;
    public static final float a = (float)Math.PI;
    public static final float b = 1.5707964f;
    public static final float c = (float)Math.PI * 2;
    public static final float d = (float)Math.PI / 180;
    public static final float e = 57.295776f;
    public static final float f = 1.0E-5f;
    public static final float g = MathHelper.c(2.0f);
    private static final float n = 10430.378f;
    private static final float[] o = SystemUtils.a(new float[65536], sineTable -> {
        for (int i2 = 0; i2 < ((float[])sineTable).length; ++i2) {
            sineTable[i2] = (float)Math.sin((double)i2 * Math.PI * 2.0 / 65536.0);
        }
    });
    private static final Random p = new Random();
    private static final int[] q = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    private static final double r = 0.16666666666666666;
    private static final int s = 8;
    private static final int t = 257;
    private static final double u = Double.longBitsToDouble(4805340802404319232L);
    private static final double[] v = new double[257];
    private static final double[] w = new double[257];

    public static float a(float value) {
        return o[(int)(value * 10430.378f) & 0xFFFF];
    }

    public static float b(float value) {
        return o[(int)(value * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float c(float value) {
        return (float)Math.sqrt(value);
    }

    public static int d(float value) {
        int i2 = (int)value;
        return value < (float)i2 ? i2 - 1 : i2;
    }

    public static int a(double value) {
        return (int)(value + 1024.0) - 1024;
    }

    public static int b(double value) {
        int i2 = (int)value;
        return value < (double)i2 ? i2 - 1 : i2;
    }

    public static long c(double value) {
        long l2 = (long)value;
        return value < (double)l2 ? l2 - 1L : l2;
    }

    public static int d(double value) {
        return (int)(value >= 0.0 ? value : -value + 1.0);
    }

    public static float e(float value) {
        return Math.abs(value);
    }

    public static int a(int value) {
        return Math.abs(value);
    }

    public static int f(float value) {
        int i2 = (int)value;
        return value > (float)i2 ? i2 + 1 : i2;
    }

    public static int e(double value) {
        int i2 = (int)value;
        return value > (double)i2 ? i2 + 1 : i2;
    }

    public static byte a(byte value, byte min, byte max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int a(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static long a(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float a(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double a(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double b(double start, double end, double delta) {
        if (delta < 0.0) {
            return start;
        }
        if (delta > 1.0) {
            return end;
        }
        return MathHelper.d(delta, start, end);
    }

    public static float b(float start, float end, float delta) {
        if (delta < 0.0f) {
            return start;
        }
        if (delta > 1.0f) {
            return end;
        }
        return MathHelper.i(delta, start, end);
    }

    public static double a(double a2, double b2) {
        if (a2 < 0.0) {
            a2 = -a2;
        }
        if (b2 < 0.0) {
            b2 = -b2;
        }
        return a2 > b2 ? a2 : b2;
    }

    public static int a(int dividend, int divisor) {
        return Math.floorDiv(dividend, divisor);
    }

    public static int a(Random random, int min, int max) {
        if (min >= max) {
            return min;
        }
        return random.nextInt(max - min + 1) + min;
    }

    public static float a(Random random, float min, float max) {
        if (min >= max) {
            return min;
        }
        return random.nextFloat() * (max - min) + min;
    }

    public static double a(Random random, double min, double max) {
        if (min >= max) {
            return min;
        }
        return random.nextDouble() * (max - min) + min;
    }

    public static double a(long[] array) {
        long l2 = 0L;
        for (long m2 : array) {
            l2 += m2;
        }
        return (double)l2 / (double)array.length;
    }

    public static boolean a(float a2, float b2) {
        return Math.abs(b2 - a2) < 1.0E-5f;
    }

    public static boolean b(double a2, double b2) {
        return Math.abs(b2 - a2) < (double)1.0E-5f;
    }

    public static int b(int dividend, int divisor) {
        return Math.floorMod(dividend, divisor);
    }

    public static float b(float dividend, float divisor) {
        return (dividend % divisor + divisor) % divisor;
    }

    public static double c(double dividend, double divisor) {
        return (dividend % divisor + divisor) % divisor;
    }

    public static int b(int degrees) {
        int i2 = degrees % 360;
        if (i2 >= 180) {
            i2 -= 360;
        }
        if (i2 < -180) {
            i2 += 360;
        }
        return i2;
    }

    public static float g(float degrees) {
        float f2 = degrees % 360.0f;
        if (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        if (f2 < -180.0f) {
            f2 += 360.0f;
        }
        return f2;
    }

    public static double f(double degrees) {
        double d2 = degrees % 360.0;
        if (d2 >= 180.0) {
            d2 -= 360.0;
        }
        if (d2 < -180.0) {
            d2 += 360.0;
        }
        return d2;
    }

    public static float c(float start, float end) {
        return MathHelper.g(end - start);
    }

    public static float d(float first, float second) {
        return MathHelper.e(MathHelper.c(first, second));
    }

    public static float c(float value, float mean, float delta) {
        float f2 = MathHelper.c(value, mean);
        float g2 = MathHelper.a(f2, -delta, delta);
        return mean - g2;
    }

    public static float d(float from, float to, float step) {
        step = MathHelper.e(step);
        if (from < to) {
            return MathHelper.a(from + step, from, to);
        }
        return MathHelper.a(from - step, to, from);
    }

    public static float e(float from, float to, float step) {
        float f2 = MathHelper.c(from, to);
        return MathHelper.d(from, from + f2, step);
    }

    public static int a(String string, int fallback) {
        return NumberUtils.toInt((String)string, (int)fallback);
    }

    public static int a(String string, int fallback, int min) {
        return Math.max(min, MathHelper.a(string, fallback));
    }

    public static double a(String string, double fallback) {
        try {
            return Double.parseDouble(string);
        }
        catch (Throwable throwable) {
            return fallback;
        }
    }

    public static double a(String string, double fallback, double min) {
        return Math.max(min, MathHelper.a(string, fallback));
    }

    public static int c(int value) {
        int i2 = value - 1;
        i2 |= i2 >> 1;
        i2 |= i2 >> 2;
        i2 |= i2 >> 4;
        i2 |= i2 >> 8;
        i2 |= i2 >> 16;
        return i2 + 1;
    }

    public static boolean d(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int e(int value) {
        value = MathHelper.d(value) ? value : MathHelper.c(value);
        return q[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static int f(int value) {
        return MathHelper.e(value) - (MathHelper.d(value) ? 0 : 1);
    }

    public static int f(float r2, float g2, float b2) {
        return MathHelper.b(MathHelper.d(r2 * 255.0f), MathHelper.d(g2 * 255.0f), MathHelper.d(b2 * 255.0f));
    }

    public static int b(int r2, int g2, int b2) {
        int i2 = r2;
        i2 = (i2 << 8) + g2;
        i2 = (i2 << 8) + b2;
        return i2;
    }

    public static int c(int a2, int b2) {
        int i2 = (a2 & 0xFF0000) >> 16;
        int j2 = (b2 & 0xFF0000) >> 16;
        int k2 = (a2 & 0xFF00) >> 8;
        int l2 = (b2 & 0xFF00) >> 8;
        int m2 = (a2 & 0xFF) >> 0;
        int n2 = (b2 & 0xFF) >> 0;
        int o2 = (int)((float)i2 * (float)j2 / 255.0f);
        int p2 = (int)((float)k2 * (float)l2 / 255.0f);
        int q2 = (int)((float)m2 * (float)n2 / 255.0f);
        return a2 & 0xFF000000 | o2 << 16 | p2 << 8 | q2;
    }

    public static int a(int color, float r2, float g2, float b2) {
        int i2 = (color & 0xFF0000) >> 16;
        int j2 = (color & 0xFF00) >> 8;
        int k2 = (color & 0xFF) >> 0;
        int l2 = (int)((float)i2 * r2);
        int m2 = (int)((float)j2 * g2);
        int n2 = (int)((float)k2 * b2);
        return color & 0xFF000000 | l2 << 16 | m2 << 8 | n2;
    }

    public static float h(float value) {
        return value - (float)MathHelper.d(value);
    }

    public static double g(double value) {
        return value - (double)MathHelper.c(value);
    }

    public static Vec3D a(Vec3D vec3, Vec3D vec32, Vec3D vec33, Vec3D vec34, double d2) {
        double e2 = ((-d2 + 2.0) * d2 - 1.0) * d2 * 0.5;
        double f2 = ((3.0 * d2 - 5.0) * d2 * d2 + 2.0) * 0.5;
        double g2 = ((-3.0 * d2 + 4.0) * d2 + 1.0) * d2 * 0.5;
        double h2 = (d2 - 1.0) * d2 * d2 * 0.5;
        return new Vec3D(vec3.b * e2 + vec32.b * f2 + vec33.b * g2 + vec34.b * h2, vec3.c * e2 + vec32.c * f2 + vec33.c * g2 + vec34.c * h2, vec3.d * e2 + vec32.d * f2 + vec33.d * g2 + vec34.d * h2);
    }

    public static long a(BaseBlockPosition vec) {
        return MathHelper.c(vec.u(), vec.v(), vec.w());
    }

    public static long c(int x2, int y2, int z2) {
        long l2 = (long)(x2 * 3129871) ^ (long)z2 * 116129781L ^ (long)y2;
        l2 = l2 * l2 * 42317861L + l2 * 11L;
        return l2 >> 16;
    }

    public static UUID a(Random random) {
        long l2 = random.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long m2 = random.nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(l2, m2);
    }

    public static UUID a() {
        return MathHelper.a(p);
    }

    public static double c(double value, double start, double end) {
        return (value - start) / (end - start);
    }

    public static float g(float value, float start, float end) {
        return (value - start) / (end - start);
    }

    public static boolean a(Vec3D vec3, Vec3D vec32, AxisAlignedBB aABB) {
        double d2 = (aABB.a + aABB.d) * 0.5;
        double e2 = (aABB.d - aABB.a) * 0.5;
        double f2 = vec3.b - d2;
        if (Math.abs(f2) > e2 && f2 * vec32.b >= 0.0) {
            return false;
        }
        double g2 = (aABB.b + aABB.e) * 0.5;
        double h2 = (aABB.e - aABB.b) * 0.5;
        double i2 = vec3.c - g2;
        if (Math.abs(i2) > h2 && i2 * vec32.c >= 0.0) {
            return false;
        }
        double j2 = (aABB.c + aABB.f) * 0.5;
        double k2 = (aABB.f - aABB.c) * 0.5;
        double l2 = vec3.d - j2;
        if (Math.abs(l2) > k2 && l2 * vec32.d >= 0.0) {
            return false;
        }
        double m2 = Math.abs(vec32.b);
        double n2 = Math.abs(vec32.c);
        double o2 = Math.abs(vec32.d);
        double p2 = vec32.c * l2 - vec32.d * i2;
        if (Math.abs(p2) > h2 * o2 + k2 * n2) {
            return false;
        }
        p2 = vec32.d * f2 - vec32.b * l2;
        if (Math.abs(p2) > e2 * o2 + k2 * m2) {
            return false;
        }
        p2 = vec32.b * i2 - vec32.c * f2;
        return Math.abs(p2) < e2 * n2 + h2 * m2;
    }

    public static double d(double y2, double x2) {
        boolean bl3;
        boolean bl2;
        boolean bl;
        double d2 = x2 * x2 + y2 * y2;
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        boolean bl4 = bl = y2 < 0.0;
        if (bl) {
            y2 = -y2;
        }
        boolean bl5 = bl2 = x2 < 0.0;
        if (bl2) {
            x2 = -x2;
        }
        boolean bl6 = bl3 = y2 > x2;
        if (bl3) {
            double e2 = x2;
            x2 = y2;
            y2 = e2;
        }
        double f2 = MathHelper.h(d2);
        x2 *= f2;
        double g2 = u + (y2 *= f2);
        int i2 = (int)Double.doubleToRawLongBits(g2);
        double h2 = v[i2];
        double j2 = w[i2];
        double k2 = g2 - u;
        double l2 = y2 * j2 - x2 * k2;
        double m2 = (6.0 + l2 * l2) * l2 * 0.16666666666666666;
        double n2 = h2 + m2;
        if (bl3) {
            n2 = 1.5707963267948966 - n2;
        }
        if (bl2) {
            n2 = Math.PI - n2;
        }
        if (bl) {
            n2 = -n2;
        }
        return n2;
    }

    public static float i(float x2) {
        float f2 = 0.5f * x2;
        int i2 = Float.floatToIntBits(x2);
        i2 = 1597463007 - (i2 >> 1);
        x2 = Float.intBitsToFloat(i2);
        x2 *= 1.5f - f2 * x2 * x2;
        return x2;
    }

    public static double h(double x2) {
        double d2 = 0.5 * x2;
        long l2 = Double.doubleToRawLongBits(x2);
        l2 = 6910469410427058090L - (l2 >> 1);
        x2 = Double.longBitsToDouble(l2);
        x2 *= 1.5 - d2 * x2 * x2;
        return x2;
    }

    public static float j(float x2) {
        int i2 = Float.floatToIntBits(x2);
        i2 = 1419967116 - i2 / 3;
        float f2 = Float.intBitsToFloat(i2);
        f2 = 0.6666667f * f2 + 1.0f / (3.0f * f2 * f2 * x2);
        f2 = 0.6666667f * f2 + 1.0f / (3.0f * f2 * f2 * x2);
        return f2;
    }

    /*
     * WARNING - void declaration
     */
    public static int h(float hue, float saturation, float value) {
        void ae;
        void ad;
        void ac;
        int i2 = (int)(hue * 6.0f) % 6;
        float f2 = hue * 6.0f - (float)i2;
        float g2 = value * (1.0f - saturation);
        float h2 = value * (1.0f - f2 * saturation);
        float j2 = value * (1.0f - (1.0f - f2) * saturation);
        switch (i2) {
            case 0: {
                float k2 = value;
                float l2 = j2;
                float m2 = g2;
                break;
            }
            case 1: {
                float n2 = h2;
                float o2 = value;
                float p2 = g2;
                break;
            }
            case 2: {
                float q2 = g2;
                float r2 = value;
                float s2 = j2;
                break;
            }
            case 3: {
                float t2 = g2;
                float u2 = h2;
                float v2 = value;
                break;
            }
            case 4: {
                float w2 = j2;
                float x2 = g2;
                float y2 = value;
                break;
            }
            case 5: {
                float z2 = value;
                float aa2 = g2;
                float ab = h2;
                break;
            }
            default: {
                throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
            }
        }
        int af = MathHelper.a((int)(ac * 255.0f), 0, 255);
        int ag = MathHelper.a((int)(ad * 255.0f), 0, 255);
        int ah = MathHelper.a((int)(ae * 255.0f), 0, 255);
        return af << 16 | ag << 8 | ah;
    }

    public static int g(int value) {
        value ^= value >>> 16;
        value *= -2048144789;
        value ^= value >>> 13;
        value *= -1028477387;
        value ^= value >>> 16;
        return value;
    }

    public static long a(long value) {
        value ^= value >>> 33;
        value *= -49064778989728563L;
        value ^= value >>> 33;
        value *= -4265267296055464877L;
        value ^= value >>> 33;
        return value;
    }

    public static double[] a(double ... values) {
        float f2 = 0.0f;
        for (double d2 : values) {
            f2 = (float)((double)f2 + d2);
        }
        int i2 = 0;
        while (i2 < values.length) {
            int n2 = i2++;
            values[n2] = values[n2] / (double)f2;
        }
        for (int j2 = 0; j2 < values.length; ++j2) {
            values[j2] = (j2 == 0 ? 0.0 : values[j2 - 1]) + values[j2];
        }
        return values;
    }

    public static int a(Random random, double[] ds) {
        double d2 = random.nextDouble();
        for (int i2 = 0; i2 < ds.length; ++i2) {
            if (!(d2 < ds[i2])) continue;
            return i2;
        }
        return ds.length;
    }

    public static double[] a(double d2, double e2, double f2, int i2, int j2) {
        double[] ds = new double[j2 - i2 + 1];
        int k2 = 0;
        for (int l2 = i2; l2 <= j2; ++l2) {
            ds[k2] = Math.max(0.0, d2 * StrictMath.exp(-((double)l2 - f2) * ((double)l2 - f2) / (2.0 * e2 * e2)));
            ++k2;
        }
        return ds;
    }

    public static double[] a(double d2, double e2, double f2, double g2, double h2, double i2, int j2, int k2) {
        double[] ds = new double[k2 - j2 + 1];
        int l2 = 0;
        for (int m2 = j2; m2 <= k2; ++m2) {
            ds[l2] = Math.max(0.0, d2 * StrictMath.exp(-((double)m2 - f2) * ((double)m2 - f2) / (2.0 * e2 * e2)) + g2 * StrictMath.exp(-((double)m2 - i2) * ((double)m2 - i2) / (2.0 * h2 * h2)));
            ++l2;
        }
        return ds;
    }

    public static double[] a(double d2, double e2, int i2, int j2) {
        double[] ds = new double[j2 - i2 + 1];
        int k2 = 0;
        for (int l2 = i2; l2 <= j2; ++l2) {
            ds[k2] = Math.max(d2 * StrictMath.log(l2) + e2, 0.0);
            ++k2;
        }
        return ds;
    }

    public static int a(int start, int end, IntPredicate leftPredicate) {
        int i2 = end - start;
        while (i2 > 0) {
            int j2 = i2 / 2;
            int k2 = start + j2;
            if (leftPredicate.test(k2)) {
                i2 = j2;
                continue;
            }
            start = k2 + 1;
            i2 -= j2 + 1;
        }
        return start;
    }

    public static float i(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    public static double d(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public static double a(double deltaX, double deltaY, double x0y0, double x1y0, double x0y1, double x1y1) {
        return MathHelper.d(deltaY, MathHelper.d(deltaX, x0y0, x1y0), MathHelper.d(deltaX, x0y1, x1y1));
    }

    public static double a(double deltaX, double deltaY, double deltaZ, double x0y0z0, double x1y0z0, double x0y1z0, double x1y1z0, double x0y0z1, double x1y0z1, double x0y1z1, double x1y1z1) {
        return MathHelper.d(deltaZ, MathHelper.a(deltaX, deltaY, x0y0z0, x1y0z0, x0y1z0, x1y1z0), MathHelper.a(deltaX, deltaY, x0y0z1, x1y0z1, x0y1z1, x1y1z1));
    }

    public static double i(double value) {
        return value * value * value * (value * (value * 6.0 - 15.0) + 10.0);
    }

    public static double j(double value) {
        return 30.0 * value * value * (value - 1.0) * (value - 1.0);
    }

    public static int k(double value) {
        if (value == 0.0) {
            return 0;
        }
        return value > 0.0 ? 1 : -1;
    }

    public static float j(float delta, float start, float end) {
        return start + delta * MathHelper.g(end - start);
    }

    public static float k(float f2, float g2, float h2) {
        return Math.min(f2 * f2 * 0.6f + g2 * g2 * ((3.0f + g2) / 4.0f) + h2 * h2 * 0.8f, 1.0f);
    }

    @Deprecated
    public static float l(float start, float end, float delta) {
        float f2;
        for (f2 = end - start; f2 < -180.0f; f2 += 360.0f) {
        }
        while (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        return start + delta * f2;
    }

    @Deprecated
    public static float l(double degrees) {
        while (degrees >= 180.0) {
            degrees -= 360.0;
        }
        while (degrees < -180.0) {
            degrees += 360.0;
        }
        return (float)degrees;
    }

    public static float e(float value, float maxDeviation) {
        return (Math.abs(value % maxDeviation - maxDeviation * 0.5f) - maxDeviation * 0.25f) / (maxDeviation * 0.25f);
    }

    public static float k(float n2) {
        return n2 * n2;
    }

    public static double m(double n2) {
        return n2 * n2;
    }

    public static int h(int n2) {
        return n2 * n2;
    }

    public static long b(long n2) {
        return n2 * n2;
    }

    public static double a(double lerpValue, double lerpStart, double lerpEnd, double start, double end) {
        return MathHelper.b(start, end, MathHelper.c(lerpValue, lerpStart, lerpEnd));
    }

    public static float a(float lerpValue, float lerpStart, float lerpEnd, float start, float end) {
        return MathHelper.b(start, end, MathHelper.g(lerpValue, lerpStart, lerpEnd));
    }

    public static double b(double lerpValue, double lerpStart, double lerpEnd, double start, double end) {
        return MathHelper.d(MathHelper.c(lerpValue, lerpStart, lerpEnd), start, end);
    }

    public static float b(float lerpValue, float lerpStart, float lerpEnd, float start, float end) {
        return MathHelper.i(MathHelper.g(lerpValue, lerpStart, lerpEnd), start, end);
    }

    public static double n(double d2) {
        return d2 + (2.0 * new Random(MathHelper.b(d2 * 3000.0)).nextDouble() - 1.0) * 1.0E-7 / 2.0;
    }

    public static int d(int value, int divisor) {
        return MathHelper.e(value, divisor) * divisor;
    }

    public static int e(int a2, int b2) {
        return -Math.floorDiv(-a2, b2);
    }

    public static int b(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float b(Random random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static float c(Random random, float mean, float deviation) {
        return mean + (float)random.nextGaussian() * deviation;
    }

    public static double e(double a2, double b2) {
        return Math.sqrt(a2 * a2 + b2 * b2);
    }

    public static double e(double a2, double b2, double c2) {
        return Math.sqrt(a2 * a2 + b2 * b2 + c2 * c2);
    }

    public static int a(double a2, int b2) {
        return MathHelper.b(a2 / (double)b2) * b2;
    }

    static {
        for (int i2 = 0; i2 < 257; ++i2) {
            double d2 = (double)i2 / 256.0;
            double e2 = Math.asin(d2);
            MathHelper.w[i2] = Math.cos(e2);
            MathHelper.v[i2] = e2;
        }
    }
}

