/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;

public final class InclusiveRange<T extends Comparable<T>>
extends Record {
    private final T b;
    private final T c;
    public static final Codec<InclusiveRange<Integer>> a = InclusiveRange.a(Codec.INT);

    public InclusiveRange(T minInclusive, T maxInclusive) {
        if (minInclusive.compareTo(maxInclusive) > 0) {
            throw new IllegalArgumentException("min_inclusive must be less than or equal to max_inclusive");
        }
        this.b = minInclusive;
        this.c = maxInclusive;
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> a(Codec<T> elementCodec) {
        return ExtraCodecs.a(elementCodec, "min_inclusive", "max_inclusive", InclusiveRange::a, InclusiveRange::a, InclusiveRange::b);
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> a(Codec<T> codec, T minInclusive, T maxInclusive) {
        Function<InclusiveRange, DataResult> function = range -> {
            if (range.a().compareTo(minInclusive) < 0) {
                return DataResult.error((String)("Range limit too low, expected at least " + minInclusive + " [" + range.a() + "-" + range.b() + "]"));
            }
            if (range.b().compareTo(maxInclusive) > 0) {
                return DataResult.error((String)("Range limit too high, expected at most " + maxInclusive + " [" + range.a() + "-" + range.b() + "]"));
            }
            return DataResult.success((Object)range);
        };
        return InclusiveRange.a(codec).flatXmap(function, function);
    }

    public static <T extends Comparable<T>> DataResult<InclusiveRange<T>> a(T minInclusive, T maxInclusive) {
        if (minInclusive.compareTo(maxInclusive) <= 0) {
            return DataResult.success(new InclusiveRange<T>(minInclusive, maxInclusive));
        }
        return DataResult.error((String)"min_inclusive must be less than or equal to max_inclusive");
    }

    public boolean a(T value) {
        return value.compareTo(this.b) >= 0 && value.compareTo(this.c) <= 0;
    }

    public boolean a(InclusiveRange<T> other) {
        return other.a().compareTo(this.b) >= 0 && other.c.compareTo(this.c) <= 0;
    }

    @Override
    @Override
    public String toString() {
        return "[" + this.b + ", " + this.c + "]";
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InclusiveRange.class, "minInclusive;maxInclusive", "b", "c"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InclusiveRange.class, "minInclusive;maxInclusive", "b", "c"}, this, object);
    }

    public T a() {
        return this.b;
    }

    public T b() {
        return this.c;
    }
}

