/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.util.FormattedStringEmpty;
import net.minecraft.util.StringDecomposer;

@FunctionalInterface
public interface FormattedString {
    public static final FormattedString a = formattedCharSink -> true;

    public boolean accept(FormattedStringEmpty var1);

    public static FormattedString codepoint(int codePoint, ChatModifier style) {
        return visitor -> visitor.accept(0, style, codePoint);
    }

    public static FormattedString forward(String string, ChatModifier style) {
        if (string.isEmpty()) {
            return a;
        }
        return visitor -> StringDecomposer.a(string, style, visitor);
    }

    public static FormattedString forward(String string, ChatModifier style, Int2IntFunction codePointMapper) {
        if (string.isEmpty()) {
            return a;
        }
        return visitor -> StringDecomposer.a(string, style, FormattedString.decorateOutput(visitor, codePointMapper));
    }

    public static FormattedString backward(String string, ChatModifier style) {
        if (string.isEmpty()) {
            return a;
        }
        return visitor -> StringDecomposer.b(string, style, visitor);
    }

    public static FormattedString backward(String string, ChatModifier style, Int2IntFunction codePointMapper) {
        if (string.isEmpty()) {
            return a;
        }
        return visitor -> StringDecomposer.b(string, style, FormattedString.decorateOutput(visitor, codePointMapper));
    }

    public static FormattedStringEmpty decorateOutput(FormattedStringEmpty visitor, Int2IntFunction codePointMapper) {
        return (charIndex, style, charPoint) -> visitor.accept(charIndex, style, (Integer)codePointMapper.apply((Object)charPoint));
    }

    public static FormattedString composite() {
        return a;
    }

    public static FormattedString composite(FormattedString text) {
        return text;
    }

    public static FormattedString composite(FormattedString first, FormattedString second) {
        return FormattedString.fromPair(first, second);
    }

    public static FormattedString composite(FormattedString ... texts) {
        return FormattedString.fromList((List<FormattedString>)ImmutableList.copyOf((Object[])texts));
    }

    public static FormattedString composite(List<FormattedString> texts) {
        int i2 = texts.size();
        switch (i2) {
            case 0: {
                return a;
            }
            case 1: {
                return texts.get(0);
            }
            case 2: {
                return FormattedString.fromPair(texts.get(0), texts.get(1));
            }
        }
        return FormattedString.fromList((List<FormattedString>)ImmutableList.copyOf(texts));
    }

    public static FormattedString fromPair(FormattedString text1, FormattedString text2) {
        return visitor -> text1.accept(visitor) && text2.accept(visitor);
    }

    public static FormattedString fromList(List<FormattedString> texts) {
        return visitor -> {
            for (FormattedString formattedCharSequence : texts) {
                if (formattedCharSequence.accept(visitor)) continue;
                return false;
            }
            return true;
        };
    }
}

