/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import org.apache.commons.lang3.mutable.MutableObject;

public class ExtraCodecs {
    public static final Codec<Integer> a = ExtraCodecs.a(0, Integer.MAX_VALUE, (Integer v2) -> "Value must be non-negative: " + v2);
    public static final Codec<Integer> b = ExtraCodecs.a(1, Integer.MAX_VALUE, (Integer v2) -> "Value must be positive: " + v2);
    public static final Codec<Float> c = ExtraCodecs.a(0.0f, Float.MAX_VALUE, (Float v2) -> "Value must be positive: " + v2);

    public static <F, S> Codec<Either<F, S>> a(Codec<F> first, Codec<S> second) {
        return new c<F, S>(first, second);
    }

    public static <P, I> Codec<I> a(Codec<P> codec, String leftFieldName, String rightFieldName, BiFunction<P, P, DataResult<I>> combineFunction, Function<I, P> leftFunction, Function<I, P> rightFunction) {
        Codec codec2 = Codec.list(codec).comapFlatMap(list2 -> SystemUtils.a(list2, 2).flatMap(list -> {
            Object object = list.get(0);
            Object object2 = list.get(1);
            return (DataResult)combineFunction.apply(object, object2);
        }), object -> ImmutableList.of(leftFunction.apply(object), rightFunction.apply(object)));
        Codec codec3 = RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf(leftFieldName).forGetter(Pair::getFirst), (App)codec.fieldOf(rightFieldName).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).comapFlatMap(pair -> (DataResult)combineFunction.apply(pair.getFirst(), pair.getSecond()), object -> Pair.of(leftFunction.apply(object), rightFunction.apply(object)));
        Codec codec4 = new a(codec2, codec3).xmap(either -> either.map(object -> object, object -> object), Either::left);
        return Codec.either(codec, (Codec)codec4).comapFlatMap(either -> either.map(object -> (DataResult)combineFunction.apply(object, object), DataResult::success), object -> {
            Object object3;
            Object object2 = leftFunction.apply(object);
            if (Objects.equals(object2, object3 = rightFunction.apply(object))) {
                return Either.left(object2);
            }
            return Either.right(object);
        });
    }

    public static <A> Codec.ResultFunction<A> a(final A object) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> dynamicOps, T object2, DataResult<Pair<A, T>> dataResult) {
                MutableObject mutableObject = new MutableObject();
                Optional optional = dataResult.resultOrPartial(arg_0 -> ((MutableObject)mutableObject).setValue(arg_0));
                if (optional.isPresent()) {
                    return dataResult;
                }
                return DataResult.error((String)("(" + (String)mutableObject.getValue() + " -> using default)"), (Object)Pair.of((Object)object, object2));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, A object2, DataResult<T> dataResult) {
                return dataResult;
            }

            @Override
            public String toString() {
                return "OrElsePartial[" + object + "]";
            }
        };
    }

    public static <E> Codec<E> a(ToIntFunction<E> toIntFunction, IntFunction<E> intFunction, int i2) {
        return Codec.INT.flatXmap(integer -> Optional.ofNullable(intFunction.apply((int)integer)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element id: " + integer))), object -> {
            int j2 = toIntFunction.applyAsInt(object);
            return j2 == i2 ? DataResult.error((String)("Element with unknown id: " + object)) : DataResult.success((Object)j2);
        });
    }

    public static <E> Codec<E> a(Function<E, String> function, Function<String, E> function2) {
        return Codec.STRING.flatXmap(string -> Optional.ofNullable(function2.apply((String)string)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element name:" + string))), object -> Optional.ofNullable((String)function.apply(object)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Element with unknown name: " + object))));
    }

    public static <E> Codec<E> b(final Codec<E> codec, final Codec<E> codec2) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E object, DynamicOps<T> dynamicOps, T object2) {
                if (dynamicOps.compressMaps()) {
                    return codec2.encode(object, dynamicOps, object2);
                }
                return codec.encode(object, dynamicOps, object2);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> dynamicOps, T object) {
                if (dynamicOps.compressMaps()) {
                    return codec2.decode(dynamicOps, object);
                }
                return codec.decode(dynamicOps, object);
            }

            @Override
            public String toString() {
                return codec + " orCompressed " + codec2;
            }
        };
    }

    public static <E> Codec<E> a(Codec<E> codec, final Function<E, Lifecycle> function, final Function<E, Lifecycle> function2) {
        return codec.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> dynamicOps, T object, DataResult<Pair<E, T>> dataResult) {
                return dataResult.result().map(pair -> dataResult.setLifecycle((Lifecycle)function.apply(pair.getFirst()))).orElse(dataResult);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, E object, DataResult<T> dataResult) {
                return dataResult.setLifecycle((Lifecycle)function2.apply(object));
            }

            @Override
            public String toString() {
                return "WithLifecycle[" + function + " " + function2 + "]";
            }
        });
    }

    private static <N extends Number> Function<N, DataResult<N>> a(N min, N max, Function<N, String> messageFactory) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(min) >= 0 && ((Comparable)((Object)value)).compareTo(max) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error((String)((String)messageFactory.apply(value)));
        };
    }

    private static Codec<Integer> a(int min, int max, Function<Integer, String> messageFactory) {
        Function<Integer, DataResult<Integer>> function = ExtraCodecs.a(Integer.valueOf(min), Integer.valueOf(max), messageFactory);
        return Codec.INT.flatXmap(function, function);
    }

    private static <N extends Number> Function<N, DataResult<N>> b(N min, N max, Function<N, String> messageFactory) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(min) > 0 && ((Comparable)((Object)value)).compareTo(max) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error((String)((String)messageFactory.apply(value)));
        };
    }

    private static Codec<Float> a(float min, float max, Function<Float, String> messageFactory) {
        Function<Float, DataResult<Float>> function = ExtraCodecs.b(Float.valueOf(min), Float.valueOf(max), messageFactory);
        return Codec.FLOAT.flatXmap(function, function);
    }

    public static <T> Function<List<T>, DataResult<List<T>>> a() {
        return list -> {
            if (list.isEmpty()) {
                return DataResult.error((String)"List must have contents");
            }
            return DataResult.success((Object)list);
        };
    }

    public static <T> Codec<List<T>> a(Codec<List<T>> originalCodec) {
        return originalCodec.flatXmap(ExtraCodecs.a(), ExtraCodecs.a());
    }

    public static <T> Function<List<Supplier<T>>, DataResult<List<Supplier<T>>>> b() {
        return suppliers -> {
            ArrayList list = Lists.newArrayList();
            for (int i2 = 0; i2 < suppliers.size(); ++i2) {
                Supplier supplier = (Supplier)suppliers.get(i2);
                try {
                    if (supplier.get() != null) continue;
                    list.add("Missing value [" + i2 + "] : " + supplier);
                    continue;
                }
                catch (Exception exception) {
                    list.add("Invalid value [" + i2 + "]: " + supplier + ", message: " + exception.getMessage());
                }
            }
            if (!list.isEmpty()) {
                return DataResult.error((String)String.join((CharSequence)"; ", list));
            }
            return DataResult.success((Object)suppliers, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <T> Function<Supplier<T>, DataResult<Supplier<T>>> c() {
        return supplier -> {
            try {
                if (supplier.get() == null) {
                    return DataResult.error((String)("Missing value: " + supplier));
                }
            }
            catch (Exception exception) {
                return DataResult.error((String)("Invalid value: " + supplier + ", message: " + exception.getMessage()));
            }
            return DataResult.success((Object)supplier, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> a(Supplier<Codec<A>> supplier) {
        return new b<A>(supplier);
    }

    static final class c<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> a;
        private final Codec<S> b;

        public c(Codec<F> first, Codec<S> second) {
            this.a = first;
            this.b = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            DataResult dataResult = this.a.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::left));
            DataResult dataResult2 = this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::right));
            Optional optional = dataResult.result();
            Optional optional2 = dataResult2.result();
            if (optional.isPresent() && optional2.isPresent()) {
                return DataResult.error((String)("Both alternatives read successfully, can not pick the correct one; first: " + optional.get() + " second: " + optional2.get()), (Object)((Pair)optional.get()));
            }
            return optional.isPresent() ? dataResult : dataResult2;
        }

        public <T> DataResult<T> a(Either<F, S> either, DynamicOps<T> dynamicOps, T object) {
            return either.map(left -> this.a.encode(left, dynamicOps, object), right -> this.b.encode(right, dynamicOps, object));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            c xorCodec = (c)object;
            return Objects.equals(this.a, xorCodec.a) && Objects.equals(this.b, xorCodec.b);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        @Override
        public String toString() {
            return "XorCodec[" + this.a + ", " + this.b + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Either)object, dynamicOps, object2);
        }
    }

    static final class a<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> a;
        private final Codec<S> b;

        public a(Codec<F> first, Codec<S> second) {
            this.a = first;
            this.b = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            DataResult dataResult = this.a.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::left));
            if (!dataResult.error().isPresent()) {
                return dataResult;
            }
            DataResult dataResult2 = this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::right));
            if (!dataResult2.error().isPresent()) {
                return dataResult2;
            }
            return dataResult.apply2((pair, pair2) -> pair2, dataResult2);
        }

        public <T> DataResult<T> a(Either<F, S> either, DynamicOps<T> dynamicOps, T object) {
            return either.map(left -> this.a.encode(left, dynamicOps, object), right -> this.b.encode(right, dynamicOps, object));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            a eitherCodec = (a)object;
            return Objects.equals(this.a, eitherCodec.a) && Objects.equals(this.b, eitherCodec.b);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        @Override
        public String toString() {
            return "EitherCodec[" + this.a + ", " + this.b + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Either)object, dynamicOps, object2);
        }
    }

    record b<A>(Supplier<Codec<A>> a) implements Codec<A>
    {
        b(Supplier<Codec<A>> supplier) {
            this.a = supplier = Suppliers.memoize(() -> supplier.get());
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> dynamicOps, T object) {
            return this.a.get().decode(dynamicOps, object);
        }

        public <T> DataResult<T> encode(A object, DynamicOps<T> dynamicOps, T object2) {
            return this.a.get().encode(object, dynamicOps, object2);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "delegate", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "delegate", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "delegate", "a"}, this, object);
        }
    }
}

