/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.ITagRegistry;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagStatic;
import net.minecraft.tags.TagUtil;
import net.minecraft.tags.Tags;
import net.minecraft.tags.TagsInstance;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagRegistry
implements IReloadListener {
    private static final Logger a = LogManager.getLogger();
    private final IRegistryCustom b;
    private ITagRegistry c = ITagRegistry.a;

    public TagRegistry(IRegistryCustom registryManager) {
        this.b = registryManager;
    }

    public ITagRegistry a() {
        return this.c;
    }

    @Override
    @Override
    public CompletableFuture<Void> a(IReloadListener.a synchronizer, IResourceManager manager, GameProfilerFiller prepareProfiler, GameProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        ArrayList list = Lists.newArrayList();
        TagStatic.a((TagUtil<?> requiredTagList) -> {
            a loaderInfo = this.a(manager, prepareExecutor, (TagUtil)requiredTagList);
            if (loaderInfo != null) {
                list.add(loaderInfo);
            }
        });
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])list.stream().map(requiredGroup -> requiredGroup.b).toArray(CompletableFuture[]::new)).thenCompose(synchronizer::a)).thenAcceptAsync(void_ -> {
            ITagRegistry.a builder = new ITagRegistry.a();
            list.forEach(requiredGroup -> requiredGroup.a(builder));
            ITagRegistry tagContainer = builder.a();
            Multimap<ResourceKey<? extends IRegistry<?>>, MinecraftKey> multimap = TagStatic.b(tagContainer);
            if (!multimap.isEmpty()) {
                throw new IllegalStateException("Missing required tags: " + multimap.entries().stream().map(entry -> entry.getKey() + ":" + entry.getValue()).sorted().collect(Collectors.joining(",")));
            }
            TagsInstance.a(tagContainer);
            this.c = tagContainer;
        }, applyExecutor);
    }

    @Nullable
    private <T> a<T> a(IResourceManager resourceManager, Executor prepareExecutor, TagUtil<T> requirement) {
        Optional<IRegistry<T>> optional = this.b.c(requirement.c());
        if (optional.isPresent()) {
            IRegistry<T> registry = optional.get();
            TagDataPack tagLoader = new TagDataPack(registry::b, requirement.d());
            CompletableFuture<Tags> completableFuture = CompletableFuture.supplyAsync(() -> tagLoader.b(resourceManager), prepareExecutor);
            return new a<T>(requirement, completableFuture);
        }
        a.warn("Can't find registry for {}", requirement.c());
        return null;
    }

    static class a<T> {
        private final TagUtil<T> a;
        final CompletableFuture<? extends Tags<T>> b;

        a(TagUtil<T> requirement, CompletableFuture<? extends Tags<T>> groupLoadFuture) {
            this.a = requirement;
            this.b = groupLoadFuture;
        }

        public void a(ITagRegistry.a builder) {
            builder.a(this.a.c(), this.b.join());
        }
    }
}

