/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagStatic;
import net.minecraft.tags.Tags;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ITagRegistry {
    static final Logger b = LogManager.getLogger();
    public static final ITagRegistry a = new ITagRegistry((Map<ResourceKey<? extends IRegistry<?>>, Tags<?>>)ImmutableMap.of());
    private final Map<ResourceKey<? extends IRegistry<?>>, Tags<?>> c;

    ITagRegistry(Map<ResourceKey<? extends IRegistry<?>>, Tags<?>> tagGroups) {
        this.c = tagGroups;
    }

    @Nullable
    private <T> Tags<T> b(ResourceKey<? extends IRegistry<T>> registryKey) {
        return this.c.get(registryKey);
    }

    public <T> Tags<T> a(ResourceKey<? extends IRegistry<T>> registryKey) {
        return this.c.getOrDefault(registryKey, Tags.c());
    }

    public <T, E extends Exception> Tag<T> a(ResourceKey<? extends IRegistry<T>> registryKey, MinecraftKey id, Function<MinecraftKey, E> exceptionFactory) throws E {
        Tags<T> tagCollection = this.b(registryKey);
        if (tagCollection == null) {
            throw (Exception)exceptionFactory.apply(id);
        }
        Tag<T> tag = tagCollection.a(id);
        if (tag == null) {
            throw (Exception)exceptionFactory.apply(id);
        }
        return tag;
    }

    public <T, E extends Exception> MinecraftKey a(ResourceKey<? extends IRegistry<T>> registryKey, Tag<T> tag, Supplier<E> exceptionSupplier) throws E {
        Tags<T> tagCollection = this.b(registryKey);
        if (tagCollection == null) {
            throw (Exception)exceptionSupplier.get();
        }
        MinecraftKey resourceLocation = tagCollection.a(tag);
        if (resourceLocation == null) {
            throw (Exception)exceptionSupplier.get();
        }
        return resourceLocation;
    }

    public void a(b visitor) {
        this.c.forEach((type, group) -> ITagRegistry.a(visitor, type, group));
    }

    private static <T> void a(b visitor, ResourceKey<? extends IRegistry<?>> type, Tags<?> group) {
        visitor.accept(type, group);
    }

    public void a() {
        TagStatic.a(this);
        Blocks.a();
    }

    public Map<ResourceKey<? extends IRegistry<?>>, Tags.a> a(final IRegistryCustom registryManager) {
        final HashMap map = Maps.newHashMap();
        this.a(new b(){

            @Override
            @Override
            public <T> void accept(ResourceKey<? extends IRegistry<T>> type, Tags<T> group) {
                Optional optional = registryManager.c(type);
                if (optional.isPresent()) {
                    map.put(type, group.a(optional.get()));
                } else {
                    b.error("Unknown registry {}", type);
                }
            }
        });
        return map;
    }

    public static ITagRegistry a(IRegistryCustom registryManager, Map<ResourceKey<? extends IRegistry<?>>, Tags.a> groups) {
        a builder = new a();
        groups.forEach((type, group) -> ITagRegistry.a(registryManager, builder, type, group));
        return builder.a();
    }

    private static <T> void a(IRegistryCustom registryManager, a builder, ResourceKey<? extends IRegistry<? extends T>> type, Tags.a group) {
        Optional optional = registryManager.c(type);
        if (optional.isPresent()) {
            builder.a(type, Tags.a(group, optional.get()));
        } else {
            b.error("Unknown registry {}", type);
        }
    }

    @FunctionalInterface
    static interface b {
        public <T> void accept(ResourceKey<? extends IRegistry<T>> var1, Tags<T> var2);
    }

    public static class a {
        private final ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, Tags<?>> a = ImmutableMap.builder();

        public <T> a a(ResourceKey<? extends IRegistry<? extends T>> type, Tags<T> tagGroup) {
            this.a.put(type, tagGroup);
            return this;
        }

        public ITagRegistry a() {
            return new ITagRegistry((Map<ResourceKey<? extends IRegistry<?>>, Tags<?>>)this.a.build());
        }
    }
}

