/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import co.aikar.timings.MinecraftTimings;
import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.console.TerminalConsoleCommandSender;
import com.destroystokyo.paper.event.player.PlayerInitialSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.adventure.PaperAdventure;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutTags;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.spigotmc.SpigotConfig;

public abstract class PlayerList {
    public static final File b = new File("banned-players.json");
    public static final File c = new File("banned-ips.json");
    public static final File d = new File("ops.json");
    public static final File e = new File("whitelist.json");
    private static final Logger a = LogManager.getLogger();
    private static final int g = 600;
    private static final SimpleDateFormat h = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer i;
    public final List<EntityPlayer> j = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> k = Maps.newHashMap();
    private final GameProfileBanList l;
    private final IpBanList m;
    private final OpList n;
    private final WhiteList o;
    private final Map<UUID, EntityPlayer> pendingPlayers = Maps.newHashMap();
    public final WorldNBTStorage r;
    private boolean s;
    private final IRegistryCustom.Dimension t;
    protected int f;
    private int u;
    private int v;
    private boolean w;
    private static final boolean x = false;
    private int y;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();
    @Nullable
    public String collideRuleTeamName;

    public final void setMaxPlayers(int maxPlayers) {
        this.f = maxPlayers;
    }

    public PlayerList(MinecraftServer server, IRegistryCustom.Dimension registryManager, WorldNBTStorage saveHandler, int maxPlayers) {
        this.cserver = server.server = new CraftServer((DedicatedServer)server, this);
        server.console = new TerminalConsoleCommandSender();
        this.l = new GameProfileBanList(b);
        this.m = new IpBanList(c);
        this.n = new OpList(d);
        this.o = new WhiteList(e);
        this.i = server;
        this.t = registryManager;
        this.f = maxPlayers;
        this.r = saveHandler;
    }

    public abstract void loadAndSaveFiles();

    public void a(NetworkManager connection, EntityPlayer player) {
        WorldServer worldserver1;
        ResourceKey<net.minecraft.world.level.World> resourcekey;
        player.isRealPlayer = true;
        EntityPlayer prev = this.pendingPlayers.put(player.cm(), player);
        if (prev != null) {
            this.disconnectPendingPlayer(prev);
        }
        player.networkManager = connection;
        player.loginTime = System.currentTimeMillis();
        GameProfile gameprofile = player.fp();
        UserCache usercache = this.i.ao();
        Optional<GameProfile> optional = usercache.a(gameprofile.getId());
        String s2 = optional.map(GameProfile::getName).orElse(gameprofile.getName());
        usercache.a(gameprofile);
        NBTTagCompound nbttagcompound = this.a(player);
        if (nbttagcompound != null && nbttagcompound.e("bukkit")) {
            NBTTagCompound bukkit = nbttagcompound.p("bukkit");
            s2 = bukkit.b("lastKnownName", 8) ? bukkit.l("lastKnownName") : s2;
        }
        String lastKnownName = s2;
        if (nbttagcompound != null && nbttagcompound.e("WorldUUIDMost") && nbttagcompound.e("WorldUUIDLeast")) {
            UUID uid = new UUID(nbttagcompound.i("WorldUUIDMost"), nbttagcompound.i("WorldUUIDLeast"));
            World bWorld = Bukkit.getServer().getWorld(uid);
            resourcekey = bWorld != null ? ((CraftWorld)bWorld).getHandle().aa() : net.minecraft.world.level.World.f;
        } else if (nbttagcompound != null) {
            DataResult<ResourceKey<net.minecraft.world.level.World>> dataresult = DimensionManager.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbttagcompound.c("Dimension")));
            Logger logger = a;
            Objects.requireNonNull(logger);
            resourcekey = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(net.minecraft.world.level.World.f);
        } else {
            resourcekey = net.minecraft.world.level.World.f;
        }
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = resourcekey;
        WorldServer worldserver = this.i.a(resourcekey1);
        if (worldserver == null) {
            a.warn("Unknown respawn dimension {}, defaulting to overworld", resourcekey1);
            worldserver1 = this.i.D();
        } else {
            worldserver1 = worldserver;
        }
        if (nbttagcompound == null) {
            player.d(worldserver1);
        }
        player.c(worldserver1);
        String s1 = connection.c() != null ? (PaperConfig.logPlayerIpAddresses ? connection.c().toString() : "<ip address withheld>") : "local";
        CraftPlayer spawnPlayer = player.getBukkitEntity();
        PlayerInitialSpawnEvent ev = new PlayerInitialSpawnEvent((Player)spawnPlayer, spawnPlayer.getLocation());
        this.cserver.getPluginManager().callEvent((Event)ev);
        Location loc = ev.getSpawnLocation();
        worldserver1 = ((CraftWorld)loc.getWorld()).getHandle();
        player.spawnIn(worldserver1);
        player.d.a((WorldServer)player.t);
        player.o(loc.getX(), loc.getY(), loc.getZ());
        player.a(loc.getYaw(), loc.getPitch());
        WorldData worlddata = worldserver1.n_();
        player.c(nbttagcompound);
        PlayerConnection playerconnection = new PlayerConnection(this.i, connection, player);
        GameRules gamerules = worldserver1.X();
        boolean flag = gamerules.b(GameRules.A);
        boolean flag1 = gamerules.b(GameRules.p);
        playerconnection.a(new PacketPlayOutLogin(player.ae(), worlddata.n(), player.d.b(), player.d.c(), this.i.E(), this.t, worldserver1.q_(), worldserver1.aa(), BiomeManager.a(worldserver1.E()), this.n(), worldserver1.spigotConfig.viewDistance, worldserver1.spigotConfig.simulationDistance, flag1, !flag, worldserver1.ad(), worldserver1.D()));
        player.getBukkitEntity().sendSupportedChannels();
        playerconnection.a(new PacketPlayOutCustomPayload(PacketPlayOutCustomPayload.a, new PacketDataSerializer(Unpooled.buffer()).a(this.c().getServerModName())));
        playerconnection.a(new PacketPlayOutServerDifficulty(worlddata.s(), worlddata.t()));
        playerconnection.a(new PacketPlayOutAbilities(player.fr()));
        playerconnection.a(new PacketPlayOutHeldItemSlot(player.fq().k));
        playerconnection.a(new PacketPlayOutRecipeUpdate(this.i.aC().b()));
        playerconnection.a(new PacketPlayOutTags(this.i.aD().a(this.t)));
        this.d(player);
        player.D().c();
        player.E().a(player);
        this.a(worldserver1.f(), player);
        this.i.aq();
        WorldServer finalWorldserver = worldserver1;
        int chunkX = loc.getBlockX() >> 4;
        int chunkZ = loc.getBlockZ() >> 4;
        ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
        PlayerChunkMap playerChunkMap = worldserver1.k().a;
        PlayerChunkMap.ChunkDistanceManager distanceManager = playerChunkMap.D;
        distanceManager.addTicketAtLevel(TicketType.LOGIN, pos, 31, pos.a());
        worldserver1.k().markAreaHighPriority(pos, 28, 3);
        ((CompletableFuture)worldserver1.k().getChunkAtAsynchronously(chunkX, chunkZ, true, false).thenApply(chunk -> {
            PlayerChunk updatingChunk = playerChunkMap.a(pos.a());
            if (updatingChunk != null) {
                return updatingChunk.b();
            }
            return CompletableFuture.completedFuture(chunk);
        })).thenAccept(chunk -> {
            playerconnection.playerJoinReady = () -> this.postChunkLoadJoin(player, finalWorldserver, connection, playerconnection, nbttagcompound, s1, lastKnownName);
        });
    }

    public EntityPlayer getActivePlayer(UUID uuid) {
        EntityPlayer player = this.k.get(uuid);
        return player != null ? player : this.pendingPlayers.get(uuid);
    }

    void disconnectPendingPlayer(EntityPlayer entityplayer) {
        ChatMessage msg = new ChatMessage("multiplayer.disconnect.duplicate_login", new Object[0]);
        entityplayer.networkManager.a(new PacketPlayOutKickDisconnect(msg), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> {
            entityplayer.networkManager.a(msg);
            entityplayer.networkManager = null;
        }));
    }

    private void postChunkLoadJoin(EntityPlayer player, WorldServer worldserver1, NetworkManager networkmanager, PlayerConnection playerconnection, NBTTagCompound nbttagcompound, String s1, String s2) {
        this.pendingPlayers.remove(player.cm(), player);
        if (!networkmanager.h()) {
            return;
        }
        player.didPlayerJoinEvent = true;
        ChatMessage chatmessage = player.fp().getName().equalsIgnoreCase(s2) ? new ChatMessage("multiplayer.player.joined", player.C_()) : new ChatMessage("multiplayer.player.joined.renamed", player.C_(), s2);
        chatmessage.a(EnumChatFormat.o);
        IChatBaseComponent joinMessage = chatmessage;
        playerconnection.b(player.dc(), player.de(), player.di(), player.dm(), player.dn());
        this.j.add(player);
        this.playersByName.put(player.co().toLowerCase(Locale.ROOT), player);
        this.k.put(player.cm(), player);
        player.supressTrackerForLogin = true;
        worldserver1.c(player);
        this.i.aK().a(player);
        this.mountSavedVehicle(player, worldserver1, nbttagcompound);
        CraftPlayer bukkitPlayer = player.getBukkitEntity();
        player.bW.transferTo(player.bW, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, PaperAdventure.asAdventure(chatmessage));
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!player.b.a.h()) {
            return;
        }
        Component jm = playerJoinEvent.joinMessage();
        if (jm != null && !jm.equals(Component.empty())) {
            joinMessage = PaperAdventure.asVanilla(jm);
            this.i.ac().a(joinMessage, ChatMessageType.b, SystemUtils.b);
        }
        PacketPlayOutPlayerInfo packet = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, player);
        for (int i2 = 0; i2 < this.j.size(); ++i2) {
            EntityPlayer entityplayer1 = this.j.get(i2);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                entityplayer1.b.a(packet);
            }
            if (!bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            player.b.a(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, entityplayer1));
        }
        player.sentListPacket = true;
        player.supressTrackerForLogin = false;
        ((WorldServer)player.t).k().a.a((Entity)player);
        player.b.a(new PacketPlayOutEntityMetadata(player.ae(), player.ai(), true));
        if (player.t == worldserver1 && !worldserver1.z().contains(player)) {
            worldserver1.c(player);
            this.i.aK().a(player);
        }
        worldserver1 = player.x();
        this.a(player, worldserver1);
        if (!this.i.S().isEmpty()) {
            player.a(this.i.S(), this.i.T(), this.i.aW(), this.i.aZ());
        }
        for (MobEffect mobeffect : player.dW()) {
            playerconnection.a(new PacketPlayOutEntityEffect(player.ae(), mobeffect));
        }
        this.onPlayerJoinFinish(player, worldserver1, s1);
    }

    private void mountSavedVehicle(EntityPlayer player, WorldServer worldserver1, NBTTagCompound nbttagcompound) {
        if (nbttagcompound != null && nbttagcompound.b("RootVehicle", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.p("RootVehicle");
            WorldServer finalWorldServer = worldserver1;
            Entity entity = EntityTypes.a(nbttagcompound1.p("Entity"), finalWorldServer, entity1 -> !finalWorldServer.addWithUUID((Entity)entity1, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity1);
            if (entity != null) {
                UUID uuid = nbttagcompound1.b("Attach") ? nbttagcompound1.a("Attach") : null;
                if (entity.cm().equals(uuid)) {
                    player.a(entity, true);
                } else {
                    for (Entity entity12 : entity.cJ()) {
                        if (!entity12.cm().equals(uuid)) continue;
                        player.a(entity12, true);
                        break;
                    }
                }
                if (!player.bF()) {
                    a.warn("Couldn't reattach entity to player");
                    entity.ah();
                    for (Entity entity12 : entity.cJ()) {
                        entity12.ah();
                    }
                }
            }
        }
    }

    public void onPlayerJoinFinish(EntityPlayer player, WorldServer worldserver1, String s1) {
        player.g();
        ScoreboardServer scoreboard = this.c().a(net.minecraft.world.level.World.f).f();
        ScoreboardTeam collideRuleTeam = scoreboard.f(this.collideRuleTeamName);
        if (this.collideRuleTeamName != null && collideRuleTeam != null && player.bW() == null) {
            ((Scoreboard)scoreboard).a(player.co(), collideRuleTeam);
        }
        a.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", (Object)player.X().getString(), (Object)s1, (Object)player.ae(), (Object)worldserver1.N.g(), (Object)player.dc(), (Object)player.de(), (Object)player.di());
    }

    public void a(ScoreboardServer scoreboard, EntityPlayer player) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam scoreboardteam : scoreboard.g()) {
            player.b.a(PacketPlayOutScoreboardTeam.a(scoreboardteam, true));
        }
        for (int i2 = 0; i2 < 19; ++i2) {
            ScoreboardObjective scoreboardobjective = scoreboard.a(i2);
            if (scoreboardobjective == null || set.contains(scoreboardobjective)) continue;
            List<Packet<?>> list = scoreboard.d(scoreboardobjective);
            for (Packet<?> packet : list) {
                player.b.a(packet);
            }
            set.add(scoreboardobjective);
        }
    }

    public void a(WorldServer world) {
        if (this.r != null) {
            return;
        }
        world.p_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder border, double size) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double fromSize, double toSize, long time) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double centerX, double centerZ) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderCenterPacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, int warningTime) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, int warningBlockDistance) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(WorldBorder border, double safeZoneRadius) {
            }
        });
    }

    @Nullable
    public NBTTagCompound a(EntityPlayer player) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = this.i.aU().y();
        if (player.X().getString().equals(this.i.N()) && nbttagcompound != null) {
            nbttagcompound1 = nbttagcompound;
            player.g(nbttagcompound);
            a.debug("loading single player");
        } else {
            nbttagcompound1 = this.r.b(player);
        }
        return nbttagcompound1;
    }

    protected void b(EntityPlayer player) {
        AdvancementDataPlayer advancementdataplayer;
        if (!player.getBukkitEntity().isPersistent()) {
            return;
        }
        if (!player.didPlayerJoinEvent) {
            return;
        }
        player.lastSave = MinecraftServer.currentTick;
        this.r.a(player);
        ServerStatisticManager serverstatisticmanager = player.D();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.a();
        }
        if ((advancementdataplayer = player.M()) != null) {
            advancementdataplayer.b();
        }
    }

    public Component remove(EntityPlayer entityplayer) {
        return this.remove(entityplayer, (Component)Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{PaperConfig.useDisplayNameInQuit ? entityplayer.getBukkitEntity().displayName() : Component.text((String)entityplayer.co())}));
    }

    public Component remove(EntityPlayer entityplayer, Component leaveMessage) {
        Entity entity;
        WorldServer worldserver = entityplayer.x();
        entityplayer.a(StatisticList.j);
        if (entityplayer.bW != entityplayer.bV) {
            entityplayer.closeContainer(InventoryCloseEvent.Reason.DISCONNECT);
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)entityplayer.getBukkitEntity(), leaveMessage, entityplayer.quitReason);
        if (entityplayer.didPlayerJoinEvent) {
            this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        }
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        if (this.i.bl()) {
            entityplayer.l();
        }
        if (this.collideRuleTeamName != null) {
            ScoreboardServer scoreBoard = this.i.a(net.minecraft.world.level.World.f).f();
            ScoreboardTeam team = scoreBoard.i(this.collideRuleTeamName);
            if (entityplayer.bW() == team && team != null) {
                ((Scoreboard)scoreBoard).b(entityplayer.co(), team);
            }
        }
        if (!entityplayer.bW.g().b()) {
            ItemStack carried = entityplayer.bW.g();
            entityplayer.bW.b(ItemStack.b);
            entityplayer.a(carried, false);
        }
        this.b(entityplayer);
        if (entityplayer.bF() && (entity = entityplayer.cL()).cK()) {
            a.debug("Removing player mount");
            entityplayer.p();
            entity.cI().forEach(entity1 -> {
                EntityVillagerAbstract villager;
                EntityHuman human;
                if (entity1 instanceof EntityVillagerAbstract && (human = (villager = (EntityVillagerAbstract)entity1).fy()) != null) {
                    villager.f((EntityHuman)null);
                }
                entity1.b(Entity.RemovalReason.d);
            });
        }
        entityplayer.ab();
        worldserver.a(entityplayer, Entity.RemovalReason.d);
        entityplayer.M().a();
        this.j.remove(entityplayer);
        this.playersByName.remove(entityplayer.co().toLowerCase(Locale.ROOT));
        this.i.aK().b(entityplayer);
        UUID uuid = entityplayer.cm();
        EntityPlayer entityplayer1 = this.k.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.k.remove(uuid);
        }
        if ((entityplayer1 = this.pendingPlayers.get(uuid)) == entityplayer) {
            this.pendingPlayers.remove(uuid);
        }
        entityplayer.networkManager = null;
        PacketPlayOutPlayerInfo packet = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, entityplayer);
        for (int i2 = 0; i2 < this.j.size(); ++i2) {
            EntityPlayer entityplayer2 = this.j.get(i2);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.b.a(packet);
                continue;
            }
            entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return entityplayer.didPlayerJoinEvent ? playerQuitEvent.quitMessage() : null;
    }

    public EntityPlayer canPlayerLogin(LoginListener loginlistener, GameProfile gameprofile, String hostname) {
        GameProfileBanEntry gameprofilebanentry;
        EntityPlayer entityplayer2;
        UUID uuid = EntityHuman.a(gameprofile);
        ArrayList list = Lists.newArrayList();
        for (int i2 = 0; i2 < this.j.size(); ++i2) {
            entityplayer2 = this.j.get(i2);
            if (!entityplayer2.cm().equals(uuid) && (!PaperConfig.isProxyOnlineMode() || !entityplayer2.fp().getName().equalsIgnoreCase(gameprofile.getName()))) continue;
            list.add(entityplayer2);
        }
        entityplayer2 = this.pendingPlayers.get(uuid);
        if (entityplayer2 != null) {
            this.pendingPlayers.remove(uuid);
            this.disconnectPendingPlayer(entityplayer2);
        }
        for (EntityPlayer entityplayer2 : list) {
            this.b(entityplayer2);
            entityplayer2.b.disconnect(new ChatMessage("multiplayer.disconnect.duplicate_login", new Object[0]), PlayerKickEvent.Cause.DUPLICATE_LOGIN);
        }
        SocketAddress socketaddress = loginlistener.a.c();
        EntityPlayer entity = new EntityPlayer(this.i, this.i.a(net.minecraft.world.level.World.f), gameprofile);
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)player, hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.a.getRawAddress()).getAddress());
        if (this.f().a(gameprofile) && (gameprofilebanentry = (GameProfileBanEntry)this.f().b(gameprofile)) != null) {
            ChatMessage chatmessage = new ChatMessage("multiplayer.disconnect.banned.reason", gameprofilebanentry.d());
            if (gameprofilebanentry.c() != null) {
                chatmessage.a(new ChatMessage("multiplayer.disconnect.banned.expiration", h.format(gameprofilebanentry.c())));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(chatmessage));
        } else if (this.isWhitelisted(gameprofile, event)) {
            if (this.g().a(socketaddress) && this.g().b(socketaddress) != null && !this.g().b(socketaddress).f()) {
                IpBanEntry ipbanentry = this.m.b(socketaddress);
                ChatMessage chatmessage = new ChatMessage("multiplayer.disconnect.banned_ip.reason", ipbanentry.d());
                if (ipbanentry.c() != null) {
                    chatmessage.a(new ChatMessage("multiplayer.disconnect.banned_ip.expiration", h.format(ipbanentry.c())));
                }
                event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(chatmessage));
            } else if (this.j.size() >= this.f && !this.d(gameprofile)) {
                event.disallow(PlayerLoginEvent.Result.KICK_FULL, (Component)PaperAdventure.LEGACY_SECTION_UXRC.deserialize(SpigotConfig.serverFullMessage));
            }
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.b(PaperAdventure.asVanilla(event.kickMessage()));
            return null;
        }
        return entity;
    }

    public EntityPlayer getPlayerForLogin(GameProfile gameprofile, EntityPlayer player) {
        return player;
    }

    public EntityPlayer a(EntityPlayer player, boolean alive) {
        return this.respawn(player, this.i.a(player.P()), alive, null, true);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, WorldServer worldserver, boolean flag, Location location, boolean avoidSuffocation) {
        return this.respawn(entityplayer, worldserver, flag, location, avoidSuffocation, new PlayerRespawnEvent.RespawnFlag[0]);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, WorldServer worldserver, boolean flag, Location location, boolean avoidSuffocation, PlayerRespawnEvent.RespawnFlag ... respawnFlags) {
        WorldServer worldserver1;
        entityplayer.p();
        this.j.remove(entityplayer);
        this.playersByName.remove(entityplayer.co().toLowerCase(Locale.ROOT));
        entityplayer.x().a(entityplayer, Entity.RemovalReason.b);
        BlockPosition blockposition = entityplayer.N();
        float f2 = entityplayer.O();
        boolean flag1 = entityplayer.Q();
        EntityPlayer entityplayer1 = entityplayer;
        World fromWorld = entityplayer.getBukkitEntity().getWorld();
        entityplayer.f = false;
        entityplayer1.b = entityplayer.b;
        entityplayer1.a(entityplayer, flag);
        entityplayer1.e(entityplayer.ae());
        entityplayer1.a(entityplayer.eK());
        for (String s2 : entityplayer.af()) {
            entityplayer1.a(s2);
        }
        boolean flag2 = false;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        boolean isRespawn = false;
        boolean isLocAltered = false;
        if (location == null) {
            worldserver1 = this.i.a(entityplayer.P());
            if (worldserver1 != null) {
                Optional<Object> optional = blockposition != null ? EntityHuman.a(worldserver1, blockposition, f2, flag1, true) : Optional.empty();
                if (optional.isPresent()) {
                    float f1;
                    boolean flag3;
                    IBlockData iblockdata = worldserver1.a_(blockposition);
                    isAnchorSpawn = flag3 = iblockdata.a(Blocks.nx);
                    Vec3D vec3d = (Vec3D)optional.get();
                    if (!iblockdata.a(TagsBlock.L) && !flag3) {
                        f1 = f2;
                    } else {
                        Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                        f1 = (float)MathHelper.f(MathHelper.d(vec3d1.d, vec3d1.b) * 57.2957763671875 - 90.0);
                    }
                    entityplayer1.setRespawnPosition(worldserver1.aa(), blockposition, f2, flag1, false, PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN);
                    flag2 = !flag && flag3;
                    isBedSpawn = true;
                    location = new Location((World)worldserver1.getWorld(), vec3d.b, vec3d.c, vec3d.d, f1, 0.0f);
                } else if (blockposition != null) {
                    entityplayer1.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.a, 0.0f));
                    entityplayer1.a(null, null, 0.0f, false, false);
                }
            }
            if (location == null) {
                worldserver1 = this.i.a(net.minecraft.world.level.World.f);
                blockposition = entityplayer1.getSpawnPoint(worldserver1);
                location = new Location((World)worldserver1.getWorld(), (double)((float)blockposition.u() + 0.5f), (double)((float)blockposition.v() + 0.1f), (double)((float)blockposition.w() + 0.5f), worldserver1.x.d(), 0.0f);
            }
            CraftPlayer respawnPlayer = entityplayer1.getBukkitEntity();
            PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn && !isAnchorSpawn, isAnchorSpawn, ImmutableSet.builder().add((Object[])respawnFlags));
            this.cserver.getPluginManager().callEvent((Event)respawnEvent);
            if (entityplayer.b.isDisconnected()) {
                return entityplayer;
            }
            if (!location.equals((Object)respawnEvent.getRespawnLocation())) {
                location = respawnEvent.getRespawnLocation();
                isLocAltered = true;
            }
            if (!flag) {
                entityplayer.reset();
            }
            isRespawn = true;
        } else {
            location.setWorld((World)worldserver.getWorld());
        }
        worldserver1 = ((CraftWorld)location.getWorld()).getHandle();
        entityplayer1.forceSetPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        worldserver1.k().a(TicketType.g, new ChunkCoordIntPair(location.getBlockX() >> 4, location.getBlockZ() >> 4), 1, entityplayer.ae());
        while (avoidSuffocation && !worldserver1.noCollision(entityplayer1, entityplayer1.cw(), true) && entityplayer1.de() < (double)worldserver1.ag()) {
            entityplayer1.e(entityplayer1.dc(), entityplayer1.de() + 1.0, entityplayer1.di());
        }
        WorldData worlddata = worldserver1.n_();
        entityplayer1.b.a(new PacketPlayOutRespawn(worldserver1.q_(), worldserver1.aa(), BiomeManager.a(worldserver1.E()), entityplayer1.d.b(), entityplayer1.d.c(), worldserver1.ad(), worldserver1.D(), flag));
        entityplayer1.b.a(new PacketPlayOutViewDistance(worldserver1.spigotConfig.viewDistance));
        entityplayer1.b.a(new ClientboundSetSimulationDistancePacket(worldserver1.spigotConfig.simulationDistance));
        entityplayer1.spawnIn(worldserver1);
        entityplayer1.dq();
        entityplayer1.b.teleport(new Location((World)worldserver1.getWorld(), entityplayer1.dc(), entityplayer1.de(), entityplayer1.di(), entityplayer1.dm(), entityplayer1.dn()));
        entityplayer1.f(false);
        entityplayer1.b.a(new PacketPlayOutSpawnPosition(worldserver1.w(), worldserver1.x()));
        entityplayer1.b.a(new PacketPlayOutServerDifficulty(worlddata.s(), worlddata.t()));
        entityplayer1.b.a(new PacketPlayOutExperience(entityplayer1.cl, entityplayer1.ck, entityplayer1.cj));
        this.a(entityplayer1, worldserver1);
        this.d(entityplayer1);
        if (!entityplayer.b.isDisconnected()) {
            worldserver1.d(entityplayer1);
            this.j.add(entityplayer1);
            this.playersByName.put(entityplayer1.co().toLowerCase(Locale.ROOT), entityplayer1);
            this.k.put(entityplayer1.cm(), entityplayer1);
        }
        entityplayer1.c(entityplayer1.dZ());
        if (flag2 && !isLocAltered) {
            IBlockData data = worldserver1.a_(blockposition);
            worldserver1.a(blockposition, (IBlockData)data.a(BlockRespawnAnchor.c, data.c(BlockRespawnAnchor.c) - 1), 3);
            entityplayer1.b.a(new PacketPlayOutNamedSoundEffect(SoundEffects.pS, SoundCategory.e, location.getX(), location.getY(), location.getZ(), 1.0f, 1.0f));
        }
        this.e(entityplayer);
        entityplayer.w();
        for (MobEffect mobEffect : entityplayer.dW()) {
            entityplayer.b.a(new PacketPlayOutEntityEffect(entityplayer.ae(), mobEffect));
        }
        entityplayer.e(((CraftWorld)fromWorld).getHandle());
        if (fromWorld != location.getWorld()) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)entityplayer.getBukkitEntity(), fromWorld);
            this.i.server.getPluginManager().callEvent((Event)event);
        }
        if (entityplayer.b.isDisconnected()) {
            this.b(entityplayer);
        }
        if (isRespawn) {
            this.cserver.getPluginManager().callEvent((Event)new PlayerPostRespawnEvent((Player)entityplayer.getBukkitEntity(), location, isBedSpawn));
        }
        return entityplayer1;
    }

    public void d(EntityPlayer player) {
        GameProfile gameprofile = player.fp();
        int i2 = this.i.b(gameprofile);
        this.a(player, i2);
    }

    public void d() {
        if (++this.y > 600) {
            for (int i2 = 0; i2 < this.j.size(); ++i2) {
                final EntityPlayer target = this.j.get(i2);
                target.b.a(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.c, this.j.stream().filter(new Predicate<EntityPlayer>(){

                    public boolean apply(EntityPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
            }
            this.y = 0;
        }
    }

    public void a(Packet<?> packet) {
        for (EntityPlayer entityplayer : this.j) {
            entityplayer.b.a(packet);
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        for (int i2 = 0; i2 < this.j.size(); ++i2) {
            EntityPlayer entityplayer = this.j.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.j.get((int)i2).b.a(packet);
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        for (int i2 = 0; i2 < world.z().size(); ++i2) {
            ((EntityPlayer)world.z().get((int)i2)).b.a(packet);
        }
    }

    public void a(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> dimension) {
        for (EntityPlayer entityplayer : this.j) {
            if (entityplayer.t.aa() != dimension) continue;
            entityplayer.b.a(packet);
        }
    }

    public void a(EntityHuman source, IChatBaseComponent message) {
        ScoreboardTeamBase scoreboardteambase = source.bW();
        if (scoreboardteambase != null) {
            Collection<String> collection = scoreboardteambase.g();
            for (String s2 : collection) {
                EntityPlayer entityplayer = this.a(s2);
                if (entityplayer == null || entityplayer == source) continue;
                entityplayer.a(message, source.cm());
            }
        }
    }

    public void b(EntityHuman source, IChatBaseComponent message) {
        ScoreboardTeamBase scoreboardteambase = source.bW();
        if (scoreboardteambase == null) {
            this.a(message, ChatMessageType.b, source.cm());
        } else {
            for (int i2 = 0; i2 < this.j.size(); ++i2) {
                EntityPlayer entityplayer = this.j.get(i2);
                if (entityplayer.bW() == scoreboardteambase) continue;
                entityplayer.a(message, source.cm());
            }
        }
    }

    public String[] e() {
        String[] astring = new String[this.j.size()];
        for (int i2 = 0; i2 < this.j.size(); ++i2) {
            astring[i2] = this.j.get(i2).fp().getName();
        }
        return astring;
    }

    public GameProfileBanList f() {
        return this.l;
    }

    public IpBanList g() {
        return this.m;
    }

    public void a(GameProfile profile) {
        this.n.a(new OpListEntry(profile, this.i.h(), this.n.a(profile)));
        EntityPlayer entityplayer = this.a(profile.getId());
        if (entityplayer != null) {
            this.d(entityplayer);
        }
    }

    public void b(GameProfile profile) {
        this.n.c(profile);
        EntityPlayer entityplayer = this.a(profile.getId());
        if (entityplayer != null) {
            this.d(entityplayer);
        }
    }

    private void a(EntityPlayer player, int permissionLevel) {
        this.sendPlayerPermissionLevel(player, permissionLevel, true);
    }

    public void sendPlayerPermissionLevel(EntityPlayer player, int permissionLevel, boolean recalculatePermissions) {
        if (player.b != null) {
            byte b0 = permissionLevel <= 0 ? (byte)24 : (permissionLevel >= 4 ? (byte)28 : (byte)((byte)(24 + permissionLevel)));
            player.b.a(new PacketPlayOutEntityStatus(player, b0));
        }
        if (recalculatePermissions) {
            player.getBukkitEntity().recalculatePermissions();
            this.i.aA().a(player);
        }
    }

    public boolean c(GameProfile profile) {
        return this.isWhitelisted(profile, null);
    }

    public boolean isWhitelisted(GameProfile gameprofile, PlayerLoginEvent loginEvent) {
        boolean isOp = this.n.d(gameprofile);
        boolean isWhitelisted = !this.s || isOp || this.o.d(gameprofile);
        ProfileWhitelistVerifyEvent event = new ProfileWhitelistVerifyEvent(MCUtil.toBukkit(gameprofile), this.s, isWhitelisted, isOp, SpigotConfig.whitelistMessage);
        event.callEvent();
        if (!event.isWhitelisted()) {
            if (loginEvent != null) {
                loginEvent.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, (Component)PaperAdventure.LEGACY_SECTION_UXRC.deserialize(event.getKickMessage() == null ? SpigotConfig.whitelistMessage : event.getKickMessage()));
            }
            return false;
        }
        return true;
    }

    public boolean f(GameProfile profile) {
        return this.n.d(profile) || this.i.a(profile) && this.i.aU().o() || this.w;
    }

    @Nullable
    public EntityPlayer a(String name) {
        return this.playersByName.get(name.toLowerCase(Locale.ROOT));
    }

    public void a(@Nullable EntityHuman player, double x2, double y2, double z2, double distance, ResourceKey<net.minecraft.world.level.World> worldKey, Packet<?> packet) {
        for (int i2 = 0; i2 < this.j.size(); ++i2) {
            double d6;
            double d5;
            double d4;
            EntityPlayer entityplayer = this.j.get(i2);
            if (player != null && !entityplayer.getBukkitEntity().canSee(player.getBukkitEntity()) || entityplayer == player || entityplayer.t.aa() != worldKey || !((d4 = x2 - entityplayer.dc()) * d4 + (d5 = y2 - entityplayer.de()) * d5 + (d6 = z2 - entityplayer.di()) * d6 < distance * distance)) continue;
            entityplayer.b.a(packet);
        }
    }

    public void h() {
        this.saveAll(-1);
    }

    public void saveAll(int interval) {
        MCUtil.ensureMain("Save Players", () -> {
            MinecraftTimings.savePlayers.startTiming();
            int numSaved = 0;
            long now = MinecraftServer.currentTick;
            for (int i2 = 0; i2 < this.j.size(); ++i2) {
                EntityPlayer entityplayer = this.j.get(i2);
                if (interval != -1 && now - entityplayer.lastSave < (long)interval) continue;
                this.b(entityplayer);
                if (interval != -1 && ++numSaved <= PaperConfig.maxPlayerAutoSavePerTick) break;
            }
            MinecraftTimings.savePlayers.stopTiming();
            return null;
        });
    }

    public WhiteList i() {
        return this.o;
    }

    public String[] j() {
        return this.o.a();
    }

    public OpList k() {
        return this.n;
    }

    public String[] l() {
        return this.n.a();
    }

    public void a() {
    }

    public void a(EntityPlayer player, WorldServer world) {
        WorldBorder worldborder = player.t.p_();
        player.b.a(new ClientboundInitializeBorderPacket(worldborder));
        player.b.a(new PacketPlayOutUpdateTime(world.V(), world.W(), world.X().b(GameRules.k)));
        player.b.a(new PacketPlayOutSpawnPosition(world.w(), world.x()));
        if (world.Z()) {
            player.setPlayerWeather(WeatherType.DOWNFALL, false);
            player.updateWeather(-world.t, world.t, -world.v, world.v);
        }
    }

    public void e(EntityPlayer player) {
        player.bV.b();
        player.getBukkitEntity().updateScaledHealth();
        player.b.a(new PacketPlayOutHeldItemSlot(player.fq().k));
        int i2 = player.t.X().b(GameRules.p) ? 22 : 23;
        player.b.a(new PacketPlayOutEntityStatus(player, (byte)i2));
        float immediateRespawn = player.t.X().b(GameRules.A) ? 1.0f : 0.0f;
        player.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.l, immediateRespawn));
    }

    public int m() {
        return this.j.size();
    }

    public int n() {
        return this.f;
    }

    public boolean o() {
        return this.s;
    }

    public void a(boolean whitelistEnabled) {
        new WhitelistToggleEvent(whitelistEnabled).callEvent();
        this.s = whitelistEnabled;
    }

    public List<EntityPlayer> b(String ip) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.j) {
            if (!entityplayer.y().equals(ip)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int p() {
        return this.u;
    }

    public int q() {
        return this.v;
    }

    public MinecraftServer c() {
        return this.i;
    }

    @Nullable
    public NBTTagCompound r() {
        return null;
    }

    public void b(boolean cheatsAllowed) {
        this.w = cheatsAllowed;
    }

    public void s() {
        this.removeAll(false);
    }

    public void removeAll(boolean isRestarting) {
        ScoreboardServer scoreboard;
        ScoreboardTeam team;
        for (EntityPlayer player : this.j) {
            if (isRestarting) {
                player.b.disconnect(SpigotConfig.restartMessage, PlayerKickEvent.Cause.UNKNOWN);
                continue;
            }
            player.b.disconnect(this.i.server.shutdownMessage(), PlayerKickEvent.Cause.UNKNOWN);
        }
        if (this.collideRuleTeamName != null && (team = (scoreboard = this.c().a(net.minecraft.world.level.World.f).f()).i(this.collideRuleTeamName)) != null) {
            scoreboard.d(team);
        }
    }

    public void broadcastMessage(IChatBaseComponent[] iChatBaseComponents) {
        for (IChatBaseComponent component : iChatBaseComponents) {
            this.a(component, ChatMessageType.b, SystemUtils.b);
        }
    }

    public void a(IChatBaseComponent message, ChatMessageType type, UUID sender) {
        this.i.a(message, sender);
        for (EntityPlayer entityplayer : this.j) {
            entityplayer.a(message, type, sender);
        }
    }

    public void a(IChatBaseComponent serverMessage, Function<EntityPlayer, IChatBaseComponent> playerMessageFactory, ChatMessageType type, UUID sender) {
        this.i.a(serverMessage, sender);
        for (EntityPlayer entityplayer : this.j) {
            IChatBaseComponent ichatbasecomponent1 = playerMessageFactory.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.a(ichatbasecomponent1, type, sender);
        }
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer entityhuman) {
        ServerStatisticManager serverstatisticmanager = entityhuman.D();
        return serverstatisticmanager == null ? this.getPlayerStats(entityhuman.cm(), entityhuman.C_().getString()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverstatisticmanager;
        EntityPlayer entityhuman = this.a(uuid);
        ServerStatisticManager serverStatisticManager = serverstatisticmanager = entityhuman == null ? null : entityhuman.D();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.i.a(SavedFile.b).toFile();
            File file1 = new File(file, uuid + ".json");
            if (!file1.exists() && FileUtils.a(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtils.b(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatisticManager(this.i, file1);
        }
        return serverstatisticmanager;
    }

    public AdvancementDataPlayer f(EntityPlayer player) {
        UUID uuid = player.cm();
        AdvancementDataPlayer advancementdataplayer = player.M();
        if (advancementdataplayer == null) {
            File file = this.i.a(SavedFile.a).toFile();
            File file1 = new File(file, uuid + ".json");
            advancementdataplayer = new AdvancementDataPlayer(this.i.aw(), this, this.i.ax(), file1, player);
        }
        advancementdataplayer.a(player);
        return advancementdataplayer;
    }

    public void a(int viewDistance) {
        this.u = viewDistance;
        this.a(new PacketPlayOutViewDistance(viewDistance));
        for (WorldServer worldserver : this.i.F()) {
            if (worldserver == null) continue;
            worldserver.k().a(viewDistance);
        }
    }

    public void b(int simulationDistance) {
        this.v = simulationDistance;
        this.a(new ClientboundSetSimulationDistancePacket(simulationDistance));
        for (WorldServer worldserver : this.i.F()) {
            if (worldserver == null) continue;
            worldserver.k().b(simulationDistance);
        }
    }

    public List<EntityPlayer> t() {
        return this.j;
    }

    @Nullable
    public EntityPlayer a(UUID uuid) {
        return this.k.get(uuid);
    }

    public boolean d(GameProfile profile) {
        return false;
    }

    public void u() {
        for (EntityPlayer player : this.j) {
            player.M().a(this.i.ax());
            player.M().b(player);
        }
        this.a(new PacketPlayOutTags(this.i.aD().a(this.t)));
        PacketPlayOutRecipeUpdate packetplayoutrecipeupdate = new PacketPlayOutRecipeUpdate(this.i.aC().b());
        for (EntityPlayer entityplayer : this.j) {
            entityplayer.b.a(packetplayoutrecipeupdate);
            entityplayer.E().a(entityplayer);
        }
    }

    public boolean v() {
        return this.w;
    }
}

