/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.ResourcePackFolder;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackVanilla
implements IResourcePack,
ResourceProvider {
    @Nullable
    public static Path a;
    private static final Logger g;
    public static Class<?> b;
    private static final Map<EnumResourcePackType, Path> h;
    public final ResourcePackInfo e;
    public final Set<String> f;

    private static Path a(URI uri) throws IOException {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            g.warn("Unable to get path for: {}", (Object)uri, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(uri);
    }

    public ResourcePackVanilla(ResourcePackInfo metadata, String ... namespaces) {
        this.e = metadata;
        this.f = ImmutableSet.copyOf((Object[])namespaces);
    }

    @Override
    @Override
    public InputStream b(String fileName) throws IOException {
        Path path;
        if (fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        if (a != null && Files.exists(path = a.resolve(fileName), new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        return this.a(fileName);
    }

    @Override
    @Override
    public InputStream a(EnumResourcePackType type, MinecraftKey id) throws IOException {
        InputStream inputStream = this.c(type, id);
        if (inputStream != null) {
            return inputStream;
        }
        throw new FileNotFoundException(id.a());
    }

    @Override
    @Override
    public Collection<MinecraftKey> a(EnumResourcePackType type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        HashSet set = Sets.newHashSet();
        if (a != null) {
            try {
                ResourcePackVanilla.a(set, maxDepth, namespace, a.resolve(type.a()), prefix, pathFilter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (type == EnumResourcePackType.a) {
                Enumeration<URL> enumeration = null;
                try {
                    enumeration = b.getClassLoader().getResources(type.a() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        URI uRI = enumeration.nextElement().toURI();
                        if (!"file".equals(uRI.getScheme())) continue;
                        ResourcePackVanilla.a(set, maxDepth, namespace, Paths.get(uRI), prefix, pathFilter);
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            }
        }
        try {
            Path path = h.get((Object)type);
            if (path != null) {
                ResourcePackVanilla.a(set, maxDepth, namespace, path, prefix, pathFilter);
            } else {
                g.error("Can't access assets root for type: {}", (Object)type);
            }
        }
        catch (FileNotFoundException | NoSuchFileException path) {
        }
        catch (IOException iOException) {
            g.error("Couldn't get a list of all vanilla resources", (Throwable)iOException);
        }
        return set;
    }

    private static void a(Collection<MinecraftKey> results, int maxDepth, String namespace, Path root, String prefix, Predicate<String> pathFilter) throws IOException {
        Path path2 = root.resolve(namespace);
        try (Stream<Path> stream = Files.walk(path2.resolve(prefix), maxDepth, new FileVisitOption[0]);){
            stream.filter(path -> !path.endsWith(".mcmeta") && Files.isRegularFile(path, new LinkOption[0]) && pathFilter.test(path.getFileName().toString())).map(path -> new MinecraftKey(namespace, path2.relativize((Path)path).toString().replaceAll("\\\\", "/"))).forEach(results::add);
        }
    }

    @Nullable
    protected InputStream c(EnumResourcePackType type, MinecraftKey id) {
        Path path;
        String string = ResourcePackVanilla.d(type, id);
        if (a != null && Files.exists(path = a.resolve(type.a() + "/" + id.b() + "/" + id.a()), new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            URL uRL = ResourcePackVanilla.class.getResource(string);
            if (ResourcePackVanilla.a(string, uRL)) {
                return uRL.openStream();
            }
        }
        catch (IOException iOException) {
            return ResourcePackVanilla.class.getResourceAsStream(string);
        }
        return null;
    }

    private static String d(EnumResourcePackType type, MinecraftKey id) {
        return "/" + type.a() + "/" + id.b() + "/" + id.a();
    }

    private static boolean a(String fileName, @Nullable URL url) throws IOException {
        return url != null && (url.getProtocol().equals("jar") || ResourcePackFolder.a(new File(url.getFile()), fileName));
    }

    @Nullable
    protected InputStream a(String path) {
        return ResourcePackVanilla.class.getResourceAsStream("/" + path);
    }

    @Override
    @Override
    public boolean b(EnumResourcePackType type, MinecraftKey id) {
        Path path;
        String string = ResourcePackVanilla.d(type, id);
        if (a != null && Files.exists(path = a.resolve(type.a() + "/" + id.b() + "/" + id.a()), new LinkOption[0])) {
            return true;
        }
        try {
            URL uRL = ResourcePackVanilla.class.getResource(string);
            return ResourcePackVanilla.a(string, uRL);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    @Override
    public Set<String> a(EnumResourcePackType type) {
        return this.f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    @Override
    public <T> T a(ResourcePackMetaParser<T> metaReader) throws IOException {
        try (InputStream inputStream = this.b("pack.mcmeta");){
            T object;
            if (inputStream != null && (object = ResourcePackAbstract.a(metaReader, inputStream)) != null) {
                T t2 = object;
                return t2;
            }
        }
        catch (FileNotFoundException | RuntimeException exception) {
            // empty catch block
        }
        if (metaReader != ResourcePackInfo.a) return null;
        return (T)this.e;
    }

    @Override
    @Override
    public String a() {
        return "Default";
    }

    @Override
    @Override
    public void close() {
    }

    @Override
    @Override
    public IResource a(final MinecraftKey id) throws IOException {
        return new IResource(){
            @Nullable
            InputStream a;

            @Override
            @Override
            public void close() throws IOException {
                if (this.a != null) {
                    this.a.close();
                }
            }

            @Override
            @Override
            public MinecraftKey a() {
                return id;
            }

            @Override
            @Override
            public InputStream b() {
                try {
                    this.a = ResourcePackVanilla.this.a(EnumResourcePackType.a, id);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Could not get client resource from vanilla pack", iOException);
                }
                return this.a;
            }

            @Override
            @Override
            public boolean c() {
                return false;
            }

            @Override
            @Nullable
            @Override
            public <T> T a(ResourcePackMetaParser<T> metaReader) {
                return null;
            }

            @Override
            @Override
            public String d() {
                return id.toString();
            }
        };
    }

    static {
        g = LogManager.getLogger();
        h = (Map)SystemUtils.a(() -> {
            Class<ResourcePackVanilla> clazz = ResourcePackVanilla.class;
            synchronized (ResourcePackVanilla.class) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (EnumResourcePackType packType : EnumResourcePackType.values()) {
                    String string = "/" + packType.a() + "/.mcassetsroot";
                    URL uRL = ResourcePackVanilla.class.getResource(string);
                    if (uRL == null) {
                        g.error("File {} does not exist in classpath", (Object)string);
                        continue;
                    }
                    try {
                        URI uRI = uRL.toURI();
                        String string2 = uRI.getScheme();
                        if (!"jar".equals(string2) && !"file".equals(string2)) {
                            g.warn("Assets URL '{}' uses unexpected schema", (Object)uRI);
                        }
                        Path path = ResourcePackVanilla.a(uRI);
                        builder.put((Object)packType, (Object)path.getParent());
                    }
                    catch (Exception exception) {
                        g.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return builder.build();
            }
        });
    }
}

