/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.thread.ThreadedMailbox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextFilter
implements AutoCloseable {
    private static final Logger a = LogManager.getLogger();
    private static final AtomicInteger b = new AtomicInteger(1);
    private static final ThreadFactory c = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("Chat-Filter-Worker-" + b.getAndIncrement());
        return thread;
    };
    private final URL d;
    final URL e;
    final URL f;
    private final String g;
    private final int h;
    private final String i;
    private final String j;
    final a k;
    final ExecutorService l;

    private TextFilter(URI apiUrl, String apiKey, int ruleId, String serverId, String roomId, a ignorer, int parallelism) throws MalformedURLException {
        this.g = apiKey;
        this.h = ruleId;
        this.i = serverId;
        this.j = roomId;
        this.k = ignorer;
        this.d = apiUrl.resolve("/v1/chat").toURL();
        this.e = apiUrl.resolve("/v1/join").toURL();
        this.f = apiUrl.resolve("/v1/leave").toURL();
        this.l = Executors.newFixedThreadPool(parallelism, c);
    }

    @Nullable
    public static TextFilter a(String config) {
        if (Strings.isNullOrEmpty((String)config)) {
            return null;
        }
        try {
            JsonObject jsonObject = ChatDeserializer.a(config);
            URI uRI = new URI(ChatDeserializer.h(jsonObject, "apiServer"));
            String string = ChatDeserializer.h(jsonObject, "apiKey");
            if (string.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int i2 = ChatDeserializer.a(jsonObject, "ruleId", 1);
            String string2 = ChatDeserializer.a(jsonObject, "serverId", "");
            String string3 = ChatDeserializer.a(jsonObject, "roomId", "Java:Chat");
            int j2 = ChatDeserializer.a(jsonObject, "hashesToDrop", -1);
            int k2 = ChatDeserializer.a(jsonObject, "maxConcurrentRequests", 7);
            a ignoreStrategy = net.minecraft.server.network.TextFilter$a.select(j2);
            return new TextFilter(uRI, Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.US_ASCII)), i2, string2, string3, ignoreStrategy, k2);
        }
        catch (Exception exception) {
            a.warn("Failed to parse chat filter config {}", (Object)config, (Object)exception);
            return null;
        }
    }

    void a(GameProfile gameProfile, URL endpoint, Executor executor) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("server", this.i);
        jsonObject.addProperty("room", this.j);
        jsonObject.addProperty("user_id", gameProfile.getId().toString());
        jsonObject.addProperty("user_display_name", gameProfile.getName());
        executor.execute(() -> {
            try {
                this.b(jsonObject, endpoint);
            }
            catch (Exception exception) {
                a.warn("Failed to send join/leave packet to {} for player {}", (Object)endpoint, (Object)gameProfile, (Object)exception);
            }
        });
    }

    CompletableFuture<ITextFilter.a> a(GameProfile gameProfile, String message, a ignorer, Executor executor) {
        if (message.isEmpty()) {
            return CompletableFuture.completedFuture(ITextFilter.a.a);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("rule", (Number)this.h);
        jsonObject.addProperty("server", this.i);
        jsonObject.addProperty("room", this.j);
        jsonObject.addProperty("player", gameProfile.getId().toString());
        jsonObject.addProperty("player_display_name", gameProfile.getName());
        jsonObject.addProperty("text", message);
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject jsonObject2 = this.a(jsonObject, this.d);
                boolean bl = ChatDeserializer.a(jsonObject2, "response", false);
                if (bl) {
                    return ITextFilter.a.a(message);
                }
                String string2 = ChatDeserializer.a(jsonObject2, "hashed", null);
                if (string2 == null) {
                    return ITextFilter.a.b(message);
                }
                int i2 = ChatDeserializer.u(jsonObject2, "hashes").size();
                return ignorer.shouldIgnore(string2, i2) ? ITextFilter.a.b(message) : new ITextFilter.a(message, string2);
            }
            catch (Exception exception) {
                a.warn("Failed to validate message '{}'", (Object)message, (Object)exception);
                return ITextFilter.a.b(message);
            }
        }, executor);
    }

    @Override
    @Override
    public void close() {
        this.l.shutdownNow();
    }

    private void a(InputStream inputStream) throws IOException {
        byte[] bs = new byte[1024];
        while (inputStream.read(bs) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject a(JsonObject payload, URL endpoint) throws IOException {
        HttpURLConnection httpURLConnection = this.c(payload, endpoint);
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            JsonObject jsonObject;
            if (httpURLConnection.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(inputStream))).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.a(inputStream);
                throw throwable;
            }
            this.a(inputStream);
            return jsonObject;
        }
    }

    private void b(JsonObject payload, URL endpoint) throws IOException {
        HttpURLConnection httpURLConnection = this.c(payload, endpoint);
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            this.a(inputStream);
        }
    }

    private HttpURLConnection c(JsonObject payload, URL endpoint) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)endpoint.openConnection();
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(2000);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.setRequestProperty("Authorization", "Basic " + this.g);
        httpURLConnection.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.b().getName());
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter jsonWriter = new JsonWriter((Writer)outputStreamWriter);){
            Streams.write((JsonElement)payload, (JsonWriter)jsonWriter);
        }
        int i2 = httpURLConnection.getResponseCode();
        if (i2 < 200 || i2 >= 300) {
            throw new c(i2 + " " + httpURLConnection.getResponseMessage());
        }
        return httpURLConnection;
    }

    public ITextFilter a(GameProfile gameProfile) {
        return new b(gameProfile);
    }

    @FunctionalInterface
    public static interface a {
        public static final a a = (hashes, hashesSize) -> false;
        public static final a b = (hashes, hashesSize) -> hashes.length() == hashesSize;

        public static a ignoreOverThreshold(int hashesToDrop) {
            return (hashes, hashesSize) -> hashesSize >= hashesToDrop;
        }

        public static a select(int hashesToDrop) {
            switch (hashesToDrop) {
                case -1: {
                    return a;
                }
                case 0: {
                    return b;
                }
            }
            return net.minecraft.server.network.TextFilter$a.ignoreOverThreshold(hashesToDrop);
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    public static class c
    extends RuntimeException {
        c(String message) {
            super(message);
        }
    }

    class b
    implements ITextFilter {
        private final GameProfile c;
        private final Executor d;

        b(GameProfile gameProfile) {
            this.c = gameProfile;
            ThreadedMailbox<Runnable> processorMailbox = ThreadedMailbox.a(TextFilter.this.l, "chat stream for " + gameProfile.getName());
            this.d = processorMailbox::a;
        }

        @Override
        @Override
        public void a() {
            TextFilter.this.a(this.c, TextFilter.this.e, this.d);
        }

        @Override
        @Override
        public void b() {
            TextFilter.this.a(this.c, TextFilter.this.f, this.d);
        }

        @Override
        @Override
        public CompletableFuture<List<ITextFilter.a>> a(List<String> texts) {
            List list = (List)texts.stream().map(string -> TextFilter.this.a(this.c, (String)string, TextFilter.this.k, this.d)).collect(ImmutableList.toImmutableList());
            return ((CompletableFuture)((Object)SystemUtils.c(list))).exceptionally(throwable -> ImmutableList.of());
        }

        @Override
        @Override
        public CompletableFuture<ITextFilter.a> a(String text) {
            return TextFilter.this.a(this.c, text, TextFilter.this.k, this.d);
        }
    }
}

