/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingHistory;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.destroystokyo.paper.io.PaperFileIOThread;
import com.destroystokyo.paper.io.chunk.ChunkTaskManager;
import com.destroystokyo.paper.util.maplist.IBlockDataList;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import io.papermc.paper.chunk.SingleThreadChunkRegionManager;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.WorldUtil;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import io.papermc.paper.util.math.ThreadUnsafeRandom;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddVibrationSignalPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.ITagRegistry;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListenerRegistrar;
import net.minecraft.world.level.gameevent.vibrations.VibrationPath;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_18_R1.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_18_R1.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.map.MapView;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;

public class WorldServer
extends net.minecraft.world.level.World
implements GeneratorAccessSeed {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    private static final int z = 12000;
    private static final int A = 180000;
    private static final int B = 12000;
    private static final int C = 24000;
    private static final int D = 12000;
    private static final int E = 180000;
    private static final int F = 3600;
    private static final int G = 15600;
    private static final Logger H = LogManager.getLogger();
    private static final int I = 300;
    private static final int J = 65536;
    public final List<EntityPlayer> K;
    public final ChunkProviderServer L;
    private final MinecraftServer M;
    public final WorldDataServer N;
    final EntityTickList O;
    public final PersistentEntitySectionManager<net.minecraft.world.entity.Entity> P;
    public boolean b;
    private final SleepStatus Q;
    private int R;
    private final PortalTravelAgent S;
    private final TickListServer<Block> T;
    private final TickListServer<FluidType> U;
    final Set<EntityInsentient> V;
    volatile boolean W;
    protected final PersistentRaid c;
    private final ObjectLinkedOpenHashSet<BlockActionData> X;
    private final List<BlockActionData> Y;
    private boolean Z;
    private final List<MobSpawner> aa;
    @Nullable
    private final EnderDragonBattle ab;
    final Int2ObjectMap<EntityComplexPart> ac;
    private final StructureManager ad;
    private final StructureCheck ae;
    private final boolean af;
    public long lastMidTickExecuteFailure;
    private int tickPosition;
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent = false;
    public final PaperFileIOThread.ChunkDataController poiDataController = new PaperFileIOThread.ChunkDataController(){

        @Override
        public void writeData(int x2, int z2, NBTTagCompound compound) throws IOException {
            WorldServer.this.k().a.j().a(new ChunkCoordIntPair(x2, z2), compound);
        }

        @Override
        public NBTTagCompound readData(int x2, int z2) throws IOException {
            return WorldServer.this.k().a.j().a(new ChunkCoordIntPair(x2, z2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T computeForRegionFile(int chunkX, int chunkZ, Function<RegionFile, T> function) {
            VillagePlace villagePlace = WorldServer.this.k().a.j();
            synchronized (villagePlace) {
                RegionFile file;
                try {
                    file = WorldServer.this.k().a.j().getRegionFile(new ChunkCoordIntPair(chunkX, chunkZ), false);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return function.apply(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T computeForRegionFileIfLoaded(int chunkX, int chunkZ, Function<RegionFile, T> function) {
            VillagePlace villagePlace = WorldServer.this.k().a.j();
            synchronized (villagePlace) {
                RegionFile file = WorldServer.this.k().a.j().getRegionFileIfLoaded(new ChunkCoordIntPair(chunkX, chunkZ));
                return function.apply(file);
            }
        }
    };
    public final PaperFileIOThread.ChunkDataController chunkDataController = new PaperFileIOThread.ChunkDataController(){

        @Override
        public void writeData(int x2, int z2, NBTTagCompound compound) throws IOException {
            WorldServer.this.k().a.a(new ChunkCoordIntPair(x2, z2), compound);
        }

        @Override
        public NBTTagCompound readData(int x2, int z2) throws IOException {
            return WorldServer.this.k().a.f(new ChunkCoordIntPair(x2, z2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T computeForRegionFile(int chunkX, int chunkZ, Function<RegionFile, T> function) {
            PlayerChunkMap playerChunkMap = WorldServer.this.k().a;
            synchronized (playerChunkMap) {
                RegionFile file;
                try {
                    file = WorldServer.this.k().a.regionFileCache.getRegionFile(new ChunkCoordIntPair(chunkX, chunkZ), false);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return function.apply(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T computeForRegionFileIfLoaded(int chunkX, int chunkZ, Function<RegionFile, T> function) {
            PlayerChunkMap playerChunkMap = WorldServer.this.k().a;
            synchronized (playerChunkMap) {
                RegionFile file = WorldServer.this.k().a.regionFileCache.getRegionFileIfLoaded(new ChunkCoordIntPair(chunkX, chunkZ));
                return function.apply(file);
            }
        }
    };
    public final ChunkTaskManager asyncChunkTaskManager;
    public final List<EntityPlayer> playersAffectingSpawning = new ArrayList<EntityPlayer>();
    private final BlockPosition.MutableBlockPosition chunkTickMutablePosition = new BlockPosition.MutableBlockPosition();
    private final ThreadUnsafeRandom randomTickRandom = new ThreadUnsafeRandom();
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();

    public static Throwable getAddToWorldStackTrace(net.minecraft.world.entity.Entity entity) {
        return new Throwable(entity + " Added to world at " + new Date());
    }

    @Override
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.L.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AxisAlignedBB axisalignedbb) {
        int minBlockX = MathHelper.b(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.b(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.b(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.b(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = this.k();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksForMoveAsync(AxisAlignedBB axisalignedbb, double toX, double toZ, Consumer<List<IChunkAccess>> onLoad) {
        if (Thread.currentThread() != ((net.minecraft.world.level.World)this).z) {
            this.k().h.execute(() -> this.loadChunksForMoveAsync(axisalignedbb, toX, toZ, onLoad));
            return;
        }
        ArrayList ret = new ArrayList();
        IntArrayList ticketLevels = new IntArrayList();
        int minBlockX = MathHelper.b(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.b(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.b(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.b(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = this.k();
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        int[] loadedChunks = new int[1];
        Long holderIdentifier = chunkProvider.chunkFutureAwaitCounter++;
        Consumer<IChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                int ticketLevel = Math.max(33, chunkProvider.a.a(chunk.f().a()).j());
                ret.add(chunk);
                ticketLevels.add(ticketLevel);
                chunkProvider.addTicketAtLevel(TicketType.FUTURE_AWAIT, chunk.f(), ticketLevel, holderIdentifier);
            }
            if ((loadedChunks[0] = loadedChunks[0] + 1) == requiredChunks) {
                try {
                    onLoad.accept(Collections.unmodifiableList(ret));
                }
                finally {
                    int len = ret.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        ChunkCoordIntPair chunkPos = ((IChunkAccess)ret.get(i2)).f();
                        int ticketLevel = ticketLevels.getInt(i2);
                        chunkProvider.addTicketAtLevel(TicketType.h, chunkPos, ticketLevel, chunkPos);
                        chunkProvider.removeTicketAtLevel(TicketType.FUTURE_AWAIT, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                chunkProvider.getChunkAtAsynchronously(cx, cz, ChunkStatus.o, true, false, consumer);
            }
        }
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.k().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Override
    @Nullable
    public EntityHuman b(UUID uuid) {
        return this.n().ac().a(uuid);
    }

    public final EntityPlayer getNearestPlayer(PathfinderTargetCondition condition, @Nullable EntityLiving source, double centerX, double centerY, double centerZ) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet nearby = this.k().a.playerGeneralAreaMap.getObjectsInRange(MathHelper.b(centerX) >> 4, MathHelper.b(centerZ) >> 4);
        if (nearby == null) {
            return null;
        }
        E[] backingSet = nearby.getBackingSet();
        double closestDistanceSquared = Double.MAX_VALUE;
        EntityPlayer closest = null;
        for (Object _player : backingSet) {
            EntityPlayer player;
            double distanceSquared;
            if (!(_player instanceof EntityPlayer) || !((distanceSquared = (player = (EntityPlayer)_player).h(centerX, centerY, centerZ)) < closestDistanceSquared) || !condition.a(source, player)) continue;
            closest = player;
            closestDistanceSquared = distanceSquared;
        }
        return closest;
    }

    @Override
    public EntityHuman a(PathfinderTargetCondition pathfindertargetcondition, EntityLiving entityliving) {
        return this.getNearestPlayer(pathfindertargetcondition, entityliving, entityliving.dc(), entityliving.de(), entityliving.di());
    }

    @Override
    public EntityHuman a(PathfinderTargetCondition pathfindertargetcondition, double d0, double d1, double d2) {
        return this.getNearestPlayer(pathfindertargetcondition, null, d0, d1, d2);
    }

    @Override
    public List<EntityHuman> a(PathfinderTargetCondition condition, EntityLiving source, AxisAlignedBB axisalignedbb) {
        double centerX = (axisalignedbb.d + axisalignedbb.a) * 0.5;
        double centerZ = (axisalignedbb.f + axisalignedbb.c) * 0.5;
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet nearby = this.k().a.playerGeneralAreaMap.getObjectsInRange(MathHelper.b(centerX) >> 4, MathHelper.b(centerZ) >> 4);
        ArrayList<EntityHuman> ret = new ArrayList<EntityHuman>();
        if (nearby == null) {
            return ret;
        }
        for (Object _player : nearby.getBackingSet()) {
            EntityPlayer player;
            if (!(_player instanceof EntityPlayer) || !axisalignedbb.e((player = (EntityPlayer)_player).dc(), player.de(), player.di()) || !condition.a(source, player)) continue;
            ret.add(player);
        }
        return ret;
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, IWorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, DimensionManager dimensionmanager, WorldLoadListener worldloadlistener, ChunkGenerator chunkgenerator, boolean flag, long i2, List<MobSpawner> list, boolean flag1, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, dimensionmanager, minecraftserver::aO, false, flag, i2, gen, biomeProvider, env, executor);
        this.pvpMode = minecraftserver.Y();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.c.toFile());
        this.K = Lists.newArrayList();
        this.O = new EntityTickList();
        this.T = new TickListServer(this::d, this.ac());
        this.U = new TickListServer(this::d, this.ac());
        this.V = new ObjectOpenHashSet();
        this.X = new ObjectLinkedOpenHashSet();
        this.Y = new ArrayList<BlockActionData>(64);
        this.ac = new Int2ObjectOpenHashMap();
        this.af = flag1;
        this.M = minecraftserver;
        this.aa = list;
        this.N = (WorldDataServer)iworlddataserver;
        this.N.world = this;
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.aS();
        DataFixer datafixer = minecraftserver.aw();
        EntityStorage entitypersistentstorage = new EntityStorage(this, convertable_conversionsession.a(resourcekey).resolve("entities"), datafixer, flag2, minecraftserver);
        this.P = new PersistentEntitySectionManager<net.minecraft.world.entity.Entity>(net.minecraft.world.entity.Entity.class, new a(), entitypersistentstorage, this.entitySliceManager);
        DefinedStructureManager definedstructuremanager = minecraftserver.aT();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        PersistentEntitySectionManager<net.minecraft.world.entity.Entity> persistententitysectionmanager = this.P;
        Objects.requireNonNull(this.P);
        this.L = new ChunkProviderServer(this, convertable_conversionsession, datafixer, definedstructuremanager, executor, chunkgenerator, j2, k2, flag2, worldloadlistener, persistententitysectionmanager::a, () -> minecraftserver.D().u());
        this.S = new PortalTravelAgent(this);
        this.S();
        this.T();
        this.p_().a(minecraftserver.ar());
        this.c = this.u().a((NBTTagCompound nbttagcompound) -> PersistentRaid.a(this, nbttagcompound), () -> new PersistentRaid(this), PersistentRaid.a(this.q_()));
        if (!minecraftserver.O()) {
            iworlddataserver.a(minecraftserver.h_());
        }
        long l2 = minecraftserver.aU().A().a();
        this.ae = new StructureCheck(this.L.k(), this.t(), minecraftserver.aT(), resourcekey, chunkgenerator, this, chunkgenerator.e(), l2, datafixer);
        this.ad = new StructureManager(this, this.N.A(), this.ae);
        this.ab = this.q_().n() ? new EnderDragonBattle(this, this.N.A().a(), this.N.C()) : null;
        this.Q = new SleepStatus();
        this.getCraftServer().addWorld(this.getWorld());
        this.asyncChunkTaskManager = new ChunkTaskManager(this);
    }

    public void a(int clearDuration, int rainDuration, boolean raining, boolean thundering) {
        this.N.a(clearDuration);
        this.N.f(rainDuration);
        this.N.e(rainDuration);
        this.N.setRaining(raining, WeatherChangeEvent.Cause.COMMAND);
        this.N.setThundering(thundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public BiomeBase a(int biomeX, int biomeY, int biomeZ) {
        return this.k().g().getNoiseBiome(biomeX, biomeY, biomeZ);
    }

    public StructureManager a() {
        return this.ad;
    }

    public void a(BooleanSupplier shouldKeepTicking) {
        long j2;
        this.playersAffectingSpawning.clear();
        for (EntityPlayer player : this.K) {
            if (!IEntitySelector.affectsSpawning.test(player)) continue;
            this.playersAffectingSpawning.add(player);
        }
        GameProfilerFiller gameprofilerfiller = this.ab();
        this.Z = true;
        gameprofilerfiller.a("world border");
        this.p_().s();
        gameprofilerfiller.b("weather");
        this.ao();
        int i2 = this.X().c(GameRules.J);
        if (this.Q.a(i2) && this.Q.a(i2, this.K)) {
            j2 = this.x.f() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.W());
            if (this.X().b(GameRules.k)) {
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.b(this.W() + event.getSkipAmount());
                }
            }
            if (!event.isCancelled()) {
                this.am();
            }
            if (this.X().b(GameRules.u) && this.Z()) {
                this.ap();
            }
        }
        this.S();
        this.b();
        gameprofilerfiller.b("tickPending");
        this.timings.scheduledBlocks.startTiming();
        if (!this.ad()) {
            j2 = this.V();
            gameprofilerfiller.a("blockTicks");
            this.T.a(j2, 65536, this::d);
            gameprofilerfiller.b("fluidTicks");
            this.U.a(j2, 65536, this::a);
            gameprofilerfiller.c();
        }
        this.timings.scheduledBlocks.stopTiming();
        gameprofilerfiller.b("raid");
        this.timings.raids.startTiming();
        this.c.a();
        this.timings.raids.stopTiming();
        gameprofilerfiller.b("chunkSource");
        this.timings.chunkProviderTick.startTiming();
        this.k().a(shouldKeepTicking);
        this.timings.chunkProviderTick.stopTiming();
        gameprofilerfiller.b("blockEvents");
        this.timings.doSounds.startTiming();
        this.ar();
        this.timings.doSounds.stopTiming();
        this.Z = false;
        gameprofilerfiller.c();
        boolean flag = true;
        if (flag) {
            this.g();
        }
        if (flag || this.R++ < 300) {
            gameprofilerfiller.a("entities");
            this.timings.tickEntities.startTiming();
            if (this.ab != null) {
                gameprofilerfiller.a("dragonFight");
                this.ab.b();
                gameprofilerfiller.c();
            }
            ActivationRange.activateEntities(this);
            this.timings.entityTick.startTiming();
            this.O.a((net.minecraft.world.entity.Entity entity) -> {
                if (!entity.do()) {
                    gameprofilerfiller.a("checkDespawn");
                    entity.dj();
                    gameprofilerfiller.c();
                    if (this.L.a.g().c(entity.cZ().a())) {
                        net.minecraft.world.entity.Entity entity1 = entity.cN();
                        if (entity1 != null) {
                            if (!entity1.do() && entity1.u((net.minecraft.world.entity.Entity)entity)) {
                                return;
                            }
                            entity.p();
                        }
                        gameprofilerfiller.a("tick");
                        this.a(this::a, entity);
                        gameprofilerfiller.c();
                    }
                }
            });
            this.timings.entityTick.stopTiming();
            this.timings.tickEntities.stopTiming();
            gameprofilerfiller.c();
            this.R();
        }
        gameprofilerfiller.a("entityManagement");
        this.P.a();
        gameprofilerfiller.c();
    }

    @Override
    public boolean a(long chunkPos) {
        return this.L.a.g().d(chunkPos);
    }

    protected void b() {
        if (this.af) {
            long i2 = this.x.e() + 1L;
            this.N.a(i2);
            this.N.u().a(this.M, i2);
            if (this.x.q().b(GameRules.k)) {
                this.b(this.x.f() + 1L);
            }
        }
    }

    public void b(long timeOfDay) {
        this.N.b(timeOfDay);
    }

    public void a(boolean spawnMonsters, boolean spawnAnimals) {
        for (MobSpawner mobspawner : this.aa) {
            mobspawner.a(this, spawnMonsters, spawnAnimals);
        }
    }

    private boolean i(net.minecraft.world.entity.Entity entity) {
        return !this.M.W() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal) ? true : !this.M.X() && entity instanceof NPC;
    }

    private void am() {
        this.Q.a();
        this.K.stream().filter(EntityLiving::fb).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.a(false, false));
    }

    public void a(Chunk chunk, int randomTickSpeed) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        boolean flag = this.Z();
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = this.ab();
        gameprofilerfiller.a("thunder");
        BlockPosition.MutableBlockPosition blockposition = this.chunkTickMutablePosition;
        if (!this.paperConfig.disableThunder && flag && this.Y() && this.spigotConfig.thunderChance > 0 && this.w.nextInt(this.spigotConfig.thunderChance) == 0) {
            blockposition.g(this.a(this.a(j2, 0, k2, 15)));
            if (this.s(blockposition)) {
                boolean flag1;
                DifficultyDamageScaler difficultydamagescaler = this.d_(blockposition);
                boolean bl = flag1 = this.X().b(GameRules.e) && this.w.nextDouble() < (double)difficultydamagescaler.b() * this.paperConfig.skeleHorseSpawnChance && !this.a_(blockposition.c()).a(Blocks.py);
                if (flag1) {
                    EntityHorseSkeleton entityhorseskeleton = EntityTypes.aC.a(this);
                    entityhorseskeleton.v(true);
                    entityhorseskeleton.b_(0);
                    entityhorseskeleton.e(blockposition.u(), blockposition.v(), blockposition.w());
                    this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                }
                EntityLightning entitylightning = EntityTypes.U.a(this);
                entitylightning.e(Vec3D.c(blockposition));
                entitylightning.a(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.b("iceandsnow");
        if (!this.paperConfig.disableIceAndSnow && this.randomTickRandom.nextInt(16) == 0) {
            this.getRandomBlockPosition(j2, 0, k2, 15, blockposition);
            int normalY = chunk.a(HeightMap.Type.e, blockposition.u() & 0xF, blockposition.w() & 0xF) + 1;
            int downY = normalY - 1;
            blockposition.q(normalY);
            BiomeBase biomebase = this.v(blockposition);
            blockposition.q(downY);
            if (biomebase.a(this, blockposition)) {
                CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, (BlockPosition)blockposition, Blocks.cL.n(), null);
            }
            if (flag) {
                blockposition.q(normalY);
                if (biomebase.b(this, blockposition)) {
                    CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, (BlockPosition)blockposition, Blocks.cK.n(), null);
                }
                blockposition.q(downY);
                IBlockData iblockdata = this.a_(blockposition);
                blockposition.q(normalY);
                BiomeBase.Precipitation biomebase_precipitation = this.v(blockposition).c();
                blockposition.q(downY);
                if (biomebase_precipitation == BiomeBase.Precipitation.b && biomebase.a(blockposition)) {
                    biomebase_precipitation = BiomeBase.Precipitation.c;
                }
                iblockdata.b().a(iblockdata, (net.minecraft.world.level.World)this, (BlockPosition)blockposition, biomebase_precipitation);
            }
        }
        gameprofilerfiller.b("randomTick");
        this.timings.chunkTicksBlocks.startTiming();
        if (randomTickSpeed > 0) {
            ChunkSection[] sections = chunk.d();
            int minSection = WorldUtil.getMinSection(this);
            for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
                ChunkSection section = sections[sectionIndex];
                if (section == null || section.tickingList.size() == 0) continue;
                int yPos = sectionIndex + minSection << 4;
                for (int a2 = 0; a2 < randomTickSpeed; ++a2) {
                    int tickingBlocks = section.tickingList.size();
                    int index = this.randomTickRandom.nextInt(4096);
                    if (index >= tickingBlocks) continue;
                    long raw = section.tickingList.getRaw(index);
                    int location = IBlockDataList.getLocationFromRaw(raw);
                    int randomX = location & 0xF;
                    int randomY = location >>> 8 & 0xFF | yPos;
                    int randomZ = location >>> 4 & 0xF;
                    BlockPosition.MutableBlockPosition blockposition2 = blockposition.d(j2 + randomX, randomY, k2 + randomZ);
                    IBlockData iblockdata = IBlockDataList.getBlockDataFromRaw(raw);
                    iblockdata.b(this, (BlockPosition)blockposition2, this.randomTickRandom);
                }
            }
        }
        this.timings.chunkTicksBlocks.stopTiming();
        gameprofilerfiller.c();
    }

    public Optional<BlockPosition> D(BlockPosition pos) {
        Optional<BlockPosition> optional = this.A().d(villageplacetype -> villageplacetype == VillagePlaceType.x, blockposition1 -> blockposition1.v() == this.G().a(HeightMap.Type.b, blockposition1.u(), blockposition1.w()) - 1, pos, 128, VillagePlace.Occupancy.c);
        return optional.map(blockposition1 -> blockposition1.b(1));
    }

    protected BlockPosition a(BlockPosition pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPosition findLightningTargetAround(BlockPosition pos, boolean returnNullWhenNoTarget) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, pos);
        Optional<BlockPosition> optional = this.D(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockposition1, new BlockPosition(blockposition1.u(), this.ag(), blockposition1.w())).g(3.0);
        List<EntityLiving> list = this.a(EntityLiving.class, axisalignedbb, (? super T entityliving) -> entityliving != null && entityliving.bl() && this.f(entityliving.cW()));
        if (!list.isEmpty()) {
            return list.get(this.w.nextInt(list.size())).cW();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (blockposition1.v() == this.u_() - 1) {
            blockposition1 = blockposition1.b(2);
        }
        return blockposition1;
    }

    public boolean c() {
        return this.Z;
    }

    public boolean d() {
        return this.X().c(GameRules.J) <= 100;
    }

    private void an() {
        if (this.d() && (!this.n().O() || this.n().o())) {
            int i2 = this.X().c(GameRules.J);
            ChatMessage chatmessage = this.Q.a(i2) ? new ChatMessage("sleep.skipping_night") : new ChatMessage("sleep.players_sleeping", this.Q.b(), this.Q.b(i2));
            for (EntityPlayer entityplayer : this.K) {
                entityplayer.a((IChatBaseComponent)chatmessage, true);
            }
        }
    }

    public void e() {
        if (!this.K.isEmpty() && this.Q.a(this.K)) {
            this.an();
        }
    }

    public ScoreboardServer f() {
        return this.M.aE();
    }

    private void ao() {
        int idx;
        boolean flag = this.Z();
        if (this.q_().b()) {
            if (this.X().b(GameRules.u)) {
                int i2 = this.N.h();
                int j2 = this.N.j();
                int k2 = this.N.l();
                boolean flag1 = this.x.i();
                boolean flag2 = this.x.k();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? MathHelper.b(this.w, 3600, 15600) : MathHelper.b(this.w, 12000, 180000);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? MathHelper.b(this.w, 12000, 24000) : MathHelper.b(this.w, 12000, 180000);
                    }
                }
                this.N.e(j2);
                this.N.f(k2);
                this.N.a(i2);
                this.N.setThundering(flag1, ThunderChangeEvent.Cause.NATURAL);
                this.N.setRaining(flag2, WeatherChangeEvent.Cause.NATURAL);
            }
            this.u = this.v;
            this.v = this.x.i() ? (float)((double)this.v + 0.01) : (float)((double)this.v - 0.01);
            this.v = MathHelper.a(this.v, 0.0f, 1.0f);
            this.s = this.t;
            this.t = this.x.k() ? (float)((double)this.t + 0.01) : (float)((double)this.t - 0.01);
            this.t = MathHelper.a(this.t, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.K.size(); ++idx) {
            if (this.K.get((int)idx).t != this) continue;
            this.K.get(idx).tickWeather();
        }
        if (flag != this.Z()) {
            for (idx = 0; idx < this.K.size(); ++idx) {
                if (this.K.get((int)idx).t != this) continue;
                this.K.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.K.size(); ++idx) {
            if (this.K.get((int)idx).t != this) continue;
            this.K.get(idx).updateWeather(this.s, this.t, this.u, this.v);
        }
    }

    private void ap() {
        this.N.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        if (!this.N.k()) {
            this.N.f(0);
        }
        this.N.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        if (!this.N.i()) {
            this.N.e(0);
        }
    }

    public void g() {
        this.R = 0;
    }

    private void a(BlockPosition pos, FluidType fluid) {
        Fluid fluid1 = this.b_(pos);
        if (fluid1.b(fluid)) {
            fluid1.a(this, pos);
        }
    }

    private void d(BlockPosition pos, Block block) {
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.a(block)) {
            iblockdata.a(this, pos, this.w);
        }
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = new net.minecraft.world.entity.Entity[]{};
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        this.P.updateNavigatorsInRegion(entity);
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            ++TimingHistory.entityTicks;
            boolean isActive = ActivationRange.checkIfActive(entity);
            Timing timer = isActive ? entity.ad().tickTimer.startTiming() : entity.ad().inactiveTickTimer.startTiming();
            try {
                entity.be();
                GameProfilerFiller gameprofilerfiller = this.ab();
                ++entity.S;
                this.ab().a(() -> IRegistry.Z.b(entity.ad()).toString());
                gameprofilerfiller.d("tickNonPassenger");
                if (isActive) {
                    ++TimingHistory.activatedEntityTicks;
                    entity.k();
                    entity.postTick();
                } else {
                    entity.inactiveTick();
                }
                this.ab().c();
            }
            finally {
                timer.stopTiming();
            }
            for (net.minecraft.world.entity.Entity entity1 : entity.cF()) {
                this.a(entity, entity1);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(net.minecraft.world.entity.Entity vehicle, net.minecraft.world.entity.Entity passenger) {
        if (!passenger.do() && passenger.cN() == vehicle) {
            if (passenger instanceof EntityHuman || this.O.c(passenger)) {
                boolean isActive = ActivationRange.checkIfActive(passenger);
                Timing timer = isActive ? passenger.ad().passengerTickTimer.startTiming() : passenger.ad().passengerInactiveTickTimer.startTiming();
                try {
                    passenger.be();
                    ++passenger.S;
                    GameProfilerFiller gameprofilerfiller = this.ab();
                    gameprofilerfiller.a(() -> IRegistry.Z.b(passenger.ad()).toString());
                    gameprofilerfiller.d("tickPassenger");
                    if (isActive) {
                        passenger.bo();
                        passenger.postTick();
                    } else {
                        passenger.g(Vec3D.a);
                        passenger.inactiveTick();
                        vehicle.i(passenger);
                    }
                    gameprofilerfiller.c();
                    for (net.minecraft.world.entity.Entity entity2 : passenger.cF()) {
                        this.a(passenger, entity2);
                    }
                }
                finally {
                    timer.stopTiming();
                }
            }
        } else {
            passenger.p();
        }
    }

    @Override
    public boolean a(EntityHuman player, BlockPosition pos) {
        return !this.M.a(this, pos, player) && this.p_().a(pos);
    }

    public void saveIncrementally(boolean doFull) {
        ChunkProviderServer chunkproviderserver = this.k();
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        try (Timing ignored = this.timings.worldSave.startTiming();){
            if (doFull) {
                this.aq();
            }
            this.timings.worldSaveChunks.startTiming();
            if (!this.s()) {
                chunkproviderserver.saveIncrementally();
            }
            this.timings.worldSaveChunks.stopTiming();
            if (doFull) {
                WorldServer worldserver1 = this;
                this.N.a(worldserver1.p_().t());
                this.N.b(this.M.aK().c());
                this.convertable.a(this.M.n, this.N, this.M.ac().r());
            }
        }
    }

    public void a(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled) {
        ChunkProviderServer chunkproviderserver = this.k();
        if (!savingDisabled) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            try (Timing ignored = this.timings.worldSave.startTiming();){
                if (progressListener != null) {
                    progressListener.a(new ChatMessage("menu.savingLevel"));
                }
                this.aq();
                if (progressListener != null) {
                    progressListener.c(new ChatMessage("menu.savingChunks"));
                }
                this.timings.worldSaveChunks.startTiming();
                chunkproviderserver.a(flush);
                this.timings.worldSaveChunks.stopTiming();
            }
            if (flush) {
                this.P.c();
            } else {
                this.P.b();
            }
        }
        WorldServer worldserver1 = this;
        this.N.a(worldserver1.p_().t());
        this.N.b(this.M.aK().c());
        this.convertable.a(this.M.n, this.N, this.M.ac().r());
    }

    private void aq() {
        if (this.ab != null) {
            this.N.a(this.ab.a());
        }
        this.k().i().a();
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.I().a(filter, (U entity) -> {
            if (predicate.test(entity)) {
                list.add(entity);
            }
        });
        return list;
    }

    public List<? extends EntityEnderDragon> h() {
        return this.a(EntityTypes.v, EntityLiving::bl);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.K) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    @Nullable
    public EntityPlayer i() {
        List<EntityPlayer> list = this.a(EntityLiving::bl);
        return list.isEmpty() ? null : list.get(this.w.nextInt(list.size()));
    }

    @Override
    public boolean b(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.addEntity(entity, reason);
    }

    public void a(EntityPlayer player) {
        this.e(player);
    }

    public void b(EntityPlayer player) {
        this.e(player);
    }

    public void c(EntityPlayer player) {
        this.e(player);
    }

    public void d(EntityPlayer player) {
        this.e(player);
    }

    private void e(EntityPlayer player) {
        net.minecraft.world.entity.Entity entity = this.I().a(player.cm());
        if (entity != null) {
            H.warn("Force-added player with duplicate UUID {}", (Object)player.cm().toString());
            entity.ab();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.P.a(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        AsyncCatcher.catchOp("entity add");
        if (entity.valid) {
            MinecraftServer.r.error("Attempted Double World add on " + entity, new Throwable());
            if (net.minecraft.world.level.World.DEBUG_ENTITIES) {
                Throwable thr = entity.addedToWorldStack;
                if (thr == null) {
                    MinecraftServer.r.error("Double add entity has no add stacktrace");
                } else {
                    MinecraftServer.r.error("Double add stacktrace: ", thr);
                }
            }
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.do()) {
            if (net.minecraft.world.level.World.DEBUG_ENTITIES) {
                new Throwable("Tried to add entity " + entity + " but it was marked as removed already").printStackTrace();
                WorldServer.getAddToWorldStackTrace(entity).printStackTrace();
            }
            return false;
        }
        if (this.captureDrops != null && entity instanceof EntityItem) {
            this.captureDrops.add((EntityItem)entity);
            return true;
        }
        if (!CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.P.a(entity);
    }

    public boolean e(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        Stream<UUID> stream = entity.cH().map(net.minecraft.world.entity.Entity::cm);
        PersistentEntitySectionManager<net.minecraft.world.entity.Entity> persistententitysectionmanager = this.P;
        Objects.requireNonNull(this.P);
        if (stream.anyMatch(persistententitysectionmanager::a)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void a(Chunk chunk) {
        for (TileEntity tileentity : chunk.E().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                ((CraftHumanEntity)h2).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.G();
        chunk.b(this);
    }

    public void a(EntityPlayer player, Entity.RemovalReason reason) {
        player.a(reason);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int entityId, BlockPosition pos, int progress) {
        Iterator<EntityPlayer> iterator = this.M.ac().t().iterator();
        EntityHuman entityhuman = null;
        net.minecraft.world.entity.Entity entity = this.a(entityId);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = iterator.next();
            if (entityplayer == null || entityplayer.t != this || entityplayer.ae() == entityId) continue;
            double d0 = (double)pos.u() - entityplayer.dc();
            double d1 = (double)pos.v() - entityplayer.de();
            double d2 = (double)pos.w() - entityplayer.di();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.b.a(new PacketPlayOutBlockBreakAnimation(entityId, pos, progress));
        }
    }

    @Override
    public void a(@Nullable EntityHuman except, double x2, double y2, double z2, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.M.ac().a(except, x2, y2, z2, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.aa(), new PacketPlayOutNamedSoundEffect(sound, category, x2, y2, z2, volume, pitch));
    }

    @Override
    public void a(@Nullable EntityHuman except, net.minecraft.world.entity.Entity entity, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.M.ac().a(except, entity.dc(), entity.de(), entity.di(), volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.aa(), new PacketPlayOutEntitySound(sound, category, entity, volume, pitch));
    }

    @Override
    public void b(int eventId, BlockPosition pos, int data) {
        this.M.ac().a(new PacketPlayOutWorldEvent(eventId, pos, data, true));
    }

    @Override
    public void a(@Nullable EntityHuman player, int eventId, BlockPosition pos, int data) {
        this.M.ac().a(player, pos.u(), pos.v(), pos.w(), 64.0, this.aa(), new PacketPlayOutWorldEvent(eventId, pos, data, false));
    }

    public int j() {
        return this.q_().m();
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity, GameEvent event, BlockPosition pos) {
        this.a(entity, event, pos, event.b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState, int flags) {
        VoxelShape voxelshape1;
        VoxelShape voxelshape;
        if (this.W) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.k().a(pos);
        if (this.paperConfig.updatePathfindingOnBlockUpdate && VoxelShapes.c(voxelshape = oldState.k(this, pos), voxelshape1 = newState.k(this, pos), OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            SingleThreadChunkRegionManager.Region region = this.k().a.dataRegionManager.getRegion(pos.u() >> 4, pos.w() >> 4);
            if (region == null) {
                return;
            }
            IteratorSafeOrderedReferenceSet<EntityInsentient> navigatorsFromRegion = ((PlayerChunkMap.DataRegionData)region.regionData).getNavigators();
            if (navigatorsFromRegion == null) {
                return;
            }
            IteratorSafeOrderedReferenceSet.Iterator<EntityInsentient> iterator = navigatorsFromRegion.iterator();
            try {
                while (iterator.hasNext()) {
                    EntityInsentient entityinsentient;
                    try {
                        entityinsentient = (EntityInsentient)iterator.next();
                    }
                    catch (ConcurrentModificationException ex) {
                        this.a(pos, oldState, newState, flags);
                        iterator.finishedIterating();
                        return;
                    }
                    NavigationAbstract navigationabstract = entityinsentient.D();
                    if (!navigationabstract.b(pos)) continue;
                    list.add(navigationabstract);
                }
                try {
                    this.W = true;
                    for (NavigationAbstract navigationabstract1 : list) {
                        navigationabstract1.i();
                    }
                }
                finally {
                    this.W = false;
                }
            }
            finally {
                iterator.finishedIterating();
            }
        }
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, byte status) {
        this.k().a(entity, new PacketPlayOutEntityStatus(entity, status));
    }

    public ChunkProviderServer k() {
        return this.L;
    }

    @Override
    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, Explosion.Effect destructionType) {
        Explosion explosion = super.a(entity, damageSource, behavior, x2, y2, z2, power, createFire, destructionType);
        if (explosion.wasCanceled) {
            return explosion;
        }
        if (destructionType == Explosion.Effect.a) {
            explosion.e();
        }
        for (EntityPlayer entityplayer : this.K) {
            if (!(entityplayer.h(x2, y2, z2) < 4096.0)) continue;
            entityplayer.b.a(new PacketPlayOutExplosion(x2, y2, z2, power, explosion.f(), explosion.c().get(entityplayer)));
        }
        return explosion;
    }

    @Override
    public void a(BlockPosition pos, Block block, int type, int data) {
        this.X.add((Object)new BlockActionData(pos, block, type, data));
    }

    private void ar() {
        this.Y.clear();
        while (!this.X.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.X.removeFirst();
            if (this.a(ChunkCoordIntPair.a(blockactiondata.a()))) {
                if (!this.a(blockactiondata)) continue;
                this.M.ac().a(null, blockactiondata.a().u(), blockactiondata.a().v(), blockactiondata.a().w(), 64.0, this.aa(), new PacketPlayOutBlockAction(blockactiondata.a(), blockactiondata.b(), blockactiondata.c(), blockactiondata.d()));
                continue;
            }
            this.Y.add(blockactiondata);
        }
        this.X.addAll(this.Y);
    }

    private boolean a(BlockActionData event) {
        IBlockData iblockdata = this.a_(event.a());
        return iblockdata.a(event.b()) ? iblockdata.a((net.minecraft.world.level.World)this, event.a(), event.c(), event.d()) : false;
    }

    public TickListServer<Block> l() {
        return this.T;
    }

    public TickListServer<FluidType> m() {
        return this.U;
    }

    @Override
    @Nonnull
    public MinecraftServer n() {
        return this.M;
    }

    public PortalTravelAgent o() {
        return this.S;
    }

    public DefinedStructureManager p() {
        return this.M.aT();
    }

    public void a(VibrationPath vibration) {
        BlockPosition blockposition = vibration.b();
        ClientboundAddVibrationSignalPacket clientboundaddvibrationsignalpacket = new ClientboundAddVibrationSignalPacket(vibration);
        this.K.forEach(entityplayer -> this.a((EntityPlayer)entityplayer, false, (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w(), clientboundaddvibrationsignalpacket));
    }

    public <T extends ParticleParam> int a(T particle, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        return this.sendParticles(null, particle, x2, y2, z2, count, deltaX, deltaY, deltaZ, speed, false);
    }

    public <T extends ParticleParam> int sendParticles(EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        return this.sendParticles(this.K, sender, t0, d0, d1, d2, i2, d3, d4, d5, d6, force);
    }

    public <T extends ParticleParam> int sendParticles(List<EntityPlayer> receivers, EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        for (EntityHuman entityHuman : receivers) {
            EntityPlayer entityplayer = (EntityPlayer)entityHuman;
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(entityplayer, force, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer viewer, T particle, boolean force, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(particle, force, x2, y2, z2, (float)deltaX, (float)deltaY, (float)deltaZ, (float)speed, count);
        return this.a(viewer, force, x2, y2, z2, packet);
    }

    private boolean a(EntityPlayer player, boolean force, double x2, double y2, double z2, Packet<?> packet) {
        if (player.x() != this) {
            return false;
        }
        BlockPosition blockposition = player.cW();
        if (blockposition.a((IPosition)new Vec3D(x2, y2, z2), force ? 512.0 : 32.0)) {
            player.b.a(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(int id) {
        return this.I().a(id);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity b(int id) {
        net.minecraft.world.entity.Entity entity = this.I().a(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.ac.get(id);
    }

    @Nullable
    public net.minecraft.world.entity.Entity a(UUID uuid) {
        return this.I().a(uuid);
    }

    @Nullable
    public BlockPosition a(StructureGenerator<?> feature, BlockPosition pos, int radius, boolean skipExistingChunks) {
        return !this.N.A().b() ? null : this.k().g().a(this, feature, pos, radius, skipExistingChunks);
    }

    @Nullable
    public BlockPosition a(BiomeBase biome, BlockPosition pos, int radius, int blockCheckInterval) {
        return this.k().g().e().a(pos.u(), pos.v(), pos.w(), radius, blockCheckInterval, biomebase1 -> biomebase1 == biome, this.w, true, this.k().g().c());
    }

    @Override
    public CraftingManager q() {
        return this.M.aC();
    }

    @Override
    public ITagRegistry r() {
        return this.M.aD();
    }

    @Override
    public boolean s() {
        return this.b;
    }

    @Override
    public IRegistryCustom t() {
        return this.M.aV();
    }

    public WorldPersistentData u() {
        return this.k().i();
    }

    @Override
    @Nullable
    public WorldMap a(String id) {
        return this.n().D().u().a((NBTTagCompound nbttagcompound) -> {
            WorldMap newMap = WorldMap.b(nbttagcompound);
            newMap.id = id;
            MapInitializeEvent event = new MapInitializeEvent((MapView)newMap.mapView);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            return newMap;
        }, id);
    }

    @Override
    public void a(String id, WorldMap state) {
        state.id = id;
        this.n().D().u().a(id, state);
    }

    @Override
    public int v() {
        return this.n().D().u().a(PersistentIdCounts::b, PersistentIdCounts::new, "idcounts").a();
    }

    public void addTicketsForSpawn(int radiusInBlocks, BlockPosition spawn) {
        int x2;
        ChunkProviderServer chunkproviderserver = this.k();
        int tickRadius = radiusInBlocks - 16;
        for (x2 = -tickRadius; x2 <= tickRadius; x2 += 16) {
            for (int z2 = -tickRadius; z2 <= tickRadius; z2 += 16) {
                chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, z2)), 2, Unit.a);
            }
        }
        for (x2 = -radiusInBlocks; x2 <= radiusInBlocks; x2 += 16) {
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, radiusInBlocks)), 1, Unit.a);
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, -radiusInBlocks)), 1, Unit.a);
        }
        for (int z3 = -radiusInBlocks + 16; z3 < radiusInBlocks; z3 += 16) {
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(radiusInBlocks, 0, z3)), 1, Unit.a);
            chunkproviderserver.a(TicketType.a, new ChunkCoordIntPair(spawn.b(-radiusInBlocks, 0, z3)), 1, Unit.a);
        }
    }

    public void removeTicketsForSpawn(int radiusInBlocks, BlockPosition spawn) {
        int x2;
        ChunkProviderServer chunkproviderserver = this.k();
        int tickRadius = radiusInBlocks - 16;
        for (x2 = -tickRadius; x2 <= tickRadius; x2 += 16) {
            for (int z2 = -tickRadius; z2 <= tickRadius; z2 += 16) {
                chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, z2)), 2, Unit.a);
            }
        }
        for (x2 = -radiusInBlocks; x2 <= radiusInBlocks; x2 += 16) {
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, radiusInBlocks)), 1, Unit.a);
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(x2, 0, -radiusInBlocks)), 1, Unit.a);
        }
        for (int z3 = -radiusInBlocks + 16; z3 < radiusInBlocks; z3 += 16) {
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(radiusInBlocks, 0, z3)), 1, Unit.a);
            chunkproviderserver.b(TicketType.a, new ChunkCoordIntPair(spawn.b(-radiusInBlocks, 0, z3)), 1, Unit.a);
        }
    }

    public void a(BlockPosition pos, float angle) {
        BlockPosition prevSpawn = this.w();
        this.x.a(pos, angle);
        new SpawnChangeEvent((World)this.getWorld(), MCUtil.toLocation(this, prevSpawn)).callEvent();
        if (this.keepSpawnInMemory) {
            this.removeTicketsForSpawn(this.paperConfig.keepLoadedRange, prevSpawn);
            this.addTicketsForSpawn(this.paperConfig.keepLoadedRange, pos);
        }
        this.n().ac().a(new PacketPlayOutSpawnPosition(pos, angle));
    }

    public BlockPosition w() {
        BlockPosition blockposition = new BlockPosition(this.x.a(), this.x.b(), this.x.c());
        if (!this.p_().a(blockposition)) {
            blockposition = this.a(HeightMap.Type.e, new BlockPosition(this.p_().a(), 0.0, this.p_().b()));
        }
        return blockposition;
    }

    public float x() {
        return this.x.d();
    }

    public LongSet y() {
        ForcedChunk forcedchunk = this.u().a(ForcedChunk::b, "chunks");
        return forcedchunk != null ? LongSets.unmodifiable((LongSet)forcedchunk.a()) : LongSets.EMPTY_SET;
    }

    public boolean a(int x2, int z2, boolean forced) {
        boolean flag1;
        ForcedChunk forcedchunk = this.u().a(ForcedChunk::b, ForcedChunk::new, "chunks");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(x2, z2);
        long k2 = chunkcoordintpair.a();
        if (forced) {
            flag1 = forcedchunk.a().add(k2);
            if (flag1) {
                this.d(x2, z2);
            }
        } else {
            flag1 = forcedchunk.a().remove(k2);
        }
        forcedchunk.a(flag1);
        if (flag1) {
            this.k().a(chunkcoordintpair, forced);
        }
        return flag1;
    }

    public List<EntityPlayer> z() {
        return this.K;
    }

    @Override
    public void a(BlockPosition pos, IBlockData oldBlock, IBlockData newBlock) {
        Optional<VillagePlaceType> optional1;
        Optional<VillagePlaceType> optional = VillagePlaceType.b(oldBlock);
        if (!Objects.equals(optional, optional1 = VillagePlaceType.b(newBlock))) {
            BlockPosition blockposition1 = pos.h();
            optional.ifPresent(villageplacetype -> this.n().execute(() -> {
                this.A().a(blockposition1);
                PacketDebug.b(this, blockposition1);
            }));
            optional1.ifPresent(villageplacetype -> this.n().execute(() -> {
                if (optional.isEmpty() && this.A().a(blockposition1, (VillagePlaceType poiType) -> true)) {
                    this.A().a(blockposition1);
                }
                this.A().a(blockposition1, (VillagePlaceType)villageplacetype);
                PacketDebug.a(this, blockposition1);
            }));
        }
    }

    public VillagePlace A() {
        return this.k().j();
    }

    public boolean b(BlockPosition pos) {
        return this.a(pos, 1);
    }

    public boolean a(SectionPosition sectionPos) {
        return this.b(sectionPos.q());
    }

    public boolean a(BlockPosition pos, int maxDistance) {
        return maxDistance > 6 ? false : this.b(SectionPosition.a(pos)) <= maxDistance;
    }

    public int b(SectionPosition pos) {
        return this.A().a(pos);
    }

    public PersistentRaid B() {
        return this.c;
    }

    @Nullable
    public Raid c(BlockPosition pos) {
        return this.c.a(pos, 9216);
    }

    public boolean d(BlockPosition pos) {
        return this.c(pos) != null;
    }

    public void a(ReputationEvent interaction, net.minecraft.world.entity.Entity entity, ReputationHandler observer) {
        observer.a(interaction, entity);
    }

    public void a(Path path) throws IOException {
        PlayerChunkMap playerchunkmap = this.k().a;
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedwriter.write(String.format("spawning_chunks: %d\n", playerchunkmap.g().b()));
            SpawnerCreature.d spawnercreature_d = this.k().l();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry entry : spawnercreature_d.b().object2IntEntrySet()) {
                    bufferedwriter.write(String.format("spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedwriter.write(String.format("entities: %s\n", this.P.e()));
            bufferedwriter.write(String.format("block_entity_tickers: %d\n", this.p.size()));
            bufferedwriter.write(String.format("block_ticks: %d\n", this.l().a()));
            bufferedwriter.write(String.format("fluid_ticks: %d\n", this.m().a()));
            bufferedwriter.write("distance_manager: " + playerchunkmap.g().c() + "\n");
            bufferedwriter.write(String.format("pending_tasks: %d\n", this.k().f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashreport);
        try (BufferedWriter bufferedwriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedwriter1.write(crashreport.e());
        }
        Path path1 = path.resolve("chunks.csv");
        try (BufferedWriter bufferedwriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);){
            playerchunkmap.a(bufferedwriter2);
        }
        Path path2 = path.resolve("entity_chunks.csv");
        try (BufferedWriter bufferedwriter3 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            this.P.a(bufferedwriter3);
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedwriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedwriter4, this.I().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedwriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedwriter5);
        }
    }

    private static void a(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            IChatBaseComponent ichatbasecomponent = entity.Z();
            IChatBaseComponent ichatbasecomponent1 = entity.C_();
            csvwriter.a(entity.dc(), entity.de(), entity.di(), entity.cm(), IRegistry.Z.b(entity.ad()), entity.bl(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("type").a(writer);
        for (TickingBlockEntity tickingblockentity : this.p) {
            BlockPosition blockposition = tickingblockentity.c();
            csvwriter.a(blockposition.u(), blockposition.v(), blockposition.w(), tickingblockentity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox box) {
        this.X.removeIf(blockactiondata -> box.b(blockactiondata.a()));
    }

    @Override
    public void a(BlockPosition pos, Block block) {
        if (!this.ad()) {
            if (this.populating) {
                return;
            }
            this.b(pos, block);
        }
    }

    @Override
    public float a(EnumDirection direction, boolean shaded) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> C() {
        return this.I().a();
    }

    public String toString() {
        return "ServerLevel[" + this.N.g() + "]";
    }

    public boolean D() {
        return this.N.A().h();
    }

    @Override
    public long E() {
        return this.N.A().a();
    }

    @Nullable
    public EnderDragonBattle F() {
        return this.ab;
    }

    @Override
    public List<? extends StructureStart<?>> a(SectionPosition pos, StructureGenerator<?> feature) {
        return this.a().a(pos, feature);
    }

    @Override
    public WorldServer G() {
        return this;
    }

    @VisibleForTesting
    public String H() {
        return String.format("players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.K.size(), this.P.e(), WorldServer.a(this.P.d().a(), (T entity) -> IRegistry.Z.b(entity.ad()).toString()), this.p.size(), WorldServer.a(this.p, TickingBlockEntity::d), this.l().a(), this.m().a(), this.J());
    }

    private static <T> String a(Iterable<T> items, Function<T, String> classifier) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : items) {
                String s2 = classifier.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void a(WorldServer world) {
        WorldServer.makeObsidianPlatform(world, null);
    }

    public static void makeObsidianPlatform(WorldServer worldserver, net.minecraft.world.entity.Entity entity) {
        BlockPosition blockposition = a;
        int i2 = blockposition.u();
        int j2 = blockposition.v() - 2;
        int k2 = blockposition.w();
        BlockStateListPopulator blockList = new BlockStateListPopulator(worldserver);
        BlockPosition.b(i2 - 2, j2 + 1, k2 - 2, i2 + 2, j2 + 3, k2 + 2).forEach(blockposition1 -> blockList.a((BlockPosition)blockposition1, Blocks.a.n(), 3));
        BlockPosition.b(i2 - 2, j2, k2 - 2, i2 + 2, j2, k2 + 2).forEach(blockposition1 -> blockList.a((BlockPosition)blockposition1, Blocks.bQ.n(), 3));
        CraftWorld bworld = worldserver.getWorld();
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.END_PLATFORM);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> I() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.P.d();
    }

    public void a(Stream<net.minecraft.world.entity.Entity> entities) {
        this.P.a(entities);
    }

    public void b(Stream<net.minecraft.world.entity.Entity> entities) {
        this.P.b(entities);
    }

    public void b(Chunk chunk) {
        chunk.c(this.n_().e());
    }

    public void a(IChunkAccess chunk) {
        this.M.execute(() -> this.ae.a(chunk.f(), chunk.g()));
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.P.close();
    }

    @Override
    public String J() {
        String s2 = this.L.e();
        return "Chunks[S] W: " + s2 + " E: " + this.P.e();
    }

    public boolean c(long chunkPos) {
        return this.P.a(chunkPos);
    }

    private boolean d(long chunkPos) {
        PlayerChunk chunkHolder = this.L.a.b(chunkPos);
        return chunkHolder != null && this.L.a(chunkPos) && chunkHolder.isTickingReady() && this.c(chunkPos);
    }

    public boolean e(BlockPosition pos) {
        return this.P.isPositionTicking(ChunkCoordIntPair.a(pos));
    }

    public boolean a(ChunkCoordIntPair pos) {
        return this.P.isPositionTicking(pos.a());
    }

    private final class a
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        a() {
        }

        @Override
        public void a(net.minecraft.world.entity.Entity entity) {
        }

        @Override
        public void b(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.f().a(entity);
        }

        @Override
        public void c(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.O.a(entity);
            WorldServer.this.P.addNavigatorsIfPathingToRegion(entity);
        }

        @Override
        public void d(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.O.b(entity);
            WorldServer.this.P.removeNavigatorsFromData(entity);
        }

        @Override
        public void e(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.K.add(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.W) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.V.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.t()) {
                    WorldServer.this.ac.put(entitycomplexpart.ae(), (Object)entitycomplexpart);
                }
            }
            entity.valid = true;
            WorldServer.this.k().b(entity);
            if (entity.getOriginVector() == null) {
                entity.setOrigin(entity.getBukkitEntity().getLocation());
            }
            if (entity.getOriginWorld() == null) {
                entity.setOrigin(entity.getOriginVector().toLocation((World)WorldServer.this.getWorld()));
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity()).callEvent();
        }

        @Override
        public void f(net.minecraft.world.entity.Entity entity) {
            GameEventListenerRegistrar gameeventlistenerregistrar;
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                WorldServer.this.n().R.values().stream().map(WorldServer::u).forEach(worldData -> {
                    for (PersistentBase o2 : worldData.b.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)o2;
                        map.o.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.n.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().a != entity) continue;
                            map.q.remove(entity.X().getString());
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.dp() != Entity.RemovalReason.a)) {
                Object merchant;
                CraftEntity craftEntity = entity.getBukkitEntity();
                if (craftEntity instanceof Merchant && (merchant = (Merchant)craftEntity).getTrader() != null) {
                    merchant.getTrader().closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            WorldServer.this.k().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.K.remove(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.W) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.V.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.t()) {
                    WorldServer.this.ac.remove(entitycomplexpart.ae());
                }
            }
            if ((gameeventlistenerregistrar = entity.bV()) != null) {
                gameeventlistenerregistrar.a(entity.t);
            }
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.K) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity()).callEvent();
        }
    }
}

