/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import co.aikar.timings.Timing;
import com.destroystokyo.paper.PaperWorldConfig;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.destroystokyo.paper.io.IOUtil;
import com.destroystokyo.paper.io.PaperFileIOThread;
import com.destroystokyo.paper.io.chunk.ChunkTaskManager;
import com.destroystokyo.paper.util.SneakyThrow;
import com.destroystokyo.paper.util.map.QueuedChangesMapLong2Object;
import com.destroystokyo.paper.util.misc.PlayerAreaMap;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.destroystokyo.paper.utils.CachedSizeConcurrentLinkedQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.chunk.SingleThreadChunkRegionManager;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SlackActivityAccountant;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.e {
    private static final byte f = -1;
    private static final byte g = 0;
    private static final byte h = 1;
    private static final Logger i = LogManager.getLogger();
    private static final int j = 200;
    private static final int k = 20;
    private static final int l = 3;
    public static final int a = 33;
    public static final int b = 33 + ChunkStatus.b();
    public final QueuedChangesMapLong2Object<PlayerChunk> updatingChunks = new QueuedChangesMapLong2Object();
    public static final int c = 31;
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> o;
    public final LongSet p;
    public final WorldServer q;
    private final LightEngineThreaded r;
    public final IAsyncTaskHandler<Runnable> s;
    final Executor mainInvokingExecutor;
    public ChunkGenerator t;
    public final Supplier<WorldPersistentData> u;
    private final VillagePlace v;
    public final LongSet w;
    private boolean x;
    private final ChunkTaskQueueSorter y;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> z;
    public final Mailbox<ChunkTaskQueueSorter.a<Runnable>> A;
    final Mailbox<ChunkTaskQueueSorter.a<Runnable>> mailboxLight;
    public final WorldLoadListener B;
    private final ChunkStatusUpdateListener C;
    public final ChunkDistanceManager D;
    private final AtomicInteger E;
    public final DefinedStructureManager F;
    private final String G;
    private final PlayerMap H;
    public final Int2ObjectMap<EntityTracker> I;
    private final Long2ByteMap J;
    private final Queue<Runnable> K;
    int L;
    public final PlayerAreaMap playerMobDistanceMap;
    public static final int GENERAL_AREA_MAP_SQUARE_RADIUS = 40;
    public static final double GENERAL_AREA_MAP_ACCEPTABLE_SEARCH_RANGE = 624.0;
    public static final double GENERAL_AREA_MAP_ACCEPTABLE_SEARCH_RANGE_SQUARED = 389376.0;
    public final PlayerAreaMap playerGeneralAreaMap;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();
    final CallbackExecutor chunkLoadConversionCallbackExecutor = new CallbackExecutor();
    private final PooledLinkedHashSets<EntityPlayer> pooledLinkedPlayerHashSets = new PooledLinkedHashSets();
    public final PlayerAreaMap playerMobSpawnMap;
    public final PlayerAreaMap playerChunkTickRangeMap;
    static final TrackingRange.TrackingRangeType[] TRACKING_RANGE_TYPES = TrackingRange.TrackingRangeType.values();
    public final PlayerAreaMap[] playerEntityTrackerTrackMaps;
    final int[] entityTrackerTrackRanges;
    public final List<SingleThreadChunkRegionManager> regionManagers = new ArrayList<SingleThreadChunkRegionManager>();
    public final SingleThreadChunkRegionManager dataRegionManager;
    boolean unloadingPlayerChunk = false;
    final ObjectRBTreeSet<PlayerChunk> autoSaveQueue = new ObjectRBTreeSet((playerchunk1, playerchunk2) -> {
        int timeCompare = Long.compare(playerchunk1.lastAutoSaveTime, playerchunk2.lastAutoSaveTime);
        if (timeCompare != 0) {
            return timeCompare;
        }
        return Long.compare(MCUtil.getCoordinateKey(playerchunk1.r), MCUtil.getCoordinateKey(playerchunk2.r));
    });
    public static final double UNLOAD_QUEUE_RESIZE_FACTOR = 0.9;

    public void addLightTask(PlayerChunk playerchunk, Runnable run) {
        this.mailboxLight.a(ChunkTaskQueueSorter.a(playerchunk, run));
    }

    public static boolean isLegacyTrackingEntity(Entity entity) {
        return entity.isLegacyTrackingEntity;
    }

    public final int getEntityTrackerRange(int ordinal) {
        return this.entityTrackerTrackRanges[ordinal];
    }

    private int convertSpigotRangeToVanilla(int vanilla) {
        return MinecraftServer.getServer().b(vanilla);
    }

    void addPlayerToDistanceMaps(EntityPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.dc());
        int chunkZ = MCUtil.getChunkCoordinate(player.di());
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i2];
            int trackRange = this.entityTrackerTrackRanges[i2];
            trackMap.add(player, chunkX, chunkZ, Math.min(trackRange, this.getEffectiveViewDistance()));
        }
        this.playerChunkTickRangeMap.add(player, chunkX, chunkZ, 8);
        this.playerGeneralAreaMap.add(player, chunkX, chunkZ, 40);
        if (this.playerMobDistanceMap != null) {
            this.playerMobDistanceMap.add(player, chunkX, chunkZ, this.D.getSimulationDistance());
        }
    }

    void removePlayerFromDistanceMaps(EntityPlayer player) {
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.playerEntityTrackerTrackMaps[i2].remove(player);
        }
        this.playerMobSpawnMap.remove(player);
        this.playerChunkTickRangeMap.remove(player);
        this.playerGeneralAreaMap.remove(player);
        if (this.playerMobDistanceMap != null) {
            this.playerMobDistanceMap.remove(player);
        }
    }

    void updateMaps(EntityPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.dc());
        int chunkZ = MCUtil.getChunkCoordinate(player.di());
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i2];
            int trackRange = this.entityTrackerTrackRanges[i2];
            trackMap.update(player, chunkX, chunkZ, Math.min(trackRange, this.getEffectiveViewDistance()));
        }
        this.playerChunkTickRangeMap.update(player, chunkX, chunkZ, 8);
        this.playerGeneralAreaMap.update(player, chunkX, chunkZ, 40);
        if (this.playerMobDistanceMap != null) {
            this.playerMobDistanceMap.update(player, chunkX, chunkZ, this.D.getSimulationDistance());
        }
    }

    public final PlayerChunk getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return (PlayerChunk)this.o.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public PlayerChunkMap(WorldServer world, Convertable.ConversionSession session, DataFixer dataFixer, DefinedStructureManager structureManager, Executor executor, IAsyncTaskHandler<Runnable> mainThreadExecutor, ILightAccess chunkProvider, ChunkGenerator chunkGenerator, WorldLoadListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<WorldPersistentData> persistentStateManagerFactory, int viewDistance, boolean dsync) {
        super(session.a(world.aa()).resolve("region"), dataFixer, dsync);
        ThreadedMailbox<Runnable> lightthreaded;
        this.o = new Long2ObjectLinkedOpenHashMap();
        this.p = new LongOpenHashSet();
        this.w = new LongOpenHashSet();
        this.E = new AtomicInteger();
        this.H = new PlayerMap();
        this.I = new Int2ObjectOpenHashMap();
        this.J = new Long2ByteOpenHashMap();
        this.K = new CachedSizeConcurrentLinkedQueue();
        this.F = structureManager;
        Path path = session.a(world.aa());
        this.G = path.getFileName().toString();
        this.q = world;
        this.t = chunkGenerator;
        this.s = mainThreadExecutor;
        this.mainInvokingExecutor = run -> {
            if (MCUtil.isMainThread()) {
                run.run();
            } else {
                mainThreadExecutor.execute(run);
            }
        };
        ThreadedMailbox<Runnable> threadedmailbox = ThreadedMailbox.a(executor, "worldgen");
        Objects.requireNonNull(mainThreadExecutor);
        Mailbox<Runnable> mailbox = Mailbox.a("main", mainThreadExecutor::h);
        this.B = worldGenerationProgressListener;
        this.C = chunkStatusChangeListener;
        ThreadedMailbox<Runnable> threadedmailbox1 = lightthreaded = ThreadedMailbox.a(executor, "light");
        this.y = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(threadedmailbox, mailbox, threadedmailbox1), executor, Integer.MAX_VALUE);
        this.z = this.y.a(threadedmailbox, false);
        this.A = this.y.a(mailbox, false);
        this.mailboxLight = this.y.a(lightthreaded, false);
        this.r = new LightEngineThreaded(chunkProvider, this, this.q.q_().b(), threadedmailbox1, this.y.a(threadedmailbox1, false));
        this.D = new ChunkDistanceManager(executor, mainThreadExecutor);
        this.u = persistentStateManagerFactory;
        this.v = new VillagePlace(path.resolve("poi"), dataFixer, dsync, world);
        this.a(viewDistance);
        this.dataRegionManager = new SingleThreadChunkRegionManager(this.q, 2, 0.3333333333333333, 1, 6, "Data", DataRegionData::new, DataRegionSectionData::new);
        this.regionManagers.add(this.dataRegionManager);
        this.playerMobDistanceMap = this.q.paperConfig.perPlayerMobSpawns ? new PlayerAreaMap(this.pooledLinkedPlayerHashSets) : null;
        this.playerEntityTrackerTrackMaps = new PlayerAreaMap[TRACKING_RANGE_TYPES.length];
        this.entityTrackerTrackRanges = new int[TRACKING_RANGE_TYPES.length];
        SpigotWorldConfig spigotWorldConfig = this.q.spigotConfig;
        for (TrackingRange.TrackingRangeType trackingRangeType : TRACKING_RANGE_TYPES) {
            int trackRange;
            int configuredSpigotValue = switch (trackingRangeType) {
                case TrackingRange.TrackingRangeType.PLAYER -> spigotWorldConfig.playerTrackingRange;
                case TrackingRange.TrackingRangeType.ANIMAL -> spigotWorldConfig.animalTrackingRange;
                case TrackingRange.TrackingRangeType.MONSTER -> spigotWorldConfig.monsterTrackingRange;
                case TrackingRange.TrackingRangeType.MISC -> spigotWorldConfig.miscTrackingRange;
                case TrackingRange.TrackingRangeType.OTHER -> spigotWorldConfig.otherTrackingRange;
                case TrackingRange.TrackingRangeType.ENDERDRAGON -> EntityTypes.v.n() * 16;
                default -> throw new IllegalStateException("Missing case for enum " + trackingRangeType);
            };
            configuredSpigotValue = this.convertSpigotRangeToVanilla(configuredSpigotValue);
            this.entityTrackerTrackRanges[ordinal] = trackRange = (configuredSpigotValue >>> 4) + ((configuredSpigotValue & 0xF) != 0 ? 1 : 0);
            this.playerEntityTrackerTrackMaps[ordinal] = new PlayerAreaMap(this.pooledLinkedPlayerHashSets);
        }
        this.playerChunkTickRangeMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInChunkTickRange = newState;
            }
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInChunkTickRange = newState;
            }
        });
        this.playerMobSpawnMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInMobSpawnRange = newState;
            }
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            PlayerChunk playerChunk = this.a(MCUtil.getCoordinateKey(rangeX, rangeZ));
            if (playerChunk != null) {
                playerChunk.playersInMobSpawnRange = newState;
            }
        });
        this.playerGeneralAreaMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            Chunk chunk = this.q.k().getChunkAtIfCachedImmediately(rangeX, rangeZ);
            if (chunk != null) {
                chunk.updateGeneralAreaCache(newState);
            }
        }, (player, rangeX, rangeZ, currPosX, currPosZ, prevPosX, prevPosZ, newState) -> {
            Chunk chunk = this.q.k().getChunkAtIfCachedImmediately(rangeX, rangeZ);
            if (chunk != null) {
                chunk.updateGeneralAreaCache(newState);
            }
        });
    }

    protected ChunkGenerator a() {
        return this.t;
    }

    public void b() {
        DataResult dataresult = ChunkGenerator.a.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.t);
        DataResult dataresult1 = dataresult.flatMap(jsonelement -> ChunkGenerator.a.parse((DynamicOps)JsonOps.INSTANCE, jsonelement));
        dataresult1.result().ifPresent(chunkgenerator -> {
            this.t = chunkgenerator;
        });
    }

    public void queueHolderUpdate(PlayerChunk playerchunk) {
        Runnable runnable = () -> {
            if (this.isUnloading(playerchunk)) {
                return;
            }
            this.D.pendingChunkUpdates.add(playerchunk);
            if (!this.D.pollingPendingChunkUpdates) {
                this.q.k().p();
            }
        };
        if (MCUtil.isMainThread()) {
            runnable.run();
        } else {
            this.s.execute(runnable);
        }
    }

    private boolean isUnloading(PlayerChunk playerchunk) {
        return playerchunk == null || this.w.contains(playerchunk.r.a());
    }

    private void updateChunkPriorityMap(Long2IntOpenHashMap map, long chunk, int level) {
        int prev = map.getOrDefault(chunk, -1);
        if (level > prev) {
            map.put(chunk, level);
        }
    }

    public void updatePlayerMobTypeMap(Entity entity) {
        if (!this.q.paperConfig.perPlayerMobSpawns) {
            return;
        }
        int index = entity.ad().f().ordinal();
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet inRange = this.playerMobDistanceMap.getObjectsInRange(entity.cZ());
        if (inRange == null) {
            return;
        }
        E[] backingSet = inRange.getBackingSet();
        for (int i2 = 0; i2 < backingSet.length; ++i2) {
            Object e2 = backingSet[i2];
            if (!(e2 instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)e2;
            int n2 = index;
            player.mobCounts[n2] = player.mobCounts[n2] + 1;
        }
    }

    public int getMobCountNear(EntityPlayer entityPlayer, EnumCreatureType mobCategory) {
        return entityPlayer.mobCounts[mobCategory.ordinal()];
    }

    private static double a(ChunkCoordIntPair pos, Entity entity) {
        double d0 = SectionPosition.a(pos.c, 8);
        double d1 = SectionPosition.a(pos.d, 8);
        double d2 = d0 - entity.dc();
        double d3 = d1 - entity.di();
        return d2 * d2 + d3 * d3;
    }

    public static boolean a(int x1, int z1, int x2, int z2, int distance) {
        int k2;
        int l2;
        int j1 = Math.max(0, Math.abs(x1 - x2) - 1);
        int k1 = Math.max(0, Math.abs(z1 - z2) - 1);
        long l1 = Math.max(0, Math.max(j1, k1) - 1);
        long i2 = Math.min(j1, k1);
        long j2 = i2 * i2 + l1 * l1;
        return j2 <= (long)(l2 = (k2 = distance - 1) * k2);
    }

    private static boolean b(int x1, int z1, int x2, int z2, int distance) {
        return !PlayerChunkMap.a(x1, z1, x2, z2, distance) ? false : (!PlayerChunkMap.a(x1 + 1, z1, x2, z2, distance) ? true : (!PlayerChunkMap.a(x1, z1 + 1, x2, z2, distance) ? true : (!PlayerChunkMap.a(x1 - 1, z1, x2, z2, distance) ? true : !PlayerChunkMap.a(x1, z1 - 1, x2, z2, distance))));
    }

    protected LightEngineThreaded c() {
        return this.r;
    }

    @Nullable
    public PlayerChunk a(long pos) {
        return this.updatingChunks.getUpdating(pos);
    }

    @Nullable
    public PlayerChunk b(long pos) {
        if (Thread.currentThread() == ((World)this.q).z) {
            return this.updatingChunks.getVisible(pos);
        }
        return this.updatingChunks.getVisibleAsync(pos);
    }

    protected IntSupplier c(long pos) {
        return () -> {
            PlayerChunk playerchunk = this.b(pos);
            return playerchunk == null ? ChunkTaskQueue.a - 1 : Math.min(playerchunk.k(), ChunkTaskQueue.a - 1);
        };
    }

    public String a(ChunkCoordIntPair chunkPos) {
        PlayerChunk playerchunk = this.b(chunkPos.a());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = playerchunk.j() + "\n";
        ChunkStatus chunkstatus = playerchunk.e();
        IChunkAccess ichunkaccess = playerchunk.f();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.c() + chunkstatus + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = s2 + "Ch: \u00a7" + ichunkaccess.j().c() + ichunkaccess.j() + "\u00a7r\n";
        }
        PlayerChunk.State playerchunk_state = playerchunk.h();
        s2 = s2 + "\u00a7" + playerchunk_state.ordinal() + playerchunk_state;
        return s2 + "\u00a7r";
    }

    public final int getEffectiveViewDistance() {
        return this.L - 1;
    }

    private CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> a(ChunkCoordIntPair centerChunk, final int margin, IntFunction<ChunkStatus> distanceToStatus) {
        ArrayList<CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>> list = new ArrayList<CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>>();
        ArrayList<PlayerChunk> list1 = new ArrayList<PlayerChunk>();
        final int j2 = centerChunk.c;
        final int k2 = centerChunk.d;
        PlayerChunk requestingNeighbor = this.a(centerChunk.a());
        for (int l2 = -margin; l2 <= margin; ++l2) {
            for (int i1 = -margin; i1 <= margin; ++i1) {
                int j1 = Math.max(Math.abs(i1), Math.abs(l2));
                final ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(j2 + i1, k2 + l2);
                long k1 = chunkcoordintpair1.a();
                PlayerChunk playerchunk = this.a(k1);
                if (playerchunk == null) {
                    return CompletableFuture.completedFuture(Either.right(new PlayerChunk.Failure(){

                        public String toString() {
                            return "Unloaded " + chunkcoordintpair1;
                        }
                    }));
                }
                ChunkStatus chunkstatus = distanceToStatus.apply(j1);
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = playerchunk.a(chunkstatus, this);
                if (requestingNeighbor != null && requestingNeighbor != playerchunk && !completablefuture.isDone()) {
                    requestingNeighbor.onNeighborRequest(playerchunk, chunkstatus);
                    completablefuture.thenAccept(either -> requestingNeighbor.onNeighborDone(playerchunk, chunkstatus, either.left().orElse(null)));
                }
                list1.add(playerchunk);
                list.add(completablefuture);
            }
        }
        CompletableFuture completablefuture1 = SystemUtils.b(list);
        CompletionStage completablefuture2 = completablefuture1.thenApply(list2 -> {
            ArrayList list3 = Lists.newArrayList();
            int cnt = 0;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                final int l1 = cnt++;
                final Either either = (Either)iterator.next();
                Optional optional = either.left();
                if (!optional.isPresent()) {
                    return Either.right(new PlayerChunk.Failure(){

                        public String toString() {
                            ChunkCoordIntPair chunkcoordintpair2 = new ChunkCoordIntPair(j2 + l1 % (margin * 2 + 1), k2 + l1 / (margin * 2 + 1));
                            return "Unloaded " + chunkcoordintpair2 + " " + either.right().get();
                        }
                    });
                }
                list3.add((IChunkAccess)optional.get());
            }
            return Either.left(list3);
        });
        for (PlayerChunk playerchunk1 : list1) {
            playerchunk1.a("getChunkRangeFuture " + centerChunk + " " + margin, (CompletableFuture<?>)completablefuture2);
        }
        return completablefuture2;
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> b(ChunkCoordIntPair pos) {
        return this.a(pos, 2, (int i2) -> ChunkStatus.o).thenApplyAsync(either -> either.mapLeft(list -> (Chunk)list.get(list.size() / 2)), this.mainInvokingExecutor);
    }

    @Nullable
    PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
        if (this.unloadingPlayerChunk) {
            MinecraftServer.r.fatal("Cannot tick distance manager while unloading playerchunks", new Throwable());
            throw new IllegalStateException("Cannot tick distance manager while unloading playerchunks");
        }
        if (k2 > b && level > b) {
            return holder;
        }
        if (holder != null) {
            holder.a(level);
            holder.updateRanges();
        }
        if (holder != null) {
            if (level > b) {
                this.w.add(pos);
            } else {
                this.w.remove(pos);
            }
        }
        if (level <= b && holder == null) {
            holder = (PlayerChunk)this.o.remove(pos);
            if (holder != null) {
                holder.a(level);
            } else {
                holder = new PlayerChunk(new ChunkCoordIntPair(pos), level, this.q, this.r, this.y, this);
                int len = this.regionManagers.size();
                for (int index = 0; index < len; ++index) {
                    this.regionManagers.get(index).addChunk(holder.r.c, holder.r.d);
                }
            }
            this.j().dequeueUnload(holder.r.longKey);
            this.updatingChunks.queueUpdate(pos, holder);
            this.x = true;
        }
        return holder;
    }

    @Override
    public void close() throws IOException {
        try {
            this.y.close();
            this.q.asyncChunkTaskManager.close(true);
            this.v.close();
        }
        finally {
            super.close();
        }
    }

    protected void saveIncrementally() {
        int savedThisTick = 0;
        ArrayList<PlayerChunk> reschedule = new ArrayList<PlayerChunk>(this.q.paperConfig.maxAutoSaveChunksPerTick);
        long currentTick = this.q.V();
        long maxSaveTime = currentTick - (long)this.q.paperConfig.autoSavePeriod;
        ObjectBidirectionalIterator iterator = this.autoSaveQueue.iterator();
        while (iterator.hasNext()) {
            PlayerChunk playerchunk = (PlayerChunk)iterator.next();
            if (playerchunk.lastAutoSaveTime > maxSaveTime) break;
            iterator.remove();
            IChunkAccess ichunkaccess = playerchunk.g().getNow(null);
            if (ichunkaccess instanceof Chunk) {
                boolean shouldSave;
                boolean bl = shouldSave = ((Chunk)ichunkaccess).lastSaveTime <= maxSaveTime;
                if (shouldSave && this.a(ichunkaccess) && this.q.P.a(playerchunk.r.a(), (T entity) -> {})) {
                    ++savedThisTick;
                    if (!playerchunk.setHasBeenLoaded()) {
                        playerchunk.inactiveTimeStart = currentTick;
                        if (savedThisTick < this.q.paperConfig.maxAutoSaveChunksPerTick) continue;
                        break;
                    }
                }
            }
            reschedule.add(playerchunk);
            if (savedThisTick < this.q.paperConfig.maxAutoSaveChunksPerTick) continue;
            break;
        }
        int len = reschedule.size();
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerChunk playerchunk = (PlayerChunk)reschedule.get(i2);
            playerchunk.lastAutoSaveTime = this.q.V();
            this.autoSaveQueue.add((Object)playerchunk);
        }
    }

    protected void a(boolean flush) {
        int[] saved = new int[1];
        int maxAsyncSaves = 50;
        Runnable onChunkSave = () -> {
            saved[0] = saved[0] + 1;
            if (saved[0] >= maxAsyncSaves) {
                saved[0] = 0;
                PaperFileIOThread.Holder.INSTANCE.flush();
            }
        };
        if (flush) {
            List list = this.updatingChunks.getVisibleValuesCopy().stream().filter(PlayerChunk::l).peek(PlayerChunk::m).collect(Collectors.toList());
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                boolean isShuttingDown = this.q.n().hasStopped();
                mutableboolean.setFalse();
                list.stream().map(playerchunk -> {
                    CompletableFuture<IChunkAccess> completablefuture;
                    do {
                        completablefuture = playerchunk.g();
                        IAsyncTaskHandler<Runnable> iasynctaskhandler = this.s;
                        Objects.requireNonNull(completablefuture);
                        iasynctaskhandler.c(completablefuture::isDone);
                    } while (completablefuture != playerchunk.g());
                    return completablefuture.join();
                }).filter(ichunkaccess -> ichunkaccess instanceof ProtoChunkExtension || ichunkaccess instanceof Chunk).filter(this::a).forEach(ichunkaccess -> {
                    onChunkSave.run();
                    mutableboolean.setTrue();
                });
            } while (mutableboolean.isTrue());
            this.b(() -> true);
            this.q.asyncChunkTaskManager.flush();
        } else {
            this.updatingChunks.getVisibleValuesCopy().forEach(this::d);
        }
    }

    protected void a(BooleanSupplier shouldKeepTicking) {
        GameProfilerFiller gameprofilerfiller = this.q.ab();
        try (Timing ignored = this.q.timings.poiUnload.startTiming();){
            gameprofilerfiller.a("poi");
            this.v.a(shouldKeepTicking);
        }
        gameprofilerfiller.b("chunk_unload");
        if (!this.q.s()) {
            ignored = this.q.timings.chunkUnload.startTiming();
            try {
                this.b(shouldKeepTicking);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        gameprofilerfiller.c();
    }

    private void b(BooleanSupplier shouldKeepTicking) {
        Runnable runnable;
        LongIterator longiterator = this.w.iterator();
        SlackActivityAccountant activityAccountant = this.q.n().slackActivityAccountant;
        activityAccountant.startActivity(0.5);
        int targetSize = Math.min(this.w.size() - 100, (int)((double)this.w.size() * 0.9));
        while (longiterator.hasNext()) {
            long j2 = longiterator.nextLong();
            longiterator.remove();
            PlayerChunk playerchunk = this.updatingChunks.queueRemove(j2);
            if (playerchunk == null) continue;
            this.o.put(j2, (Object)playerchunk);
            this.x = true;
            this.a(j2, playerchunk);
            if (shouldKeepTicking.getAsBoolean() || this.w.size() > targetSize || !activityAccountant.activityTimeIsExhausted()) continue;
            break;
        }
        activityAccountant.endActivity();
        for (int k2 = Math.max(0, Math.min(100, this.K.size() - (int)((double)this.K.size() * 0.9))); (shouldKeepTicking.getAsBoolean() || k2 > 0) && (runnable = this.K.poll()) != null; --k2) {
            runnable.run();
        }
        boolean l2 = false;
    }

    private void a(long pos, PlayerChunk holder) {
        CompletableFuture<IChunkAccess> completablefuture = holder.g();
        Consumer<IChunkAccess> consumer = ichunkaccess -> {
            block14: {
                CompletableFuture<IChunkAccess> completablefuture1 = holder.g();
                if (completablefuture1 != completablefuture) {
                    this.a(pos, holder);
                } else {
                    AsyncCatcher.catchOp("playerchunk unload");
                    boolean unloadingBefore = this.unloadingPlayerChunk;
                    this.unloadingPlayerChunk = true;
                    try {
                        boolean removed = this.o.remove(pos, (Object)holder);
                        if (removed && ichunkaccess != null) {
                            int len = this.regionManagers.size();
                            for (int index = 0; index < len; ++index) {
                                this.regionManagers.get(index).removeChunk(holder.r.c, holder.r.d);
                            }
                            this.j().queueUnload(holder.r.longKey, MinecraftServer.currentTickLong + 1L);
                            if (ichunkaccess instanceof Chunk) {
                                ((Chunk)ichunkaccess).c(false);
                            }
                            try {
                                this.asyncSave((IChunkAccess)ichunkaccess);
                            }
                            catch (ThreadDeath ex) {
                                throw ex;
                            }
                            catch (Throwable ex) {
                                i.fatal("Failed to prepare async save, attempting synchronous save", ex);
                                this.a((IChunkAccess)ichunkaccess);
                            }
                            if (this.p.remove(pos) && ichunkaccess instanceof Chunk) {
                                Chunk chunk = (Chunk)ichunkaccess;
                                this.q.a(chunk);
                            }
                            this.autoSaveQueue.remove((Object)holder);
                            this.r.a(ichunkaccess.f());
                            this.r.a();
                            this.B.a(ichunkaccess.f(), null);
                            break block14;
                        }
                        if (removed) {
                            int len = this.regionManagers.size();
                            for (int index = 0; index < len; ++index) {
                                this.regionManagers.get(index).removeChunk(holder.r.c, holder.r.d);
                            }
                            this.j().queueUnload(holder.r.longKey, MinecraftServer.currentTickLong + 1L);
                        }
                    }
                    finally {
                        this.unloadingPlayerChunk = unloadingBefore;
                    }
                }
            }
        };
        Queue<Runnable> queue = this.K;
        Objects.requireNonNull(this.K);
        ((CompletableFuture)completablefuture.thenAcceptAsync((Consumer)consumer, queue::add)).whenComplete((ovoid, throwable) -> {
            if (throwable != null) {
                i.error("Failed to save chunk {}", (Object)holder.i(), throwable);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean d() {
        if (!this.x) {
            return false;
        }
        QueuedChangesMapLong2Object<PlayerChunk> queuedChangesMapLong2Object = this.updatingChunks;
        synchronized (queuedChangesMapLong2Object) {
            this.updatingChunks.performUpdates();
        }
        this.x = false;
        return true;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(PlayerChunk holder, ChunkStatus requiredStatus) {
        ChunkCoordIntPair chunkcoordintpair = holder.i();
        if (requiredStatus == ChunkStatus.c) {
            return this.g(chunkcoordintpair);
        }
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> future = holder.a(requiredStatus.e(), this);
        return ((CompletableFuture)future.thenComposeAsync(either -> {
            Optional optional = either.left();
            if (!optional.isPresent()) {
                return CompletableFuture.completedFuture(either);
            }
            if (requiredStatus == ChunkStatus.l) {
                this.D.a(TicketType.e, chunkcoordintpair, 33 + ChunkStatus.a(ChunkStatus.l), chunkcoordintpair);
            }
            if (optional.isPresent() && ((IChunkAccess)optional.get()).j().b(requiredStatus)) {
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = requiredStatus.a(this.q, this.F, this.r, ichunkaccess -> this.c(holder), (IChunkAccess)optional.get());
                this.B.a(chunkcoordintpair, requiredStatus);
                return completablefuture;
            }
            return this.b(holder, requiredStatus);
        }, (Executor)this.s)).thenComposeAsync(CompletableFuture::completedFuture, (Executor)this.s);
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> g(ChunkCoordIntPair pos) {
        boolean isHighestPriority;
        BiFunction<ChunkRegionLoader.InProgressChunkHolder, Throwable, Either> syncLoadComplete = (chunkHolder, ioThrowable) -> {
            block17: {
                try (Timing ignored = this.q.timings.chunkLoad.startTimingIfSync();){
                    Either either;
                    block18: {
                        this.q.ab().d("chunkLoad");
                        if (ioThrowable != null) {
                            SneakyThrow.sneaky((Throwable)ioThrowable);
                        }
                        this.v.loadInData(pos, chunkHolder.poiData);
                        chunkHolder.tasks.forEach(Runnable::run);
                        this.j().dequeueUnload(pos.longKey);
                        if (chunkHolder.protoChunk == null) break block17;
                        Timing ignored2 = this.q.timings.chunkLoadLevelTimer.startTimingIfSync();
                        try {
                            ProtoChunk protochunk = chunkHolder.protoChunk;
                            this.a(pos, protochunk.j().g());
                            either = Either.left(protochunk);
                            if (ignored2 == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (ignored2 != null) {
                                try {
                                    ignored2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        ignored2.close();
                    }
                    return either;
                }
                catch (ReportedException reportedexception) {
                    Throwable throwable = reportedexception.getCause();
                    if (!(throwable instanceof IOException)) {
                        this.h(pos);
                        throw reportedexception;
                    }
                    i.error("Couldn't load chunk {}", (Object)pos, (Object)throwable);
                }
                catch (Exception exception) {
                    i.error("Couldn't load chunk {}", (Object)pos, (Object)exception);
                }
            }
            this.h(pos);
            return Either.left(new ProtoChunk(pos, ChunkConverter.a, this.q, this.q.t().d(IRegistry.aR), null));
        };
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> ret = new CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>();
        Consumer<ChunkRegionLoader.InProgressChunkHolder> chunkHolderConsumer = holder -> ChunkTaskManager.queueChunkWaitTask(() -> {
            try {
                ret.complete((Either)syncLoadComplete.apply((ChunkRegionLoader.InProgressChunkHolder)holder, (Throwable)null));
            }
            catch (Exception e2) {
                ret.completeExceptionally(e2);
            }
        });
        CompletableFuture<NBTTagCompound> chunkSaveFuture = this.q.asyncChunkTaskManager.getChunkSaveFuture(pos.c, pos.d);
        PlayerChunk playerChunk = this.a(pos.a());
        int chunkPriority = playerChunk != null ? playerChunk.requestedPriority : 33;
        int priority = 3;
        if (chunkPriority <= 10) {
            priority = 0;
        } else if (chunkPriority <= 20) {
            priority = 2;
        }
        boolean bl = isHighestPriority = priority == 0;
        if (chunkSaveFuture != null) {
            this.q.asyncChunkTaskManager.scheduleChunkLoad(pos.c, pos.d, priority, chunkHolderConsumer, isHighestPriority, chunkSaveFuture);
        } else {
            this.q.asyncChunkTaskManager.scheduleChunkLoad(pos.c, pos.d, priority, chunkHolderConsumer, isHighestPriority);
        }
        this.q.asyncChunkTaskManager.raisePriority(pos.c, pos.d, priority);
        return ret;
    }

    private void h(ChunkCoordIntPair pos) {
        this.J.put(pos.a(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair pos, ChunkStatus.Type type) {
        return this.J.put(pos.a(), (byte)(type == ChunkStatus.Type.a ? -1 : 1));
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(PlayerChunk holder, ChunkStatus requiredStatus) {
        ChunkCoordIntPair chunkcoordintpair = holder.i();
        CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> completablefuture = this.a(chunkcoordintpair, requiredStatus.f(), (int i2) -> this.a(requiredStatus, i2));
        this.q.ab().c(() -> "chunkGenerate " + requiredStatus.d());
        Executor executor = runnable -> {
            if (holder.canAdvanceStatus()) {
                this.mainInvokingExecutor.execute(runnable);
                return;
            }
            this.z.a(ChunkTaskQueueSorter.a(holder, runnable));
        };
        return ((CompletableFuture)completablefuture.thenComposeAsync(either -> either.map(list -> {
            try {
                CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture1 = requiredStatus.a(executor, this.q, this.t, this.F, this.r, ichunkaccess -> this.c(holder), (List<IChunkAccess>)list, false);
                this.B.a(chunkcoordintpair, requiredStatus);
                return completablefuture1;
            }
            catch (Exception exception) {
                exception.getStackTrace();
                CrashReport crashreport = CrashReport.a(exception, "Exception generating new chunk");
                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk to be generated");
                crashreportsystemdetails.a("Location", String.format("%d,%d", chunkcoordintpair.c, chunkcoordintpair.d));
                crashreportsystemdetails.a("Position hash", ChunkCoordIntPair.a(chunkcoordintpair.c, chunkcoordintpair.d));
                crashreportsystemdetails.a("Generator", this.t);
                this.s.execute(() -> {
                    throw new ReportedException(crashreport);
                });
                throw new ReportedException(crashreport);
            }
        }, playerchunk_failure -> {
            this.c(chunkcoordintpair);
            return CompletableFuture.completedFuture(Either.right(playerchunk_failure));
        }), executor)).thenComposeAsync(either -> CompletableFuture.completedFuture(either), (Executor)this.s);
    }

    protected void c(ChunkCoordIntPair pos) {
        this.s.h(SystemUtils.a(() -> this.D.b(TicketType.e, pos, 33 + ChunkStatus.a(ChunkStatus.l), pos), () -> "release light ticket " + pos));
    }

    private ChunkStatus a(ChunkStatus centerChunkTargetStatus, int distance) {
        ChunkStatus chunkstatus1 = distance == 0 ? centerChunkTargetStatus.e() : ChunkStatus.a(ChunkStatus.a(centerChunkTargetStatus) + distance);
        return chunkstatus1;
    }

    private static void a(WorldServer world, List<NBTTagCompound> nbt) {
        if (!nbt.isEmpty()) {
            world.b(EntityTypes.a(nbt, (World)world).filter(entity -> {
                boolean needsRemoval = false;
                DedicatedServer server = world.getCraftServer().getServer();
                if (!server.X() && entity instanceof NPC) {
                    entity.ah();
                    needsRemoval = true;
                }
                if (!server.W() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
                    entity.ah();
                    needsRemoval = true;
                }
                PlayerChunkMap.checkDupeUUID(world, entity);
                return !needsRemoval;
            }));
        }
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> c(PlayerChunk chunkHolder) {
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = chunkHolder.a(ChunkStatus.o.e());
        return completablefuture.thenApplyAsync(either -> {
            ChunkStatus chunkstatus = PlayerChunk.b(chunkHolder.j());
            return !chunkstatus.b(ChunkStatus.o) ? PlayerChunk.a : either.mapLeft(ichunkaccess -> {
                try (Timing ignored = this.q.timings.chunkPostLoad.startTimingIfSync();){
                    Chunk chunk;
                    ChunkCoordIntPair chunkcoordintpair = chunkHolder.i();
                    ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
                    if (protochunk instanceof ProtoChunkExtension) {
                        chunk = ((ProtoChunkExtension)protochunk).A();
                    } else {
                        chunk = new Chunk(this.q, protochunk, chunk1 -> PlayerChunkMap.a(this.q, protochunk.D()));
                        chunkHolder.a(new ProtoChunkExtension(chunk, false));
                    }
                    chunk.b(() -> PlayerChunk.c(chunkHolder.j()));
                    chunk.C();
                    if (this.p.add(chunkcoordintpair.a())) {
                        chunk.c(true);
                        chunk.H();
                        chunk.a(this.q);
                    }
                    Chunk chunk2 = chunk;
                    return chunk2;
                }
            });
        }, runnable -> {
            Mailbox<ChunkTaskQueueSorter.a<Runnable>> mailbox = this.A;
            long i2 = chunkHolder.i().a();
            Objects.requireNonNull(chunkHolder);
            mailbox.a(ChunkTaskQueueSorter.a(runnable, i2, () -> 1));
        });
    }

    private static void checkDupeUUID(WorldServer level, Entity entity) {
        PaperWorldConfig.DuplicateUUIDMode mode = level.paperConfig.duplicateUUIDMode;
        if (mode != PaperWorldConfig.DuplicateUUIDMode.WARN && mode != PaperWorldConfig.DuplicateUUIDMode.DELETE && mode != PaperWorldConfig.DuplicateUUIDMode.SAFE_REGEN) {
            return;
        }
        Entity other = level.a(entity.cm());
        if (mode == PaperWorldConfig.DuplicateUUIDMode.SAFE_REGEN && other != null && !other.do() && Objects.equals(other.bk(), entity.bk()) && entity.getBukkitEntity().getLocation().distance(other.getBukkitEntity().getLocation()) < (double)level.paperConfig.duplicateUUIDDeleteRange) {
            if (World.DEBUG_ENTITIES) {
                i.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", deleted entity " + entity + " because it was near the duplicate and likely an actual duplicate. See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
            }
            entity.ah();
            return;
        }
        if (other != null && !other.do()) {
            switch (mode) {
                case SAFE_REGEN: {
                    entity.a_(UUID.randomUUID());
                    if (!World.DEBUG_ENTITIES) break;
                    i.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", regenerated UUID for " + entity + ". See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
                    break;
                }
                case DELETE: {
                    if (World.DEBUG_ENTITIES) {
                        i.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", deleted entity " + entity + ". See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
                    }
                    entity.ah();
                    break;
                }
                default: {
                    if (!World.DEBUG_ENTITIES) break;
                    i.warn("[DUPE-UUID] Duplicate UUID found used by " + other + ", doing nothing to " + entity + ". See https://github.com/PaperMC/Paper/issues/1223 for discussion on what this is about.");
                }
            }
        }
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> a(PlayerChunk holder) {
        ChunkCoordIntPair chunkcoordintpair = holder.i();
        CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> completablefuture = this.a(chunkcoordintpair, 1, (int i2) -> ChunkStatus.o);
        CompletionStage completablefuture1 = completablefuture.thenApplyAsync(either -> either.flatMap(list -> {
            Chunk chunk = (Chunk)list.get(list.size() / 2);
            chunk.F();
            this.q.b(chunk);
            return Either.left(chunk);
        }), runnable -> this.A.a(ChunkTaskQueueSorter.a(holder, () -> this.chunkLoadConversionCallbackExecutor.execute(runnable))));
        ((CompletableFuture)completablefuture1).thenAcceptAsync(either -> either.ifLeft(chunk -> {
            this.E.getAndIncrement();
            MutableObject mutableobject = new MutableObject();
            this.a(chunkcoordintpair, false).forEach(entityplayer -> this.a((EntityPlayer)entityplayer, (MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>>)mutableobject, (Chunk)chunk));
        }), runnable -> this.A.a(ChunkTaskQueueSorter.a(holder, runnable)));
        return completablefuture1;
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> b(PlayerChunk playerchunk) {
        return this.a(playerchunk.i(), 1, ChunkStatus::a).thenApplyAsync(either -> either.mapLeft(list -> {
            Chunk chunk = (Chunk)list.get(list.size() / 2);
            return chunk;
        }), (Executor)this.s);
    }

    public int e() {
        return this.E.get();
    }

    private boolean d(PlayerChunk chunkHolder) {
        if (!chunkHolder.l()) {
            return false;
        }
        IChunkAccess ichunkaccess = chunkHolder.g().getNow(null);
        if (!(ichunkaccess instanceof ProtoChunkExtension) && !(ichunkaccess instanceof Chunk)) {
            return false;
        }
        boolean flag = this.a(ichunkaccess);
        chunkHolder.m();
        return flag;
    }

    private void asyncSave(IChunkAccess chunk) {
        ChunkRegionLoader.AsyncSaveData asyncSaveData;
        NBTTagCompound poiData;
        ChunkCoordIntPair chunkPos = chunk.f();
        try (Timing ignored = this.q.timings.chunkUnloadPOISerialization.startTiming();){
            poiData = this.v.getData(chunk.f());
        }
        PaperFileIOThread.Holder.INSTANCE.scheduleSave(this.q, chunkPos.c, chunkPos.d, poiData, null, 3);
        if (!chunk.i()) {
            return;
        }
        ChunkStatus chunkstatus = chunk.j();
        if (chunkstatus.g() != ChunkStatus.Type.b && chunkstatus == ChunkStatus.c && chunk.g().values().stream().noneMatch(StructureStart::b)) {
            return;
        }
        try (Timing ignored = this.q.timings.chunkUnloadPrepareSave.startTiming();){
            asyncSaveData = ChunkRegionLoader.getAsyncSaveData(this.q, chunk);
        }
        this.q.asyncChunkTaskManager.scheduleChunkSave(chunkPos.c, chunkPos.d, 3, asyncSaveData, chunk);
        chunk.a(false);
        chunk.setLastSaved(this.q.V());
    }

    public boolean a(IChunkAccess chunk) {
        try (Timing ignored = this.q.timings.chunkSave.startTiming();){
            NBTTagCompound nbttagcompound;
            ChunkStatus chunkstatus;
            this.v.a(chunk.f());
            if (!chunk.i()) {
                boolean bl = false;
                return bl;
            }
            chunk.setLastSaved(this.q.V());
            chunk.a(false);
            ChunkCoordIntPair chunkcoordintpair = chunk.f();
            try {
                chunkstatus = chunk.j();
                if (chunkstatus.g() != ChunkStatus.Type.b && chunkstatus == ChunkStatus.c && chunk.g().values().stream().noneMatch(StructureStart::b)) {
                    boolean bl = false;
                    return bl;
                }
                this.q.ab().d("chunkSave");
            }
            catch (Exception exception) {
                i.error("Failed to save chunk {},{}", (Object)chunkcoordintpair.c, (Object)chunkcoordintpair.d, (Object)exception);
                ServerInternalException.reportInternalException((Throwable)exception);
                boolean bl = false;
                return bl;
            }
            try (Timing ignored1 = this.q.timings.chunkSaveDataSerialization.startTiming();){
                nbttagcompound = ChunkRegionLoader.a(this.q, chunk);
            }
            PaperFileIOThread.Holder.INSTANCE.scheduleSave(this.q, chunkcoordintpair.c, chunkcoordintpair.d, null, nbttagcompound, 3);
            this.a(chunkcoordintpair, chunkstatus.g());
            boolean bl = true;
            return bl;
        }
    }

    private boolean i(ChunkCoordIntPair pos) {
        NBTTagCompound nbttagcompound;
        byte b0 = this.J.get(pos.a());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            nbttagcompound = this.j(pos);
            if (nbttagcompound == null) {
                this.h(pos);
                return false;
            }
        }
        catch (Exception exception) {
            i.error("Failed to read chunk {}", (Object)pos, (Object)exception);
            this.h(pos);
            return false;
        }
        ChunkStatus.Type chunkstatus_type = ChunkRegionLoader.a(nbttagcompound);
        return this.a(pos, chunkstatus_type) == 1;
    }

    public void a(int watchDistance) {
        int j2 = MathHelper.a(watchDistance + 1, 3, 33);
        if (j2 != this.L) {
            int k2 = this.L;
            this.L = j2;
            this.D.a(this.L + 1);
            for (PlayerChunk playerchunk : this.updatingChunks.getVisibleValuesCopy()) {
                ChunkCoordIntPair chunkcoordintpair = playerchunk.i();
                MutableObject mutableobject = new MutableObject();
                this.a(chunkcoordintpair, false).forEach(entityplayer -> {
                    SectionPosition sectionposition = entityplayer.R();
                    boolean flag = PlayerChunkMap.a(chunkcoordintpair.c, chunkcoordintpair.d, sectionposition.a(), sectionposition.c(), k2);
                    boolean flag1 = PlayerChunkMap.a(chunkcoordintpair.c, chunkcoordintpair.d, sectionposition.a(), sectionposition.c(), this.L);
                    this.a((EntityPlayer)entityplayer, chunkcoordintpair, (MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>>)mutableobject, flag, flag1);
                });
            }
        }
    }

    protected void a(EntityPlayer player, ChunkCoordIntPair pos, MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>> mutableobject, boolean oldWithinViewDistance, boolean newWithinViewDistance) {
        if (player.t == this.q) {
            PlayerChunk playerchunk;
            if (newWithinViewDistance && !oldWithinViewDistance && (playerchunk = this.b(pos.a())) != null) {
                Chunk chunk = playerchunk.d();
                if (chunk != null) {
                    this.a(player, mutableobject, chunk);
                }
                PacketDebug.a(this.q, pos);
            }
            if (!newWithinViewDistance && oldWithinViewDistance) {
                player.a(pos);
            }
        }
    }

    public int f() {
        return this.updatingChunks.getVisibleMap().size();
    }

    public ChunkMapDistance g() {
        return this.D;
    }

    protected Iterable<PlayerChunk> h() {
        return Iterables.unmodifiableIterable(this.updatingChunks.getVisibleValuesCopy());
    }

    void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("z").a("level").a("in_memory").a("status").a("full_status").a("accessible_ready").a("ticking_ready").a("entity_ticking_ready").a("ticket").a("spawning").a("block_entity_count").a("ticking_ticket").a("ticking_level").a("block_ticks").a("fluid_ticks").a(writer);
        TickingTracker tickingtracker = this.D.d();
        ObjectBidirectionalIterator objectbidirectionaliterator = this.updatingChunks.getVisibleMap().clone().long2ObjectEntrySet().fastIterator();
        while (objectbidirectionaliterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectbidirectionaliterator.next();
            long i2 = entry.getLongKey();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
            PlayerChunk playerchunk = (PlayerChunk)entry.getValue();
            Optional<IChunkAccess> optional = Optional.ofNullable(playerchunk.f());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof Chunk ? Optional.of((Chunk)ichunkaccess) : Optional.empty());
            csvwriter.a(chunkcoordintpair.c, chunkcoordintpair.d, playerchunk.j(), optional.isPresent(), optional.map(IChunkAccess::j).orElse(null), optional1.map(Chunk::B).orElse(null), PlayerChunkMap.a(playerchunk.c()), PlayerChunkMap.a(playerchunk.a()), PlayerChunkMap.a(playerchunk.b()), this.D.e(i2), this.d(chunkcoordintpair), optional1.map(chunk -> chunk.E().size()).orElse(0), tickingtracker.d(i2), tickingtracker.c(i2), optional1.map(chunk -> chunk.o().a()).orElse(0), optional1.map(chunk -> chunk.p().a()).orElse(0));
        }
    }

    private static String a(CompletableFuture<Either<Chunk, PlayerChunk.Failure>> completablefuture) {
        try {
            Either either = completablefuture.getNow(null);
            return either != null ? either.map(chunk -> "done", playerchunk_failure -> "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    @Override
    @Nullable
    public NBTTagCompound f(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        if (Thread.currentThread() != PaperFileIOThread.Holder.INSTANCE) {
            NBTTagCompound ret = PaperFileIOThread.Holder.INSTANCE.loadChunkDataAsyncFuture((WorldServer)this.q, (int)chunkcoordintpair.c, (int)chunkcoordintpair.d, (int)IOUtil.getPriorityForCurrentThread(), (boolean)false, (boolean)true, (boolean)true).join().chunkData;
            if (ret == PaperFileIOThread.FAILURE_VALUE) {
                throw new IOException("See logs for further detail");
            }
            return ret;
        }
        return super.f(chunkcoordintpair);
    }

    @Override
    public void a(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) throws IOException {
        if (Thread.currentThread() != PaperFileIOThread.Holder.INSTANCE) {
            PaperFileIOThread.Holder.INSTANCE.scheduleSave(this.q, chunkcoordintpair.c, chunkcoordintpair.d, null, nbttagcompound, IOUtil.getPriorityForCurrentThread());
            return;
        }
        super.a(chunkcoordintpair, nbttagcompound);
    }

    @Nullable
    public NBTTagCompound j(ChunkCoordIntPair pos) throws IOException {
        NBTTagCompound nbttagcompound = this.f(pos);
        if (nbttagcompound == null) {
            return null;
        }
        nbttagcompound = this.upgradeChunkTag(this.q.getTypeKey(), this.u, nbttagcompound, this.t.b(), pos, this.q);
        if (nbttagcompound == null) {
            return null;
        }
        this.updateChunkStatusOnDisk(pos, nbttagcompound);
        return nbttagcompound;
    }

    public ChunkStatus getChunkStatusOnDiskIfCached(ChunkCoordIntPair chunkPos) {
        RegionFile regionFile = this.regionFileCache.getRegionFileIfLoaded(chunkPos);
        return regionFile == null ? null : regionFile.getStatusIfCached(chunkPos.c, chunkPos.d);
    }

    public ChunkStatus getChunkStatusOnDisk(ChunkCoordIntPair chunkPos) throws IOException {
        RegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, true);
        if (regionFile == null || !this.regionFileCache.chunkExists(chunkPos)) {
            return null;
        }
        ChunkStatus status = regionFile.getStatusIfCached(chunkPos.c, chunkPos.d);
        if (status != null) {
            return status;
        }
        this.j(chunkPos);
        return regionFile.getStatusIfCached(chunkPos.c, chunkPos.d);
    }

    public void updateChunkStatusOnDisk(ChunkCoordIntPair chunkPos, @Nullable NBTTagCompound compound) throws IOException {
        RegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, false);
        regionFile.setStatus(chunkPos.c, chunkPos.d, ChunkRegionLoader.getStatus(compound));
    }

    public IChunkAccess getUnloadingChunk(int chunkX, int chunkZ) {
        PlayerChunk chunkHolder = (PlayerChunk)this.o.get(ChunkCoordIntPair.a(chunkX, chunkZ));
        return chunkHolder == null ? null : chunkHolder.getAvailableChunkNow();
    }

    boolean d(ChunkCoordIntPair pos) {
        return this.anyPlayerCloseEnoughForSpawning(pos, false);
    }

    final boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        return this.anyPlayerCloseEnoughForSpawning(this.a(chunkcoordintpair.a()), chunkcoordintpair, reducedRange);
    }

    final boolean anyPlayerCloseEnoughForSpawning(PlayerChunk playerchunk, ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInRange;
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> pooledObjectLinkedOpenHashSet = playersInRange = reducedRange ? playerchunk.playersInMobSpawnRange : playerchunk.playersInChunkTickRange;
        if (playersInRange == null) {
            return false;
        }
        EntityPlayer[] backingSet = playersInRange.getBackingSet();
        if (reducedRange) {
            for (EntityPlayer raw : backingSet) {
                EntityPlayer player;
                if (!(raw instanceof EntityPlayer) || !(PlayerChunkMap.a(chunkcoordintpair, player = raw) < player.lastEntitySpawnRadiusSquared)) continue;
                return true;
            }
        } else {
            double range = 16384.0;
            for (EntityPlayer raw : backingSet) {
                EntityPlayer player;
                if (!(raw instanceof EntityPlayer) || !(PlayerChunkMap.a(chunkcoordintpair, player = raw) < 16384.0)) continue;
                return true;
            }
        }
        return false;
    }

    public List<EntityPlayer> e(ChunkCoordIntPair pos) {
        long i2 = pos.a();
        if (!this.D.f(i2)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.H.a(i2)) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, pos, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, double range) {
        if (entityplayer.B_()) {
            return false;
        }
        double d0 = PlayerChunkMap.a(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean b(EntityPlayer player) {
        return player.B_() && !this.q.X().b(GameRules.q);
    }

    void a(EntityPlayer player, boolean added) {
        boolean flag1 = this.b(player);
        boolean flag2 = this.H.c(player);
        int i2 = SectionPosition.a(player.db());
        int j2 = SectionPosition.a(player.dh());
        if (added) {
            this.H.a(ChunkCoordIntPair.a(i2, j2), player, flag1);
            this.c(player);
            if (!flag1) {
                this.D.a(SectionPosition.a(player), player);
            }
            this.addPlayerToDistanceMaps(player);
        } else {
            SectionPosition sectionposition = player.R();
            this.H.a(sectionposition.r().a(), player);
            if (!flag2) {
                this.D.b(sectionposition, player);
            }
            this.removePlayerFromDistanceMaps(player);
        }
        for (int k2 = i2 - this.L - 1; k2 <= i2 + this.L + 1; ++k2) {
            for (int l2 = j2 - this.L - 1; l2 <= j2 + this.L + 1; ++l2) {
                if (!PlayerChunkMap.a(k2, l2, i2, j2, this.L)) continue;
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(k2, l2);
                this.a(player, chunkcoordintpair, (MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>>)new MutableObject(), !added, added);
            }
        }
    }

    private SectionPosition c(EntityPlayer player) {
        SectionPosition sectionposition = SectionPosition.a(player);
        player.a(sectionposition);
        player.b.a(new PacketPlayOutViewCentre(sectionposition.a(), sectionposition.c()));
        return sectionposition;
    }

    public void a(EntityPlayer player) {
        boolean flag2;
        int i2 = SectionPosition.a(player.db());
        int j2 = SectionPosition.a(player.dh());
        SectionPosition sectionposition = player.R();
        SectionPosition sectionposition1 = SectionPosition.a(player);
        long k2 = sectionposition.r().a();
        long l2 = sectionposition1.r().a();
        boolean flag = this.H.d(player);
        boolean flag1 = this.b(player);
        boolean bl = flag2 = sectionposition.s() != sectionposition1.s();
        if (flag2 || flag != flag1) {
            this.c(player);
            if (!flag) {
                this.D.b(sectionposition, player);
            }
            if (!flag1) {
                this.D.a(sectionposition1, player);
            }
            if (!flag && flag1) {
                this.H.a(player);
            }
            if (flag && !flag1) {
                this.H.b(player);
            }
            if (k2 != l2) {
                this.H.a(k2, l2, player);
            }
        }
        int i1 = sectionposition.a();
        int j1 = sectionposition.c();
        if (Math.abs(i1 - i2) <= this.L * 2 && Math.abs(j1 - j2) <= this.L * 2) {
            int k1 = Math.min(i2, i1) - this.L - 1;
            int l1 = Math.min(j2, j1) - this.L - 1;
            int i22 = Math.max(i2, i1) + this.L + 1;
            int j22 = Math.max(j2, j1) + this.L + 1;
            for (int k22 = k1; k22 <= i22; ++k22) {
                for (int l22 = l1; l22 <= j22; ++l22) {
                    boolean flag3 = PlayerChunkMap.a(k22, l22, i1, j1, this.L);
                    boolean flag4 = PlayerChunkMap.a(k22, l22, i2, j2, this.L);
                    this.a(player, new ChunkCoordIntPair(k22, l22), (MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>>)new MutableObject(), flag3, flag4);
                }
            }
        } else {
            boolean flag6;
            boolean flag5;
            int l1;
            int k1;
            for (k1 = i1 - this.L - 1; k1 <= i1 + this.L + 1; ++k1) {
                for (l1 = j1 - this.L - 1; l1 <= j1 + this.L + 1; ++l1) {
                    if (!PlayerChunkMap.a(k1, l1, i1, j1, this.L)) continue;
                    flag5 = true;
                    flag6 = false;
                    this.a(player, new ChunkCoordIntPair(k1, l1), (MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>>)new MutableObject(), true, false);
                }
            }
            for (k1 = i2 - this.L - 1; k1 <= i2 + this.L + 1; ++k1) {
                for (l1 = j2 - this.L - 1; l1 <= j2 + this.L + 1; ++l1) {
                    if (!PlayerChunkMap.a(k1, l1, i2, j2, this.L)) continue;
                    flag5 = false;
                    flag6 = true;
                    this.a(player, new ChunkCoordIntPair(k1, l1), (MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>>)new MutableObject(), false, true);
                }
            }
        }
        this.updateMaps(player);
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair chunkPos, boolean onlyOnWatchDistanceEdge) {
        Set<EntityPlayer> set = this.H.a(chunkPos.a());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : set) {
            SectionPosition sectionposition = entityplayer.R();
            if ((!onlyOnWatchDistanceEdge || !PlayerChunkMap.b(chunkPos.c, chunkPos.d, sectionposition.a(), sectionposition.c(), this.L)) && (onlyOnWatchDistanceEdge || !PlayerChunkMap.a(chunkPos.c, chunkPos.d, sectionposition.a(), sectionposition.c(), this.L))) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    public void a(Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.t != this.q || this.I.containsKey(entity.ae())) {
            new Throwable("[ERROR] Illegal PlayerChunkMap::addEntity for world " + this.q.getWorld().getName() + ": " + entity + (this.I.containsKey(entity.ae()) ? " ALREADY CONTAINED (This would have crashed your server)" : "")).printStackTrace();
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).supressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> entitytypes = entity.ad();
            int i2 = entitytypes.n() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                EntityTracker playerchunkmap_entitytracker;
                int j2 = entitytypes.o();
                if (this.I.containsKey(entity.ae())) {
                    throw SystemUtils.c(new IllegalStateException("Entity is already tracked!"));
                }
                entity.tracker = playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.p());
                this.I.put(entity.ae(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.updatePlayers(entity.getPlayersInTrackRange());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    this.a(entityplayer, true);
                    for (EntityTracker playerchunkmap_entitytracker1 : this.I.values()) {
                        if (playerchunkmap_entitytracker1.c == entityplayer) continue;
                        playerchunkmap_entitytracker1.b(entityplayer);
                    }
                }
            }
        }
    }

    protected void b(Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.a(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.I.values()) {
                playerchunkmap_entitytracker.a(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.I.remove(entity.ae())) != null) {
            playerchunkmap_entitytracker1.a();
        }
        entity.tracker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processTrackQueue() {
        this.q.timings.tracker1.startTiming();
        try {
            for (EntityTracker tracker : this.I.values()) {
                tracker.updatePlayers(tracker.c.getPlayersInTrackRange());
            }
        }
        finally {
            this.q.timings.tracker1.stopTiming();
        }
        this.q.timings.tracker2.startTiming();
        try {
            for (EntityTracker tracker : this.I.values()) {
                tracker.b.a();
            }
        }
        finally {
            this.q.timings.tracker2.stopTiming();
        }
    }

    protected void i() {
        this.processTrackQueue();
    }

    public void a(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.I.get(entity.ae());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet);
        }
    }

    protected void b(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.I.get(entity.ae());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.b(packet);
        }
    }

    private void a(EntityPlayer player, MutableObject<Map<Object, ClientboundLevelChunkWithLightPacket>> cachedDataPackets, Chunk chunk) {
        if (cachedDataPackets.getValue() == null) {
            cachedDataPackets.setValue(new HashMap());
        }
        Boolean shouldModify = chunk.D().chunkPacketBlockController.shouldModify(player, chunk);
        player.a(chunk.f(), ((Map)cachedDataPackets.getValue()).computeIfAbsent(shouldModify, s2 -> new ClientboundLevelChunkWithLightPacket(chunk, this.r, null, null, true, (Boolean)s2)));
        PacketDebug.a(this.q, chunk.f());
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        Entity[] entities = chunk.entities.getRawData();
        int size = chunk.entities.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Entity entity = entities[i2];
            if (entity == player) continue;
            EntityTracker tracker = (EntityTracker)this.I.get(entity.ae());
            if (tracker != null) {
                tracker.b(player);
            }
            if (entity instanceof EntityInsentient && ((EntityInsentient)entity).fq() != null) {
                list.add(entity);
            }
            if (entity.cF().isEmpty()) continue;
            list1.add(entity);
        }
        if (!list.isEmpty()) {
            for (Entity entity1 : list) {
                player.b.a(new PacketPlayOutAttachEntity(entity1, ((EntityInsentient)entity1).fq()));
            }
        }
        if (!list1.isEmpty()) {
            for (Entity entity1 : list1) {
                player.b.a(new PacketPlayOutMount(entity1));
            }
        }
    }

    public VillagePlace j() {
        return this.v;
    }

    public String k() {
        return this.G;
    }

    void a(ChunkCoordIntPair chunkPos, PlayerChunk.State levelType) {
        this.C.onChunkStatusChange(chunkPos, levelType);
    }

    public class ChunkDistanceManager
    extends ChunkMapDistance {
        protected ChunkDistanceManager(Executor workerExecutor, Executor mainThreadExecutor) {
            super(workerExecutor, mainThreadExecutor, PlayerChunkMap.this);
        }

        @Override
        protected boolean a(long pos) {
            return PlayerChunkMap.this.w.contains(pos);
        }

        @Override
        @Nullable
        protected PlayerChunk b(long pos) {
            return PlayerChunkMap.this.a(pos);
        }

        @Override
        @Nullable
        protected PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
            return PlayerChunkMap.this.a(pos, level, holder, k2);
        }
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private Runnable queued;

        @Override
        public void execute(Runnable runnable) {
            AsyncCatcher.catchOp("Callback Executor execute");
            if (this.queued != null) {
                MinecraftServer.r.fatal("Failed to schedule runnable", (Throwable)new IllegalStateException("Already queued"));
                throw new IllegalStateException("Already queued");
            }
            this.queued = runnable;
        }

        @Override
        public void run() {
            AsyncCatcher.catchOp("Callback Executor execute");
            Runnable task = this.queued;
            if (task != null) {
                this.queued = null;
                task.run();
            }
        }
    }

    public class EntityTracker {
        final EntityTrackerEntry b;
        final Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = new ReferenceOpenHashSet();
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> lastTrackerCandidates;

        public EntityTracker(Entity entity, int i2, int j2, boolean flag) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.q, entity, j2, flag, this::a, this.f);
            this.c = entity;
            this.d = i2;
            this.e = SectionPosition.a(entity);
        }

        final void updatePlayers(PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> newTrackerCandidates) {
            PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> oldTrackerCandidates = this.lastTrackerCandidates;
            this.lastTrackerCandidates = newTrackerCandidates;
            if (newTrackerCandidates != null) {
                for (EntityPlayer raw : newTrackerCandidates.getBackingSet()) {
                    if (!(raw instanceof EntityPlayer)) continue;
                    EntityPlayer player = raw;
                    this.b(player);
                }
            }
            if (oldTrackerCandidates == newTrackerCandidates) {
                return;
            }
            for (ServerPlayerConnection conn : this.f.toArray(new ServerPlayerConnection[0])) {
                if (newTrackerCandidates != null && newTrackerCandidates.contains(conn.d())) continue;
                this.b(conn.d());
            }
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).c.ae() == this.c.ae() : false;
        }

        public int hashCode() {
            return this.c.ae();
        }

        public void a(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                serverplayerconnection.a(packet);
            }
        }

        public void b(Packet<?> packet) {
            this.a(packet);
            if (this.c instanceof EntityPlayer) {
                ((EntityPlayer)this.c).b.a(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                this.b.a(serverplayerconnection.d());
            }
        }

        public void a(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(player.b)) {
                this.b.a(player);
            }
        }

        public void b(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.c) {
                double d0;
                double d2;
                boolean flag;
                double vec3d_dz;
                double vec3d_dx = player.dc() - this.c.dc();
                double d1 = vec3d_dx * vec3d_dx + (vec3d_dz = player.di() - this.c.di()) * vec3d_dz;
                boolean bl = flag = d1 <= (d2 = (d0 = (double)Math.min(this.b(), (PlayerChunkMap.this.L - 1) * 16)) * d0) && this.c.a(player);
                if (!player.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(player.b)) {
                        this.b.b(player);
                    }
                } else if (this.f.remove(player.b)) {
                    this.b.a(player);
                }
            }
        }

        private int a(int initialDistance) {
            return PlayerChunkMap.this.q.n().b(initialDistance);
        }

        private int b() {
            int i2 = this.d;
            for (Entity entity : this.c.cJ()) {
                int j2 = entity.ad().n() * 16;
                if ((j2 = TrackingRange.getEntityTrackingRange(entity, j2)) <= i2) continue;
                i2 = j2;
            }
            return this.a(i2);
        }

        public void a(List<EntityPlayer> players) {
            for (EntityPlayer entityplayer : players) {
                this.b(entityplayer);
            }
        }
    }

    public static final class DataRegionSectionData
    implements SingleThreadChunkRegionManager.RegionSectionData {
        private IteratorSafeOrderedReferenceSet<EntityInsentient> navigators;

        public IteratorSafeOrderedReferenceSet<EntityInsentient> getNavigators() {
            return this.navigators;
        }

        public boolean addToNavigators(SingleThreadChunkRegionManager.RegionSection section, EntityInsentient navigator) {
            DataRegionData data;
            boolean ret;
            if (this.navigators == null) {
                this.navigators = new IteratorSafeOrderedReferenceSet();
            }
            if ((ret = this.navigators.add(navigator)) && !(data = (DataRegionData)section.getRegion().regionData).addToNavigators(navigator)) {
                throw new IllegalStateException();
            }
            return ret;
        }

        public boolean removeFromNavigators(SingleThreadChunkRegionManager.RegionSection section, EntityInsentient navigator) {
            DataRegionData data;
            if (this.navigators == null) {
                return false;
            }
            boolean ret = this.navigators.remove(navigator);
            if (ret && !(data = (DataRegionData)section.getRegion().regionData).removeFromNavigators(navigator)) {
                throw new IllegalStateException();
            }
            return ret;
        }

        @Override
        public void removeFromRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region from) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData fromData = (DataRegionData)from.regionData;
            if (sectionData.navigators != null) {
                Iterator<EntityInsentient> iterator = sectionData.navigators.unsafeIterator(1);
                while (iterator.hasNext()) {
                    if (fromData.removeFromNavigators(iterator.next())) continue;
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public void addToRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region oldRegion, SingleThreadChunkRegionManager.Region newRegion) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData oldRegionData = oldRegion == null ? null : (DataRegionData)oldRegion.regionData;
            DataRegionData newRegionData = (DataRegionData)newRegion.regionData;
            if (sectionData.navigators != null) {
                Iterator<EntityInsentient> iterator = sectionData.navigators.unsafeIterator(1);
                while (iterator.hasNext()) {
                    if (newRegionData.addToNavigators(iterator.next())) continue;
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static final class DataRegionData
    implements SingleThreadChunkRegionManager.RegionData {
        private IteratorSafeOrderedReferenceSet<EntityInsentient> navigators;

        public IteratorSafeOrderedReferenceSet<EntityInsentient> getNavigators() {
            return this.navigators;
        }

        public boolean addToNavigators(EntityInsentient navigator) {
            if (this.navigators == null) {
                this.navigators = new IteratorSafeOrderedReferenceSet();
            }
            return this.navigators.add(navigator);
        }

        public boolean removeFromNavigators(EntityInsentient navigator) {
            if (this.navigators == null) {
                return false;
            }
            return this.navigators.remove(navigator);
        }
    }
}

