/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.util.TickThread;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.DebugBuffer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.lighting.LightEngine;

public class PlayerChunk {
    public static final Either<IChunkAccess, Failure> a = Either.right(Failure.b);
    public static final CompletableFuture<Either<IChunkAccess, Failure>> b = CompletableFuture.completedFuture(a);
    public static final Either<Chunk, Failure> c = Either.right(Failure.b);
    private static final CompletableFuture<Either<Chunk, Failure>> d = CompletableFuture.completedFuture(c);
    private static final List<ChunkStatus> e = ChunkStatus.a();
    private static final State[] f = State.values();
    private static final int g = 64;
    private final AtomicReferenceArray<CompletableFuture<Either<IChunkAccess, Failure>>> h;
    private final LevelHeightAccessor i;
    private volatile CompletableFuture<Either<Chunk, Failure>> j;
    private int fullChunkCreateCount;
    private volatile boolean isFullChunkReady;
    private volatile CompletableFuture<Either<Chunk, Failure>> k;
    private volatile boolean isTickingReady;
    private volatile CompletableFuture<Either<Chunk, Failure>> l;
    private volatile boolean isEntityTickingReady;
    public CompletableFuture<IChunkAccess> m;
    @Nullable
    private final DebugBuffer<b> n = null;
    public int o;
    private int p;
    public volatile int q;
    public final ChunkCoordIntPair r;
    private boolean s;
    private final ShortSet[] t;
    private final BitSet u;
    private final BitSet v;
    private final LightEngine w;
    private final d x;
    public final e y;
    private boolean z;
    private boolean A;
    private CompletableFuture<Void> B;
    boolean isUpdateQueued = false;
    private final PlayerChunkMap chunkMap;
    PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInMobSpawnRange;
    PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInChunkTickRange;
    long lastAutoSaveTime;
    long inactiveTimeStart;
    private boolean loadCallbackScheduled = false;
    private boolean unloadCallbackScheduled = false;
    protected long updateCount;
    volatile int neighborPriority = -1;
    volatile int priorityBoost = 0;
    public final ConcurrentHashMap<PlayerChunk, ChunkStatus> neighbors = new ConcurrentHashMap();
    public final Long2ObjectOpenHashMap<Integer> neighborPriorities = new Long2ObjectOpenHashMap();
    int requestedPriority = PlayerChunkMap.b + 1;

    public WorldServer getWorld() {
        return this.chunkMap.q;
    }

    void updateRanges() {
        long key = MCUtil.getCoordinateKey(this.r);
        this.playersInMobSpawnRange = this.chunkMap.playerMobSpawnMap.getObjectsInRange(key);
        this.playersInChunkTickRange = this.chunkMap.playerChunkTickRangeMap.getObjectsInRange(key);
        Chunk chunk = this.getFullChunkUnchecked();
        if (chunk != null) {
            chunk.updateGeneralAreaCache();
        }
    }

    public boolean canAdvanceStatus() {
        ChunkStatus status = this.getChunkHolderStatus();
        IChunkAccess chunk = this.getAvailableChunkNow();
        return chunk != null && (status == null || chunk.j().b(PlayerChunk.getNextStatus(status)));
    }

    public PlayerChunk(ChunkCoordIntPair pos, int level, LevelHeightAccessor world, LightEngine lightingProvider, d levelUpdateListener, e playersWatchingChunkProvider) {
        this.h = new AtomicReferenceArray(e.size());
        this.j = d;
        this.k = d;
        this.l = d;
        this.m = CompletableFuture.completedFuture(null);
        this.u = new BitSet();
        this.v = new BitSet();
        this.B = CompletableFuture.completedFuture(null);
        this.r = pos;
        this.i = world;
        this.w = lightingProvider;
        this.x = levelUpdateListener;
        this.y = playersWatchingChunkProvider;
        this.p = this.o = PlayerChunkMap.b + 1;
        this.q = this.o;
        this.a(level);
        this.t = new ShortSet[world.ah()];
        this.chunkMap = (PlayerChunkMap)playersWatchingChunkProvider;
        this.updateRanges();
    }

    public final Chunk getFullChunk() {
        if (!PlayerChunk.c(this.o).a(State.b)) {
            return null;
        }
        return this.getFullChunkUnchecked();
    }

    public Chunk getFullChunkUnchecked() {
        CompletableFuture<Either<IChunkAccess, Failure>> statusFuture = this.a(ChunkStatus.o);
        Either either = statusFuture.getNow(null);
        return either == null ? null : (Chunk)either.left().orElse(null);
    }

    public IChunkAccess getAvailableChunkNow() {
        ChunkStatus curr = ChunkStatus.o;
        for (ChunkStatus next = curr.e(); curr != next; next = next.e()) {
            CompletableFuture<Either<IChunkAccess, Failure>> future = this.a(curr);
            Either either = future.getNow(null);
            if (either != null && either.left().isPresent()) {
                return (IChunkAccess)either.left().get();
            }
            curr = next;
        }
        return null;
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> a(ChunkStatus leastStatus) {
        CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.h.get(leastStatus.c());
        return completablefuture == null ? b : completablefuture;
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> b(ChunkStatus leastStatus) {
        return PlayerChunk.b(this.p).b(leastStatus) ? this.a(leastStatus) : b;
    }

    public final CompletableFuture<Either<Chunk, Failure>> a() {
        return this.k;
    }

    public final CompletableFuture<Either<Chunk, Failure>> b() {
        return this.l;
    }

    public final CompletableFuture<Either<Chunk, Failure>> c() {
        return this.j;
    }

    @Nullable
    public final Chunk d() {
        CompletableFuture<Either<Chunk, Failure>> completablefuture = this.a();
        Either either = completablefuture.getNow(null);
        return either == null ? null : (Chunk)either.left().orElse(null);
    }

    @Nullable
    public ChunkStatus e() {
        for (int i2 = e.size() - 1; i2 >= 0; --i2) {
            ChunkStatus chunkstatus = e.get(i2);
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.a(chunkstatus);
            if (!completablefuture.getNow(a).left().isPresent()) continue;
            return chunkstatus;
        }
        return null;
    }

    public ChunkStatus getChunkHolderStatus() {
        ChunkStatus curr = ChunkStatus.o;
        for (ChunkStatus next = curr.e(); curr != next; next = next.e()) {
            CompletableFuture<Either<IChunkAccess, Failure>> future = this.a(curr);
            Either either = future.getNow(null);
            if (either != null && either.left().isPresent()) {
                return curr;
            }
            curr = next;
        }
        return null;
    }

    @Nullable
    public IChunkAccess f() {
        for (int i2 = e.size() - 1; i2 >= 0; --i2) {
            Optional<IChunkAccess> optional;
            ChunkStatus chunkstatus = e.get(i2);
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.a(chunkstatus);
            if (completablefuture.isCompletedExceptionally() || !(optional = completablefuture.getNow(a).left()).isPresent()) continue;
            return optional.get();
        }
        return null;
    }

    public final CompletableFuture<IChunkAccess> g() {
        return this.m;
    }

    public void a(BlockPosition pos) {
        if (!pos.isInsideBuildHeightAndWorldBoundsHorizontal(this.i)) {
            return;
        }
        Chunk chunk = this.d();
        if (chunk != null) {
            int i2 = this.i.e(pos.v());
            if (i2 < 0 || i2 >= this.t.length) {
                return;
            }
            if (this.t[i2] == null) {
                this.s = true;
                this.t[i2] = new ShortOpenHashSet();
            }
            this.t[i2].add(SectionPosition.b(pos));
        }
    }

    public void a(EnumSkyBlock lightType, int y2) {
        Chunk chunk = this.d();
        if (chunk != null) {
            chunk.a(true);
            int j2 = this.w.c();
            int k2 = this.w.d();
            if (y2 >= j2 && y2 <= k2) {
                int l2 = y2 - j2;
                if (lightType == EnumSkyBlock.a) {
                    this.v.set(l2);
                } else {
                    this.u.set(l2);
                }
            }
        }
    }

    public void a(Chunk chunk) {
        if (this.s || !this.v.isEmpty() || !this.u.isEmpty()) {
            int j2;
            World world = chunk.D();
            int i2 = 0;
            for (j2 = 0; j2 < this.t.length; ++j2) {
                i2 += this.t[j2] != null ? this.t[j2].size() : 0;
            }
            this.A |= i2 >= 64;
            if (!this.v.isEmpty() || !this.u.isEmpty()) {
                this.a(new PacketPlayOutLightUpdate(chunk.f(), this.w, this.v, this.u, true), !this.A);
                this.v.clear();
                this.u.clear();
            }
            for (j2 = 0; j2 < this.t.length; ++j2) {
                ShortSet shortset = this.t[j2];
                if (shortset == null) continue;
                int k2 = this.i.g(j2);
                SectionPosition sectionposition = SectionPosition.a(chunk.f(), k2);
                if (shortset.size() == 1) {
                    BlockPosition blockposition = sectionposition.g(shortset.iterator().nextShort());
                    IBlockData iblockdata = world.a_(blockposition);
                    this.a(new PacketPlayOutBlockChange(blockposition, iblockdata), false);
                    this.a(world, blockposition, iblockdata);
                } else {
                    ChunkSection chunksection = chunk.b(j2);
                    PacketPlayOutMultiBlockChange packetplayoutmultiblockchange = new PacketPlayOutMultiBlockChange(sectionposition, shortset, chunksection, this.A);
                    this.a(packetplayoutmultiblockchange, false);
                    packetplayoutmultiblockchange.a((BlockPosition blockposition1, IBlockData iblockdata1) -> this.a(world, (BlockPosition)blockposition1, (IBlockData)iblockdata1));
                }
                this.t[j2] = null;
            }
            this.s = false;
        }
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        if (state.m()) {
            this.a(world, pos);
        }
    }

    private void a(World world, BlockPosition pos) {
        Packet<PacketListenerPlayOut> packet;
        TileEntity tileentity = world.c_(pos);
        if (tileentity != null && (packet = tileentity.h()) != null) {
            this.a(packet, false);
        }
    }

    public void a(Packet<?> packet, boolean onlyOnWatchDistanceEdge) {
        this.y.a(this.r, onlyOnWatchDistanceEdge).forEach(entityplayer -> entityplayer.b.a(packet));
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> a(ChunkStatus targetStatus, PlayerChunkMap chunkStorage) {
        int i2 = targetStatus.c();
        CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.h.get(i2);
        if (completablefuture != null) {
            boolean flag;
            Either either = completablefuture.getNow(null);
            boolean bl = flag = either != null && either.right().isPresent();
            if (!flag) {
                return completablefuture;
            }
        }
        if (PlayerChunk.b(this.p).b(targetStatus)) {
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture1 = chunkStorage.a(this, targetStatus);
            this.a(completablefuture1, "schedule " + targetStatus);
            this.h.set(i2, completablefuture1);
            return completablefuture1;
        }
        return completablefuture == null ? b : completablefuture;
    }

    protected void a(String thenDesc, CompletableFuture<?> then) {
        if (this.n != null) {
            this.n.a(new b(Thread.currentThread(), then, thenDesc));
        }
        this.m = this.m.thenCombine(then, (ichunkaccess, object) -> ichunkaccess);
    }

    private void a(CompletableFuture<? extends Either<? extends IChunkAccess, Failure>> then, String thenDesc) {
        if (this.n != null) {
            this.n.a(new b(Thread.currentThread(), then, thenDesc));
        }
        this.m = this.m.thenCombine(then, (ichunkaccess, either) -> either.map(ichunkaccess1 -> ichunkaccess1, playerchunk_failure -> ichunkaccess));
    }

    public State h() {
        return PlayerChunk.c(this.p);
    }

    public final ChunkCoordIntPair i() {
        return this.r;
    }

    public final int j() {
        return this.p;
    }

    public int k() {
        return this.q;
    }

    private void d(int level) {
        this.q = level;
    }

    public void a(int level) {
        this.p = level;
    }

    private void a(PlayerChunkMap playerchunkmap, CompletableFuture<Either<Chunk, Failure>> completablefuture, Executor executor, State playerchunk_state) {
        this.B.cancel(false);
        CompletableFuture completablefuture1 = new CompletableFuture();
        completablefuture1.thenRunAsync(() -> {
            boolean unloadingBefore = this.chunkMap.unloadingPlayerChunk;
            this.chunkMap.unloadingPlayerChunk = true;
            try {
                playerchunkmap.a(this.r, playerchunk_state);
            }
            finally {
                this.chunkMap.unloadingPlayerChunk = unloadingBefore;
            }
        }, executor);
        this.B = completablefuture1;
        completablefuture.thenAccept(either -> either.ifLeft(chunk -> completablefuture1.complete(null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(PlayerChunkMap playerchunkmap, State playerchunk_state) {
        this.B.cancel(false);
        boolean unloadingBefore = this.chunkMap.unloadingPlayerChunk;
        this.chunkMap.unloadingPlayerChunk = true;
        try {
            playerchunkmap.a(this.r, playerchunk_state);
        }
        finally {
            this.chunkMap.unloadingPlayerChunk = unloadingBefore;
        }
    }

    protected void a(PlayerChunkMap chunkStorage, Executor executor) {
        int priority;
        TickThread.ensureTickThread("Async ticket level update");
        long updateCount = ++this.updateCount;
        ChunkStatus chunkstatus = PlayerChunk.b(this.o);
        ChunkStatus chunkstatus1 = PlayerChunk.b(this.p);
        boolean flag = this.o <= PlayerChunkMap.b;
        boolean flag1 = this.p <= PlayerChunkMap.b;
        State playerchunk_state = PlayerChunk.c(this.o);
        State playerchunk_state1 = PlayerChunk.c(this.p);
        if (playerchunk_state.a(State.b) && !playerchunk_state1.a(State.b)) {
            ((CompletableFuture)this.a(ChunkStatus.o).thenAccept(either -> {
                TickThread.ensureTickThread("Async full status chunk future completion");
                Chunk chunk = either.left().orElse(null);
                if (chunk != null && chunk.wasLoadCallbackInvoked() && this.p > 33) {
                    if (this.unloadCallbackScheduled) {
                        return;
                    }
                    this.unloadCallbackScheduled = true;
                    chunkStorage.callbackExecutor.execute(() -> {
                        this.unloadCallbackScheduled = false;
                        if (this.p <= 33) {
                            return;
                        }
                        chunk.a(true);
                        chunk.unloadCallback();
                    });
                }
            })).exceptionally(throwable -> {
                MinecraftServer.r.fatal("Failed to schedule unload callback for chunk " + this.r, throwable);
                return null;
            });
            chunkStorage.callbackExecutor.run();
            if (this.updateCount != updateCount) {
                return;
            }
        }
        if (flag) {
            int i2;
            Either either2 = Either.right(new Failure(){

                public String toString() {
                    return "Unloaded ticket level " + PlayerChunk.this.r;
                }
            });
            int n2 = i2 = flag1 ? chunkstatus1.c() + 1 : 0;
            while (i2 <= chunkstatus.c()) {
                CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.h.get(i2);
                if (completablefuture == null) {
                    this.h.set(i2, CompletableFuture.completedFuture(either2));
                }
                ++i2;
            }
        }
        boolean flag2 = playerchunk_state.a(State.b);
        boolean flag3 = playerchunk_state1.a(State.b);
        boolean prevHasBeenLoaded = this.z;
        this.z |= flag3;
        if (this.z & !prevHasBeenLoaded) {
            long timeSinceAutoSave = this.inactiveTimeStart - this.lastAutoSaveTime;
            if (timeSinceAutoSave < 0L) {
                timeSinceAutoSave = this.chunkMap.q.paperConfig.autoSavePeriod;
            }
            this.lastAutoSaveTime = this.chunkMap.q.V() - timeSinceAutoSave;
            this.chunkMap.autoSaveQueue.add((Object)this);
        }
        if (!flag2 && flag3) {
            int expectCreateCount = ++this.fullChunkCreateCount;
            this.j = chunkStorage.b(this);
            this.a(chunkStorage, this.j, executor, State.b);
            this.j.thenAccept(either -> {
                TickThread.ensureTickThread("Async full chunk future completion");
                Optional left = either.left();
                if (left.isPresent() && this.fullChunkCreateCount == expectCreateCount) {
                    Chunk fullChunk = (Chunk)either.left().get();
                    this.isFullChunkReady = true;
                    fullChunk.playerChunk = this;
                    this.chunkMap.D.clearPriorityTickets(this.r);
                }
            });
            this.a(this.j, "full");
        }
        if (flag2 && !flag3) {
            this.j.complete(c);
            this.j = d;
            ++this.fullChunkCreateCount;
            this.isFullChunkReady = false;
        }
        boolean flag4 = playerchunk_state.a(State.c);
        boolean flag5 = playerchunk_state1.a(State.c);
        if (!flag4 && flag5) {
            this.k = chunkStorage.a(this);
            this.a(chunkStorage, this.k, executor, State.c);
            this.k.thenAccept(either -> {
                TickThread.ensureTickThread("Async full chunk future completion");
                either.ifLeft(chunk -> {
                    this.isTickingReady = true;
                    this.chunkMap.q.k().tickingChunks.add((Chunk)chunk);
                });
            });
            this.a(this.k, "ticking");
        }
        if (flag4 && !flag5) {
            this.k.complete(c);
            this.isTickingReady = false;
            this.k = d;
            Chunk chunkIfCached = this.getFullChunkUnchecked();
            if (chunkIfCached != null) {
                this.chunkMap.q.k().tickingChunks.remove(chunkIfCached);
            }
        }
        boolean flag6 = playerchunk_state.a(State.d);
        boolean flag7 = playerchunk_state1.a(State.d);
        if (!flag6 && flag7) {
            if (this.l != d) {
                throw SystemUtils.c(new IllegalStateException());
            }
            this.l = chunkStorage.b(this.r);
            this.a(chunkStorage, this.l, executor, State.d);
            this.l.thenAccept(either -> {
                TickThread.ensureTickThread("Async full chunk future completion");
                either.ifLeft(chunk -> {
                    this.isEntityTickingReady = true;
                    this.chunkMap.q.k().entityTickingChunks.add((Chunk)chunk);
                });
            });
            this.a(this.l, "entity ticking");
        }
        if (flag6 && !flag7) {
            this.l.complete(c);
            this.isEntityTickingReady = false;
            this.l = d;
            Chunk chunkIfCached = this.getFullChunkUnchecked();
            if (chunkIfCached != null) {
                this.chunkMap.q.k().entityTickingChunks.remove(chunkIfCached);
            }
        }
        if (!playerchunk_state1.a(playerchunk_state)) {
            this.a(chunkStorage, playerchunk_state1);
        }
        this.priorityBoost = this.chunkMap.D.getChunkPriority(this.r);
        int currRequestedPriority = this.requestedPriority;
        int newRequestedPriority = this.requestedPriority = (priority = this.getDemandedPriority());
        if (this.q > priority) {
            int ioPriority = 3;
            if (priority <= 10) {
                ioPriority = 0;
            } else if (priority <= 20) {
                ioPriority = 2;
            }
            this.chunkMap.q.asyncChunkTaskManager.raisePriority(this.r.c, this.r.d, ioPriority);
            this.chunkMap.q.k().a().queue.changePriority(this.r.a(), this.q, priority);
        }
        if (currRequestedPriority != newRequestedPriority) {
            this.x.onLevelChange(this.r, () -> this.q, priority, p2 -> {
                this.q = p2;
            });
            int neighborsPriority = this.getNeighborsPriority();
            this.neighbors.forEach((neighbor, neighborDesired) -> neighbor.setNeighborPriority(this, neighborsPriority));
        }
        this.o = this.p;
        if (!playerchunk_state.a(State.b) && playerchunk_state1.a(State.b)) {
            ((CompletableFuture)this.a(ChunkStatus.o).thenAccept(either -> {
                TickThread.ensureTickThread("Async full status chunk future completion");
                Chunk chunk = either.left().orElse(null);
                if (chunk != null && this.o <= 33 && !chunk.wasLoadCallbackInvoked()) {
                    if (this.loadCallbackScheduled) {
                        return;
                    }
                    this.loadCallbackScheduled = true;
                    chunkStorage.callbackExecutor.execute(() -> {
                        this.loadCallbackScheduled = false;
                        if (this.o <= 33) {
                            chunk.loadCallback();
                        }
                    });
                }
            })).exceptionally(throwable -> {
                MinecraftServer.r.fatal("Failed to schedule load callback for chunk " + this.r, throwable);
                return null;
            });
            chunkStorage.callbackExecutor.run();
        }
    }

    public static ChunkStatus b(int level) {
        return level < 33 ? ChunkStatus.o : ChunkStatus.a(level - 33);
    }

    public static State c(int distance) {
        return f[MathHelper.a(33 - distance + 1, 0, f.length - 1)];
    }

    public boolean l() {
        return this.z;
    }

    public void m() {
        boolean prev = this.z;
        this.z = PlayerChunk.c(this.p).a(State.b);
        if (prev != this.z) {
            if (this.z) {
                long timeSinceAutoSave = this.inactiveTimeStart - this.lastAutoSaveTime;
                if (timeSinceAutoSave < 0L) {
                    timeSinceAutoSave = this.chunkMap.q.paperConfig.autoSavePeriod;
                }
                this.lastAutoSaveTime = this.chunkMap.q.V() - timeSinceAutoSave;
                this.chunkMap.autoSaveQueue.add((Object)this);
            } else {
                this.inactiveTimeStart = this.chunkMap.q.V();
                this.chunkMap.autoSaveQueue.remove((Object)this);
            }
        }
    }

    public boolean setHasBeenLoaded() {
        this.z = PlayerChunk.c(this.p).a(State.b);
        return this.z;
    }

    public void a(ProtoChunkExtension chunk) {
        for (int i2 = 0; i2 < this.h.length(); ++i2) {
            Optional<IChunkAccess> optional;
            CompletableFuture<Either<IChunkAccess, Failure>> completablefuture = this.h.get(i2);
            if (completablefuture == null || !(optional = completablefuture.getNow(a).left()).isPresent() || !(optional.get() instanceof ProtoChunk)) continue;
            this.h.set(i2, CompletableFuture.completedFuture(Either.left(chunk)));
        }
        this.a(CompletableFuture.completedFuture(Either.left(chunk.A())), "replaceProto");
    }

    private int getDemandedPriority() {
        int priority = this.neighborPriority;
        int myPriority = this.getMyPriority();
        if (priority == -1 || this.p <= 33 && priority > myPriority) {
            priority = myPriority;
        }
        return Math.max(1, Math.min(Math.max(this.p, PlayerChunkMap.b), priority));
    }

    private int getMyPriority() {
        if (this.priorityBoost == 29) {
            return 2;
        }
        return this.p - this.priorityBoost;
    }

    private int getNeighborsPriority() {
        return (this.neighborPriorities.isEmpty() ? this.getMyPriority() : this.getDemandedPriority()) + 1;
    }

    public void onNeighborRequest(PlayerChunk neighbor, ChunkStatus status) {
        neighbor.setNeighborPriority(this, this.getNeighborsPriority());
        this.neighbors.compute(neighbor, (playerChunk, currentWantedStatus) -> {
            if (currentWantedStatus == null || !currentWantedStatus.b(status)) {
                return status;
            }
            return currentWantedStatus;
        });
    }

    public void onNeighborDone(PlayerChunk neighbor, ChunkStatus chunkstatus, IChunkAccess chunk) {
        this.neighbors.compute(neighbor, (playerChunk, wantedStatus) -> {
            if (wantedStatus != null && chunkstatus.b((ChunkStatus)wantedStatus)) {
                neighbor.removeNeighborPriority(this);
                return null;
            }
            return wantedStatus;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNeighborPriority(PlayerChunk requester) {
        Long2ObjectOpenHashMap<Integer> long2ObjectOpenHashMap = this.neighborPriorities;
        synchronized (long2ObjectOpenHashMap) {
            this.neighborPriorities.remove(requester.r.a());
            this.recalcNeighborPriority();
        }
        this.checkPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNeighborPriority(PlayerChunk requester, int priority) {
        Long2ObjectOpenHashMap<Integer> long2ObjectOpenHashMap = this.neighborPriorities;
        synchronized (long2ObjectOpenHashMap) {
            if (!Integer.valueOf(priority).equals(this.neighborPriorities.put(requester.r.a(), (Object)priority))) {
                this.recalcNeighborPriority();
            }
        }
        this.checkPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcNeighborPriority() {
        this.neighborPriority = -1;
        if (!this.neighborPriorities.isEmpty()) {
            Long2ObjectOpenHashMap<Integer> long2ObjectOpenHashMap = this.neighborPriorities;
            synchronized (long2ObjectOpenHashMap) {
                for (Integer neighbor : this.neighborPriorities.values()) {
                    if (neighbor >= this.neighborPriority && this.neighborPriority != -1) continue;
                    this.neighborPriority = neighbor;
                }
            }
        }
    }

    private void checkPriority() {
        if (this.requestedPriority != this.getDemandedPriority()) {
            this.chunkMap.queueHolderUpdate(this);
        }
    }

    public final double getDistance(EntityPlayer player) {
        return this.getDistance(player.dc(), player.di());
    }

    public final double getDistance(double blockX, double blockZ) {
        int cx = MCUtil.fastFloor(blockX) >> 4;
        int cz = MCUtil.fastFloor(blockZ) >> 4;
        double x2 = this.r.c - cx;
        double z2 = this.r.d - cz;
        return x2 * x2 + z2 * z2;
    }

    public final double getDistanceFrom(BlockPosition pos) {
        return this.getDistance(pos.u(), pos.w());
    }

    public static ChunkStatus getNextStatus(ChunkStatus status) {
        if (status == ChunkStatus.o) {
            return status;
        }
        return e.get(status.c() + 1);
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> getStatusFutureUncheckedMain(ChunkStatus chunkstatus) {
        return this.ensureMain(this.a(chunkstatus));
    }

    public <T> CompletableFuture<T> ensureMain(CompletableFuture<T> future) {
        return future.thenApplyAsync(r2 -> r2, this.chunkMap.mainInvokingExecutor);
    }

    public String toString() {
        return "PlayerChunk{location=" + this.r + ", ticketLevel=" + this.p + "/" + PlayerChunk.b(this.p) + ", chunkHolderStatus=" + this.getChunkHolderStatus() + ", neighborPriority=" + this.getNeighborsPriority() + ", priority=(" + this.p + " - " + this.priorityBoost + " vs N " + this.neighborPriority + ") = " + this.getDemandedPriority() + " A " + this.q + "}";
    }

    public final boolean isEntityTickingReady() {
        return this.isEntityTickingReady;
    }

    public final boolean isTickingReady() {
        return this.isTickingReady;
    }

    public final boolean isFullChunkReady() {
        return this.isFullChunkReady;
    }

    @FunctionalInterface
    public static interface d {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface e {
        public List<EntityPlayer> a(ChunkCoordIntPair var1, boolean var2);
    }

    public static enum State {
        a,
        b,
        c,
        d;


        public boolean a(State levelType) {
            return this.ordinal() >= levelType.ordinal();
        }
    }

    private static final class b {
        private final Thread a;
        private final CompletableFuture<?> b;
        private final String c;

        b(Thread thread, CompletableFuture<?> action, String actionDesc) {
            this.a = thread;
            this.b = action;
            this.c = actionDesc;
        }
    }

    public static interface Failure {
        public static final Failure b = new Failure(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }
}

