/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import io.papermc.paper.util.CoordinateUtils;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;

public class LightEngineThreaded
extends LightEngine
implements AutoCloseable {
    private static final Logger d = LogManager.getLogger();
    private final ThreadedMailbox<Runnable> e;
    private static final int MAX_PRIORITIES = PlayerChunkMap.b + 2;
    final LightQueue queue = new LightQueue();
    private final PlayerChunkMap g;
    private final PlayerChunkMap playerChunkMap;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> h;
    private volatile int i = 5;
    private final AtomicBoolean j = new AtomicBoolean();
    protected final StarLightInterface theLightEngine;
    public final boolean hasBlockLight;
    public final boolean hasSkyLight;
    protected long relightCounter;
    private final Long2IntOpenHashMap chunksBeingWorkedOn = new Long2IntOpenHashMap();
    private final List<Runnable> pre = new ArrayList<Runnable>();
    private final List<Runnable> post = new ArrayList<Runnable>();

    public LightEngineThreaded(ILightAccess chunkProvider, PlayerChunkMap chunkStorage, boolean hasBlockLight, ThreadedMailbox<Runnable> processor, Mailbox<ChunkTaskQueueSorter.a<Runnable>> executor) {
        super(chunkProvider, false, false);
        this.playerChunkMap = this.g = chunkStorage;
        this.h = executor;
        this.e = processor;
        this.hasBlockLight = true;
        this.hasSkyLight = hasBlockLight;
        this.theLightEngine = new StarLightInterface(chunkProvider, this.hasSkyLight, this.hasBlockLight, this);
    }

    protected final IChunkAccess getChunk(int chunkX, int chunkZ) {
        return ((WorldServer)this.theLightEngine.getWorld()).k().getChunkAtImmediately(chunkX, chunkZ);
    }

    public int relight(Set<ChunkCoordIntPair> chunks_param, Consumer<ChunkCoordIntPair> chunkLightCallback, IntConsumer onComplete) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Must only be called on the main thread");
        }
        LinkedHashSet<ChunkCoordIntPair> chunks = new LinkedHashSet<ChunkCoordIntPair>(chunks_param);
        HashMap<ChunkCoordIntPair, Long> ticketIds = new HashMap<ChunkCoordIntPair, Long>();
        int totalChunks = 0;
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkCoordIntPair chunkPos = (ChunkCoordIntPair)iterator.next();
            IChunkAccess chunk = ((WorldServer)this.theLightEngine.getWorld()).k().getChunkAtImmediately(chunkPos.c, chunkPos.d);
            if (chunk == null || !chunk.v() || !chunk.j().b(ChunkStatus.l)) {
                iterator.remove();
                continue;
            }
            Long id = this.relightCounter++;
            ((WorldServer)this.theLightEngine.getWorld()).k().addTicketAtLevel(TicketType.CHUNK_RELIGHT, chunkPos, MCUtil.getTicketLevelFor(ChunkStatus.l), id);
            ticketIds.put(chunkPos, id);
            ++totalChunks;
        }
        this.e.a(() -> this.theLightEngine.relightChunks(chunks, chunkPos -> {
            chunkLightCallback.accept((ChunkCoordIntPair)chunkPos);
            ((WorldServer)this.theLightEngine.getWorld()).k().h.execute(() -> {
                ((WorldServer)this.theLightEngine.getWorld()).k().a.a(chunkPos.a()).a(new PacketPlayOutLightUpdate((ChunkCoordIntPair)chunkPos, this, null, null, true), false);
                ((WorldServer)this.theLightEngine.getWorld()).k().removeTicketAtLevel(TicketType.CHUNK_RELIGHT, (ChunkCoordIntPair)chunkPos, MCUtil.getTicketLevelFor(ChunkStatus.l), (Long)ticketIds.get(chunkPos));
            });
        }, onComplete));
        this.a();
        return totalChunks;
    }

    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<CompletableFuture<Void>> runnable) {
        WorldServer world = (WorldServer)this.theLightEngine.getWorld();
        IChunkAccess center = this.theLightEngine.getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.j().b(ChunkStatus.l)) {
            return;
        }
        if (center.j() != ChunkStatus.o) {
            runnable.get();
            return;
        }
        if (!world.k().a.s.bl()) {
            world.k().a.s.execute(() -> this.queueTaskForSection(chunkX, chunkY, chunkZ, runnable));
            return;
        }
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        CompletableFuture<Void> updateFuture = runnable.get();
        if (updateFuture == null) {
            return;
        }
        int references = this.chunksBeingWorkedOn.addTo(key, 1);
        if (references == 0) {
            ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
            world.k().a(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, pos);
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                PlayerChunk neighbour = world.k().a.a(CoordinateUtils.getChunkKey(dx + chunkX, dz + chunkZ));
                if (neighbour == null) continue;
                neighbour.m = neighbour.m.thenCombine(updateFuture, (curr, ignore) -> curr);
            }
        }
        ((CompletableFuture)updateFuture.thenAcceptAsync(ignore -> {
            int newReferences = this.chunksBeingWorkedOn.get(key);
            if (newReferences == 1) {
                this.chunksBeingWorkedOn.remove(key);
                ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
                world.k().b(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, pos);
            } else {
                this.chunksBeingWorkedOn.put(key, newReferences - 1);
            }
        }, (Executor)world.k().a.s)).whenComplete((ignore, thr) -> {
            if (thr != null) {
                d.fatal("Failed to remove ticket level for post chunk task " + new ChunkCoordIntPair(chunkX, chunkZ), thr);
            }
        });
    }

    @Override
    public boolean A_() {
        return this.theLightEngine.hasUpdates() || !this.queue.isEmpty();
    }

    @Override
    public LightEngineLayerEventListener a(EnumSkyBlock lightType) {
        return lightType == EnumSkyBlock.b ? this.theLightEngine.getBlockReader() : this.theLightEngine.getSkyReader();
    }

    @Override
    public int b(BlockPosition pos, int ambientDarkness) {
        int sky = this.theLightEngine.getSkyReader().b(pos) - ambientDarkness;
        if (sky == 15) {
            return 15;
        }
        int block = this.theLightEngine.getBlockReader().b(pos);
        return Math.max(sky, block);
    }

    @Override
    public void close() {
    }

    @Override
    public int a(int i2, boolean doSkylight, boolean skipEdgeLightPropagation) {
        throw SystemUtils.c(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void a(BlockPosition pos, int level) {
        throw SystemUtils.c(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void a(BlockPosition pos) {
        BlockPosition posCopy = pos.h();
        this.queueTaskForSection(posCopy.u() >> 4, posCopy.v() >> 4, posCopy.w() >> 4, () -> this.theLightEngine.blockChange(posCopy));
    }

    protected void a(ChunkCoordIntPair pos) {
    }

    @Override
    public void a(SectionPosition pos, boolean notReady) {
        this.queueTaskForSection(pos.u(), pos.v(), pos.w(), () -> this.theLightEngine.sectionChange(pos, notReady));
    }

    @Override
    public void a(ChunkCoordIntPair pos, boolean retainData) {
    }

    @Override
    public void a(EnumSkyBlock lightType, SectionPosition pos, @Nullable NibbleArray nibbles, boolean nonEdge) {
    }

    private void a(int x2, int z2, Update stage, Runnable task) {
        this.a(x2, z2, this.g.c(ChunkCoordIntPair.a(x2, z2)), stage, task);
    }

    private void a(int x2, int z2, IntSupplier completedLevelSupplier, Update stage, Runnable task) {
        this.queue.add(ChunkCoordIntPair.a(x2, z2), completedLevelSupplier, stage, task);
    }

    @Override
    public void b(ChunkCoordIntPair pos, boolean retainData) {
    }

    public CompletableFuture<IChunkAccess> a(IChunkAccess chunk, boolean excludeBlocks) {
        boolean lit = excludeBlocks;
        ChunkCoordIntPair chunkPos = chunk.f();
        return CompletableFuture.supplyAsync(() -> {
            Boolean[] emptySections = StarLightEngine.getEmptySectionsForChunk(chunk);
            if (!lit) {
                chunk.b(false);
                this.theLightEngine.lightChunk(chunk, emptySections);
                chunk.b(true);
            } else {
                this.theLightEngine.forceLoadInChunk(chunk, emptySections);
                this.theLightEngine.checkChunkEdges(chunkPos.c, chunkPos.d);
            }
            this.g.c(chunkPos);
            return chunk;
        }, runnable -> {
            this.theLightEngine.scheduleChunkLight(chunkPos, runnable);
            this.a();
        }).whenComplete((c2, throwable) -> {
            if (throwable != null) {
                d.fatal("Failed to light chunk " + chunkPos, throwable);
            }
        });
    }

    public void a() {
        if (this.A_() && this.j.compareAndSet(false, true)) {
            this.e.a(() -> {
                this.e();
                this.j.set(false);
                this.a();
            });
        }
    }

    private void e() {
        if (this.queue.poll(this.pre, this.post)) {
            this.pre.forEach(Runnable::run);
            this.pre.clear();
            this.theLightEngine.propagateChanges();
            this.post.forEach(Runnable::run);
            this.post.clear();
        } else {
            this.theLightEngine.propagateChanges();
        }
    }

    public void a(int taskBatchSize) {
        this.i = taskBatchSize;
    }

    private /* synthetic */ void lambda$lightChunk$26(ChunkCoordIntPair chunkPos, boolean[] skippedPre, IChunkAccess chunk, CompletableFuture future) {
        this.g.c(chunkPos);
        if (skippedPre[0]) {
            return;
        }
        chunk.b(true);
        super.b(chunkPos, false);
        future.complete(chunk);
    }

    private static /* synthetic */ String lambda$lightChunk$25(ChunkCoordIntPair chunkPos, boolean excludeBlocks) {
        return "lightChunk " + chunkPos + " " + excludeBlocks;
    }

    private /* synthetic */ void lambda$lightChunk$24(IChunkAccess chunk, ChunkCoordIntPair chunkPos, boolean excludeBlocks) {
        ChunkSection[] levelChunkSections = chunk.d();
        for (int i2 = 0; i2 < chunk.ah(); ++i2) {
            ChunkSection levelChunkSection = levelChunkSections[i2];
            if (levelChunkSection.c()) continue;
            int j2 = this.c.g(i2);
            super.a(SectionPosition.a(chunkPos, j2), false);
        }
        super.a(chunkPos, true);
        if (!excludeBlocks) {
            chunk.n().forEach(pos -> super.a((BlockPosition)pos, chunk.g((BlockPosition)pos)));
        }
    }

    private static /* synthetic */ String lambda$retainData$19(ChunkCoordIntPair pos) {
        return "retainData " + pos;
    }

    private /* synthetic */ void lambda$retainData$18(ChunkCoordIntPair pos, boolean retainData) {
        super.b(pos, retainData);
    }

    private static /* synthetic */ int lambda$retainData$17() {
        return 0;
    }

    private static /* synthetic */ String lambda$queueSectionData$16(SectionPosition pos) {
        return "queueData " + pos;
    }

    private /* synthetic */ void lambda$queueSectionData$15(EnumSkyBlock lightType, SectionPosition pos, NibbleArray nibbles, boolean nonEdge) {
        super.a(lightType, pos, nibbles, nonEdge);
    }

    private static /* synthetic */ int lambda$queueSectionData$14() {
        return 0;
    }

    private static /* synthetic */ String lambda$enableLightSources$13(ChunkCoordIntPair pos, boolean retainData) {
        return "enableLight " + pos + " " + retainData;
    }

    private /* synthetic */ void lambda$enableLightSources$12(ChunkCoordIntPair pos, boolean retainData) {
        super.a(pos, retainData);
    }

    private static /* synthetic */ String lambda$updateChunkStatus$10(ChunkCoordIntPair pos) {
        return "updateChunkStatus " + pos + " true";
    }

    private /* synthetic */ void lambda$updateChunkStatus$9(ChunkCoordIntPair pos) {
        super.b(pos, false);
        super.a(pos, false);
        for (int i2 = this.c(); i2 < this.d(); ++i2) {
            super.a(EnumSkyBlock.b, SectionPosition.a(pos, i2), null, true);
            super.a(EnumSkyBlock.a, SectionPosition.a(pos, i2), null, true);
        }
        for (int j2 = this.c.ai(); j2 < this.c.aj(); ++j2) {
            super.a(SectionPosition.a(pos, j2), true);
        }
    }

    private static /* synthetic */ int lambda$updateChunkStatus$8() {
        return 0;
    }

    class LightQueue {
        private int size = 0;
        private final Long2ObjectLinkedOpenHashMap<ChunkLightQueue>[] buckets = new Long2ObjectLinkedOpenHashMap[MAX_PRIORITIES];
        private final ConcurrentLinkedQueue<PendingLightTask> pendingTasks = new ConcurrentLinkedQueue();
        private final ConcurrentLinkedQueue<Runnable> priorityChanges = new ConcurrentLinkedQueue();

        private LightQueue() {
            for (int i2 = 0; i2 < this.buckets.length; ++i2) {
                this.buckets[i2] = new Long2ObjectLinkedOpenHashMap();
            }
        }

        public void changePriority(long pair, int currentPriority, int priority) {
            this.priorityChanges.add(() -> {
                ChunkLightQueue existing;
                ChunkLightQueue remove = (ChunkLightQueue)this.buckets[currentPriority].remove(pair);
                if (remove != null && (existing = (ChunkLightQueue)this.buckets[Math.max(1, priority)].put(pair, (Object)remove)) != null) {
                    remove.pre.addAll(existing.pre);
                    remove.post.addAll(existing.post);
                }
            });
        }

        public final void addChunk(long chunkId, IntSupplier priority, Runnable pre, Runnable post) {
            this.pendingTasks.add(new PendingLightTask(chunkId, priority, pre, post, true));
            LightEngineThreaded.this.a();
        }

        public final void add(long chunkId, IntSupplier priority, Update type, Runnable run) {
            this.pendingTasks.add(new PendingLightTask(chunkId, priority, type == Update.a ? run : null, type == Update.b ? run : null, false));
        }

        public final void add(PendingLightTask update) {
            int priority = update.priority.getAsInt();
            ChunkLightQueue lightQueue = (ChunkLightQueue)this.buckets[priority].computeIfAbsent(update.chunkId, ChunkLightQueue::new);
            if (update.pre != null) {
                ++this.size;
                lightQueue.pre.add(update.pre);
            }
            if (update.post != null) {
                ++this.size;
                lightQueue.post.add(update.post);
            }
            if (update.fastUpdate) {
                lightQueue.shouldFastUpdate = true;
            }
        }

        public final boolean isEmpty() {
            return this.size == 0 && this.pendingTasks.isEmpty();
        }

        public final int size() {
            return this.size;
        }

        public boolean poll(List<Runnable> pre, List<Runnable> post) {
            Runnable run;
            PendingLightTask pending;
            while ((pending = this.pendingTasks.poll()) != null) {
                this.add(pending);
            }
            while ((run = this.priorityChanges.poll()) != null) {
                run.run();
            }
            boolean hasWork = false;
            Long2ObjectLinkedOpenHashMap<ChunkLightQueue>[] buckets = this.buckets;
            int priority = 0;
            while (priority < MAX_PRIORITIES && !this.isEmpty()) {
                Long2ObjectLinkedOpenHashMap<ChunkLightQueue> bucket = buckets[priority];
                if (bucket.isEmpty()) {
                    ++priority;
                    if (!hasWork) continue;
                    return true;
                }
                ChunkLightQueue queue = (ChunkLightQueue)bucket.removeFirst();
                this.size -= queue.pre.size() + queue.post.size();
                pre.addAll(queue.pre);
                post.addAll(queue.post);
                queue.pre.clear();
                queue.post.clear();
                hasWork = true;
                if (!queue.shouldFastUpdate) continue;
                return true;
            }
            return hasWork;
        }
    }

    static final class Update
    extends Enum<Update> {
        public static final /* enum */ Update a = new Update();
        public static final /* enum */ Update b = new Update();
        private static final /* synthetic */ Update[] c;

        public static Update[] values() {
            return (Update[])c.clone();
        }

        public static Update valueOf(String name) {
            return Enum.valueOf(Update.class, name);
        }

        private static /* synthetic */ Update[] a() {
            return new Update[]{a, b};
        }

        static {
            c = Update.a();
        }
    }

    static class PendingLightTask {
        long chunkId;
        IntSupplier priority;
        Runnable pre;
        Runnable post;
        boolean fastUpdate;

        public PendingLightTask(long chunkId, IntSupplier priority, Runnable pre, Runnable post, boolean fastUpdate) {
            this.chunkId = chunkId;
            this.priority = priority;
            this.pre = pre;
            this.post = post;
            this.fastUpdate = fastUpdate;
        }
    }

    static class ChunkLightQueue {
        public boolean shouldFastUpdate;
        ArrayDeque<Runnable> pre = new ArrayDeque();
        ArrayDeque<Runnable> post = new ArrayDeque();

        ChunkLightQueue(long chunk) {
        }
    }
}

