/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.PaperConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;

public class EntityTrackerEntry {
    private static final Logger a = LogManager.getLogger();
    private static final int b = 1;
    private final WorldServer c;
    private final Entity d;
    private final int e;
    private final boolean f;
    private final Consumer<Packet<?>> g;
    private long h;
    private long i;
    private long j;
    private int k;
    private int l;
    private int m;
    private Vec3D n;
    private int o;
    private int p;
    private List<Entity> q;
    private boolean r;
    private boolean s;
    final Set<ServerPlayerConnection> trackedPlayers;

    public EntityTrackerEntry(WorldServer worldserver, Entity entity, int i2, boolean flag, Consumer<Packet<?>> consumer, Set<ServerPlayerConnection> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
        this.n = Vec3D.a;
        this.q = ImmutableList.of();
        this.c = worldserver;
        this.g = consumer;
        this.d = entity;
        this.e = i2;
        this.f = flag;
        this.d();
        this.k = MathHelper.d(entity.dm() * 256.0f / 360.0f);
        this.l = MathHelper.d(entity.dn() * 256.0f / 360.0f);
        this.m = MathHelper.d(entity.ce() * 256.0f / 360.0f);
        this.s = entity.aw();
    }

    public void a() {
        List<Entity> list = this.d.cF();
        if (!list.equals(this.q)) {
            this.q = list;
            this.a(new PacketPlayOutMount(this.d));
        }
        if (this.d instanceof EntityItemFrame) {
            Integer integer;
            WorldMap worldmap;
            EntityItemFrame entityitemframe = (EntityItemFrame)this.d;
            ItemStack itemstack = entityitemframe.x();
            if (this.c.paperConfig.mapItemFrameCursorUpdateInterval > 0 && this.o % this.c.paperConfig.mapItemFrameCursorUpdateInterval == 0 && itemstack.c() instanceof ItemWorldMap && (worldmap = ItemWorldMap.a(integer = ItemWorldMap.d(itemstack), (World)this.c)) != null) {
                Iterator<ServerPlayerConnection> iterator = this.trackedPlayers.iterator();
                while (iterator.hasNext()) {
                    EntityPlayer entityplayer = iterator.next().d();
                    worldmap.a(entityplayer, itemstack);
                    Packet<?> packet = worldmap.a((int)integer, entityplayer);
                    if (packet == null) continue;
                    entityplayer.b.a(packet);
                }
            }
            this.c();
        }
        if (this.o % this.e == 0 || this.d.ag || this.d.ai().a()) {
            int i2;
            if (this.d.bF()) {
                boolean flag;
                i2 = MathHelper.d(this.d.dm() * 256.0f / 360.0f);
                j = MathHelper.d(this.d.dn() * 256.0f / 360.0f);
                boolean bl = flag = Math.abs(i2 - this.k) >= 1 || Math.abs(j - this.l) >= 1;
                if (flag) {
                    this.g.accept(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.d.ae(), (byte)i2, (byte)j, this.d.aw()));
                    this.k = i2;
                    this.l = j;
                }
                this.d();
                this.c();
                this.r = true;
            } else {
                Vec3D vec3d1;
                double d0;
                boolean flag3;
                double vec3d_dz;
                double vec3d_dy;
                ++this.p;
                i2 = MathHelper.d(this.d.dm() * 256.0f / 360.0f);
                j = MathHelper.d(this.d.dn() * 256.0f / 360.0f);
                double vec3d_dx = this.d.dc() - 2.44140625E-4 * (double)this.h;
                boolean flag1 = vec3d_dx * vec3d_dx + (vec3d_dy = this.d.de() - 2.44140625E-4 * (double)this.i) * vec3d_dy + (vec3d_dz = this.d.di() - 2.44140625E-4 * (double)this.j) * vec3d_dz >= 7.62939453125E-6;
                Packet<PacketListenerPlayOut> packet1 = null;
                boolean flag2 = flag1 || this.o % 60 == 0;
                boolean bl = flag3 = Math.abs(i2 - this.k) >= 1 || Math.abs(j - this.l) >= 1;
                if (flag2) {
                    this.d();
                }
                if (flag3) {
                    this.k = i2;
                    this.l = j;
                }
                if (this.o > 0 || this.d instanceof EntityArrow) {
                    boolean flag4;
                    long k2 = PacketPlayOutEntity.a(vec3d_dx);
                    long l2 = PacketPlayOutEntity.a(vec3d_dy);
                    long i1 = PacketPlayOutEntity.a(vec3d_dz);
                    boolean bl2 = flag4 = k2 < -32768L || k2 > 32767L || l2 < -32768L || l2 > 32767L || i1 < -32768L || i1 > 32767L;
                    if (!(flag4 || this.p > 400 || this.r || this.s != this.d.aw() || PaperConfig.sendFullPosForHardCollidingEntities && this.d.hardCollides())) {
                        if (!(flag2 && flag3 || this.d instanceof EntityArrow)) {
                            if (flag2) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.d.ae(), (short)k2, (short)l2, (short)i1, this.d.aw());
                            } else if (flag3) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.d.ae(), (byte)i2, (byte)j, this.d.aw());
                            }
                        } else {
                            packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.d.ae(), (short)k2, (short)l2, (short)i1, (byte)i2, (byte)j, this.d.aw());
                        }
                    } else {
                        this.s = this.d.aw();
                        this.p = 0;
                        packet1 = new PacketPlayOutEntityTeleport(this.d);
                    }
                }
                if ((this.f || this.d.ag || this.d instanceof EntityLiving && ((EntityLiving)this.d).eU()) && this.o > 0 && ((d0 = (vec3d1 = this.d.da()).g(this.n)) > 1.0E-7 || d0 > 0.0 && vec3d1.g() == 0.0)) {
                    this.n = vec3d1;
                    this.g.accept(new PacketPlayOutEntityVelocity(this.d.ae(), this.n));
                }
                if (packet1 != null) {
                    this.g.accept(packet1);
                }
                this.c();
                this.r = false;
            }
            i2 = MathHelper.d(this.d.ce() * 256.0f / 360.0f);
            if (Math.abs(i2 - this.m) >= 1) {
                this.g.accept(new PacketPlayOutEntityHeadRotation(this.d, (byte)i2));
                this.m = i2;
            }
            this.d.ag = false;
        }
        ++this.o;
        if (this.d.D) {
            boolean cancelled = false;
            if (this.d instanceof EntityPlayer) {
                Player player = (Player)this.d.getBukkitEntity();
                Vector velocity = player.getVelocity();
                PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                this.d.t.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    cancelled = true;
                } else if (!velocity.equals((Object)event.getVelocity())) {
                    player.setVelocity(event.getVelocity());
                }
            }
            if (!cancelled) {
                this.a(new PacketPlayOutEntityVelocity(this.d));
            }
            this.d.D = false;
        }
    }

    public void a(EntityPlayer player) {
        this.d.d(player);
        player.b.a(new PacketPlayOutEntityDestroy(this.d.ae()));
    }

    public void b(EntityPlayer player) {
        PlayerConnection playerconnection = player.b;
        Objects.requireNonNull(player.b);
        this.sendPairingData(playerconnection::a, player);
        this.d.c(player);
    }

    public void sendPairingData(Consumer<Packet<?>> consumer, EntityPlayer entityplayer) {
        EntityInsentient entityinsentient;
        if (this.d.do()) {
            return;
        }
        Packet<?> packet = this.d.S();
        this.m = MathHelper.d(this.d.ce() * 256.0f / 360.0f);
        consumer.accept(packet);
        if (!this.d.ai().d()) {
            consumer.accept(new PacketPlayOutEntityMetadata(this.d.ae(), this.d.ai(), true));
        }
        boolean flag = this.f;
        if (this.d instanceof EntityLiving) {
            Collection<AttributeModifiable> collection = ((EntityLiving)this.d).ep().b();
            if (this.d.ae() == entityplayer.ae()) {
                ((EntityPlayer)this.d).getBukkitEntity().injectScaledMaxHealth(collection, false);
            }
            if (!collection.isEmpty()) {
                consumer.accept(new PacketPlayOutUpdateAttributes(this.d.ae(), collection));
            }
            if (((EntityLiving)this.d).eU()) {
                flag = true;
            }
        }
        this.n = this.d.da();
        if (flag && !(packet instanceof PacketPlayOutSpawnEntityLiving)) {
            consumer.accept(new PacketPlayOutEntityVelocity(this.d.ae(), this.n));
        }
        if (this.d instanceof EntityLiving) {
            ArrayList list = Lists.newArrayList();
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                ItemStack itemstack = ((EntityLiving)this.d).b(enumitemslot);
                if (itemstack.b()) continue;
                ItemStack sanitized = EntityLiving.sanitizeItemStack(itemstack.m(), false);
                list.add(Pair.of((Object)((Object)enumitemslot), (Object)((EntityLiving)this.d).stripMeta(sanitized, false)));
            }
            if (!list.isEmpty()) {
                consumer.accept(new PacketPlayOutEntityEquipment(this.d.ae(), list));
            }
            ((EntityLiving)this.d).x();
        }
        this.m = MathHelper.d(this.d.ce() * 256.0f / 360.0f);
        consumer.accept(new PacketPlayOutEntityHeadRotation(this.d, (byte)this.m));
        if (this.d instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)this.d;
            for (MobEffect mobeffect : entityliving.dW()) {
                consumer.accept(new PacketPlayOutEntityEffect(this.d.ae(), mobeffect));
            }
        }
        if (!this.d.cF().isEmpty()) {
            consumer.accept(new PacketPlayOutMount(this.d));
        }
        if (this.d.bF()) {
            consumer.accept(new PacketPlayOutMount(this.d.cN()));
        }
        if (this.d instanceof EntityInsentient && (entityinsentient = (EntityInsentient)this.d).fp()) {
            consumer.accept(new PacketPlayOutAttachEntity(entityinsentient, entityinsentient.fq()));
        }
    }

    private void c() {
        DataWatcher datawatcher = this.d.ai();
        if (datawatcher.a()) {
            this.a(new PacketPlayOutEntityMetadata(this.d.ae(), datawatcher, false));
        }
        if (this.d instanceof EntityLiving) {
            Set<AttributeModifiable> set = ((EntityLiving)this.d).ep().a();
            if (!set.isEmpty()) {
                if (this.d instanceof EntityPlayer) {
                    ((EntityPlayer)this.d).getBukkitEntity().injectScaledMaxHealth(set, false);
                }
                this.a(new PacketPlayOutUpdateAttributes(this.d.ae(), set));
            }
            set.clear();
        }
    }

    private void d() {
        this.h = PacketPlayOutEntity.a(this.d.dc());
        this.i = PacketPlayOutEntity.a(this.d.de());
        this.j = PacketPlayOutEntity.a(this.d.di());
    }

    public Vec3D b() {
        return PacketPlayOutEntity.a(this.h, this.i, this.j);
    }

    void broadcast(Packet<?> packet) {
        this.g.accept(packet);
    }

    private void a(Packet<?> packet) {
        this.g.accept(packet);
        if (this.d instanceof EntityPlayer) {
            ((EntityPlayer)this.d).b.a(packet);
        }
    }
}

